/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.scripted;

import JinRyuu.JRMCore.JRMCoreH;
import JinRyuu.JRMCore.server.JGPlayerMP;
import java.util.Arrays;
import kamkeel.npcdbc.api.IDBCAddon;
import kamkeel.npcdbc.api.aura.IAura;
import kamkeel.npcdbc.api.form.IForm;
import kamkeel.npcdbc.api.outline.IOutline;
import kamkeel.npcdbc.controllers.AuraController;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.controllers.OutlineController;
import kamkeel.npcdbc.data.PlayerDBCInfo;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.scripted.DBCAPI;
import kamkeel.npcdbc.util.PlayerDataUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.api.entity.IEntityLivingBase;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.scripted.CustomNPCsException;
import noppes.npcs.scripted.entity.ScriptDBCPlayer;
import noppes.npcs.util.ValueUtil;

public class ScriptDBCAddon<T extends EntityPlayerMP>
extends ScriptDBCPlayer<T>
implements IDBCAddon {
    public T player;
    public NBTTagCompound nbt;
    public DBCData dbcData;

    public ScriptDBCAddon(T player) {
        super(player);
        this.player = player;
        this.nbt = player.getEntityData().func_74775_l("PlayerPersisted");
        this.dbcData = DBCData.get(player);
    }

    @Override
    public void setLockOnTarget(IEntityLivingBase lockOnTarget) {
        this.dbcData.setLockOnTarget(lockOnTarget == null ? null : lockOnTarget.getMCEntity());
    }

    @Override
    public boolean isTurboOn() {
        return this.dbcData.containsSE(3);
    }

    @Override
    public void setTurboState(boolean on) {
        this.dbcData.setTurboState(on);
    }

    @Override
    public int getMaxBody() {
        return this.dbcData.stats.getMaxBody();
    }

    @Override
    public int getMaxHP() {
        return this.getMaxBody();
    }

    @Override
    public float getBodyPercentage() {
        return this.dbcData.stats.getCurrentBodyPercentage();
    }

    @Override
    public int getMaxKi() {
        return this.dbcData.stats.getMaxKi();
    }

    @Override
    public int getMaxStamina() {
        return this.dbcData.stats.getMaxStamina();
    }

    @Override
    public int[] getAllAttributes() {
        return this.dbcData.stats.getAllAttributes();
    }

    @Override
    public void modifyAllAttributes(int[] attri, boolean multiplyAddedAttris, double multiValue) {
        if (attri.length == 6) {
            int[] stats = this.getAllAttributes();
            double multi = multiValue;
            if (multiValue == 0.0 || !multiplyAddedAttris) {
                multi = 1.0;
            }
            int[] newstats = new int[stats.length];
            for (int i = 0; i < stats.length; ++i) {
                newstats[i] = (int)((double)(stats[i] + attri[i]) * multi);
                this.nbt.func_74768_a(JRMCoreH.AttrbtNbtI[i], newstats[i]);
            }
            this.setBody(this.getMaxBody());
            this.setKi(this.getMaxKi());
            this.setStamina(this.getMaxStamina());
        }
    }

    @Override
    public void modifyAllAttributes(int Num, boolean setStatsToNum) {
        int[] num = new int[]{Num, Num, Num, Num, Num, Num};
        if (!setStatsToNum) {
            this.modifyAllAttributes(num, false, 1.0);
        } else {
            for (int i = 0; i < num.length; ++i) {
                this.nbt.func_74768_a(JRMCoreH.AttrbtNbtI[i], num[i]);
            }
            this.setBody(this.getMaxBody());
            this.setKi(this.getMaxKi());
            this.setStamina(this.getMaxStamina());
        }
    }

    @Override
    public void modifyAllAttributes(int[] submitted, boolean setStats) {
        if (submitted.length == 6) {
            if (!setStats) {
                this.modifyAllAttributes(submitted, false, 1.0);
            } else {
                for (int i = 0; i < submitted.length; ++i) {
                    this.nbt.func_74768_a(JRMCoreH.AttrbtNbtI[i], submitted[i]);
                }
                this.setBody(this.getMaxBody());
                this.setKi(this.getMaxKi());
                this.setStamina(this.getMaxStamina());
            }
        }
    }

    @Override
    public void multiplyAttribute(int statid, double multi) {
        if (multi == 0.0) {
            multi = 1.0;
        }
        int[] stats = this.getAllAttributes();
        int newstat = (int)Math.floor((double)stats[statid] * multi);
        this.nbt.func_74768_a(JRMCoreH.AttrbtNbtI[statid], newstat);
        switch (statid) {
            case 2: {
                this.setBody(this.getMaxBody());
                this.setStamina(this.getMaxStamina());
                break;
            }
            case 5: {
                this.setKi(this.getMaxKi());
            }
        }
    }

    @Override
    public void multiplyAllAttributes(double multi) {
        int[] stats = this.getAllAttributes();
        if (multi == 0.0) {
            multi = 1.0;
        }
        int[] newstats = new int[stats.length];
        for (int i = 0; i < stats.length; ++i) {
            newstats[i] = (int)Math.floor((double)stats[i] * multi);
            this.nbt.func_74768_a(JRMCoreH.AttrbtNbtI[i], newstats[i]);
        }
        this.setBody(this.getMaxBody());
        this.setKi(this.getMaxKi());
        this.setStamina(this.getMaxStamina());
    }

    @Override
    public int getFullAttribute(int attributeID) {
        return this.dbcData.stats.getFullAttribute(attributeID);
    }

    @Override
    public int[] getAllFullAttributes() {
        return this.dbcData.stats.getAllFullAttributes();
    }

    @Override
    public String getRaceName() {
        if (this.getRace() >= 0 && this.getRace() <= 5) {
            return JRMCoreH.Races[this.getRace()];
        }
        return null;
    }

    @Override
    public String getCurrentDBCFormName() {
        int race = this.getRace();
        byte form = this.getForm();
        return DBCAPI.Instance().getFormName(race, form);
    }

    @Override
    public void changeDBCMastery(String formName, double amount, boolean add) {
        JGPlayerMP JG = new JGPlayerMP(this.player);
        NBTTagCompound nbt = this.player.getEntityData().func_74775_l("PlayerPersisted");
        JG.setNBT(nbt);
        byte race = JG.getRace();
        boolean found = false;
        boolean isKaiokenOn = false;
        boolean isMysticOn = false;
        boolean isUltraInstinctOn = false;
        boolean isGoDOn = false;
        int state = 0;
        int state2 = 0;
        double amountKK = 0.0;
        switch (formName.toLowerCase()) {
            case "kaioken": {
                found = true;
                isKaiokenOn = true;
                amountKK = amount;
                break;
            }
            case "mystic": {
                found = true;
                isMysticOn = true;
                break;
            }
            case "ultrainstict": {
                found = true;
                isUltraInstinctOn = true;
                break;
            }
            case "godofdestruction": {
                found = true;
                isGoDOn = true;
            }
        }
        if (found) {
            String nonracial = nbt.func_74779_i("jrmcFormMasteryNonRacial");
            String[] masteries = nonracial.split(";");
            String newnonracial = "";
            for (int i = 0; i < masteries.length; ++i) {
                if (!masteries[i].toLowerCase().contains(formName.toLowerCase())) continue;
                int foundatindex = i;
                String[] masteryvalues = masteries[i].split(",");
                double masteryvalue = Double.parseDouble(masteryvalues[1]);
                masteryvalue = add ? (masteryvalue += amount) : amount;
                String newvalue = Double.toString(masteryvalue);
                switch (foundatindex) {
                    case 0: {
                        newnonracial = masteryvalues[0] + "," + newvalue + ";" + masteries[1] + ";" + masteries[2] + ";" + masteries[3];
                        break;
                    }
                    case 1: {
                        newnonracial = masteries[0] + ";" + masteryvalues[0] + "," + newvalue + ";" + masteries[2] + ";" + masteries[3];
                        break;
                    }
                    case 2: {
                        newnonracial = masteries[0] + ";" + masteries[1] + ";" + masteryvalues[0] + "," + newvalue + ";" + masteries[3];
                        break;
                    }
                    case 3: {
                        newnonracial = masteries[0] + ";" + masteries[1] + ";" + masteries[2] + ";" + masteryvalues[0] + "," + newvalue;
                    }
                }
                nbt.func_74778_a("jrmcFormMasteryNonRacial", newnonracial);
                break;
            }
        } else {
            for (int i = 0; i < JRMCoreH.trans[race].length; ++i) {
                if (!JRMCoreH.trans[race][i].equalsIgnoreCase(formName)) continue;
                state = i;
                found = true;
                JRMCoreH.changeFormMasteriesValue(this.player, (double)amount, (double)amountKK, (boolean)add, (int)race, (int)state, (int)state2, (boolean)isKaiokenOn, (boolean)isMysticOn, (boolean)isUltraInstinctOn, (boolean)isGoDOn, (int)-1);
            }
        }
        if (!found) {
            throw new CustomNPCsException("Invalid \nform name. For non racial form names, use Kaioken, Mystic, UltraInstict and GodOfDestruction. For racial \nform names, check getformName(int race, int form) or getCurrentformName()", new Object[2]);
        }
    }

    @Override
    public double getDBCMasteryValue(String formName) {
        JGPlayerMP JG = new JGPlayerMP(this.player);
        NBTTagCompound nbt = this.player.getEntityData().func_74775_l("PlayerPersisted");
        JG.setNBT(nbt);
        byte race = JG.getRace();
        boolean found = false;
        double valuetoreturn = -1.0;
        switch (formName.toLowerCase()) {
            case "kaioken": {
                found = true;
                break;
            }
            case "mystic": {
                found = true;
            }
            case "ultrainstict": {
                found = true;
                break;
            }
            case "godofdestruction": {
                found = true;
            }
        }
        if (found) {
            String[] masteries;
            String nonracial = nbt.func_74779_i("jrmcFormMasteryNonRacial");
            for (String mastery : masteries = nonracial.split(";")) {
                if (!mastery.toLowerCase().contains(formName.toLowerCase())) continue;
                String[] masteryvalues = mastery.split(",");
                valuetoreturn = Double.parseDouble(masteryvalues[1]);
                return valuetoreturn;
            }
        } else {
            String[] masteries;
            String racial = nbt.func_74779_i("jrmcFormMasteryRacial_" + JRMCoreH.Races[race]);
            for (String mastery : masteries = racial.split(";")) {
                if (!mastery.toLowerCase().contains(formName.toLowerCase())) continue;
                String[] masteryvalues = mastery.split(",");
                double masteryvalue = Double.parseDouble(masteryvalues[1]);
                found = true;
                valuetoreturn = masteryvalue;
                return valuetoreturn;
            }
        }
        if (!found) {
            throw new CustomNPCsException("Invalid \nform name. For non racial form names, use Kaioken, Mystic, UltraInstict and GodOfDestruction. For racial \nform names, check getformName(int race, int form) or getCurrentformName()", new Object[2]);
        }
        throw new CustomNPCsException("Form Mastery value is -1.0", new Object[3]);
    }

    @Override
    public String getAllDBCMasteries() {
        return JRMCoreH.getFormMasteryData(this.player);
    }

    @Override
    public boolean isDBCFusionSpectator() {
        return JRMCoreH.isFusionSpectator(this.player);
    }

    @Override
    public boolean isChargingKi() {
        return this.dbcData.stats.isChargingKiAttack();
    }

    @Override
    public int getSkillLevel(String skillname) {
        String[] playerskills = this.nbt.func_74779_i("jrmcSSlts").split(",");
        String[] skillids = JRMCoreH.DBCSkillsIDs;
        String[] skillnames = JRMCoreH.DBCSkillNames;
        boolean skillFound = false;
        boolean playerHasSkill = false;
        for (int i = 0; i < skillnames.length; ++i) {
            if (!skillname.equals(skillnames[i])) continue;
            skillFound = true;
            for (String playerskill : playerskills) {
                if (!playerskill.contains(skillids[i])) continue;
                return JRMCoreH.SklLvl((int)i, (String[])playerskills);
            }
        }
        if (!skillFound) {
            throw new CustomNPCsException("\nInvalid Skill ID :" + skillname + ". Please re-enter the skill name \nwithout any spaces in between. \ni.e: GodOfDestruction, KiProtection, \nDefensePenetration", new Object[0]);
        }
        if (!playerHasSkill) {
            throw new CustomNPCsException("\nPlayer doesn't have skill " + skillname + "!", new Object[1]);
        }
        return 0;
    }

    @Override
    public int getMaxStat(int statID) {
        return this.dbcData.stats.getMaxStat(statID);
    }

    @Override
    public int getCurrentStat(int statID) {
        return this.dbcData.stats.getCurrentStat(statID);
    }

    @Override
    public double getCurrentFormMultiplier() {
        return this.dbcData.stats.getCurrentMulti();
    }

    @Override
    public int getMajinAbsorptionRace() {
        if (this.getRace() != 5) {
            return 0;
        }
        String s = this.nbt.func_74779_i("jrmcMajinAbsorptionData");
        String[] data = s.split(",");
        String value = data.length >= 3 ? data[1] : "0";
        return Integer.parseInt(value);
    }

    @Override
    public void setMajinAbsorptionRace(int race) {
        if (this.getRace() != 5) {
            return;
        }
        Object[] data = this.nbt.func_74779_i("jrmcMajinAbsorptionData").split(",");
        StringBuilder str = new StringBuilder(race + ",");
        for (int i = 1; i < data.length; ++i) {
            str.append(Arrays.toString(data)).append(",");
        }
        str = new StringBuilder(str.substring(0, str.length() - 1));
        this.nbt.func_74778_a("jrmcMajinAbsorptionData", str.toString());
    }

    @Override
    public int getMajinAbsorptionPower() {
        if (this.getRace() != 5) {
            return 0;
        }
        String s = this.nbt.func_74779_i("jrmcMajinAbsorptionData");
        return JRMCoreH.getMajinAbsorptionValueS((String)s);
    }

    @Override
    public void setMajinAbsorptionPower(int power) {
        if (this.getRace() != 5) {
            return;
        }
        String[] data = this.nbt.func_74779_i("jrmcMajinAbsorptionData").split(",");
        String str = power + ",";
        for (int i = 1; i < data.length; ++i) {
            str = str + data + ",";
        }
        str = str.substring(0, str.length() - 1);
        this.nbt.func_74778_a("jrmcMajinAbsorptionData", str);
    }

    @Override
    public boolean isKO() {
        int currentKO = JRMCoreH.getInt(this.player, (String)"jrmcHar4va");
        return currentKO > 0;
    }

    @Override
    public boolean isUI() {
        return this.dbcData.isForm(41);
    }

    @Override
    public boolean isMUI() {
        return this.dbcData.isForm(40);
    }

    @Override
    public boolean isMystic() {
        return this.dbcData.isForm(21);
    }

    @Override
    public boolean isKaioken() {
        return this.dbcData.isForm(31);
    }

    @Override
    public boolean isGOD() {
        return this.dbcData.isForm(24);
    }

    @Override
    public boolean isLegendary() {
        return this.dbcData.isForm(25);
    }

    @Override
    public boolean isDivine() {
        return this.dbcData.isForm(26);
    }

    @Override
    public boolean isMajin() {
        return this.dbcData.isForm(27);
    }

    @Override
    public void setFlight(boolean flightOn) {
        this.dbcData.setFlight(flightOn);
    }

    @Override
    public boolean isFlying() {
        return this.dbcData.isFlying;
    }

    @Override
    public void setAllowFlight(boolean allowFlight) {
        this.dbcData.flightEnabled = allowFlight;
        this.dbcData.saveNBTData(false);
    }

    @Override
    public void setFlightSpeedRelease(int release) {
        this.dbcData.flightSpeedRelease = ValueUtil.clamp((int)release, (int)1, (int)100);
        this.dbcData.saveNBTData(false);
    }

    @Override
    public void setBaseFlightSpeed(float speed) {
        this.dbcData.baseFlightSpeed = ValueUtil.clamp((float)speed, (float)1.0f, (float)10.0f);
        this.dbcData.saveNBTData(false);
    }

    @Override
    public void setDynamicFlightSpeed(float speed) {
        this.dbcData.dynamicFlightSpeed = ValueUtil.clamp((float)speed, (float)1.0f, (float)10.0f);
        this.dbcData.saveNBTData(false);
    }

    @Override
    public void setFlightGravity(boolean isEffected) {
        this.dbcData.flightGravity = isEffected;
        this.dbcData.saveNBTData(false);
    }

    @Override
    public void setFlightDefaults() {
        this.dbcData.baseFlightSpeed = 1.0f;
        this.dbcData.dynamicFlightSpeed = 1.0f;
        this.dbcData.flightEnabled = true;
        this.dbcData.flightSpeedRelease = 100;
        this.dbcData.flightGravity = true;
        this.dbcData.saveNBTData(false);
    }

    @Override
    public void setSprintSpeed(float speed) {
        this.dbcData.sprintSpeed = ValueUtil.clamp((float)speed, (float)1.0f, (float)20.0f);
        this.dbcData.saveNBTData(false);
    }

    @Override
    public void giveCustomForm(String formName) {
        IForm form = FormController.Instance.get(formName);
        form.assignToPlayer((IPlayer)this);
    }

    @Override
    public void giveCustomForm(IForm form) {
        this.giveCustomForm(form.getName());
    }

    @Override
    public void removeCustomForm(String formName) {
        IForm f = FormController.Instance.get(formName);
        f.removeFromPlayer((IPlayer)this);
    }

    @Override
    public void removeCustomForm(IForm form) {
        this.removeCustomForm(form.getName());
    }

    @Override
    public void setSelectedForm(IForm form) {
        this.setSelectedForm(form != null ? form.getID() : -1);
    }

    @Override
    public void setSelectedForm(int formID) {
        PlayerDBCInfo c = PlayerDataUtil.getDBCInfo(this.player);
        c.selectedForm = FormController.getInstance().has(formID) ? formID : -1;
        c.updateClient();
    }

    @Override
    public void removeSelectedForm() {
        PlayerDBCInfo formData = PlayerDataUtil.getDBCInfo(this.player);
        formData.selectedForm = -1;
        formData.updateClient();
    }

    @Override
    public boolean isInCustomForm() {
        return PlayerDataUtil.getDBCInfo(this.player).isInCustomForm();
    }

    @Override
    public boolean isInCustomForm(IForm form) {
        return this.dbcData.addonFormID == form.getID();
    }

    @Override
    public boolean isInCustomForm(int formID) {
        return PlayerDataUtil.getDBCInfo(this.player).isInForm(formID);
    }

    @Override
    public IForm getCurrentForm() {
        return this.dbcData.getForm();
    }

    @Override
    public void setCustomForm(int formID) {
        Form f = (Form)FormController.Instance.get(formID);
        if (f == null) {
            throw new CustomNPCsException("Form does not exist!", new Object[0]);
        }
        PlayerDBCInfo c = PlayerDataUtil.getDBCInfo(this.player);
        if (c.hasForm(f)) {
            DBCData d = DBCData.get(this.player);
            d.State = 0;
            if (!f.stackable.isFormStackable(31) && d.isForm(31)) {
                d.State2 = 0;
                d.setForm(31, false);
            }
            if (!f.stackable.isFormStackable(41) && d.isForm(41)) {
                d.State2 = 0;
                d.setForm(41, false);
            }
            if (!f.stackable.isFormStackable(24) && d.isForm(24)) {
                d.setForm(24, false);
            }
            if (!f.stackable.isFormStackable(21) && d.isForm(21)) {
                d.setForm(21, false);
            }
        } else {
            throw new CustomNPCsException("Player doesn't have form " + f.name + " unlocked!", new Object[0]);
        }
        c.currentForm = f.id;
        c.updateClient();
    }

    @Override
    public void setCustomForm(IForm form) {
        this.setCustomForm(form.getID());
    }

    @Override
    public void setCustomMastery(int formID, float value) {
        this.setCustomMastery(formID, value, false);
    }

    @Override
    public void setCustomMastery(IForm form, float value) {
        this.setCustomMastery(form.getID(), value, false);
    }

    @Override
    public void setCustomMastery(int formID, float value, boolean ignoreUnlockCheck) {
        PlayerDBCInfo formData = PlayerDataUtil.getDBCInfo(this.player);
        if (ignoreUnlockCheck || formData.hasFormUnlocked(formID)) {
            formData.setFormLevel(formID, value);
            formData.updateClient();
        }
    }

    @Override
    public void setCustomMastery(IForm form, float value, boolean ignoreUnlockCheck) {
        this.setCustomMastery(form.getID(), value, ignoreUnlockCheck);
    }

    @Override
    public void addCustomMastery(int formID, float value) {
        this.addCustomMastery(formID, value, false);
    }

    @Override
    public void addCustomMastery(IForm form, float value) {
        this.addCustomMastery(form.getID(), value, false);
    }

    @Override
    public void addCustomMastery(int formID, float value, boolean ignoreUnlockCheck) {
        PlayerDBCInfo formData = PlayerDataUtil.getDBCInfo(this.player);
        if (ignoreUnlockCheck || formData.hasFormUnlocked(formID)) {
            formData.addFormLevel(formID, value);
            formData.updateClient();
        }
    }

    @Override
    public void addCustomMastery(IForm form, float value, boolean ignoreUnlockCheck) {
        this.addCustomMastery(form.getID(), value, ignoreUnlockCheck);
    }

    @Override
    public float getCustomMastery(int formID) {
        return this.getCustomMastery(formID, true);
    }

    @Override
    public float getCustomMastery(IForm form) {
        return this.getCustomMastery(form.getID(), true);
    }

    @Override
    public float getCustomMastery(int formID, boolean checkFusion) {
        PlayerDBCInfo formData = PlayerDataUtil.getDBCInfo(this.player);
        float level = 0.0f;
        level = formData.getFormLevel(formID, checkFusion);
        return level;
    }

    @Override
    public float getCustomMastery(IForm form, boolean checkFusion) {
        return this.getCustomMastery(form.getID(), checkFusion);
    }

    @Override
    public void removeCustomMastery(int formID) {
        PlayerDBCInfo formData = PlayerDataUtil.getDBCInfo(this.player);
        if (formData.hasFormUnlocked(formID)) {
            formData.removeFormMastery(formID);
            formData.updateClient();
        }
    }

    @Override
    public void removeCustomMastery(IForm form) {
        this.removeCustomMastery(form.getID());
    }

    @Override
    public void giveAura(IAura aura) {
        if (aura == null) {
            throw new CustomNPCsException("This aura doesn't exist", new Object[0]);
        }
        aura.assignToPlayer((IPlayer)this);
    }

    @Override
    public void giveAura(int auraID) {
        IAura aura = AuraController.getInstance().get(auraID);
        if (aura == null) {
            throw new CustomNPCsException(String.format("There is no aura with given ID (ID: %d)", auraID), new Object[0]);
        }
        this.giveAura(aura);
    }

    @Override
    public void giveAura(String auraName) {
        IAura aura = AuraController.Instance.get(auraName);
        if (aura == null) {
            throw new CustomNPCsException(String.format("There is no aura with given name (name: \"%s\")", auraName), new Object[0]);
        }
        this.giveAura(aura);
    }

    @Override
    public void removeAura(String auraName) {
        IAura aura = AuraController.Instance.get(auraName);
        if (aura == null) {
            throw new CustomNPCsException(String.format("There is no aura with given name (name: \"%s\")", auraName), new Object[0]);
        }
        this.removeAura(aura);
    }

    @Override
    public void removeAura(IAura aura) {
        if (aura == null) {
            throw new CustomNPCsException("This aura doesn't exist", new Object[0]);
        }
        aura.removeFromPlayer((IPlayer)this);
    }

    @Override
    public void removeAura(int auraID) {
        IAura aura = AuraController.getInstance().get(auraID);
        if (aura == null) {
            throw new CustomNPCsException(String.format("There is no aura with given ID (ID: %d)", auraID), new Object[0]);
        }
        this.removeAura(aura);
    }

    @Override
    public void setAura(String auraName) {
        if (auraName == null) {
            this.removeAuraSelection();
            return;
        }
        IAura aura = AuraController.Instance.get(auraName);
        if (aura == null) {
            throw new CustomNPCsException(String.format("There is no aura with given name (name: \"%s\")", auraName), new Object[0]);
        }
        this.setAura(aura);
    }

    @Override
    public void setAura(IAura aura) {
        this.setAura(aura != null ? aura.getID() : -1);
    }

    @Override
    public void setAura(int auraID) {
        if (auraID == -1) {
            this.removeAuraSelection();
            return;
        }
        PlayerDBCInfo c = PlayerDataUtil.getDBCInfo(this.player);
        if (!AuraController.getInstance().has(auraID)) {
            throw new CustomNPCsException(String.format("There is no aura with given ID (ID: %d)", auraID), new Object[0]);
        }
        c.selectedAura = auraID;
        c.updateClient();
    }

    @Override
    public void removeAuraSelection() {
        PlayerDBCInfo AuraData = PlayerDataUtil.getDBCInfo(this.player);
        AuraData.selectedAura = -1;
        AuraData.updateClient();
    }

    public IAura getAura() {
        return this.dbcData.getAura();
    }

    @Override
    public void setAuraSelection(String auraName) {
        if (auraName == null) {
            this.removeAuraSelection();
            return;
        }
        IAura aura = AuraController.Instance.get(auraName);
        if (aura == null) {
            throw new CustomNPCsException(String.format("There is no aura with given name (name: \"%s\")", auraName), new Object[0]);
        }
        this.setAuraSelection(aura);
    }

    @Override
    public void setAuraSelection(IAura aura) {
        if (aura == null) {
            this.removeAuraSelection();
            return;
        }
        int auraID = aura.getID();
        PlayerDBCInfo c = PlayerDataUtil.getDBCInfo(this.player);
        if (!c.hasAuraUnlocked(auraID)) {
            throw new CustomNPCsException(String.format("Player \"%s\" doesn't have aura \"%s\" (ID: %d) unlocked.", this.player.func_70005_c_(), aura.getName(), auraID), new Object[0]);
        }
        c.currentAura = auraID;
        c.updateClient();
    }

    @Override
    public void setAuraSelection(int auraID) {
        if (auraID == -1) {
            this.removeAuraSelection();
            return;
        }
        IAura aura = AuraController.Instance.get(auraID);
        if (aura == null) {
            throw new CustomNPCsException(String.format("There is no aura with given ID (ID: %d)", auraID), new Object[0]);
        }
        this.setAuraSelection(aura);
    }

    public DBCData getDBCData() {
        return this.dbcData;
    }

    @Override
    public boolean isInAura() {
        return PlayerDataUtil.getDBCInfo(this.player).isInCustomAura();
    }

    @Override
    public boolean isInAura(IAura aura) {
        if (aura == null) {
            return this.dbcData.auraID == -1;
        }
        return aura.getID() == this.dbcData.auraID;
    }

    @Override
    public boolean isInAura(String auraName) {
        return this.isInAura(AuraController.getInstance().get(auraName));
    }

    @Override
    public boolean isInAura(int auraID) {
        return auraID == this.dbcData.auraID;
    }

    @Override
    public void setOutline(IOutline outline) {
        if (outline == null) {
            throw new CustomNPCsException("This outline doesn't exist!", new Object[0]);
        }
        this.dbcData.setOutline(outline);
    }

    @Override
    public void setOutline(String outlineName) {
        IOutline outline = OutlineController.getInstance().getOutlineFromName(outlineName);
        if (outline == null) {
            throw new CustomNPCsException(String.format("There is no outline with given name (name: \"%s\")", outlineName), new Object[0]);
        }
        this.setOutline(outline);
    }

    @Override
    public void setOutline(int outlineID) {
        IOutline outline = OutlineController.getInstance().get(outlineID);
        if (outline == null) {
            throw new CustomNPCsException(String.format("There is no outline with given ID (ID: \"%s\")", outline), new Object[0]);
        }
        this.setOutline(outline);
    }

    @Override
    public IOutline getOutline() {
        return this.dbcData.getOutline();
    }
}

