/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import kamkeel.npcdbc.client.OptifineHelper;
import kamkeel.npcdbc.controllers.AuraController;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.data.IAuraData;
import kamkeel.npcdbc.data.PlayerDBCInfo;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.data.npc.DBCDisplay;
import kamkeel.npcdbc.mixins.late.INPCDisplay;
import kamkeel.npcdbc.mixins.late.IPlayerDBCInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.NpcAPI;

public class PlayerDataUtil {
    @SideOnly(value=Side.CLIENT)
    public static PlayerDBCInfo getClientDBCInfo() {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return null;
        }
        IPlayerDBCInfo formData = (IPlayerDBCInfo)PlayerData.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (formData == null) {
            return null;
        }
        return formData.getPlayerDBCInfo();
    }

    public static PlayerDBCInfo getDBCInfo(EntityPlayer player) {
        return PlayerDataUtil.getDBCInfo(PlayerDataController.Instance.getPlayerData(player));
    }

    public static PlayerDBCInfo getDBCInfo(PlayerData playerData) {
        return ((IPlayerDBCInfo)playerData).getPlayerDBCInfo();
    }

    public static void sendFormDBCInfo(EntityPlayerMP player, boolean useMenuName) {
        PlayerDBCInfo data = ((IPlayerDBCInfo)PlayerDataController.Instance.getPlayerData((EntityPlayer)player)).getPlayerDBCInfo();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int formID : data.unlockedForms) {
            Form form = (Form)FormController.getInstance().get(formID);
            if (form == null) continue;
            map.put(useMenuName ? form.menuName : form.name, form.id);
        }
        NoppesUtilServer.sendScrollData((EntityPlayerMP)player, map);
    }

    public static void sendAuraDBCInfo(EntityPlayerMP player) {
        PlayerDBCInfo data = ((IPlayerDBCInfo)PlayerDataController.Instance.getPlayerData((EntityPlayer)player)).getPlayerDBCInfo();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int auraID : data.unlockedAuras) {
            Aura aura = (Aura)AuraController.getInstance().get(auraID);
            if (aura == null) continue;
            map.put(aura.name, aura.id);
        }
        NoppesUtilServer.sendScrollData((EntityPlayerMP)player, map);
    }

    public static IPlayer getIPlayer(EntityPlayer p) {
        return (IPlayer)NpcAPI.Instance().getIEntity((Entity)p);
    }

    public static Form getForm(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return DBCData.get((EntityPlayer)entity).getForm();
        }
        if (entity instanceof EntityNPCInterface) {
            return ((INPCDisplay)((EntityNPCInterface)entity).display).getDBCDisplay().getForm();
        }
        return null;
    }

    public static float getFormLevel(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return DBCData.get((EntityPlayer)((EntityPlayer)entity)).addonFormLevel;
        }
        if (entity instanceof EntityNPCInterface) {
            return ((INPCDisplay)((EntityNPCInterface)entity).display).getDBCDisplay().formLevel;
        }
        return 0.0f;
    }

    public static Aura getToggledAura(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return DBCData.get((EntityPlayer)entity).getToggledAura();
        }
        if (entity instanceof EntityNPCInterface) {
            return ((INPCDisplay)((EntityNPCInterface)entity).display).getDBCDisplay().getToggledAura();
        }
        return null;
    }

    public static IAuraData getAuraData(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return DBCData.get((EntityPlayer)entity);
        }
        if (entity instanceof EntityNPCInterface) {
            return ((INPCDisplay)((EntityNPCInterface)entity).display).getDBCDisplay();
        }
        return null;
    }

    public static boolean useStencilBuffer(Entity entity) {
        IAuraData dat = PlayerDataUtil.getAuraData(entity);
        if (OptifineHelper.shaderPackLoaded && OptifineHelper.isQueued(entity)) {
            dat.useStencilBuffer(true);
            return true;
        }
        boolean auraOn = false;
        boolean outlineOn = false;
        boolean particlesOn = false;
        boolean use = false;
        if (entity instanceof EntityPlayer) {
            DBCData data = (DBCData)dat;
            auraOn = data.auraEntity != null;
            outlineOn = data.getOutline() != null;
            particlesOn = !data.particleRenderQueue.isEmpty();
            use = auraOn || outlineOn || particlesOn;
        } else if (entity instanceof EntityNPCInterface) {
            DBCDisplay data = (DBCDisplay)dat;
            auraOn = data.auraEntity != null;
            outlineOn = data.getOutline() != null;
            particlesOn = !data.particleRenderQueue.isEmpty();
            boolean bl = use = auraOn || outlineOn || particlesOn || !data.dbcSecondaryAuraQueue.isEmpty() || !data.dbcAuraQueue.isEmpty();
        }
        if (use && OptifineHelper.shaderPackLoaded && !OptifineHelper.isQueued(entity)) {
            OptifineHelper.enqueue(entity);
            dat.useStencilBuffer(false);
            return false;
        }
        if (use) {
            dat.useStencilBuffer(true);
        }
        return use;
    }
}

