/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.AMCore;
import am2.LogHelper;
import am2.api.events.SpellRecipeItemsEvent;
import am2.api.power.PowerTypes;
import am2.api.spell.component.interfaces.ISkillTreeEntry;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.component.interfaces.ISpellPart;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.containers.ContainerInscriptionTable;
import am2.items.ItemsCommonProxy;
import am2.lore.Story;
import am2.network.AMDataReader;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleHoldPosition;
import am2.spell.SkillManager;
import am2.spell.SpellRecipeManager;
import am2.spell.SpellUtils;
import am2.spell.SpellValidator;
import am2.utility.KeyValuePair;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityInscriptionTable
extends TileEntity
implements IInventory {
    private ItemStack[] inscriptionTableItemStacks = new ItemStack[this.func_70302_i_()];
    private final ArrayList<ISpellPart> currentRecipe = new ArrayList();
    private final ArrayList<ArrayList<ISpellPart>> shapeGroups = new ArrayList();
    private int numStageGroups = 2;
    public static final int MAX_STAGE_GROUPS = 5;
    public static int bookIndex = 0;
    public static int paperIndex = 1;
    public static int featherIndex = 2;
    public static int inkIndex = 3;
    private EntityPlayer currentPlayerUsing = null;
    private int ticksToNextParticle = 20;
    private final HashMap<SpellModifiers, Integer> modifierCount;
    private String currentSpellName = "";
    private boolean currentSpellIsReadOnly;
    private static final byte FULL_UPDATE = 1;
    private static final byte MAKE_SPELL = 2;
    private static final byte RESET_NAME = 4;

    public TileEntityInscriptionTable() {
        for (int i = 0; i < 5; ++i) {
            this.shapeGroups.add(new ArrayList());
        }
        this.modifierCount = new HashMap();
        this.resetModifierCount();
    }

    public ArrayList<ISpellPart> getCurrentRecipe() {
        return this.currentRecipe;
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int i) {
        return this.inscriptionTableItemStacks[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inscriptionTableItemStacks[i] != null) {
            if (this.inscriptionTableItemStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.inscriptionTableItemStacks[i];
                this.inscriptionTableItemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inscriptionTableItemStacks[i].func_77979_a(j);
            if (this.inscriptionTableItemStacks[i].field_77994_a == 0) {
                this.inscriptionTableItemStacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inscriptionTableItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Inscription Table";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean isInUse(EntityPlayer player) {
        return this.currentPlayerUsing != null && this.currentPlayerUsing.func_145782_y() != player.func_145782_y();
    }

    public void setInUse(EntityPlayer player) {
        this.currentPlayerUsing = player;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public EntityPlayer getCurrentPlayerUsing() {
        return this.currentPlayerUsing;
    }

    private boolean isRenderingLeft() {
        return (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 8) == 8;
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K && this.getUpgradeState() >= 3) {
            this.candleUpdate();
        }
        if (this.numStageGroups > 5) {
            this.numStageGroups = 5;
        }
    }

    public int getUpgradeState() {
        return this.numStageGroups - 2;
    }

    private void candleUpdate() {
        --this.ticksToNextParticle;
        if (this.isRenderingLeft()) {
            AMParticle smoke;
            AMParticle effect;
            double particleZ;
            double particleX;
            int meta;
            if (this.ticksToNextParticle == 0 || this.ticksToNextParticle == 15) {
                meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 0xFFFFFFF7;
                particleX = 0.0;
                particleZ = 0.0;
                switch (meta) {
                    case 1: {
                        particleX = (double)this.field_145851_c + 0.15;
                        particleZ = (double)this.field_145849_e + 0.22;
                        break;
                    }
                    case 2: {
                        particleX = (double)this.field_145851_c + 0.22;
                        particleZ = (double)this.field_145849_e + 0.85;
                        break;
                    }
                    case 3: {
                        particleX = (double)this.field_145851_c + 0.83;
                        particleZ = (double)this.field_145849_e + 0.78;
                        break;
                    }
                    case 4: {
                        particleX = (double)this.field_145851_c + 0.79;
                        particleZ = (double)this.field_145849_e + 0.15;
                    }
                }
                this.ticksToNextParticle = 30;
                effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, "fire", particleX, (double)this.field_145848_d + 1.32, particleZ));
                if (effect != null) {
                    effect.setParticleScale(0.025f, 0.1f, 0.025f);
                    effect.AddParticleController(new ParticleHoldPosition(effect, 29, 1, false));
                    effect.setIgnoreMaxAge(false);
                    effect.setMaxAge(400);
                }
                if (this.field_145850_b.field_73012_v.nextInt(100) > 80 && (smoke = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, "smoke", particleX, (double)this.field_145848_d + 1.4, particleZ))) != null) {
                    smoke.setParticleScale(0.025f);
                    smoke.AddParticleController(new ParticleFloatUpward(smoke, 0.01f, 0.01f, 1, false));
                    smoke.setIgnoreMaxAge(false);
                    smoke.setMaxAge(20 + this.field_145850_b.field_73012_v.nextInt(10));
                }
            }
            if (this.ticksToNextParticle == 10 || this.ticksToNextParticle == 25) {
                meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 0xFFFFFFF7;
                particleX = 0.0;
                particleZ = 0.0;
                switch (meta) {
                    case 1: {
                        particleX = (double)this.field_145851_c + 0.59;
                        particleZ = (double)this.field_145849_e - 0.72;
                        break;
                    }
                    case 2: {
                        particleX = (double)this.field_145851_c - 0.72;
                        particleZ = (double)this.field_145849_e + 0.41;
                        break;
                    }
                    case 3: {
                        particleX = (double)this.field_145851_c + 0.41;
                        particleZ = (double)this.field_145849_e + 1.72;
                        break;
                    }
                    case 4: {
                        particleX = (double)this.field_145851_c + 1.72;
                        particleZ = (double)this.field_145849_e + 0.6;
                    }
                }
                effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, "fire", particleX, (double)this.field_145848_d + 1.26, particleZ));
                if (effect != null) {
                    effect.setParticleScale(0.025f, 0.1f, 0.025f);
                    effect.AddParticleController(new ParticleHoldPosition(effect, 29, 1, false));
                    effect.setIgnoreMaxAge(false);
                    effect.setMaxAge(400);
                }
                if (this.field_145850_b.field_73012_v.nextInt(100) > 80 && (smoke = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, "smoke", particleX, (double)this.field_145848_d + 1.4, particleZ))) != null) {
                    smoke.setParticleScale(0.025f);
                    smoke.AddParticleController(new ParticleFloatUpward(smoke, 0.01f, 0.01f, 1, false));
                    smoke.setIgnoreMaxAge(false);
                    smoke.setMaxAge(20 + this.field_145850_b.field_73012_v.nextInt(10));
                }
            }
        }
    }

    private boolean InventorySlotHasItem(int index, Item item, int meta) {
        if (this.inscriptionTableItemStacks[index] == null) {
            return false;
        }
        if (this.inscriptionTableItemStacks[index].func_77973_b() == null) {
            return false;
        }
        if (this.inscriptionTableItemStacks[index].func_77973_b() != item) {
            return false;
        }
        return meta <= -1 || this.inscriptionTableItemStacks[index].func_77960_j() == meta;
    }

    private ItemStack[] getCraftingGridContents() {
        ItemStack[] contents = new ItemStack[10];
        for (int i = 0; i < 10; ++i) {
            contents[i] = this.inscriptionTableItemStacks[i];
        }
        return contents;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70304_b(int i) {
        if (this.inscriptionTableItemStacks[i] != null) {
            ItemStack itemstack = this.inscriptionTableItemStacks[i];
            this.inscriptionTableItemStacks[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.parseTagCompound(par1NBTTagCompound);
        this.clearCurrentRecipe();
    }

    private void parseTagCompound(NBTTagCompound par1NBTTagCompound) {
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("InscriptionTableInventory", 10);
        this.inscriptionTableItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.inscriptionTableItemStacks.length) continue;
            this.inscriptionTableItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.numStageGroups = Math.max(par1NBTTagCompound.func_74762_e("numShapeGroupSlots"), 2);
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inscriptionTableItemStacks.length; ++i) {
            if (this.inscriptionTableItemStacks[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.inscriptionTableItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("InscriptionTableInventory", (NBTBase)nbttaglist);
        par1NBTTagCompound.func_74768_a("numShapeGroupSlots", this.numStageGroups);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public void HandleUpdatePacket(byte[] data) {
        if (this.field_145850_b == null) {
            return;
        }
        AMDataReader rdr = new AMDataReader(data);
        switch (rdr.ID) {
            case 1: {
                if (!rdr.getBoolean()) {
                    Entity e = this.field_145850_b.func_73045_a(rdr.getInt());
                    if (e instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)e;
                        this.setInUse(player);
                    } else {
                        this.setInUse(null);
                    }
                } else {
                    this.setInUse(null);
                }
                this.currentRecipe.clear();
                int partLength = rdr.getInt();
                for (int i = 0; i < partLength; ++i) {
                    ISkillTreeEntry part = SkillManager.instance.getSkill(rdr.getInt());
                    if (!(part instanceof ISpellPart)) continue;
                    this.currentRecipe.add((ISpellPart)part);
                }
                this.shapeGroups.clear();
                int numGroups = rdr.getInt();
                for (int i = 0; i < numGroups; ++i) {
                    int[] partData;
                    ArrayList<ISpellPart> group = new ArrayList<ISpellPart>();
                    for (int n : partData = rdr.getIntArray()) {
                        ISkillTreeEntry part = SkillManager.instance.getSkill(n);
                        if (!(part instanceof ISpellPart)) continue;
                        group.add((ISpellPart)part);
                    }
                    this.shapeGroups.add(group);
                }
                this.countModifiers();
                this.currentSpellName = rdr.getString();
                this.currentSpellIsReadOnly = rdr.getBoolean();
                break;
            }
            case 2: {
                int entityID = rdr.getInt();
                EntityPlayer player = (EntityPlayer)this.field_145850_b.func_73045_a(entityID);
                if (player == null) break;
                this.createSpellForPlayer(player);
                break;
            }
            case 4: {
                int entityID = rdr.getInt();
                EntityPlayer player = (EntityPlayer)this.field_145850_b.func_73045_a(entityID);
                if (player == null) break;
                ((ContainerInscriptionTable)player.field_71070_bA).resetSpellNameAndIcon();
            }
        }
    }

    private byte[] GetUpdatePacketForServer() {
        AMDataWriter writer = new AMDataWriter();
        writer.add((byte)1);
        writer.add(this.currentPlayerUsing == null);
        if (this.currentPlayerUsing != null) {
            writer.add(this.currentPlayerUsing.func_145782_y());
        }
        writer.add(this.currentRecipe.size());
        for (int i = 0; i < this.currentRecipe.size(); ++i) {
            ISpellPart part = this.currentRecipe.get(i);
            int id = part.getID();
            if (part instanceof ISpellComponent) {
                id += 1000;
            } else if (part instanceof ISpellModifier) {
                id += 5000;
            }
            writer.add(id);
        }
        writer.add(this.shapeGroups.size());
        for (ArrayList<ISpellPart> shapeGroup : this.shapeGroups) {
            int[] groupData = new int[shapeGroup.size()];
            for (int i = 0; i < shapeGroup.size(); ++i) {
                groupData[i] = SkillManager.instance.getShiftedPartID(shapeGroup.get(i));
            }
            writer.add(groupData);
        }
        writer.add(this.currentSpellName);
        writer.add(this.currentSpellIsReadOnly);
        return writer.generate();
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), compound);
        return packet;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.parseTagCompound(pkt.func_148857_g());
    }

    private void sendDataToServer() {
        AMDataWriter writer = new AMDataWriter();
        writer.add(this.field_145851_c);
        writer.add(this.field_145848_d);
        writer.add(this.field_145849_e);
        writer.add(this.GetUpdatePacketForServer());
        AMNetHandler.INSTANCE.sendPacketToServer((byte)36, writer.generate());
    }

    public void addSpellPartToStageGroup(int groupIndex, ISpellPart part) {
        ArrayList<ISpellPart> group = this.shapeGroups.get(groupIndex);
        if (!this.currentSpellIsReadOnly && group.size() < 4 && !(part instanceof ISpellComponent)) {
            group.add(part);
            if (this.field_145850_b.field_72995_K) {
                this.sendDataToServer();
            }
            this.countModifiers();
        }
    }

    public void removeSpellPartFromStageGroup(int index, int groupIndex) {
        ArrayList<ISpellPart> group = this.shapeGroups.get(groupIndex);
        if (!this.currentSpellIsReadOnly) {
            group.remove(index);
            if (this.field_145850_b.field_72995_K) {
                this.sendDataToServer();
            }
            this.countModifiers();
        }
    }

    public void removeMultipleSpellPartsFromStageGroup(int startIndex, int length, int groupIndex) {
        ArrayList<ISpellPart> group = this.shapeGroups.get(groupIndex);
        if (!this.currentSpellIsReadOnly) {
            for (int i = 0; i <= length; ++i) {
                group.remove(startIndex);
            }
            this.countModifiers();
            if (this.field_145850_b.field_72995_K) {
                this.sendDataToServer();
            }
        }
    }

    public void addSpellPart(ISpellPart part) {
        if (!this.currentSpellIsReadOnly && this.currentRecipe.size() < 16) {
            this.currentRecipe.add(part);
            if (this.field_145850_b.field_72995_K) {
                this.sendDataToServer();
            }
            this.countModifiers();
        }
    }

    public void removeSpellPart(int index) {
        if (!this.currentSpellIsReadOnly) {
            this.currentRecipe.remove(index);
            if (this.field_145850_b.field_72995_K) {
                this.sendDataToServer();
            }
            this.countModifiers();
        }
    }

    public void removeMultipleSpellParts(int startIndex, int length) {
        if (!this.currentSpellIsReadOnly) {
            for (int i = 0; i <= length; ++i) {
                this.getCurrentRecipe().remove(startIndex);
            }
            this.countModifiers();
            if (this.field_145850_b.field_72995_K) {
                this.sendDataToServer();
            }
        }
    }

    public int getNumStageGroups() {
        return this.numStageGroups;
    }

    private void countModifiers() {
        this.resetModifierCount();
        for (ArrayList<ISpellPart> shapeGroup : this.shapeGroups) {
            this.countModifiersInList(shapeGroup);
        }
        ArrayList<ArrayList<ISpellPart>> stages = SpellValidator.splitToStages(this.currentRecipe);
        if (stages.size() == 0) {
            return;
        }
        ArrayList<ISpellPart> currentStage = stages.get(stages.size() - 1);
        this.countModifiersInList(currentStage);
    }

    private void countModifiersInList(ArrayList<ISpellPart> currentStage) {
        for (ISpellPart part : currentStage) {
            if (!(part instanceof ISpellModifier)) continue;
            EnumSet<SpellModifiers> modifiers = ((ISpellModifier)part).getAspectsModified();
            for (SpellModifiers modifier : modifiers) {
                int count = this.modifierCount.get((Object)modifier) + 1;
                this.modifierCount.put(modifier, count);
            }
        }
    }

    private void resetModifierCount() {
        this.modifierCount.clear();
        for (SpellModifiers modifier : SpellModifiers.values()) {
            this.modifierCount.put(modifier, 0);
        }
    }

    public int getModifierCount(SpellModifiers modifier) {
        return this.modifierCount.get((Object)modifier);
    }

    public void createSpellForPlayer(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add(this.field_145851_c);
            writer.add(this.field_145848_d);
            writer.add(this.field_145849_e);
            writer.add((byte)2);
            writer.add(player.func_145782_y());
            AMNetHandler.INSTANCE.sendPacketToServer((byte)36, writer.generate());
        } else {
            ArrayList<ArrayList<KeyValuePair<ISpellPart, byte[]>>> shapeGroupSetup = new ArrayList<ArrayList<KeyValuePair<ISpellPart, byte[]>>>();
            ArrayList<KeyValuePair<ISpellPart, byte[]>> curRecipeSetup = new ArrayList<KeyValuePair<ISpellPart, byte[]>>();
            for (ArrayList<ISpellPart> arr : this.shapeGroups) {
                shapeGroupSetup.add(new ArrayList());
                for (ISpellPart part : arr) {
                    shapeGroupSetup.get(shapeGroupSetup.size() - 1).add(new KeyValuePair<ISpellPart, byte[]>(part, new byte[0]));
                }
            }
            for (ISpellPart part : this.currentRecipe) {
                curRecipeSetup.add(new KeyValuePair<ISpellPart, byte[]>(part, new byte[0]));
            }
            ItemStack stack = SpellUtils.instance.createSpellStack(shapeGroupSetup, curRecipeSetup);
            stack.field_77990_d.func_74778_a("suggestedName", this.currentSpellName);
            player.field_71071_by.func_70441_a(stack);
        }
    }

    public ItemStack writeRecipeAndDataToBook(ItemStack bookstack, EntityPlayer player, String title) {
        if (bookstack.func_77973_b() == Items.field_151164_bB && this.currentRecipe != null) {
            if (!this.currentRecipeIsValid().valid) {
                return bookstack;
            }
            if (!bookstack.func_77942_o()) {
                bookstack.func_77982_d(new NBTTagCompound());
            } else if (bookstack.func_77978_p().func_74767_n("spellFinalized")) {
                return bookstack;
            }
            LinkedHashMap<String, Integer> materialsList = new LinkedHashMap<String, Integer>();
            materialsList.put(ItemsCommonProxy.rune.func_77653_i(new ItemStack((Item)ItemsCommonProxy.rune, 1, 1)), 1);
            ArrayList<ItemStack> componentRecipeList = new ArrayList<ItemStack>();
            boolean count = false;
            ArrayList<ISpellPart> allRecipeItems = new ArrayList<ISpellPart>();
            for (ArrayList<ISpellPart> shapeGroup : this.shapeGroups) {
                if (shapeGroup == null || shapeGroup.size() == 0) continue;
                allRecipeItems.addAll(shapeGroup);
            }
            allRecipeItems.addAll(this.currentRecipe);
            for (ISpellPart part : allRecipeItems) {
                if (part == null) {
                    LogHelper.error("Unable to write recipe to book.  Recipe part is null!", new Object[0]);
                    return bookstack;
                }
                Object[] recipeItems = part.getRecipeItems();
                SpellRecipeItemsEvent event = new SpellRecipeItemsEvent(SkillManager.instance.getSkillName(part), SkillManager.instance.getShiftedPartID(part), recipeItems);
                MinecraftForge.EVENT_BUS.post((Event)event);
                recipeItems = event.recipeItems;
                if (recipeItems == null) {
                    LogHelper.error("Unable to write recipe to book.  Recipe items are null for part %d!", part.getID());
                    return bookstack;
                }
                for (int i = 0; i < recipeItems.length; ++i) {
                    Object o = recipeItems[i];
                    String materialkey = "";
                    int qty = 1;
                    ItemStack recipeStack = null;
                    if (o instanceof ItemStack) {
                        materialkey = ((ItemStack)o).func_82833_r();
                        recipeStack = (ItemStack)o;
                    } else if (o instanceof Item) {
                        recipeStack = new ItemStack((Item)o);
                        materialkey = ((Item)o).func_77653_i(new ItemStack((Item)o));
                    } else if (o instanceof Block) {
                        recipeStack = new ItemStack((Block)o);
                        materialkey = ((Block)o).func_149732_F();
                    } else if (o instanceof String) {
                        if (((String)o).startsWith("P:")) {
                            String s = ((String)o).substring(2);
                            int pfx = SpellRecipeManager.parsePotionMeta(s);
                            recipeStack = new ItemStack((Item)Items.field_151068_bn, 1, pfx);
                            materialkey = recipeStack.func_82833_r();
                        } else if (((String)o).startsWith("E:")) {
                            int[] ids = SpellRecipeManager.ParseEssenceIDs((String)o);
                            materialkey = "Essence (";
                            for (int powerID : ids) {
                                PowerTypes type = PowerTypes.getByID(powerID);
                                materialkey = materialkey + type.name() + "/";
                            }
                            if (materialkey.equals("Essence (")) {
                                ++i;
                                continue;
                            }
                            o = recipeItems[++i];
                            if (materialkey.startsWith("Essence (")) {
                                materialkey = materialkey.substring(0, materialkey.lastIndexOf("/")) + ")";
                                qty = (Integer)o;
                                int flag = 0;
                                int[] nArray = ids;
                                int n = nArray.length;
                                for (int powerID = 0; powerID < n; ++powerID) {
                                    int f = nArray[powerID];
                                    flag |= f;
                                }
                                recipeStack = new ItemStack((Item)ItemsCommonProxy.essence, qty, 12 + flag);
                            }
                        } else {
                            ArrayList ores = OreDictionary.getOres((String)((String)o));
                            recipeStack = ores.size() > 0 ? (ItemStack)ores.get(1) : null;
                            materialkey = (String)o;
                        }
                    }
                    if (materialsList.containsKey(materialkey)) {
                        int old = (Integer)materialsList.get(materialkey);
                        materialsList.put(materialkey, old += qty);
                    } else {
                        materialsList.put(materialkey, qty);
                    }
                    if (recipeStack == null) continue;
                    componentRecipeList.add(recipeStack);
                }
            }
            materialsList.put(ItemsCommonProxy.spellParchment.func_77653_i(new ItemStack((Item)ItemsCommonProxy.spellParchment)), 1);
            StringBuilder sb = new StringBuilder();
            int sgCount = 0;
            int[][] shapeGroupCombos = new int[this.shapeGroups.size()][];
            for (ArrayList arrayList : this.shapeGroups) {
                sb.append("Shape Group " + ++sgCount + "\n\n");
                Iterator<ISpellPart> it = arrayList.iterator();
                shapeGroupCombos[sgCount - 1] = this.SpellPartListToStringBuilder(it, sb, " -");
                sb.append("\n");
            }
            sb.append("Combination:\n\n");
            Iterator<ISpellPart> it = this.currentRecipe.iterator();
            ArrayList arrayList = new ArrayList();
            int[] outputData = this.SpellPartListToStringBuilder(it, sb, null);
            ArrayList<NBTTagString> pages = Story.splitStoryPartIntoPages(sb.toString());
            sb = new StringBuilder();
            sb.append("\n\nMaterials List:\n\n");
            for (String s : materialsList.keySet()) {
                sb.append(materialsList.get(s) + " x " + s + "\n");
            }
            pages.addAll(Story.splitStoryPartIntoPages(sb.toString()));
            sb = new StringBuilder();
            sb.append("Affinity Breakdown:\n\n");
            it = this.currentRecipe.iterator();
            HashMap<Affinity, Integer> affinityData = new HashMap<Affinity, Integer>();
            int cpCount = 0;
            while (it.hasNext()) {
                ISpellPart part = it.next();
                if (!(part instanceof ISpellComponent)) continue;
                EnumSet<Affinity> aff = ((ISpellComponent)part).getAffinity();
                for (Affinity affinity : aff) {
                    int qty = 1;
                    if (affinityData.containsKey((Object)affinity)) {
                        qty = 1 + affinityData.get((Object)affinity);
                    }
                    affinityData.put(affinity, qty);
                }
                ++cpCount;
            }
            ValueComparator vc = new ValueComparator(affinityData);
            TreeMap<Affinity, Integer> sorted = new TreeMap<Affinity, Integer>(vc);
            sorted.putAll(affinityData);
            for (Affinity aff : sorted.keySet()) {
                float pct = (float)((Integer)sorted.get((Object)aff)).intValue() / (float)cpCount * 100.0f;
                sb.append(String.format("%s: %.2f%%", aff.toString(), Float.valueOf(pct)));
                sb.append("\n");
            }
            pages.addAll(Story.splitStoryPartIntoPages(sb.toString()));
            Story.WritePartToNBT(bookstack.field_77990_d, pages);
            bookstack = Story.finalizeStory(bookstack, title, player.func_70005_c_());
            int[] recipeData = new int[componentRecipeList.size() * 3];
            int idx = 0;
            for (ItemStack stack : componentRecipeList) {
                recipeData[idx++] = Item.func_150891_b((Item)stack.func_77973_b());
                recipeData[idx++] = stack.field_77994_a;
                recipeData[idx++] = stack.func_77960_j();
            }
            bookstack.field_77990_d.func_74783_a("spell_combo", recipeData);
            bookstack.field_77990_d.func_74783_a("output_combo", outputData);
            bookstack.field_77990_d.func_74768_a("numShapeGroups", shapeGroupCombos.length);
            int index = 0;
            for (int[] sgArray : shapeGroupCombos) {
                bookstack.field_77990_d.func_74783_a("shapeGroupCombo_" + index++, sgArray);
            }
            bookstack.field_77990_d.func_74778_a("spell_mod_version", AMCore.instance.getVersion());
            if (this.currentSpellName.equals("")) {
                this.currentSpellName = "Spell Recipe";
            }
            bookstack.func_151001_c(this.currentSpellName);
            this.currentRecipe.clear();
            Object object = this.shapeGroups.iterator();
            while (object.hasNext()) {
                ArrayList list = (ArrayList)object.next();
                list.clear();
            }
            this.currentSpellName = "";
            bookstack.field_77990_d.func_74757_a("spellFinalized", true);
            this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "arsmagica2:misc.inscriptiontable.takebook", 1.0f, 1.0f, true);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return bookstack;
    }

    private int[] concatenateArrays(int[] a, int[] b) {
        int i;
        int[] concat = new int[a.length + b.length];
        for (i = 0; i < a.length; ++i) {
            concat[i] = a[i];
        }
        for (i = 0; i < b.length; ++i) {
            concat[i + a.length] = b[i];
        }
        return concat;
    }

    private int[] SpellPartListToStringBuilder(Iterator<ISpellPart> it, StringBuilder sb, String prefix) {
        ArrayList<Integer> outputCombo = new ArrayList<Integer>();
        while (it.hasNext()) {
            ISpellPart part = it.next();
            String displayName = SkillManager.instance.getDisplayName(part);
            if (prefix != null) {
                sb.append(prefix + displayName + "\n");
            } else if (part instanceof ISpellShape) {
                sb.append(displayName + "\n");
            } else {
                sb.append("-" + displayName + "\n");
            }
            outputCombo.add(part.getID());
        }
        int[] outputData = new int[outputCombo.size()];
        int idx = 0;
        for (Integer I : outputCombo) {
            outputData[idx++] = I;
        }
        return outputData;
    }

    public void clearCurrentRecipe() {
        this.currentRecipe.clear();
        for (ArrayList<ISpellPart> group : this.shapeGroups) {
            group.clear();
        }
        this.currentSpellName = "";
        this.currentSpellIsReadOnly = false;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public SpellValidator.ValidationResult currentRecipeIsValid() {
        ArrayList<ArrayList<ISpellPart>> segmented = SpellValidator.splitToStages(this.currentRecipe);
        return SpellValidator.instance.spellDefIsValid(this.shapeGroups, segmented);
    }

    public boolean modifierCanBeAdded(ISpellModifier modifier) {
        return false;
    }

    public void setSpellName(String name) {
        this.currentSpellName = name;
        this.sendDataToServer();
    }

    public String getSpellName() {
        return this.currentSpellName != null ? this.currentSpellName : "";
    }

    public void reverseEngineerSpell(ItemStack stack) {
        this.currentRecipe.clear();
        for (ArrayList<ISpellPart> group : this.shapeGroups) {
            group.clear();
        }
        this.currentSpellName = "";
        this.currentSpellName = stack.func_82833_r();
        int numStages = SpellUtils.instance.numStages(stack);
        for (int i = 0; i < numStages; ++i) {
            ISpellModifier[] iSpellModifierArray;
            ISpellComponent[] components;
            ISpellShape shape = SpellUtils.instance.getShapeForStage(stack, i);
            this.currentRecipe.add(shape);
            for (ISpellComponent component : components = SpellUtils.instance.getComponentsForStage(stack, i)) {
                this.currentRecipe.add(component);
            }
            ISpellModifier[] iSpellModifierArray2 = iSpellModifierArray = SpellUtils.instance.getModifiersForStage(stack, i);
            int n = iSpellModifierArray2.length;
            for (int component = 0; component < n; ++component) {
                ISpellModifier modifier = iSpellModifierArray2[component];
                this.currentRecipe.add(modifier);
            }
        }
        int numShapeGroups = SpellUtils.instance.numShapeGroups(stack);
        for (int i = 0; i < numShapeGroups; ++i) {
            int[] parts;
            for (int partID : parts = SpellUtils.instance.getShapeGroupParts(stack, i)) {
                ISkillTreeEntry entry = SkillManager.instance.getSkill(partID);
                if (entry == null || !(entry instanceof ISpellPart)) continue;
                this.shapeGroups.get(i).add((ISpellPart)entry);
            }
        }
        this.currentSpellIsReadOnly = true;
    }

    public boolean currentSpellDefIsReadOnly() {
        return this.currentSpellIsReadOnly;
    }

    public void resetSpellNameAndIcon(ItemStack stack, EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add(this.field_145851_c);
            writer.add(this.field_145848_d);
            writer.add(this.field_145849_e);
            writer.add((byte)4);
            writer.add(player.func_145782_y());
            AMNetHandler.INSTANCE.sendPacketToServer((byte)36, writer.generate());
        }
        stack.func_77964_b(0);
        stack.func_135074_t();
    }

    public int getShapeGroupSize(int groupIndex) {
        return this.shapeGroups.get(groupIndex).size();
    }

    public ISpellPart getShapeGroupPartAt(int groupIndex, int index) {
        return this.shapeGroups.get(groupIndex).get(index);
    }

    public void incrementUpgradeState() {
        ++this.numStageGroups;
        if (!this.field_145850_b.field_72995_K) {
            List players = this.field_145850_b.func_72872_a(EntityPlayerMP.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(256.0, 256.0, 256.0));
            for (EntityPlayerMP player : players) {
                player.field_71135_a.func_147359_a(this.func_145844_m());
            }
        }
    }

    static class ValueComparator
    implements Comparator<Affinity> {
        Map<Affinity, Integer> base;

        ValueComparator(Map<Affinity, Integer> base) {
            this.base = base;
        }

        @Override
        public int compare(Affinity a, Affinity b) {
            Integer y;
            Integer x = this.base.get((Object)a);
            if (x.equals(y = this.base.get((Object)b))) {
                return a.compareTo(b);
            }
            return x.compareTo(y);
        }
    }
}

