/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.api.power.IPowerNode;
import am2.api.power.PowerTypes;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.api.spell.enums.SpellCastResult;
import am2.items.ArsMagicaItem;
import am2.items.ItemsCommonProxy;
import am2.network.AMNetHandler;
import am2.playerextensions.SkillData;
import am2.power.PowerNodeRegistry;
import am2.spell.SkillManager;
import am2.spell.SkillTreeManager;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import am2.texture.ResourceManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemSpellStaff
extends ArsMagicaItem {
    private final int castingMode;
    private int staffHeadIndex;
    private final int maxCharge;
    private static final String NBT_CHARGE = "current_charge";
    private static final String NBT_SPELL = "spell_to_cast";
    private static final String NBT_SPELL_NAME = "spell_name";
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    @SideOnly(value=Side.CLIENT)
    private String[] textureFiles;

    public ItemSpellStaff(int charge, int castingMode) {
        this.func_77656_e(charge);
        this.maxCharge = charge;
        this.field_77777_bU = 1;
        this.castingMode = castingMode;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.textureFiles = new String[]{"staff_lesser", "staff_standard", "staff_greater", "staff_magitech"};
        this.icons = new IIcon[this.textureFiles.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = ResourceManager.RegisterTexture(this.textureFiles[i], par1IconRegister);
        }
    }

    public ItemSpellStaff setStaffHeadIndex(int index) {
        if (index > 3 || index < 0) {
            index = 0;
        }
        this.staffHeadIndex = index;
        return this;
    }

    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        if (pass == 0) {
            return false;
        }
        return this.isMagiTechStaff() || this.getSpellStack(par1ItemStack) != null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int dmg, int pass) {
        return this.icons[this.staffHeadIndex];
    }

    public boolean isMagiTechStaff() {
        return this.castingMode == -1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        return 0xFFFFFF;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        if (this.isMagiTechStaff()) {
            return EnumAction.none;
        }
        return EnumAction.block;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public void setSpellScroll(ItemStack stack, ItemStack spell) {
        if (this.isMagiTechStaff()) {
            return;
        }
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound compound = stack.field_77990_d;
        NBTTagCompound spellCompound = spell.func_77955_b(new NBTTagCompound());
        compound.func_74782_a(NBT_SPELL, (NBTBase)spellCompound);
        compound.func_74778_a(NBT_SPELL_NAME, spell.func_82833_r());
        if (!compound.func_74764_b(NBT_CHARGE)) {
            compound.func_74776_a(NBT_CHARGE, (float)this.maxCharge);
        }
    }

    public void copyChargeFrom(ItemStack my_stack, ItemStack stack) {
        if (this.isMagiTechStaff()) {
            return;
        }
        if (stack.func_77973_b() instanceof ItemSpellStaff && stack.field_77990_d != null && stack.field_77990_d.func_74764_b(NBT_CHARGE)) {
            if (my_stack.field_77990_d == null) {
                my_stack.field_77990_d = new NBTTagCompound();
            }
            my_stack.field_77990_d.func_74776_a(NBT_CHARGE, stack.field_77990_d.func_74760_g(NBT_CHARGE));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (stack.field_77990_d == null || this.isMagiTechStaff()) {
            return;
        }
        float chargeCost = 1.0f;
        ItemStack spell = this.getSpellStack(stack);
        if (spell != null) {
            chargeCost = SpellUtils.instance.getSpellRequirements((ItemStack)spell, (EntityLivingBase)par2EntityPlayer).manaCost;
        }
        if (chargeCost == 0.0f) {
            chargeCost = 1.0f;
        }
        float chargeRemaining = stack.field_77990_d.func_74760_g(NBT_CHARGE);
        int chargesRemaining = (int)Math.ceil(chargeRemaining / chargeCost);
        par3List.add(StatCollector.func_74838_a((String)"am2.tooltip.charge") + ": " + (int)chargeRemaining + " / " + this.maxCharge);
        par3List.add("" + chargesRemaining + " " + StatCollector.func_74838_a((String)"am2.tooltip.uses") + ".");
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        if (this.isMagiTechStaff()) {
            return StatCollector.func_74838_a((String)"item.arsmagica2:spell_staff_magitech.name");
        }
        String name = super.func_77653_i(par1ItemStack);
        if (par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b(NBT_SPELL_NAME)) {
            name = name + " (\u00a79" + par1ItemStack.func_77978_p().func_74779_i(NBT_SPELL_NAME) + "\u00a77)";
        }
        return name;
    }

    public boolean func_77651_p() {
        return true;
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int X, int Y, int Z, int side, float par8, float par9, float par10) {
        return this.isMagiTechStaff();
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (this.isMagiTechStaff() && !world.field_72995_K && (te = world.func_147438_o(x, y, z)) != null && te instanceof IPowerNode) {
            if (player.func_70093_af()) {
                AMNetHandler.INSTANCE.syncPowerPaths((IPowerNode)te, (EntityPlayerMP)player);
            } else {
                PowerTypes[] types;
                for (PowerTypes type : types = ((IPowerNode)te).getValidPowerTypes()) {
                    float power = PowerNodeRegistry.For(world).getPower((IPowerNode)te, type);
                    player.func_145747_a((IChatComponent)new ChatComponentText(String.format(StatCollector.func_74838_a((String)"am2.tooltip.det_eth"), type.chatColor(), type.name(), String.format("%.2f", Float.valueOf(power)))));
                }
            }
            return true;
        }
        return false;
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
        ISpellShape shape;
        if (this.isMagiTechStaff()) {
            return;
        }
        ItemStack spell = this.getSpellStack(itemstack);
        if (spell != null && (shape = SpellUtils.instance.getShapeForStage(spell, 0)) != null) {
            if (!shape.isChanneled() && SpellHelper.instance.applyStackStage(spell, (EntityLivingBase)entityplayer, null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, 0, world, false, false, i) == SpellCastResult.SUCCESS) {
                this.consumeStaffCharge(itemstack, entityplayer);
            }
            if (!world.field_72995_K || shape.isChanneled()) {
                // empty if block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayerSP player;
        ItemStack usingItem;
        super.func_77663_a(stack, world, entity, par4, par5);
        if (entity instanceof EntityPlayerSP && (usingItem = (player = (EntityPlayerSP)entity).func_71011_bu()) != null && usingItem.func_77973_b() == this && SkillData.For((EntityPlayer)player).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("SpellMotion")))) {
            player.field_71158_b.field_78900_b *= 2.5f;
            player.field_71158_b.field_78902_a *= 2.5f;
        }
    }

    public int func_77626_a(ItemStack itemStack) {
        return 2000;
    }

    private ItemStack getSpellStack(ItemStack staffStack) {
        if (!staffStack.func_77942_o() || !staffStack.field_77990_d.func_74764_b(NBT_SPELL)) {
            return null;
        }
        ItemStack stack = new ItemStack((Item)ItemsCommonProxy.spell);
        stack.func_77963_c(staffStack.func_77978_p().func_74775_l(NBT_SPELL));
        return stack;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (this.isMagiTechStaff()) {
            return itemstack;
        }
        if (this.getSpellStack(itemstack) != null) {
            entityplayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        }
        return itemstack;
    }

    public void onUsingTick(ItemStack itemstack, EntityPlayer player, int count) {
        if (this.isMagiTechStaff()) {
            return;
        }
        ItemStack spell = this.getSpellStack(itemstack);
        if (spell != null && SpellHelper.instance.applyStackStageOnUsing(spell, (EntityLivingBase)player, (EntityLivingBase)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70170_p, false, true, count - 1) == SpellCastResult.SUCCESS) {
            this.consumeStaffCharge(itemstack, player);
        }
    }

    public int getDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return super.getDamage(stack);
        }
        float chargeRemaining = stack.field_77990_d.func_74760_g(NBT_CHARGE);
        return this.maxCharge - (int)Math.floor(chargeRemaining);
    }

    private void consumeStaffCharge(ItemStack staffStack, EntityPlayer caster) {
        float chargeCost = 1.0f;
        ItemStack spell = this.getSpellStack(staffStack);
        if (spell != null) {
            chargeCost = SpellUtils.instance.getSpellRequirements((ItemStack)spell, (EntityLivingBase)caster).manaCost;
        }
        if (chargeCost == 0.0f) {
            chargeCost = 1.0f;
        }
        float chargeRemaining = staffStack.field_77990_d.func_74760_g(NBT_CHARGE);
        staffStack.field_77990_d.func_74776_a(NBT_CHARGE, chargeRemaining -= chargeCost);
        if (chargeRemaining <= 0.0f && !caster.field_70170_p.field_72995_K) {
            caster.func_71028_bD();
        }
    }
}

