/*
 * Decompiled with CFR 0.152.
 */
package am2.navigation;

import am2.navigation.BreadCrumb;

public class MinHeap {
    private int count = 0;
    private int capacity;
    private BreadCrumb temp;
    private BreadCrumb mheap;
    private BreadCrumb[] array;
    private BreadCrumb[] tempArray;

    public int Count() {
        return this.count;
    }

    public MinHeap() {
        this(16);
    }

    public MinHeap(int capacity) {
        this.capacity = capacity;
        this.array = new BreadCrumb[capacity];
    }

    public void BuildHead() {
        for (int position = this.count - 1 >> 1; position >= 0; --position) {
            this.MinHeapify(position);
        }
    }

    public void Add(BreadCrumb item) {
        ++this.count;
        if (this.count > this.capacity) {
            this.DoubleArray();
        }
        this.array[this.count - 1] = item;
        int position = this.count - 1;
        int parentPosition = position - 1 >> 1;
        while (position > 0 && this.array[parentPosition].compareTo(this.array[position]) > 0) {
            this.temp = this.array[position];
            this.array[position] = this.array[parentPosition];
            this.array[parentPosition] = this.temp;
            position = parentPosition;
            parentPosition = position - 1 >> 1;
        }
    }

    private void DoubleArray() {
        this.capacity <<= 1;
        this.tempArray = new BreadCrumb[this.capacity];
        MinHeap.CopyArray(this.array, this.tempArray);
        this.array = this.tempArray;
    }

    private static void CopyArray(BreadCrumb[] source, BreadCrumb[] destination) {
        for (int index = 0; index < source.length; ++index) {
            destination[index] = source[index];
        }
    }

    public BreadCrumb Peek() throws Exception {
        if (this.count == 0) {
            throw new Exception("Heap is empty");
        }
        return this.array[0];
    }

    public BreadCrumb ExtractFirst() throws Exception {
        if (this.count == 0) {
            throw new Exception("Heap is empty");
        }
        this.temp = this.array[0];
        this.array[0] = this.array[this.count - 1];
        --this.count;
        this.MinHeapify(0);
        return this.temp;
    }

    private void MinHeapify(int position) {
        while (true) {
            int left = (position << 1) + 1;
            int right = left + 1;
            int minPosition = left < this.count && this.array[left].compareTo(this.array[position]) < 0 ? left : position;
            if (right < this.count && this.array[right].compareTo(this.array[minPosition]) < 0) {
                minPosition = right;
            }
            if (minPosition == position) break;
            this.mheap = this.array[position];
            this.array[position] = this.array[minPosition];
            this.array[minPosition] = this.mheap;
            position = minPosition;
        }
    }
}

