/*
 * Decompiled with CFR 0.152.
 */
package am2.network;

import am2.LogHelper;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class AMDataReader {
    ByteArrayInputStream input;
    DataInputStream dataStream;
    public byte ID;

    public AMDataReader(byte[] data) {
        this(data, true);
    }

    public AMDataReader(byte[] data, boolean getID) {
        this.input = new ByteArrayInputStream(data);
        this.dataStream = new DataInputStream(this.input);
        if (getID) {
            try {
                this.ID = this.dataStream.readByte();
            }
            catch (IOException e) {
                LogHelper.error("AMDataReader (getID): " + e.toString(), new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public int getInt() {
        int value = 0;
        try {
            value = this.dataStream.readInt();
        }
        catch (IOException e) {
            LogHelper.error("AMDataReader (getInt): " + e.toString(), new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public float getFloat() {
        float value = 0.0f;
        try {
            value = this.dataStream.readFloat();
        }
        catch (IOException e) {
            LogHelper.error("AMDataReader (getFloat): " + e.toString(), new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public double getDouble() {
        double value = 0.0;
        try {
            value = this.dataStream.readDouble();
        }
        catch (IOException e) {
            LogHelper.error("AMDataReader (getDouble): " + e.toString(), new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public boolean getBoolean() {
        boolean value = false;
        try {
            value = this.dataStream.readBoolean();
        }
        catch (IOException e) {
            LogHelper.error("AMDataReader (getBoolean): " + e.toString(), new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public String getString() {
        String value = "";
        try {
            value = this.dataStream.readUTF();
        }
        catch (IOException e) {
            LogHelper.error("AMDataReader (getString): " + e.toString(), new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public byte getByte() {
        byte value = 0;
        try {
            value = this.dataStream.readByte();
        }
        catch (IOException e) {
            LogHelper.error("AMDataReader (getByte): " + e.toString(), new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public short getShort() {
        short value = 0;
        try {
            value = this.dataStream.readShort();
        }
        catch (IOException e) {
            LogHelper.error("AMDataReader (getShort): " + e.toString(), new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public long getLong() {
        long value = 0L;
        try {
            value = this.dataStream.readLong();
        }
        catch (IOException e) {
            LogHelper.error("AMDataReader (getLong): " + e.toString(), new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public NBTTagCompound getNBTTagCompound() {
        NBTTagCompound data = null;
        try {
            int len = this.dataStream.readInt();
            byte[] bytes = new byte[len];
            this.dataStream.read(bytes);
            ByteBuf buf = Unpooled.copiedBuffer((byte[])bytes);
            data = ByteBufUtils.readTag((ByteBuf)buf);
        }
        catch (IOException e) {
            LogHelper.error("AMDataReader (getNBTTagCompound): " + e.toString(), new Object[0]);
            e.printStackTrace();
        }
        return data;
    }

    public byte[] getRemainingBytes() {
        byte[] remaining = null;
        try {
            remaining = new byte[this.dataStream.available()];
            this.dataStream.read(remaining);
        }
        catch (IOException e) {
            LogHelper.error("AMDataReader (getRemainingBytes): " + e.toString(), new Object[0]);
            e.printStackTrace();
        }
        return remaining;
    }

    public ItemStack getItemStack() {
        NBTTagCompound compound = this.getNBTTagCompound();
        if (compound == null) {
            return null;
        }
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)compound);
        return stack;
    }

    public int[] getIntArray() {
        try {
            int[] arr = new int[this.dataStream.readInt()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.dataStream.readInt();
            }
            return arr;
        }
        catch (IOException e) {
            LogHelper.error("AMDataReader (getIntArray): " + e.toString(), new Object[0]);
            e.printStackTrace();
            return new int[0];
        }
    }
}

