/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMParticle;
import am2.particles.ParticleController;

public final class ParticleOrbitPoint
extends ParticleController {
    private CoordStore target;
    private double distance;
    private boolean rotateClockwise;
    private double targetY;
    private double targetDistance;
    private double orbitSpeed;
    private double orbitAngle;
    private double orbitY = -512.0;
    private boolean useCurrentDistance;
    private boolean ignoreYCoord;
    private boolean shrinkingOrbit;
    private double shrinkSpeed = 0.0;
    private double shrinkTargetDistance = 0.0;

    public ParticleOrbitPoint(AMParticle particleEffect, double orbitX, double orbitY, double orbitZ, int priority, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        this.target = new CoordStore(orbitX, orbitY, orbitZ);
        this.orbitAngle = this.particle.field_70170_p.field_73012_v.nextInt(360);
        this.rotateClockwise = this.particle.field_70170_p.field_73012_v.nextInt(10) < 5;
        this.generateNewTargetY();
        this.targetDistance = 1.0 + this.particle.field_70170_p.field_73012_v.nextDouble() * 0.5;
    }

    public ParticleOrbitPoint setOrbitY(double orbitY) {
        this.orbitY = orbitY;
        return this;
    }

    public ParticleOrbitPoint setIgnoreYCoordinate(boolean ignore) {
        this.ignoreYCoord = ignore;
        return this;
    }

    public ParticleOrbitPoint SetTargetDistance(double targetDistance) {
        this.targetDistance = targetDistance;
        this.useCurrentDistance = false;
        return this;
    }

    public ParticleOrbitPoint SetUseCurrentDistance() {
        this.useCurrentDistance = true;
        return this;
    }

    public ParticleOrbitPoint SetOrbitSpeed(double speed) {
        this.orbitSpeed = speed;
        return this;
    }

    public ParticleOrbitPoint SetShrinkingOrbit(double shrinkSpeed, double newTargetDistance) {
        this.shrinkingOrbit = true;
        this.shrinkSpeed = shrinkSpeed;
        this.shrinkTargetDistance = newTargetDistance;
        return this;
    }

    private void generateNewTargetY() {
        this.targetY = this.target != null ? this.particle.field_70170_p.field_73012_v.nextDouble() * 2.0 : 0.0;
    }

    private void generateNewDistance() {
        this.targetDistance = this.target != null ? this.particle.field_70170_p.field_73012_v.nextDouble() * 2.0 : 0.0;
    }

    public ParticleOrbitPoint setRotateDirection(boolean clockwise) {
        this.rotateClockwise = clockwise;
        return this;
    }

    public ParticleOrbitPoint setStartAngle(float angle) {
        this.orbitAngle = angle;
        return this;
    }

    @Override
    public void doUpdate() {
        double posZ;
        double posX;
        double posY = this.particle.field_70163_u;
        double relativeTargetY = this.target.y + this.targetY;
        if (!this.ignoreYCoord && Math.abs(this.particle.field_70163_u - relativeTargetY) < 0.1) {
            this.generateNewTargetY();
        }
        if (this.useCurrentDistance) {
            double deltaz = this.target.z - this.particle.field_70161_v;
            double deltax = this.target.x - this.particle.field_70165_t;
            double currentDistance = Math.sqrt(deltaz * deltaz + deltax * deltax);
            posX = this.target.x + Math.cos(this.orbitAngle) * currentDistance;
            posZ = this.target.z + Math.sin(this.orbitAngle) * currentDistance;
        } else {
            if (this.shrinkingOrbit) {
                if (this.targetDistance <= this.shrinkTargetDistance) {
                    this.shrinkingOrbit = false;
                } else if (this.targetDistance < this.shrinkTargetDistance + this.shrinkSpeed * 10.0) {
                    double delta = this.targetDistance - this.shrinkTargetDistance;
                    this.targetDistance -= delta * this.shrinkSpeed;
                } else {
                    this.targetDistance -= this.shrinkSpeed;
                }
            }
            posX = this.target.x + Math.cos(this.orbitAngle) * this.targetDistance;
            posZ = this.target.z + Math.sin(this.orbitAngle) * this.targetDistance;
        }
        if (!this.ignoreYCoord) {
            if (this.particle.field_70163_u < relativeTargetY) {
                this.particle.field_70163_u += 0.1;
            } else if (this.particle.field_70163_u > relativeTargetY) {
                this.particle.field_70163_u -= 0.1;
            }
        }
        this.orbitAngle = this.rotateClockwise ? (this.orbitAngle += this.orbitSpeed) : (this.orbitAngle -= this.orbitSpeed);
        if (this.orbitAngle > 360.0) {
            this.orbitAngle -= 360.0;
        } else if (this.orbitAngle < 0.0) {
            this.orbitAngle += 360.0;
        }
        if (this.orbitY != -512.0) {
            posY = this.target.y + this.orbitY;
        }
        this.particle.func_70107_b(posX, posY, posZ);
        if (this.firstTick) {
            this.particle.field_70169_q = posX;
            this.particle.field_70167_r = posY;
            this.particle.field_70166_s = posZ;
        }
    }

    @Override
    public ParticleController clone() {
        ParticleOrbitPoint clone = new ParticleOrbitPoint(this.particle, this.target.x, this.target.y, this.target.z, this.priority, this.exclusive);
        if (this.useCurrentDistance) {
            clone.SetUseCurrentDistance();
        } else {
            clone.SetTargetDistance(this.targetDistance);
        }
        if (this.orbitY != -512.0) {
            clone.setOrbitY(this.orbitY);
        }
        clone.SetOrbitSpeed(this.orbitSpeed);
        clone.setIgnoreYCoordinate(this.ignoreYCoord);
        clone.setRotateDirection(this.rotateClockwise);
        clone.setStartAngle((float)this.orbitAngle);
        if (this.shrinkingOrbit) {
            clone.SetShrinkingOrbit(this.shrinkSpeed, this.shrinkTargetDistance);
        }
        return clone;
    }

    private class CoordStore {
        public double x;
        public double y;
        public double z;

        public CoordStore(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

