/*
 * Decompiled with CFR 0.152.
 */
package am2.proxy.tick;

import am2.AMCore;
import am2.EntityItemWatcher;
import am2.MeteorSpawnHelper;
import am2.bosses.BossSpawnHelper;
import am2.items.ItemsCommonProxy;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import am2.utility.DimensionUtilities;
import am2.worldgen.RetroactiveWorldgenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class ServerTickHandler {
    private boolean firstTick = true;
    public static HashMap<EntityLiving, EntityLivingBase> targetsToSet = new HashMap();
    public static String lastWorldName;

    private void gameTick_Start() {
        if (MinecraftServer.func_71276_C().func_71270_I() != lastWorldName) {
            lastWorldName = MinecraftServer.func_71276_C().func_71270_I();
            this.firstTick = true;
        }
        if (this.firstTick) {
            ItemsCommonProxy.crystalPhylactery.getSpawnableEntities((World)MinecraftServer.func_71276_C().field_71305_c[0]);
            this.firstTick = false;
        }
        AMCore.proxy.itemFrameWatcher.checkWatchedFrames();
    }

    private void gameTick_End() {
        BossSpawnHelper.instance.tick();
        MeteorSpawnHelper.instance.tick();
        EntityItemWatcher.instance.tick();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.gameTick_Start();
        } else if (event.phase == TickEvent.Phase.END) {
            this.gameTick_End();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (AMCore.config.retroactiveWorldgen()) {
            RetroactiveWorldgenerator.instance.continueRetrogen(event.world);
        }
        this.applyDeferredPotionEffects();
        if (event.phase == TickEvent.Phase.END) {
            this.applyDeferredDimensionTransfers();
        }
    }

    private void applyDeferredPotionEffects() {
        for (EntityLivingBase ent : AMCore.proxy.getDeferredPotionEffects().keySet()) {
            ArrayList<PotionEffect> potions = AMCore.proxy.getDeferredPotionEffects().get(ent);
            for (PotionEffect effect : potions) {
                ent.func_70690_d(effect);
            }
        }
        AMCore.proxy.clearDeferredPotionEffects();
    }

    private void applyDeferredDimensionTransfers() {
        for (EntityLivingBase ent : AMCore.proxy.getDeferredDimensionTransfers().keySet()) {
            DimensionUtilities.doDimensionTransfer(ent, AMCore.proxy.getDeferredDimensionTransfers().get(ent));
        }
        AMCore.proxy.clearDeferredDimensionTransfers();
    }

    private void applyDeferredTargetSets() {
        Iterator<Map.Entry<EntityLiving, EntityLivingBase>> it = targetsToSet.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<EntityLiving, EntityLivingBase> entry = it.next();
            if (entry.getKey() != null && !entry.getKey().field_70128_L) {
                entry.getKey().func_70624_b(entry.getValue());
            }
            it.remove();
        }
    }

    public void addDeferredTarget(EntityLiving ent, EntityLivingBase target) {
        targetsToSet.put(ent, target);
    }

    public void blackoutArmorPiece(EntityPlayerMP player, int slot, int cooldown) {
        AMNetHandler.INSTANCE.sendPacketToClientPlayer(player, (byte)9, new AMDataWriter().add(slot).add(cooldown).generate());
    }
}

