/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryRegistry;
import electroblob.wizardry.spell.Spell;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class WandHelper {
    public static final String SPELL_ARRAY_KEY = "spells";
    public static final String SELECTED_SPELL_KEY = "selectedSpell";
    public static final String COOLDOWN_ARRAY_KEY = "cooldown";
    public static final String UPGRADES_KEY = "upgrades";
    private static final HashMap<Item, String> upgradeMap = new HashMap();

    public static Spell[] getSpells(ItemStack wand) {
        Spell[] spells = new Spell[]{};
        if (wand.field_77990_d != null) {
            int[] spellIDs = wand.field_77990_d.func_74759_k(SPELL_ARRAY_KEY);
            spells = new Spell[spellIDs.length];
            for (int i = 0; i < spellIDs.length; ++i) {
                spells[i] = Spell.get(spellIDs[i]);
            }
        }
        return spells;
    }

    public static void setSpells(ItemStack wand, Spell[] spells) {
        if (wand.field_77990_d == null) {
            wand.field_77990_d = new NBTTagCompound();
        }
        int[] spellIDs = new int[spells.length];
        for (int i = 0; i < spells.length; ++i) {
            spellIDs[i] = spells[i] != null ? spells[i].id() : WizardryRegistry.none.id();
        }
        wand.field_77990_d.func_74783_a(SPELL_ARRAY_KEY, spellIDs);
    }

    public static Spell getCurrentSpell(ItemStack wand) {
        int selectedSpell;
        Spell[] spells = WandHelper.getSpells(wand);
        if (wand.field_77990_d != null && (selectedSpell = wand.field_77990_d.func_74762_e(SELECTED_SPELL_KEY)) < spells.length) {
            return spells[selectedSpell];
        }
        return WizardryRegistry.none;
    }

    public static void selectNextSpell(ItemStack wand) {
        if (WandHelper.getSpells(wand).length < 0) {
            WandHelper.setSpells(wand, new Spell[5]);
        }
        if (wand.field_77990_d != null) {
            int numberOfSpells = WandHelper.getSpells(wand).length;
            int selectedSpell = wand.field_77990_d.func_74762_e(SELECTED_SPELL_KEY);
            selectedSpell = selectedSpell >= numberOfSpells - 1 ? 0 : ++selectedSpell;
            wand.field_77990_d.func_74768_a(SELECTED_SPELL_KEY, selectedSpell);
        }
    }

    public static void selectPreviousSpell(ItemStack wand) {
        if (WandHelper.getSpells(wand).length < 0) {
            WandHelper.setSpells(wand, new Spell[5]);
        }
        if (wand.field_77990_d != null) {
            int numberOfSpells = WandHelper.getSpells(wand).length;
            int selectedSpell = wand.field_77990_d.func_74762_e(SELECTED_SPELL_KEY);
            selectedSpell = selectedSpell <= 0 ? numberOfSpells - 1 : --selectedSpell;
            wand.field_77990_d.func_74768_a(SELECTED_SPELL_KEY, selectedSpell);
        }
    }

    public static int[] getCooldowns(ItemStack wand) {
        int[] cooldowns = new int[]{};
        if (wand.field_77990_d != null) {
            return wand.field_77990_d.func_74759_k(COOLDOWN_ARRAY_KEY);
        }
        return cooldowns;
    }

    public static void setCooldowns(ItemStack wand, int[] cooldowns) {
        if (wand.field_77990_d == null) {
            wand.field_77990_d = new NBTTagCompound();
        }
        wand.field_77990_d.func_74783_a(COOLDOWN_ARRAY_KEY, cooldowns);
    }

    public static void decrementCooldowns(ItemStack wand) {
        int[] cooldowns = WandHelper.getCooldowns(wand);
        if (cooldowns.length == 0) {
            return;
        }
        for (int i = 0; i < cooldowns.length; ++i) {
            if (cooldowns[i] <= 0) continue;
            int n = i;
            cooldowns[n] = cooldowns[n] - 1;
        }
        WandHelper.setCooldowns(wand, cooldowns);
    }

    public static int getCurrentCooldown(ItemStack wand) {
        int[] cooldowns = WandHelper.getCooldowns(wand);
        if (cooldowns.length == 0) {
            return 0;
        }
        return cooldowns[wand.field_77990_d.func_74762_e(SELECTED_SPELL_KEY)];
    }

    public static void setCurrentCooldown(ItemStack wand, int cooldown) {
        int[] cooldowns;
        if (wand.field_77990_d == null) {
            wand.field_77990_d = new NBTTagCompound();
        }
        if ((cooldowns = WandHelper.getCooldowns(wand)).length == 0) {
            cooldowns = new int[WandHelper.getSpells(wand).length];
        }
        cooldowns[wand.field_77990_d.func_74762_e((String)SELECTED_SPELL_KEY)] = cooldown;
        WandHelper.setCooldowns(wand, cooldowns);
    }

    public static int getUpgradeLevel(ItemStack wand, Item upgrade) {
        String key = upgradeMap.get(upgrade);
        if (wand.field_77990_d != null && wand.field_77990_d.func_74764_b(UPGRADES_KEY) && key != null) {
            return wand.field_77990_d.func_74775_l(UPGRADES_KEY).func_74762_e(key);
        }
        return 0;
    }

    public static int getTotalUpgrades(ItemStack wand) {
        int totalUpgrades = 0;
        for (Item item : upgradeMap.keySet()) {
            totalUpgrades += WandHelper.getUpgradeLevel(wand, item);
        }
        return totalUpgrades;
    }

    public static void applyUpgrade(ItemStack wand, Item upgrade) {
        if (wand.field_77990_d == null) {
            wand.field_77990_d = new NBTTagCompound();
        }
        if (!wand.field_77990_d.func_74764_b(UPGRADES_KEY)) {
            wand.field_77990_d.func_74782_a(UPGRADES_KEY, (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound upgrades = wand.field_77990_d.func_74775_l(UPGRADES_KEY);
        String key = upgradeMap.get(upgrade);
        if (key != null) {
            upgrades.func_74768_a(key, upgrades.func_74762_e(key) + 1);
        }
        wand.field_77990_d.func_74782_a(UPGRADES_KEY, (NBTBase)upgrades);
    }

    public static boolean isWandUpgrade(Item upgrade) {
        return upgradeMap.containsKey(upgrade);
    }

    public static Set<Item> getSpecialUpgrades() {
        return upgradeMap.keySet();
    }

    public static void registerSpecialUpgrade(Item upgrade, String identifier) {
        if (upgradeMap.containsValue(identifier)) {
            throw new IllegalArgumentException("Duplicate wand upgrade identifier: " + identifier);
        }
        upgradeMap.put(upgrade, identifier);
    }

    static {
        upgradeMap.put(Wizardry.condenserUpgrade, "condenser");
        upgradeMap.put(Wizardry.storageUpgrade, "storage");
        upgradeMap.put(Wizardry.siphonUpgrade, "siphon");
        upgradeMap.put(Wizardry.rangeUpgrade, "range");
        upgradeMap.put(Wizardry.durationUpgrade, "duration");
        upgradeMap.put(Wizardry.cooldownUpgrade, COOLDOWN_ARRAY_KEY);
        upgradeMap.put(Wizardry.blastUpgrade, "blast");
        upgradeMap.put(Wizardry.attunementUpgrade, "attunement");
    }
}

