/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import electroblob.wizardry.CommonProxy;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.ExtendedPlayer;
import electroblob.wizardry.IElementalDamage;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.SpellGlyphData;
import electroblob.wizardry.WandHelper;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryRegistry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.EntityArc;
import electroblob.wizardry.entity.construct.EntityBubble;
import electroblob.wizardry.entity.construct.EntityDecay;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.EntitySilverfishMinion;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.item.ItemFlamingAxe;
import electroblob.wizardry.item.ItemFrostAxe;
import electroblob.wizardry.item.ItemSpectralArmour;
import electroblob.wizardry.item.ItemSpectralBow;
import electroblob.wizardry.item.ItemSpectralPickaxe;
import electroblob.wizardry.item.ItemSpectralSword;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.spell.Clairvoyance;
import electroblob.wizardry.spell.Intimidate;
import electroblob.wizardry.spell.MindControl;
import electroblob.wizardry.spell.ShadowWard;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WizardryEventHandler {
    @SubscribeEvent
    public void onEntityConstructingEvent(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && ExtendedPlayer.get((EntityPlayer)event.entity) == null) {
            ExtendedPlayer.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onWorldLoadEvent(WorldEvent.Load event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0) {
            SpellGlyphData.get(event.world);
        }
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (!Wizardry.friendlyFire && event.source != null && event.source.func_76346_g() instanceof EntityPlayer && event.entity instanceof EntityPlayer && event.source instanceof IElementalDamage && WizardryUtilities.isPlayerAlly((EntityPlayer)event.source.func_76346_g(), (EntityPlayer)event.entity)) {
            event.setCanceled(true);
            return;
        }
        if (event.source instanceof IElementalDamage) {
            if (MagicDamage.isEntityImmune(((IElementalDamage)event.source).getType(), event.entity)) {
                event.setCanceled(true);
                return;
            }
            if (event.entityLiving instanceof EntityCreeper && !((EntityCreeper)event.entityLiving).func_70830_n() && ((IElementalDamage)event.source).getType() == MagicDamage.DamageType.SHOCK) {
                event.entityLiving.func_70096_w().func_75692_b(17, (Object)1);
                if (event.source.func_76346_g() instanceof EntityPlayer) {
                    ((EntityPlayer)event.source.func_76346_g()).func_71029_a((StatBase)Wizardry.chargeCreeper);
                }
            }
        }
        if (event.entityLiving.field_70154_o instanceof EntityBubble && !((EntityBubble)event.entityLiving.field_70154_o).isDarkOrb) {
            event.entityLiving.field_70154_o.field_70170_p.func_72956_a(event.entityLiving.field_70154_o, "random.pop", 1.5f, 1.0f);
            event.entityLiving.field_70154_o.func_70106_y();
        }
        if (event.entityLiving.func_70644_a(Wizardry.transience) && event.source != null && !event.source.func_76363_c()) {
            event.setCanceled(true);
            return;
        }
        if (event.source != null && event.source.func_76346_g() instanceof EntityLivingBase) {
            if (event.entityLiving.func_70644_a(Wizardry.mindTrick)) {
                event.entityLiving.func_82170_o(Wizardry.mindTrick.field_76415_H);
            }
            EntityLivingBase attacker = (EntityLivingBase)event.source.func_76346_g();
            World world = event.entityLiving.field_70170_p;
            ItemStack wand = event.entityLiving.func_70694_bm();
            if (event.entityLiving.func_70644_a(Wizardry.fireskin) && !event.source.func_76352_a() && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, (Entity)event.entityLiving)) {
                attacker.func_70015_d(5);
            }
            if (event.entityLiving.func_70644_a(Wizardry.iceShroud) && !event.source.func_76352_a() && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)event.entityLiving)) {
                attacker.func_70690_d(new PotionEffect(Wizardry.frost.field_76415_H, 100, 0, true));
            }
            if (event.entityLiving.func_70644_a(Wizardry.staticAura) && !event.source.func_76352_a()) {
                if (!world.field_72995_K) {
                    EntityArc arc = new EntityArc(world);
                    arc.setEndpointCoords(event.entityLiving.field_70165_t, event.entityLiving.field_70163_u + 1.0, event.entityLiving.field_70161_v, attacker.field_70165_t, attacker.field_70163_u + (double)(attacker.field_70131_O / 2.0f), attacker.field_70161_v);
                    world.func_72838_d((Entity)arc);
                } else {
                    for (int i = 0; i < 8; ++i) {
                        Wizardry.proxy.spawnParticle(EnumParticleType.SPARK, world, attacker.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, WizardryUtilities.getEntityFeetPos((Entity)attacker) + (double)(attacker.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, attacker.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                        world.func_72869_a("largesmoke", attacker.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, WizardryUtilities.getEntityFeetPos((Entity)attacker) + (double)(attacker.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, attacker.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0);
                    }
                }
                attacker.func_70097_a(MagicDamage.causeDirectMagicDamage(event.entityLiving, MagicDamage.DamageType.SHOCK), 4.0f);
                world.func_72956_a((Entity)attacker, "wizardry:arc", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.5f);
            }
            if (event.entityLiving instanceof EntityPlayer && ((EntityPlayer)event.entityLiving).func_71039_bw() && wand != null && wand.func_77960_j() < wand.func_77958_k() && wand.func_77973_b() instanceof ItemWand && WandHelper.getCurrentSpell(wand) instanceof ShadowWard && !event.source.func_76363_c()) {
                event.setCanceled(true);
                event.entityLiving.func_70097_a(DamageSource.field_76376_m, event.ammount / 2.0f);
                attacker.func_70097_a(MagicDamage.causeDirectMagicDamage(event.entityLiving, MagicDamage.DamageType.MAGIC), event.ammount / 2.0f);
            }
            if (attacker.func_70644_a(Wizardry.transience)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        int level;
        EntityLivingBase attacker;
        ExtendedPlayer properties;
        if (!event.entity.field_70170_p.field_72995_K && event.entityLiving instanceof EntityPlayer && !event.source.func_76363_c() && (properties = ExtendedPlayer.get((EntityPlayer)event.entityLiving)) != null) {
            properties.damageAllSoulboundCreatures(event.ammount);
        }
        if (event.source.func_76346_g() instanceof EntityLivingBase && (attacker = (EntityLivingBase)event.source.func_76346_g()).func_70694_bm() != null && attacker.func_70694_bm().func_77973_b() instanceof ItemSword) {
            int level2 = EnchantmentHelper.func_77506_a((int)Wizardry.flamingWeapon.field_77352_x, (ItemStack)attacker.func_70694_bm());
            if (level2 > 0 && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, (Entity)event.entityLiving)) {
                event.entityLiving.func_70015_d(level2 * 4);
            }
            if ((level2 = EnchantmentHelper.func_77506_a((int)Wizardry.freezingWeapon.field_77352_x, (ItemStack)attacker.func_70694_bm())) > 0 && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)event.entityLiving)) {
                event.entityLiving.func_70690_d(new PotionEffect(Wizardry.frost.field_76415_H, level2 * 200, 0, true));
            }
        }
        if (event.source.func_76364_f() instanceof EntityArrow && event.source.func_76364_f().getEntityData() != null && (level = event.source.func_76364_f().getEntityData().func_74762_e("frostLevel")) > 0 && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)event.entityLiving)) {
            event.entityLiving.func_70690_d(new PotionEffect(Wizardry.frost.field_76415_H, level * 150, 0, true));
        }
        if (event.source != null && event.source instanceof IElementalDamage) {
            event.ammount = event.source.func_76346_g() instanceof EntityPlayer ? (float)((double)event.ammount * Wizardry.playerDamageScale) : (float)((double)event.ammount * Wizardry.npcDamageScale);
        }
    }

    @SubscribeEvent
    public void onBlockPlaceEvent(BlockEvent.PlaceEvent event) {
        if (event.player.func_70644_a(Wizardry.transience)) {
            event.setCanceled(true);
            return;
        }
        if (event.placedAgainst == Wizardry.spectralBlock) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        List<EntityWizard> wizards;
        if (event.getPlayer().func_70644_a(Wizardry.transience)) {
            event.setCanceled(true);
            return;
        }
        if (!(event.getPlayer() instanceof FakePlayer) && !(wizards = WizardryUtilities.getEntitiesWithinRadius(64.0, event.x, event.y, event.z, event.world, EntityWizard.class)).isEmpty()) {
            for (EntityWizard wizard : wizards) {
                if (!wizard.isBlockPartOfTower(event.x, event.y, event.z)) continue;
                wizard.func_70604_c((EntityLivingBase)event.getPlayer());
                event.getPlayer().func_71029_a((StatBase)Wizardry.angerWizard);
            }
        }
    }

    @SubscribeEvent
    public void onEntityStruckByLightningEvent(EntityStruckByLightningEvent event) {
        if (event.lightning.getEntityData() != null && event.lightning.getEntityData().func_74764_b("summoningPlayer")) {
            EntityPlayer player = (EntityPlayer)WizardryUtilities.getEntityByUUID(event.lightning.field_70170_p, UUID.fromString(event.lightning.getEntityData().func_74779_i("summoningPlayer")));
            if (event.entity instanceof EntityCreeper) {
                player.func_71029_a((StatBase)Wizardry.chargeCreeper);
            }
            if (event.entity instanceof EntityPig) {
                player.func_71029_a((StatBase)Wizardry.frankenstein);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        Entity caster;
        NBTTagCompound entityNBT;
        block36: {
            if (event.entityLiving instanceof EntityPlayer) {
                Map enchantments;
                EntityPlayer entityplayer;
                block35: {
                    block34: {
                        entityplayer = (EntityPlayer)event.entityLiving;
                        if (ExtendedPlayer.get(entityplayer) != null) {
                            ExtendedPlayer.get(entityplayer).update(entityplayer);
                        }
                        if (entityplayer.field_71070_bA instanceof ContainerWorkbench) {
                            this.craftingTableTick(entityplayer);
                        }
                        if (entityplayer.field_71070_bA instanceof ContainerPlayer) {
                            this.playerInventoryTick(entityplayer);
                        }
                        if (entityplayer.func_82169_q(0) != null && entityplayer.func_82169_q(0).func_77973_b() instanceof ItemWizardArmour && entityplayer.func_82169_q(1) != null && entityplayer.func_82169_q(1).func_77973_b() instanceof ItemWizardArmour && entityplayer.func_82169_q(2) != null && entityplayer.func_82169_q(2).func_77973_b() instanceof ItemWizardArmour && entityplayer.func_82169_q(3) != null && entityplayer.func_82169_q(3).func_77973_b() instanceof ItemWizardArmour) {
                            entityplayer.func_71029_a((StatBase)Wizardry.armourSet);
                        }
                        if (ExtendedPlayer.get(entityplayer) != null) {
                            for (ItemStack stack : entityplayer.field_71071_by.field_70462_a) {
                                if (stack == null || !stack.func_77948_v() || !(enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack)).containsKey(Wizardry.magicSword.field_77352_x) && !enchantments.containsKey(Wizardry.magicBow.field_77352_x)) continue;
                                if (ExtendedPlayer.get((EntityPlayer)entityplayer).magicWeaponDuration > 0) {
                                    --ExtendedPlayer.get((EntityPlayer)entityplayer).magicWeaponDuration;
                                } else {
                                    enchantments.remove(Wizardry.magicSword.field_77352_x);
                                    enchantments.remove(Wizardry.magicBow.field_77352_x);
                                    EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                                }
                                break block34;
                            }
                            if (ExtendedPlayer.get((EntityPlayer)entityplayer).magicWeaponDuration > 0) {
                                ExtendedPlayer.get((EntityPlayer)entityplayer).magicWeaponDuration = 0;
                            }
                        }
                    }
                    if (ExtendedPlayer.get(entityplayer) != null) {
                        for (ItemStack stack : entityplayer.field_71071_by.field_70462_a) {
                            if (stack == null || !stack.func_77948_v() || !(enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack)).containsKey(Wizardry.flamingWeapon.field_77352_x)) continue;
                            if (ExtendedPlayer.get((EntityPlayer)entityplayer).flamingWeaponDuration > 0) {
                                --ExtendedPlayer.get((EntityPlayer)entityplayer).flamingWeaponDuration;
                            } else {
                                enchantments.remove(Wizardry.flamingWeapon.field_77352_x);
                                EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                            }
                            break block35;
                        }
                        if (ExtendedPlayer.get((EntityPlayer)entityplayer).flamingWeaponDuration > 0) {
                            ExtendedPlayer.get((EntityPlayer)entityplayer).flamingWeaponDuration = 0;
                        }
                    }
                }
                if (ExtendedPlayer.get(entityplayer) != null) {
                    for (ItemStack stack : entityplayer.field_71071_by.field_70462_a) {
                        if (stack == null || !stack.func_77948_v() || !(enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack)).containsKey(Wizardry.freezingWeapon.field_77352_x)) continue;
                        if (ExtendedPlayer.get((EntityPlayer)entityplayer).freezingWeaponDuration > 0) {
                            --ExtendedPlayer.get((EntityPlayer)entityplayer).freezingWeaponDuration;
                        } else {
                            enchantments.remove(Wizardry.freezingWeapon.field_77352_x);
                            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                        }
                        break block36;
                    }
                    if (ExtendedPlayer.get((EntityPlayer)entityplayer).freezingWeaponDuration > 0) {
                        ExtendedPlayer.get((EntityPlayer)entityplayer).freezingWeaponDuration = 0;
                    }
                }
            }
        }
        if (event.entityLiving.field_70170_p.field_72995_K) {
            if (event.entityLiving.func_70644_a(Wizardry.frost)) {
                double x = event.entityLiving.field_70165_t + (event.entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)event.entityLiving.field_70130_N;
                double y = WizardryUtilities.getEntityFeetPos((Entity)event.entityLiving) + event.entityLiving.field_70170_p.field_73012_v.nextDouble() * (double)event.entityLiving.field_70131_O;
                double z = event.entityLiving.field_70161_v + (event.entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)event.entityLiving.field_70130_N;
                Wizardry.proxy.spawnParticle(EnumParticleType.SNOW, event.entityLiving.field_70170_p, x, y, z, 0.0, -0.02, 0.0, 15 + event.entityLiving.field_70170_p.field_73012_v.nextInt(5));
            }
            if (event.entityLiving.func_70644_a(Wizardry.fireskin)) {
                double x = event.entityLiving.field_70165_t + (event.entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)event.entityLiving.field_70130_N;
                double y = WizardryUtilities.getEntityFeetPos((Entity)event.entityLiving) + event.entityLiving.field_70170_p.field_73012_v.nextDouble() * (double)event.entityLiving.field_70131_O;
                double z = event.entityLiving.field_70161_v + (event.entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)event.entityLiving.field_70130_N;
                event.entityLiving.field_70170_p.func_72869_a("flame", x, y, z, 0.0, 0.0, 0.0);
            }
            if (event.entityLiving.func_70644_a(Wizardry.iceShroud)) {
                double x = event.entityLiving.field_70165_t + (event.entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)event.entityLiving.field_70130_N;
                double y = WizardryUtilities.getEntityFeetPos((Entity)event.entityLiving) + event.entityLiving.field_70170_p.field_73012_v.nextDouble() * (double)event.entityLiving.field_70131_O;
                double z = event.entityLiving.field_70161_v + (event.entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)event.entityLiving.field_70130_N;
                float brightness = 0.5f + event.entityLiving.field_70170_p.field_73012_v.nextFloat() / 2.0f;
                Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, event.entityLiving.field_70170_p, x, y, z, 0.0, 0.0, 0.0, 48 + event.entityLiving.field_70170_p.field_73012_v.nextInt(12), brightness, brightness + 0.1f, 1.0f, true, 0.0);
                Wizardry.proxy.spawnParticle(EnumParticleType.SNOW, event.entityLiving.field_70170_p, x, y, z, 0.0, -0.02, 0.0, 40 + event.entityLiving.field_70170_p.field_73012_v.nextInt(10));
            }
            if (event.entityLiving.func_70644_a(Wizardry.staticAura)) {
                double x = event.entityLiving.field_70165_t + (event.entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)event.entityLiving.field_70130_N;
                double y = WizardryUtilities.getEntityFeetPos((Entity)event.entityLiving) + event.entityLiving.field_70170_p.field_73012_v.nextDouble() * (double)event.entityLiving.field_70131_O;
                double z = event.entityLiving.field_70161_v + (event.entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)event.entityLiving.field_70130_N;
                Wizardry.proxy.spawnParticle(EnumParticleType.SPARK, event.entityLiving.field_70170_p, x, y, z, 0.0, 0.0, 0.0, 3);
            }
            if (event.entityLiving.func_70644_a(Wizardry.transience)) {
                double x = event.entityLiving.field_70165_t + (event.entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)event.entityLiving.field_70130_N;
                double y = WizardryUtilities.getEntityFeetPos((Entity)event.entityLiving) + event.entityLiving.field_70170_p.field_73012_v.nextDouble() * (double)event.entityLiving.field_70131_O;
                double z = event.entityLiving.field_70161_v + (event.entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)event.entityLiving.field_70130_N;
                Wizardry.proxy.spawnParticle(EnumParticleType.DUST, event.entityLiving.field_70170_p, x, y, z, 0.0, 0.0, 0.0, (int)(16.0 / (Math.random() * 0.8 + 0.2)), 0.8f, 0.8f, 1.0f);
            }
        } else if (event.entityLiving.func_70644_a(Wizardry.decay) && event.entityLiving.field_70122_E && event.entityLiving.field_70173_aa % 8 == 0) {
            List list = event.entityLiving.field_70170_p.func_72839_b((Entity)event.entityLiving, event.entityLiving.field_70121_D);
            boolean flag = true;
            for (Object object : list) {
                if (!(object instanceof EntityDecay)) continue;
                flag = false;
            }
            if (flag) {
                event.entityLiving.field_70170_p.func_72838_d((Entity)new EntityDecay(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, event.entityLiving));
            }
        }
        if (event.entityLiving.func_70644_a(Wizardry.mindTrick) && event.entityLiving instanceof EntityLiving && event.entityLiving instanceof EntityCreature) {
            ((EntityCreature)event.entityLiving).func_70784_b(null);
        }
        if (!(!event.entityLiving.func_70644_a(Wizardry.mindControl) || !(event.entityLiving instanceof EntityLiving) || (entityNBT = event.entityLiving.getEntityData()) != null && entityNBT.func_74764_b("controllingEntity") && (caster = WizardryUtilities.getEntityByUUID(event.entity.field_70170_p, UUID.fromString(entityNBT.func_74779_i("controllingEntity")))) instanceof EntityLivingBase && MindControl.findMindControlTarget((EntityLiving)event.entityLiving, (EntityLivingBase)caster, event.entity.field_70170_p))) {
            ((EntityLiving)event.entityLiving).func_70624_b(null);
        }
        if (event.entityLiving.func_70644_a(Wizardry.fear) && event.entityLiving instanceof EntityCreature) {
            Entity caster2;
            entityNBT = event.entityLiving.getEntityData();
            EntityCreature creature = (EntityCreature)event.entityLiving;
            if (entityNBT != null && entityNBT.func_74764_b("fearedEntity") && (caster2 = WizardryUtilities.getEntityByUUID(creature.field_70170_p, UUID.fromString(entityNBT.func_74779_i("fearedEntity")))) instanceof EntityLivingBase) {
                Intimidate.runAway(creature, (EntityLivingBase)caster2);
            }
        }
    }

    @SubscribeEvent
    public void onBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (event.entityPlayer.func_70644_a(Wizardry.frost)) {
            event.newSpeed = event.originalSpeed * (1.0f - 0.45f * (float)(event.entityPlayer.func_70660_b(Wizardry.frost).func_76458_c() + 1));
        }
    }

    private void playerInventoryTick(EntityPlayer player) {
        boolean flag = false;
        ItemStack wand = null;
        ItemStack armour = null;
        InventoryCrafting craftMatrix = ((ContainerPlayer)player.field_71070_bA).field_75181_e;
        ItemStack outputItem = ((ContainerPlayer)player.field_71070_bA).field_75179_f.func_70301_a(0);
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            if (craftMatrix.func_70301_a(i) == null) continue;
            ItemStack itemstack = craftMatrix.func_70301_a(i);
            if (itemstack.func_77973_b() == Wizardry.manaFlask) {
                flag = true;
            }
            if (itemstack.func_77973_b() instanceof ItemWand) {
                wand = itemstack;
            }
            if (!(itemstack.func_77973_b() instanceof ItemWizardArmour)) continue;
            armour = itemstack;
        }
        if (outputItem != null && outputItem.func_77973_b() instanceof ItemWand && flag && wand != null) {
            outputItem.func_77982_d(wand.func_77978_p());
            if (wand.func_77960_j() - 700 < 0) {
                outputItem.func_77964_b(0);
            } else {
                outputItem.func_77964_b(wand.func_77960_j() - 700);
            }
        }
        if (outputItem != null && outputItem.func_77973_b() instanceof ItemWizardArmour && flag && armour != null) {
            outputItem.func_77982_d(armour.func_77978_p());
            if (armour.func_77960_j() - 700 < 0) {
                outputItem.func_77964_b(0);
            } else {
                outputItem.func_77964_b(wand.func_77960_j() - 700);
            }
        }
    }

    private void craftingTableTick(EntityPlayer player) {
        boolean flag = false;
        ItemStack wand = null;
        ItemStack armour = null;
        InventoryCrafting craftMatrix = ((ContainerWorkbench)player.field_71070_bA).field_75162_e;
        ItemStack outputItem = ((ContainerWorkbench)player.field_71070_bA).field_75160_f.func_70301_a(0);
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            if (craftMatrix.func_70301_a(i) == null) continue;
            ItemStack itemstack = craftMatrix.func_70301_a(i);
            if (itemstack.func_77973_b() == Wizardry.manaFlask) {
                flag = true;
            }
            if (itemstack.func_77973_b() instanceof ItemWand) {
                wand = itemstack;
            }
            if (!(itemstack.func_77973_b() instanceof ItemWizardArmour)) continue;
            armour = itemstack;
        }
        if (outputItem != null && outputItem.func_77973_b() instanceof ItemWand && flag && wand != null) {
            outputItem.func_77982_d(wand.func_77978_p());
            if (wand.func_77960_j() - 700 < 0) {
                outputItem.func_77964_b(0);
            } else {
                outputItem.func_77964_b(wand.func_77960_j() - 700);
            }
        }
        if (outputItem != null && outputItem.func_77973_b() instanceof ItemWizardArmour && flag && armour != null) {
            outputItem.func_77982_d(armour.func_77978_p());
            if (armour.func_77960_j() - 700 < 0) {
                outputItem.func_77964_b(0);
            } else {
                outputItem.func_77964_b(wand.func_77960_j() - 700);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer && ExtendedPlayer.get((EntityPlayer)event.entity) != null) {
            ExtendedPlayer.get((EntityPlayer)event.entity).onPlayerDeath();
            NBTTagCompound playerData = new NBTTagCompound();
            ExtendedPlayer.get((EntityPlayer)event.entity).saveNBTData(playerData);
            CommonProxy.storeEntityData(ExtendedPlayer.getSaveKey((EntityPlayer)event.entity), playerData);
        }
        if (event.source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
            for (int i = 0; i < 9; ++i) {
                ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                if (itemstack == null || !(itemstack.func_77973_b() instanceof ItemWand) || !itemstack.func_77951_h() || WandHelper.getUpgradeLevel(itemstack, Wizardry.siphonUpgrade) <= 0) continue;
                int damage = itemstack.func_77960_j() - 3 * WandHelper.getUpgradeLevel(itemstack, Wizardry.siphonUpgrade) - player.field_70170_p.field_73012_v.nextInt(3);
                if (damage < 0) {
                    damage = 0;
                }
                itemstack.func_77964_b(damage);
                break;
            }
            if (event.entityLiving == player && event.source instanceof IElementalDamage) {
                player.func_71029_a((StatBase)Wizardry.selfDestruct);
            }
        }
        if (event.source.func_76346_g() instanceof EntitySilverfishMinion) {
            int lifetime = ((EntitySilverfishMinion)event.source.func_76346_g()).lifetime;
            int alliesToSummon = event.entity.field_70170_p.field_73012_v.nextInt(4) + 1;
            for (int i = 0; i < alliesToSummon; ++i) {
                EntitySilverfishMinion silverfish = new EntitySilverfishMinion(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, ((EntitySilverfishMinion)event.source.func_76346_g()).getCaster(), lifetime);
                event.entity.field_70170_p.func_72838_d((Entity)silverfish);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            NBTTagCompound playerData = CommonProxy.getEntityData(ExtendedPlayer.getSaveKey((EntityPlayer)event.entity));
            if (playerData != null) {
                ExtendedPlayer.get((EntityPlayer)event.entity).loadNBTData(playerData);
            }
            ExtendedPlayer.get((EntityPlayer)event.entity).sync();
            if (event.entity instanceof EntityPlayerMP) {
                SpellGlyphData.get(event.world).sync((EntityPlayerMP)event.entity);
            }
        }
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityArrow) {
            EntityLivingBase archer;
            EntityArrow arrow = (EntityArrow)event.entity;
            if (arrow.field_70250_c instanceof EntityLivingBase && (archer = (EntityLivingBase)arrow.field_70250_c).func_70694_bm() != null && archer.func_70694_bm().func_77973_b() instanceof ItemBow) {
                int level = EnchantmentHelper.func_77506_a((int)Wizardry.magicBow.field_77352_x, (ItemStack)archer.func_70694_bm());
                if (level > 0) {
                    arrow.func_70239_b(arrow.func_70242_d() + (double)level * 0.5 + 0.5);
                }
                if (EnchantmentHelper.func_77506_a((int)Wizardry.flamingWeapon.field_77352_x, (ItemStack)archer.func_70694_bm()) > 0) {
                    arrow.func_70015_d(100);
                }
                if ((level = EnchantmentHelper.func_77506_a((int)Wizardry.freezingWeapon.field_77352_x, (ItemStack)archer.func_70694_bm())) > 0 && arrow.getEntityData() != null) {
                    arrow.getEntityData().func_74768_a("frostLevel", level);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDropsEvent(LivingDropsEvent event) {
        int rareDropNumber;
        if (event.entityLiving instanceof EntityMob && !(event.entityLiving instanceof EntityEvilWizard) && event.source.func_76346_g() instanceof EntityPlayer && Wizardry.spellBookDropChance > 0 && (rareDropNumber = event.entity.field_70170_p.field_73012_v.nextInt(200) - event.lootingLevel) < Wizardry.spellBookDropChance) {
            int id = WizardryUtilities.getStandardWeightedRandomSpellId(event.entity.field_70170_p.field_73012_v);
            event.drops.add(new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, new ItemStack(Wizardry.spellBook, 1, id)));
        }
        for (EntityItem item : event.drops) {
            if (item.func_92059_d().func_77973_b() instanceof ItemSpectralSword || item.func_92059_d().func_77973_b() instanceof ItemSpectralPickaxe || item.func_92059_d().func_77973_b() instanceof ItemSpectralBow || item.func_92059_d().func_77973_b() instanceof ItemSpectralArmour || item.func_92059_d().func_77973_b() instanceof ItemFlamingAxe || item.func_92059_d().func_77973_b() instanceof ItemFrostAxe) {
                item.func_70106_y();
            }
            if (!item.func_92059_d().func_77948_v()) continue;
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)item.func_92059_d());
            enchantments.remove(Wizardry.magicSword.field_77352_x);
            enchantments.remove(Wizardry.magicBow.field_77352_x);
            enchantments.remove(Wizardry.flamingWeapon.field_77352_x);
            enchantments.remove(Wizardry.freezingWeapon.field_77352_x);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)item.func_92059_d());
        }
    }

    @SubscribeEvent
    public void onLivingSetAttackTargetEvent(LivingSetAttackTargetEvent event) {
        Entity caster;
        NBTTagCompound entityNBT;
        if ((event.entityLiving.func_70644_a(Wizardry.mindTrick) || event.entityLiving.func_70644_a(Wizardry.fear)) && event.entityLiving instanceof EntityLiving && event.target != null) {
            ((EntityLiving)event.entityLiving).func_70624_b(null);
        }
        if (!(!event.entityLiving.func_70644_a(Wizardry.mindControl) || !(event.entityLiving instanceof EntityLiving) || (entityNBT = event.entityLiving.getEntityData()) != null && entityNBT.func_74764_b("controllingEntity") && (WizardryUtilities.isValidTarget(caster = WizardryUtilities.getEntityByUUID(event.entity.field_70170_p, UUID.fromString(entityNBT.func_74779_i("controllingEntity"))), (Entity)event.target) || caster instanceof EntityLivingBase && MindControl.findMindControlTarget((EntityLiving)event.entityLiving, (EntityLivingBase)caster, event.entity.field_70170_p)) || event.target == null)) {
            ((EntityLiving)event.entityLiving).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void onItemPickupEvent(EntityItemPickupEvent event) {
        if (event.item.func_92059_d().func_77973_b() == Wizardry.magicCrystal) {
            event.entityPlayer.func_71064_a((StatBase)Wizardry.crystal, 1);
        }
    }

    @SubscribeEvent
    public void onItemTossEvent(ItemTossEvent event) {
        if (event.entityItem.func_92059_d().func_77973_b() instanceof ItemSpectralSword || event.entityItem.func_92059_d().func_77973_b() instanceof ItemSpectralPickaxe || event.entityItem.func_92059_d().func_77973_b() instanceof ItemSpectralBow || event.entityItem.func_92059_d().func_77973_b() instanceof ItemSpectralArmour || event.entityItem.func_92059_d().func_77973_b() instanceof ItemFlamingAxe || event.entityItem.func_92059_d().func_77973_b() instanceof ItemFrostAxe) {
            event.setCanceled(true);
            event.player.field_71071_by.func_70441_a(event.entityItem.func_92059_d());
        }
        if (event.entityItem.func_92059_d().func_77948_v()) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)event.entityItem.func_92059_d());
            enchantments.remove(Wizardry.magicSword.field_77352_x);
            enchantments.remove(Wizardry.magicBow.field_77352_x);
            enchantments.remove(Wizardry.flamingWeapon.field_77352_x);
            enchantments.remove(Wizardry.freezingWeapon.field_77352_x);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)event.entityItem.func_92059_d());
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        ExtendedPlayer properties;
        ItemStack wand;
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.func_70093_af() && (wand = event.entityPlayer.func_70694_bm()) != null && wand.func_77973_b() instanceof ItemWand && WandHelper.getCurrentSpell(wand) instanceof Clairvoyance && (properties = ExtendedPlayer.get(event.entityPlayer)) != null) {
            int x = event.x;
            int y = event.y;
            int z = event.z;
            if (event.face == 0) {
                --y;
            }
            if (event.face == 1) {
                ++y;
            }
            if (event.face == 2) {
                --z;
            }
            if (event.face == 3) {
                ++z;
            }
            if (event.face == 4) {
                --x;
            }
            if (event.face == 5) {
                ++x;
            }
            properties.setClairvoyancePoint(x, y, z, event.world.field_73011_w.field_76574_g);
            if (!event.world.field_72995_K) {
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("spell.clairvoyance.confirm", new Object[]{WizardryRegistry.clairvoyance.getDisplayNameWithFormatting()}));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBonemealEvent(BonemealEvent event) {
        int z;
        int y;
        int x;
        if (event.block == Blocks.field_150349_c && event.world.func_147437_c(x = event.x + event.world.field_73012_v.nextInt(8) - event.world.field_73012_v.nextInt(8), y = event.y + event.world.field_73012_v.nextInt(4) - event.world.field_73012_v.nextInt(4), z = event.z + event.world.field_73012_v.nextInt(8) - event.world.field_73012_v.nextInt(8)) && (!event.world.field_73011_w.field_76576_e || y < 127) && Wizardry.crystalFlower.func_149718_j(event.world, x, y, z)) {
            event.world.func_147465_d(x, y, z, Wizardry.crystalFlower, 0, 2);
        }
    }
}

