/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.living.EntityBlazeMinion;
import electroblob.wizardry.spell.Spell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class FrostRay
extends Spell {
    public FrostRay() {
        super(EnumTier.APPRENTICE, 5, EnumElement.ICE, "frost_ray", EnumSpellType.ATTACK, 0, EnumAction.none, true);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        Vec3 look = caster.func_70040_Z();
        MovingObjectPosition rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * rangeMultiplier);
        if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)rayTrace.field_72308_g;
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)target)) {
                if (!world.field_72995_K && ticksInUse == 1) {
                    caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getDisplayNameWithFormatting()}));
                }
            } else {
                double motionZ;
                double motionY;
                double motionX;
                target.func_70690_d(new PotionEffect(Wizardry.frost.field_76415_H, (int)(200.0f * durationMultiplier), 0, true));
                if (target instanceof EntityBlaze || target instanceof EntityMagmaCube || target instanceof EntityBlazeMinion) {
                    motionX = target.field_70159_w;
                    motionY = target.field_70181_x;
                    motionZ = target.field_70179_y;
                    target.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.FROST), 6.0f * damageMultiplier);
                    target.field_70159_w = motionX;
                    target.field_70181_x = motionY;
                    target.field_70179_y = motionZ;
                } else {
                    motionX = target.field_70159_w;
                    motionY = target.field_70181_x;
                    motionZ = target.field_70179_y;
                    target.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.FROST), 3.0f * damageMultiplier);
                    target.field_70159_w = motionX;
                    target.field_70181_x = motionY;
                    target.field_70179_y = motionZ;
                }
            }
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, world, x1, y1, z1, look.field_72450_a * (double)rangeMultiplier, look.field_72448_b * (double)rangeMultiplier, look.field_72449_c * (double)rangeMultiplier, 8 + world.field_73012_v.nextInt(12), 0.4f, 0.6f, 1.0f);
                x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, world, x1, y1, z1, look.field_72450_a * (double)rangeMultiplier, look.field_72448_b * (double)rangeMultiplier, look.field_72449_c * (double)rangeMultiplier, 8 + world.field_73012_v.nextInt(12), 1.0f, 1.0f, 1.0f);
            }
        }
        if (ticksInUse % 12 == 0) {
            if (ticksInUse == 0) {
                world.func_72956_a((Entity)caster, "wizardry:ice", 0.5f, 1.0f);
            }
            world.func_72956_a((Entity)caster, "wizardry:frostray", 0.5f, 1.0f);
        }
        return true;
    }
}

