/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.spell.Spell;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Intimidate
extends Spell {
    public static final String NBT_KEY = "fearedEntity";

    public Intimidate() {
        super(EnumTier.APPRENTICE, 20, EnumElement.NECROMANCY, "intimidate", EnumSpellType.ATTACK, 100, EnumAction.bow, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        if (!world.field_72995_K) {
            List<EntityCreature> entities = WizardryUtilities.getEntitiesWithinRadius(8.0f * rangeMultiplier, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world, EntityCreature.class);
            for (EntityCreature target : entities) {
                Intimidate.runAway(target, (EntityLivingBase)caster);
                NBTTagCompound entityNBT = target.getEntityData();
                if (entityNBT != null) {
                    entityNBT.func_74778_a(NBT_KEY, caster.func_110124_au().toString());
                }
                target.func_70690_d(new PotionEffect(Wizardry.fear.field_76415_H, (int)(600.0f * durationMultiplier), 0));
            }
        } else {
            for (int i = 0; i < 30; ++i) {
                Wizardry.proxy.spawnParticle(EnumParticleType.DARK_MAGIC, world, caster.field_70165_t - 1.0 + world.field_73012_v.nextDouble() * 2.0, caster.field_70121_D.field_72338_b + 1.5 + world.field_73012_v.nextDouble() * 0.5, caster.field_70161_v - 1.0 + world.field_73012_v.nextDouble() * 2.0, 0.0, 0.0, 0.0, 0, 0.9f, 0.1f, 0.0f);
            }
        }
        world.func_72956_a((Entity)caster, "mob.enderdragon.growl", 1.0f, 1.0f);
        return true;
    }

    public static boolean runAway(EntityCreature target, EntityLivingBase caster) {
        if (target.func_70032_d((Entity)caster) < 16.0f) {
            PathPoint point;
            Vec3 vec3 = RandomPositionGenerator.func_75461_b((EntityCreature)target, (int)16, (int)7, (Vec3)Vec3.func_72443_a((double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v));
            if (vec3 == null) {
                return false;
            }
            PathEntity path = target.func_70661_as().func_75488_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
            if (!target.func_70781_l() || target.func_70777_m() == caster) {
                target.func_70778_a(path);
            }
            target.func_70784_b(null);
            boolean flag = true;
            if (!target.func_70661_as().func_75500_f() && (point = target.func_70661_as().func_75505_d().func_75870_c()) != null) {
                flag = caster.func_70011_f((double)point.field_75839_a, (double)point.field_75837_b, (double)point.field_75838_c) < 16.0;
            }
            target.func_70624_b(null);
            if (flag) {
                return target.func_70661_as().func_75492_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, 1.25);
            }
        }
        return false;
    }
}

