/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.AllData;
import net.techbrew.journeymap.data.AnimalsData;
import net.techbrew.journeymap.data.MessagesData;
import net.techbrew.journeymap.data.MobsData;
import net.techbrew.journeymap.data.PlayerData;
import net.techbrew.journeymap.data.PlayersData;
import net.techbrew.journeymap.data.VillagersData;
import net.techbrew.journeymap.data.WaypointsData;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.EntityDTO;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.waypoint.WaypointStore;

public class DataCache {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    final LoadingCache<Long, Map> all;
    final LoadingCache<Class, Map<String, EntityDTO>> animals;
    final LoadingCache<Class, Map<String, EntityDTO>> mobs;
    final LoadingCache<Class, Map<String, EntityDTO>> players;
    final LoadingCache<Class, Map<String, EntityDTO>> villagers;
    final LoadingCache<Class, Collection<Waypoint>> waypoints;
    final LoadingCache<Class, EntityDTO> player;
    final LoadingCache<Class, WorldData> world;
    final LoadingCache<Class, Map<String, Object>> messages;

    private DataCache() {
        AllData allData = new AllData();
        this.all = CacheBuilder.newBuilder().recordStats().maximumSize(1L).expireAfterWrite(allData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)allData);
        AnimalsData animalsData = new AnimalsData();
        this.animals = CacheBuilder.newBuilder().recordStats().expireAfterWrite(animalsData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)animalsData);
        MobsData mobsData = new MobsData();
        this.mobs = CacheBuilder.newBuilder().recordStats().expireAfterWrite(mobsData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)mobsData);
        PlayerData playerData = new PlayerData();
        this.player = CacheBuilder.newBuilder().recordStats().expireAfterWrite(playerData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)playerData);
        PlayersData playersData = new PlayersData();
        this.players = CacheBuilder.newBuilder().recordStats().expireAfterWrite(playersData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)playersData);
        VillagersData villagersData = new VillagersData();
        this.villagers = CacheBuilder.newBuilder().recordStats().expireAfterWrite(villagersData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)villagersData);
        WaypointsData waypointsData = new WaypointsData();
        this.waypoints = CacheBuilder.newBuilder().recordStats().expireAfterWrite(waypointsData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)waypointsData);
        WorldData worldData = new WorldData();
        this.world = CacheBuilder.newBuilder().recordStats().expireAfterWrite(worldData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)worldData);
        MessagesData messagesData = new MessagesData();
        this.messages = CacheBuilder.newBuilder().recordStats().expireAfterWrite(messagesData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)messagesData);
    }

    public static DataCache instance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAll(long since) {
        LoadingCache<Long, Map> loadingCache = this.all;
        synchronized (loadingCache) {
            try {
                return (Map)this.all.get((Object)since);
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().severe("ExecutionException in getAll: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EntityDTO> getAnimals(boolean forceRefresh) {
        LoadingCache<Class, Map<String, EntityDTO>> loadingCache = this.animals;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.animals.invalidateAll();
                }
                return (Map)this.animals.get(AnimalsData.class);
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().severe("ExecutionException in getAnimals: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EntityDTO> getMobs(boolean forceRefresh) {
        LoadingCache<Class, Map<String, EntityDTO>> loadingCache = this.mobs;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.mobs.invalidateAll();
                }
                return (Map)this.mobs.get(MobsData.class);
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().severe("ExecutionException in getMobs: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EntityDTO> getPlayers(boolean forceRefresh) {
        LoadingCache<Class, Map<String, EntityDTO>> loadingCache = this.players;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.players.invalidateAll();
                }
                return (Map)this.players.get(PlayersData.class);
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().severe("ExecutionException in getPlayers: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    public static EntityDTO getPlayer() {
        return DataCache.instance().getPlayer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityDTO getPlayer(boolean forceRefresh) {
        LoadingCache<Class, EntityDTO> loadingCache = this.player;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.player.invalidateAll();
                }
                return (EntityDTO)this.player.get(PlayersData.class);
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().severe("ExecutionException in getPlayer: " + LogFormatter.toString(e));
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EntityDTO> getVillagers(boolean forceRefresh) {
        LoadingCache<Class, Map<String, EntityDTO>> loadingCache = this.villagers;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.villagers.invalidateAll();
                }
                return (Map)this.villagers.get(VillagersData.class);
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().severe("ExecutionException in getVillagers: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Waypoint> getWaypoints(boolean forceRefresh) {
        LoadingCache<Class, Collection<Waypoint>> loadingCache = this.waypoints;
        synchronized (loadingCache) {
            if (WaypointsData.isReiMinimapEnabled() || WaypointsData.isVoxelMapEnabled()) {
                try {
                    if (forceRefresh) {
                        this.waypoints.invalidateAll();
                    }
                    return (Collection)this.waypoints.get(WaypointsData.class);
                }
                catch (ExecutionException e) {
                    JourneyMap.getLogger().severe("ExecutionException in getVillagers: " + LogFormatter.toString(e));
                    return Collections.EMPTY_LIST;
                }
            }
            if (WaypointsData.isManagerEnabled()) {
                return WaypointStore.instance().getAll();
            }
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getMessages(boolean forceRefresh) {
        LoadingCache<Class, Map<String, Object>> loadingCache = this.messages;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.messages.invalidateAll();
                }
                return (Map)this.messages.get(MessagesData.class);
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().severe("ExecutionException in getMessages: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorldData getWorld(boolean forceRefresh) {
        LoadingCache<Class, WorldData> loadingCache = this.world;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.world.invalidateAll();
                }
                return (WorldData)((Object)this.world.get(WorldData.class));
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().severe("ExecutionException in getWorld: " + LogFormatter.toString(e));
                return new WorldData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Object object = this.all;
        synchronized (object) {
            this.all.invalidateAll();
        }
        object = this.animals;
        synchronized (object) {
            this.animals.invalidateAll();
        }
        object = this.mobs;
        synchronized (object) {
            this.mobs.invalidateAll();
        }
        object = this.players;
        synchronized (object) {
            this.players.invalidateAll();
        }
        object = this.player;
        synchronized (object) {
            this.player.invalidateAll();
        }
        object = this.villagers;
        synchronized (object) {
            this.villagers.invalidateAll();
        }
        object = this.waypoints;
        synchronized (object) {
            this.waypoints.invalidateAll();
        }
        object = this.world;
        synchronized (object) {
            this.world.invalidateAll();
        }
        object = this.messages;
        synchronized (object) {
            this.messages.invalidateAll();
        }
    }

    public String getDebugHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<pre>");
        sb.append(LogFormatter.LINEBREAK).append("<b>All (Web only):</b> ").append(this.toString(this.all.stats()));
        sb.append(LogFormatter.LINEBREAK).append("<b>       Animals:</b> ").append(this.toString(this.animals.stats()));
        sb.append(LogFormatter.LINEBREAK).append("<b>      Messages:</b> ").append(this.toString(this.messages.stats()));
        sb.append(LogFormatter.LINEBREAK).append("<b>          Mobs:</b> ").append(this.toString(this.mobs.stats()));
        sb.append(LogFormatter.LINEBREAK).append("<b>        Player:</b> ").append(this.toString(this.player.stats()));
        sb.append(LogFormatter.LINEBREAK).append("<b>       Players:</b> ").append(this.toString(this.players.stats()));
        sb.append(LogFormatter.LINEBREAK).append("<b>     Villagers:</b> ").append(this.toString(this.villagers.stats()));
        sb.append(LogFormatter.LINEBREAK).append("<b>     Waypoints:</b> ").append(this.toString(this.waypoints.stats()));
        sb.append(LogFormatter.LINEBREAK).append("<b>         World:</b> ").append(this.toString(this.world.stats()));
        sb.append("</pre>");
        return sb.toString();
    }

    private String toString(CacheStats cacheStats) {
        double avgLoadMillis = 0.0;
        if (cacheStats.totalLoadTime() > 0L && cacheStats.loadSuccessCount() > 0L) {
            avgLoadMillis = (double)TimeUnit.NANOSECONDS.toMillis(cacheStats.totalLoadTime()) * 1.0 / (double)cacheStats.loadSuccessCount();
        }
        return String.format("Hits: %6s, Misses: %6s, Loads: %6s, Errors: %6s, Avg Load Time: %1.2fms", cacheStats.hitCount(), cacheStats.missCount(), cacheStats.loadCount(), cacheStats.loadExceptionCount(), avgLoadMillis);
    }

    private static class Holder {
        private static final DataCache INSTANCE = new DataCache();

        private Holder() {
        }
    }
}

