/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.io.SortedProperties;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.properties.CoreProperties;
import net.techbrew.journeymap.properties.FullMapProperties;
import net.techbrew.journeymap.properties.MapProperties;
import net.techbrew.journeymap.properties.MiniMapProperties;
import net.techbrew.journeymap.properties.PropertiesBase;
import net.techbrew.journeymap.properties.WebMapProperties;
import net.techbrew.journeymap.ui.minimap.DisplayVars;

@Deprecated
public class PropertyManager {
    @Deprecated
    public static final String FILE_NAME = "journeyMap.properties";
    private final SortedProperties properties = new SortedProperties();
    private Boolean writeNeeded = false;

    public static PropertyManager getInstance() {
        return Holder.INSTANCE;
    }

    private String getString(Key key) {
        return this.properties.getProperty(key.getProperty());
    }

    private Integer getInteger(Key key) {
        return Integer.parseInt(this.properties.getProperty(key.getProperty()));
    }

    private Double getDouble(Key key) {
        return Double.parseDouble(this.properties.getProperty(key.getProperty()));
    }

    private Boolean getBoolean(Key key) {
        return Boolean.parseBoolean(this.properties.getProperty(key.getProperty()));
    }

    private void setProperty(Key key, Object value) {
        String old = this.properties.getProperty(key.getProperty());
        if (old == null || !old.equals(value)) {
            this.properties.setProperty(key.getProperty(), value.toString());
            this.writeToFile();
            JourneyMap.getLogger().fine("Property changed: " + key.getProperty() + "=" + value);
        } else {
            JourneyMap.getLogger().fine("Property unchanged: " + key.getProperty() + "=" + value);
        }
    }

    private static String getStringProp(Key key) {
        return PropertyManager.getInstance().getString(key);
    }

    private static Integer getIntegerProp(Key key) {
        return PropertyManager.getInstance().getInteger(key);
    }

    private static Boolean getBooleanProp(Key key) {
        return PropertyManager.getInstance().getBoolean(key);
    }

    private static Double getDoubleProp(Key key) {
        return PropertyManager.getInstance().getDouble(key);
    }

    private static Boolean toggle(Key key) {
        boolean flip = PropertyManager.getInstance().getBoolean(key) == false;
        PropertyManager.set(key, flip);
        return flip;
    }

    private static void set(Key key, Boolean value) {
        PropertyManager.getInstance().setProperty(key, value);
    }

    private static void set(Key key, Integer value) {
        PropertyManager.getInstance().setProperty(key, value);
    }

    private static void set(Key key, Double value) {
        PropertyManager.getInstance().setProperty(key, value);
    }

    private static void set(Key key, String value) {
        PropertyManager.getInstance().setProperty(key, value);
    }

    private Map<String, Object> getProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.properties.size());
        for (Key key : Key.values()) {
            if (key.type.equals(Boolean.class)) {
                map.put(key.getProperty(), this.getBoolean(key));
                continue;
            }
            if (key.type.equals(Integer.class)) {
                map.put(key.getProperty(), this.getInteger(key));
                continue;
            }
            if (key.type.equals(Double.class)) {
                map.put(key.getProperty(), this.getDouble(key));
                continue;
            }
            map.put(key.getProperty(), this.getString(key));
        }
        return map;
    }

    private SortedProperties getDefaultProperties() {
        SortedProperties defaults = new SortedProperties();
        for (Key key : Key.values()) {
            defaults.put(key.getProperty(), key.getDefault());
        }
        return defaults;
    }

    private PropertyManager() {
        this.readFromFile();
        SortedProperties defaults = this.getDefaultProperties();
        for (Object key : ((Properties)defaults).keySet()) {
            if (this.properties.containsKey(key)) continue;
            this.properties.put(key, defaults.get(key));
            this.writeNeeded = true;
        }
        if (this.writeNeeded.booleanValue()) {
            this.writeToFile();
        }
    }

    private File getFile() {
        File propFile = new File(FileHandler.getJourneyMapDir(), FILE_NAME);
        return propFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromFile() {
        SortedProperties sortedProperties = this.properties;
        synchronized (sortedProperties) {
            File propFile = this.getFile();
            if (!propFile.exists()) {
                JourneyMap.getLogger().fine("Legacy property file doesn't exist: " + propFile.getAbsolutePath());
                return;
            }
            try {
                FileReader in = new FileReader(propFile);
                this.properties.load(in);
                in.close();
            }
            catch (IOException e) {
                String error = Constants.getMessageJMERR19(propFile.getAbsolutePath());
                JourneyMap.getLogger().severe(error + ": " + LogFormatter.toString(e));
                return;
            }
            HashMap<Object, Object> temp = new HashMap<Object, Object>(this.properties);
            for (Map.Entry<Object, Object> entry : temp.entrySet()) {
                if (((String)entry.getKey()).contains(".")) {
                    this.writeNeeded = true;
                    this.properties.put(((String)entry.getKey()).replaceAll("\\.", "_"), entry.getValue());
                    this.properties.remove(entry.getKey());
                }
                if (((String)entry.getKey()).equals("use_custom_texturepack")) {
                    this.writeNeeded = true;
                    this.properties.remove(entry.getKey());
                }
                if (((String)entry.getKey()).equals("automap_enabled")) {
                    this.writeNeeded = true;
                    this.properties.remove(entry.getKey());
                }
                if (!((String)entry.getKey()).equals("mapgui_keycode")) continue;
                this.writeNeeded = true;
                this.properties.remove(entry.getKey());
            }
        }
    }

    public void migrateLegacyProperties() {
        File propFile = this.getFile();
        if (!propFile.exists()) {
            JourneyMap.getLogger().fine("Legacy property file doesn't exist: " + propFile.getAbsolutePath());
            return;
        }
        CoreProperties coreProperties = JourneyMap.getInstance().coreProperties;
        coreProperties.announceMod.set(this.getBoolean(Key.ANNOUNCE_MODLOADED));
        coreProperties.caveLighting.set(this.getBoolean(Key.CAVE_LIGHTING));
        coreProperties.checkUpdates.set(this.getBoolean(Key.UPDATE_CHECK_ENABLED));
        coreProperties.chunkPoll.set(this.getInteger(Key.UPDATETIMER_CHUNKS));
        coreProperties.entityPoll.set(this.getInteger(Key.BROWSER_POLL));
        coreProperties.playerPoll.set(this.getInteger(Key.BROWSER_POLL));
        coreProperties.save();
        JourneyMap.getLogger().info(String.format("Migrated legacy property file values from %s to %s .", propFile.getName(), coreProperties.getFile().getName()));
        WebMapProperties webMapProperties = (WebMapProperties)JourneyMap.getInstance().webMapProperties.enableSave(false);
        webMapProperties.enabled.set(this.getBoolean(Key.WEBSERVER_ENABLED));
        webMapProperties.port.set(this.getInteger(Key.WEBSERVER_PORT));
        MiniMapProperties miniMapProperties = (MiniMapProperties)JourneyMap.getInstance().miniMapProperties.enableSave(false);
        miniMapProperties.enabled.set(this.getBoolean(Key.PREF_SHOW_MINIMAP));
        miniMapProperties.enableHotkeys.set(this.getBoolean(Key.PREF_MINIMAP_HOTKEYS));
        miniMapProperties.fontSmall.set(this.getDouble(Key.PREF_MINIMAP_FONTSCALE).intValue() == 1);
        miniMapProperties.forceUnicode.set(this.getBoolean(Key.PREF_MINIMAP_FORCEUNICODE));
        miniMapProperties.position.set(DisplayVars.Position.safeValueOf(this.getString(Key.PREF_MINIMAP_POSITION)));
        miniMapProperties.shape.set(DisplayVars.Shape.safeValueOf(this.getString(Key.PREF_MINIMAP_SHAPE)));
        miniMapProperties.showFps.set(this.getBoolean(Key.PREF_MINIMAP_SHOWFPS));
        FullMapProperties fullMapProperties = (FullMapProperties)JourneyMap.getInstance().fullMapProperties.enableSave(false);
        fullMapProperties.fontSmall.set(this.getDouble(Key.PREF_FONTSCALE).intValue() == 1);
        fullMapProperties.forceUnicode.set(this.getBoolean(Key.PREF_FORCEUNICODE));
        fullMapProperties.showCaves.set(this.getBoolean(Key.PREF_SHOW_CAVES));
        fullMapProperties.showGrid.set(this.getBoolean(Key.PREF_SHOW_GRID));
        List<MapProperties> propsList = Arrays.asList(fullMapProperties, miniMapProperties, webMapProperties);
        for (MapProperties props : propsList) {
            props.showAnimals.set(this.getBoolean(Key.PREF_SHOW_ANIMALS));
            props.showMobs.set(this.getBoolean(Key.PREF_SHOW_MOBS));
            props.showPets.set(this.getBoolean(Key.PREF_SHOW_PETS));
            props.showPlayers.set(this.getBoolean(Key.PREF_SHOW_PLAYERS));
            props.showVillagers.set(this.getBoolean(Key.PREF_SHOW_VILLAGERS));
            props.showWaypoints.set(this.getBoolean(Key.PREF_SHOW_WAYPOINTS));
            ((PropertiesBase)props.enableSave(true)).save();
            JourneyMap.getLogger().info(String.format("Migrated legacy property file values from %s to %s .", propFile.getName(), props.getFile().getName()));
        }
        propFile.delete();
    }

    @Deprecated
    private void writeToFile() {
    }

    public String toString() {
        return this.properties.toString();
    }

    @Deprecated
    public static enum Key {
        WEBSERVER_ENABLED(Boolean.class, "webserver_enabled", true),
        WEBSERVER_PORT(Integer.class, "webserver_port", 8080),
        CHUNK_OFFSET(Integer.class, "chunk_offset", 5),
        BROWSER_POLL(Integer.class, "browser_poll", 1900),
        UPDATETIMER_CHUNKS(Integer.class, "update_timer_chunks", 2000),
        LOGGING_LEVEL(String.class, "logging_level", "INFO"),
        CAVE_LIGHTING(Boolean.class, "render_cavelighting_enabled", true),
        ANNOUNCE_MODLOADED(Boolean.class, "announce_modloaded", true),
        UPDATE_CHECK_ENABLED(Boolean.class, "update_check_enabled", true),
        NATIVE_WAYPOINTS_ENABLED(Boolean.class, "native_waypoints_enabled", true),
        PREF_SHOW_CAVES(Boolean.class, "preference_show_caves", true),
        PREF_SHOW_MOBS(Boolean.class, "preference_show_mobs", true),
        PREF_SHOW_ANIMALS(Boolean.class, "preference_show_animals", true),
        PREF_SHOW_VILLAGERS(Boolean.class, "preference_show_villagers", true),
        PREF_SHOW_PETS(Boolean.class, "preference_show_pets", true),
        PREF_SHOW_PLAYERS(Boolean.class, "preference_show_players", true),
        PREF_SHOW_WAYPOINTS(Boolean.class, "preference_show_waypoints", true),
        PREF_SHOW_GRID(Boolean.class, "preference_show_grid", true),
        PREF_FONTSCALE(Double.class, "preference_fontscale", 1.0),
        PREF_FORCEUNICODE(Boolean.class, "preference_forceunicode", false),
        PREF_SHOW_MINIMAP(Boolean.class, "preference_show_minimap", true),
        PREF_MINIMAP_SHAPE(String.class, "preference_minimap_shape", DisplayVars.Shape.SmallSquare.name()),
        PREF_MINIMAP_POSITION(String.class, "preference_minimap_position", DisplayVars.Position.TopRight.name()),
        PREF_MINIMAP_FONTSCALE(Double.class, "preference_minimap_fontscale", 1.0),
        PREF_MINIMAP_SHOWFPS(Boolean.class, "preference_minimap_showfps", false),
        PREF_MINIMAP_FORCEUNICODE(Boolean.class, "preference_minimap_forceunicode", false),
        PREF_MINIMAP_HOTKEYS(Boolean.class, "preference_minimap_hotkeys", true);

        private final String property;
        private final String defaultValue;
        private final Class type;

        private Key(Class type, String property, Object defaultValue) {
            this.type = type;
            this.property = property;
            this.defaultValue = defaultValue.toString();
        }

        @Deprecated
        public String getProperty() {
            return this.property;
        }

        @Deprecated
        String getDefault() {
            return this.defaultValue;
        }

        @Deprecated
        public static Key lookup(String propName) {
            for (Key key : Key.values()) {
                if (!key.getProperty().equals(propName)) continue;
                return key;
            }
            return null;
        }
    }

    private static class Holder {
        private static final PropertyManager INSTANCE = new PropertyManager();

        private Holder() {
        }
    }
}

