/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.draw;

import java.awt.geom.Point2D;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class DrawRotatedImageStep
implements DrawStep {
    final double posX;
    final double posZ;
    final TextureImpl texture;
    final float heading;

    public DrawRotatedImageStep(double posX, double posZ, TextureImpl texture, float heading) {
        this.posX = posX;
        this.posZ = posZ;
        this.texture = texture;
        this.heading = heading;
    }

    @Override
    public void draw(double xOffset, double yOffset, GridRenderer gridRenderer, float drawScale, double fontScale) {
        Point2D.Double pixel = gridRenderer.getPixel(this.posX, this.posZ);
        if (pixel != null) {
            DrawUtil.drawRotatedImage(this.texture, ((Point2D)pixel).getX() + xOffset, ((Point2D)pixel).getY() + yOffset, this.heading, drawScale);
        }
    }
}

