/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.overlay;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.render.overlay.Tile;

public class TileCache
implements RemovalListener<Integer, Tile> {
    private final Logger logger = JourneyMap.getLogger();
    private final Cache<Integer, Tile> cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(50L).expireAfterAccess(5L, TimeUnit.SECONDS).removalListener((RemovalListener)this).build();
    private final Map<Integer, Tile> retained = new HashMap<Integer, Tile>();
    private boolean paused;

    public static Cache<Integer, Tile> instance() {
        return Holder.INSTANCE.cache;
    }

    private TileCache() {
    }

    public static void pause() {
        Holder.INSTANCE.retainTiles();
    }

    public static void resume() {
        Holder.INSTANCE.restoreExpired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Tile getOrCreate(File worldDir, Constants.MapType mapType, int tileX, int tileZ, int zoom, int dimension) {
        int hash = Tile.toHashCode(tileX, tileZ, zoom, dimension);
        TileCache tc = Holder.INSTANCE;
        Cache<Integer, Tile> cache = tc.cache;
        synchronized (cache) {
            Tile tile = (Tile)tc.cache.getIfPresent((Object)hash);
            if (tile == null) {
                tile = new Tile(worldDir, mapType, tileX, tileZ, zoom, dimension);
                tc.cache.put((Object)hash, (Object)tile);
            }
            return tile;
        }
    }

    private void retainTiles() {
        if (!this.paused) {
            this.retained.putAll(this.cache.asMap());
            this.paused = true;
        }
    }

    private void restoreExpired() {
        if (this.paused) {
            for (Integer key : this.retained.keySet()) {
                if (this.cache.getIfPresent((Object)key) != null) continue;
                this.cache.put((Object)key, (Object)this.retained.get(key));
            }
            this.retained.clear();
            this.paused = false;
        }
    }

    public void onRemoval(RemovalNotification<Integer, Tile> notification) {
        Tile oldTile = (Tile)notification.getValue();
        if (!this.retained.containsValue(oldTile)) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Expired:" + notification.getValue() + " because: " + notification.getCause() + ". Size now: " + this.cache.size());
            }
            oldTile.clear();
        }
    }

    private static class Holder {
        private static final TileCache INSTANCE = new TileCache();

        private Holder() {
        }
    }
}

