/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.server;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.properties.FullMapProperties;
import net.techbrew.journeymap.properties.WebMapProperties;
import net.techbrew.journeymap.server.BaseService;
import se.rupy.http.Event;
import se.rupy.http.Query;

public class PropertyService
extends BaseService {
    private static final long serialVersionUID = 4412225358529161454L;
    public static final String CALLBACK_PARAM = "callback";
    FullMapProperties fullMapProperties;
    WebMapProperties webMapProperties;
    HashMap<String, AtomicBoolean> propMap = new HashMap();

    @Override
    public String path() {
        return "/properties";
    }

    private void init() {
        if (this.propMap.isEmpty()) {
            this.fullMapProperties = JourneyMap.getInstance().fullMapProperties;
            this.webMapProperties = JourneyMap.getInstance().webMapProperties;
            this.propMap.put("showCaves", this.fullMapProperties.showCaves);
            this.propMap.put("showGrid", this.fullMapProperties.showGrid);
            this.propMap.put("showAnimals", this.webMapProperties.showAnimals);
            this.propMap.put("showMobs", this.webMapProperties.showMobs);
            this.propMap.put("showPets", this.webMapProperties.showPets);
            this.propMap.put("showPlayers", this.webMapProperties.showPlayers);
            this.propMap.put("showVillagers", this.webMapProperties.showVillagers);
            this.propMap.put("showWaypoints", this.webMapProperties.showWaypoints);
        }
    }

    @Override
    public void filter(Event event) throws Event, Exception {
        try {
            this.init();
            Query query = event.query();
            query.parse();
            String path = query.path();
            if (query.method() == 2) {
                this.post(event);
                return;
            }
            if (query.method() != 1) {
                throw new Exception("HTTP method not allowed");
            }
            StringBuffer jsonData = new StringBuffer();
            boolean useJsonP = query.containsKey(CALLBACK_PARAM);
            if (useJsonP) {
                jsonData.append(URLEncoder.encode(query.get(CALLBACK_PARAM).toString(), UTF8.name()));
                jsonData.append("(");
            } else {
                jsonData.append("data=");
            }
            jsonData.append(GSON.toJson(this.propMap));
            if (useJsonP) {
                jsonData.append(")");
                BaseService.ResponseHeader.on(event).noCache().contentType(BaseService.ContentType.jsonp);
            }
            this.gzipResponse(event, jsonData.toString());
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe(LogFormatter.toString(t));
            this.throwEventException(500, Constants.getMessageJMERR12(this.path), event, true);
        }
    }

    public void post(Event event) throws Event, Exception {
        try {
            Query query = event.query();
            String[] param = query.parameters().split("=");
            if (param.length != 2) {
                throw new Exception("Expected single key-value pair");
            }
            String key = param[0];
            String value = param[1];
            if (this.propMap.containsKey(key)) {
                Boolean boolValue = Boolean.parseBoolean(value);
                this.propMap.get(key).set(boolValue);
                if (key.equals("showCaves") || key.equals("showGrid")) {
                    this.fullMapProperties.save();
                } else {
                    this.webMapProperties.save();
                }
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe(LogFormatter.toString(t));
            this.throwEventException(500, Constants.getMessageJMERR12(this.path), event, true);
        }
    }
}

