/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui;

import java.util.concurrent.atomic.AtomicBoolean;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.properties.PropertiesBase;
import net.techbrew.journeymap.ui.Button;

public class BooleanPropertyButton
extends Button {
    final PropertiesBase properties;
    final AtomicBoolean valueHolder;

    public static BooleanPropertyButton create(int id, PropertiesBase properties, AtomicBoolean valueHolder) {
        return BooleanPropertyButton.create(id, Type.OnOff, properties, valueHolder);
    }

    public static BooleanPropertyButton create(int id, Type type, PropertiesBase properties, AtomicBoolean valueHolder) {
        String labelOff;
        String labelOn;
        if (Type.OnOff == type) {
            labelOn = Constants.getString("MapOverlay.on");
            labelOff = Constants.getString("MapOverlay.off");
        } else {
            labelOn = Constants.getString("MiniMap.font_small");
            labelOff = Constants.getString("MiniMap.font_large");
        }
        return new BooleanPropertyButton(id, labelOn, labelOff, properties, valueHolder);
    }

    public static BooleanPropertyButton create(int id, String rawLabel, PropertiesBase properties, AtomicBoolean valueHolder) {
        return BooleanPropertyButton.create(id, Type.OnOff, rawLabel, properties, valueHolder);
    }

    public static BooleanPropertyButton create(int id, Type type, String rawLabel, PropertiesBase properties, AtomicBoolean valueHolder) {
        String labelOff;
        String labelOn;
        if (Type.OnOff == type) {
            labelOn = Constants.getString(rawLabel, Constants.getString("MapOverlay.on"));
            labelOff = Constants.getString(rawLabel, Constants.getString("MapOverlay.off"));
        } else {
            labelOn = Constants.getString(rawLabel, Constants.getString("MiniMap.font_small"));
            labelOff = Constants.getString(rawLabel, Constants.getString("MiniMap.font_large"));
        }
        return new BooleanPropertyButton(id, labelOn, labelOff, properties, valueHolder);
    }

    public BooleanPropertyButton(int id, String labelOn, String labelOff, PropertiesBase properties, AtomicBoolean valueHolder) {
        super(id, 0, 0, labelOn, labelOff, valueHolder.get());
        this.valueHolder = valueHolder;
        this.properties = properties;
        if (properties == null || valueHolder == null) {
            this.setEnabled(false);
            this.setNoDisableText(true);
        }
    }

    @Override
    public void toggle() {
        if (this.isEnabled()) {
            this.setToggled(this.properties.toggle(this.valueHolder));
        }
    }

    public static enum Type {
        OnOff,
        SmallLarge;

    }
}

