/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui;

import java.awt.Color;
import net.minecraft.client.gui.GuiButton;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.ui.BooleanPropertyButton;
import net.techbrew.journeymap.ui.Button;
import net.techbrew.journeymap.ui.ButtonList;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.MapOverlayActions;
import net.techbrew.journeymap.waypoint.WaypointStore;

public class MasterOptions
extends JmUI {
    String titleGeneral = Constants.getString("MapOverlay.general_display");
    String titleMiniMap = Constants.getString("MiniMap.title");
    String titleWaypoints = Constants.getString("Waypoint.display_management");
    String titleWebmap = Constants.getString("WebMap.title");
    String labelOptions = Constants.getString("MapOverlay.options_button");
    String labelHelp = Constants.getString("MapOverlay.help");
    Button buttonGeneralDisplayOptions;
    Button buttonFullMapHelp;
    Button buttonMiniMapEnable;
    Button buttonMiniMapOptions;
    Button buttonMiniMapHelp;
    Button buttonWaypointOptions;
    Button buttonWaypointHelp;
    Button buttonWaypointManagerEnable;
    Button buttonWebMapEnable;
    Button buttonWebMapOpen;
    Button buttonClose;
    ButtonList listGeneral;
    ButtonList listMiniMap;
    ButtonList listWaypoints;
    ButtonList listWebMap;

    public MasterOptions() {
        super(Constants.getString("MapOverlay.options"));
    }

    @Override
    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.buttonGeneralDisplayOptions = ButtonEnum.FullMapOptions.create(this.labelOptions);
        this.buttonFullMapHelp = ButtonEnum.FullMapHelp.create(this.labelHelp);
        this.listGeneral = new ButtonList(this.buttonGeneralDisplayOptions, this.buttonFullMapHelp);
        this.field_146292_n.addAll(this.listGeneral);
        this.buttonMiniMapOptions = ButtonEnum.MiniMapOptions.create(this.labelOptions);
        this.buttonMiniMapHelp = ButtonEnum.MiniMapHelp.create(this.labelHelp);
        this.buttonMiniMapEnable = BooleanPropertyButton.create(ButtonEnum.MiniMapEnable.ordinal(), BooleanPropertyButton.Type.OnOff, "MiniMap.enable", JourneyMap.getInstance().miniMapProperties, JourneyMap.getInstance().miniMapProperties.enabled);
        this.listMiniMap = new ButtonList(this.buttonMiniMapOptions, this.buttonMiniMapEnable, this.buttonMiniMapHelp);
        this.field_146292_n.addAll(this.listMiniMap);
        this.buttonWaypointOptions = ButtonEnum.WaypointOptions.create(this.labelOptions);
        this.buttonWaypointHelp = ButtonEnum.WaypointHelp.create(this.labelHelp);
        this.buttonWaypointManagerEnable = BooleanPropertyButton.create(ButtonEnum.WaypointManagerEnable.ordinal(), BooleanPropertyButton.Type.OnOff, "Waypoint.enable_manager", JourneyMap.getInstance().waypointProperties, JourneyMap.getInstance().waypointProperties.managerEnabled);
        this.listWaypoints = new ButtonList(this.buttonWaypointOptions, this.buttonWaypointManagerEnable, this.buttonWaypointHelp);
        this.field_146292_n.addAll(this.listWaypoints);
        this.buttonWebMapEnable = BooleanPropertyButton.create(ButtonEnum.WebMapEnable.ordinal(), BooleanPropertyButton.Type.OnOff, "WebMap.enable", JourneyMap.getInstance().webMapProperties, JourneyMap.getInstance().webMapProperties.enabled);
        this.buttonWebMapOpen = ButtonEnum.WebMapOpen.create(Constants.getString("MapOverlay.use_browser"));
        this.listWebMap = new ButtonList(this.buttonWebMapOpen, this.buttonWebMapEnable);
        this.field_146292_n.addAll(this.listWebMap);
        new ButtonList(this.field_146292_n).equalizeWidths(this.getFontRenderer());
        this.buttonClose = ButtonEnum.Close.create(Constants.getString("MapOverlay.close"));
        this.buttonClose.setWidth(150);
        this.field_146292_n.add(this.buttonClose);
    }

    @Override
    protected void layoutButtons() {
        if (this.field_146292_n.isEmpty()) {
            this.func_73866_w_();
        }
        int hgap = 4;
        int vgap = this.getFontRenderer().field_78288_b * 2 + 4;
        int listWidth = this.listGeneral.getWidth(4);
        listWidth = Math.max(listWidth, this.listMiniMap.getWidth(4));
        listWidth = Math.max(listWidth, this.listWaypoints.getWidth(4));
        listWidth = Math.max(listWidth, this.listWebMap.getWidth(4));
        int bx = (this.field_146294_l - listWidth) / 2;
        int by = Math.max(40, (this.field_146295_m - 150) / 2);
        DrawUtil.drawRectangle(bx - 5, by - 20, listWidth + 10, 1.0, Color.lightGray, 150);
        DrawUtil.drawLabel(this.titleGeneral, bx, by, DrawUtil.HAlign.Right, DrawUtil.VAlign.Above, Color.BLACK, 0, Color.cyan, 255, 1.0, false);
        this.listGeneral.layoutHorizontal(bx, by, true, 4);
        by = this.listGeneral.getBottomY() + vgap;
        DrawUtil.drawLabel(this.titleMiniMap, bx, by, DrawUtil.HAlign.Right, DrawUtil.VAlign.Above, Color.BLACK, 0, Color.cyan, 255, 1.0, false);
        this.listMiniMap.layoutHorizontal(bx, by, true, 4);
        by = this.listMiniMap.getBottomY() + vgap;
        this.buttonMiniMapOptions.setEnabled(this.buttonMiniMapEnable.getToggled());
        DrawUtil.drawLabel(this.titleWaypoints, bx, by, DrawUtil.HAlign.Right, DrawUtil.VAlign.Above, Color.BLACK, 0, Color.cyan, 255, 1.0, false);
        this.listWaypoints.layoutHorizontal(bx, by, true, 4);
        by = this.listWaypoints.getBottomY() + vgap;
        this.buttonWaypointOptions.setEnabled(this.buttonWaypointManagerEnable.getToggled());
        DrawUtil.drawLabel(this.titleWebmap, bx, by, DrawUtil.HAlign.Right, DrawUtil.VAlign.Above, Color.BLACK, 0, Color.cyan, 255, 1.0, false);
        this.listWebMap.layoutHorizontal(bx, by, true, 4);
        by = this.listWebMap.getBottomY() + 20;
        this.buttonWebMapOpen.setEnabled(this.buttonWebMapEnable.getToggled());
        DrawUtil.drawRectangle(bx - 5, by - 10, listWidth + 10, 1.0, Color.lightGray, 150);
        this.buttonClose.centerHorizontalOn(this.field_146294_l / 2).setY(by);
    }

    @Override
    public void func_73863_a(int x, int y, float par3) {
        super.func_73863_a(x, y, par3);
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof BooleanPropertyButton) {
            ((BooleanPropertyButton)button).toggle();
        }
        ButtonEnum id = ButtonEnum.values()[button.field_146127_k];
        switch (id) {
            case FullMapOptions: {
                UIManager.getInstance().openGeneralDisplayOptions(((Object)((Object)this)).getClass());
                break;
            }
            case FullMapHelp: {
                UIManager.getInstance().openMapHotkeyHelp(((Object)((Object)this)).getClass());
                break;
            }
            case MiniMapOptions: {
                UIManager.getInstance().openMiniMapOptions(((Object)((Object)this)).getClass());
                break;
            }
            case MiniMapHelp: {
                UIManager.getInstance().openMiniMapHotkeyHelp(((Object)((Object)this)).getClass());
                break;
            }
            case WaypointOptions: {
                UIManager.getInstance().openWaypointOptions(((Object)((Object)this)).getClass());
                break;
            }
            case WaypointManagerEnable: {
                if (JourneyMap.getInstance().waypointProperties.managerEnabled.get()) {
                    WaypointStore.instance().load();
                    break;
                }
                WaypointStore.instance().reset();
                break;
            }
            case WaypointHelp: {
                UIManager.getInstance().openWaypointHelp(((Object)((Object)this)).getClass());
                break;
            }
            case WebMapOpen: {
                MapOverlayActions.launchLocalhost();
                break;
            }
            case WebMapEnable: {
                JourneyMap.getInstance().toggleWebserver(this.buttonWebMapEnable.getToggled(), true);
                break;
            }
            case Close: {
                UIManager.getInstance().openMap();
            }
        }
    }

    @Override
    protected void closeAndReturn() {
        if (this.returnClass == null) {
            UIManager.getInstance().openMap();
        } else {
            UIManager.getInstance().open(this.returnClass);
        }
    }

    static enum ButtonEnum {
        FullMapOptions,
        FullMapHelp,
        MiniMapOptions,
        MiniMapHelp,
        WaypointOptions,
        WaypointHelp,
        MiniMapEnable,
        WaypointManagerEnable,
        WebMapEnable,
        WebMapOpen,
        Close;


        Button create(String label) {
            return new Button(this, label);
        }
    }
}

