/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.waypoint;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.world.WorldProvider;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.ui.Button;
import net.techbrew.journeymap.ui.ButtonList;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.ScrollPane;
import net.techbrew.journeymap.ui.TextField;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.MapOverlay;
import net.techbrew.journeymap.ui.waypoint.WaypointManager;
import net.techbrew.journeymap.waypoint.WaypointStore;
import org.lwjgl.input.Keyboard;

public class WaypointEditor
extends JmUI {
    String labelName = Constants.getString("Waypoint.name");
    String locationTitle = Constants.getString("Waypoint.location");
    String colorTitle = Constants.getString("Waypoint.color");
    String dimensionsTitle = Constants.getString("Waypoint.dimensions");
    String labelX = Constants.getString("Waypoint.x");
    String labelY = Constants.getString("Waypoint.y");
    String labelZ = Constants.getString("Waypoint.z");
    String labelR = Constants.getString("Waypoint.r");
    String labelG = Constants.getString("Waypoint.g");
    String labelB = Constants.getString("Waypoint.b");
    String currentLocation = "";
    private final TextureImpl wpTexture;
    private final TextureImpl colorPickTexture;
    private Button buttonRandomize;
    private Button buttonEnable;
    private Button buttonRemove;
    private Button buttonReset;
    private Button buttonSave;
    private Button buttonClose;
    private TextField fieldName;
    private TextField fieldR;
    private TextField fieldG;
    private TextField fieldB;
    private TextField fieldX;
    private TextField fieldY;
    private TextField fieldZ;
    private ArrayList<TextField> fieldList = new ArrayList();
    private ArrayList<DimensionButton> dimButtonList = new ArrayList();
    private ScrollPane dimScrollPane;
    private Color currentColor;
    private Rectangle2D.Double colorPickRect;
    private BufferedImage colorPickImg;
    private final Waypoint originalWaypoint;
    private Waypoint editedWaypoint;
    private final boolean isNew;
    private ButtonList bottomButtons;

    public WaypointEditor(Waypoint waypoint, boolean isNew, Class<? extends JmUI> returnClass) {
        super(Constants.getString(isNew ? "Waypoint.new_title" : "Waypoint.edit_title"), returnClass);
        this.originalWaypoint = waypoint;
        this.editedWaypoint = new Waypoint(this.originalWaypoint);
        this.isNew = isNew;
        this.wpTexture = waypoint.getTexture();
        this.colorPickTexture = TextureCache.instance().getColorPicker();
        this.colorPickRect = new Rectangle2D.Double(0.0, 0.0, this.colorPickTexture.width, this.colorPickTexture.height);
        this.colorPickImg = this.colorPickTexture.getImage();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    @Override
    public void func_73866_w_() {
        try {
            int dimension = this.field_146297_k.field_71439_g.field_70170_p.field_73011_w.field_76574_g;
            String pos = Constants.getString("MapOverlay.location_xzy", Integer.toString((int)this.field_146297_k.field_71439_g.field_70165_t), Integer.toString((int)this.field_146297_k.field_71439_g.field_70161_v), Integer.toString((int)this.field_146297_k.field_71439_g.field_70163_u));
            this.currentLocation = Constants.getString("Waypoint.current_location", " " + pos);
            if (this.fieldList.isEmpty()) {
                FontRenderer fr = this.getFontRenderer();
                this.fieldName = new TextField(this.originalWaypoint.getName(), fr, 160, 20);
                this.fieldName.func_146195_b(true);
                if (this.isNew) {
                    this.fieldName.func_146202_e();
                    this.fieldName.func_146199_i(0);
                }
                this.fieldList.add(this.fieldName);
                int width9chars = this.getFontRenderer().func_78256_a("-30000000") + 10;
                int width3chars = this.getFontRenderer().func_78256_a("255") + 10;
                int h = 20;
                this.fieldX = new TextField(this.originalWaypoint.getX(), fr, width9chars, h, true, true);
                this.fieldX.setClamp(-30000000, 30000000);
                this.fieldList.add(this.fieldX);
                this.fieldZ = new TextField(this.originalWaypoint.getZ(), fr, width9chars, h, true, true);
                this.fieldZ.setClamp(-30000000, 30000000);
                this.fieldList.add(this.fieldZ);
                int y = this.originalWaypoint.getY();
                this.fieldY = new TextField(y < 0 ? "" : Integer.valueOf(y), fr, width3chars, h, true, true);
                this.fieldY.setClamp(0, this.field_146297_k.field_71441_e.func_72800_K() - 1);
                this.fieldY.setMinLength(1);
                this.fieldList.add(this.fieldY);
                this.fieldR = new TextField("", fr, width3chars, h, true, false);
                this.fieldR.setClamp(0, 255);
                this.fieldR.func_146203_f(3);
                this.fieldList.add(this.fieldR);
                this.fieldG = new TextField("", fr, width3chars, h, true, false);
                this.fieldG.setClamp(0, 255);
                this.fieldG.func_146203_f(3);
                this.fieldList.add(this.fieldG);
                this.fieldB = new TextField("", fr, width3chars, h, true, false);
                this.fieldB.setClamp(0, 255);
                this.fieldB.func_146203_f(3);
                this.fieldList.add(this.fieldB);
                Collection<Integer> wpDims = this.originalWaypoint.getDimensions();
                int buttonId = ButtonEnum.values().length;
                for (WorldProvider provider : WorldData.getDimensionProviders(WaypointStore.instance().getLoadedDimensions())) {
                    int dim = provider.field_76574_g;
                    String dimName = provider.func_80007_l();
                    this.dimButtonList.add(new DimensionButton(buttonId++, dim, dimName, wpDims.contains(dim)));
                }
                this.dimScrollPane = new ScrollPane(this.field_146297_k, 0, 0, this.dimButtonList, this.dimButtonList.get(0).getHeight(), 4);
                this.dimScrollPane.func_148130_a(false);
            }
            if (this.field_146292_n.isEmpty()) {
                String on = Constants.getString("MapOverlay.on");
                String off = Constants.getString("MapOverlay.off");
                String enableOn = Constants.getString("Waypoint.enable", on);
                String enableOff = Constants.getString("Waypoint.enable", off);
                this.buttonRandomize = new Button(ButtonEnum.Randomize, Constants.getString("Waypoint.randomize"));
                this.buttonEnable = new Button((Enum)ButtonEnum.Enable, enableOn, enableOff, true);
                this.buttonEnable.setToggled(this.originalWaypoint.isEnable());
                this.buttonRemove = new Button(ButtonEnum.Remove, Constants.getString("Waypoint.remove"));
                this.buttonRemove.setEnabled(!this.isNew);
                this.buttonRemove.setNoDisableText(true);
                this.buttonReset = new Button(ButtonEnum.Reset, Constants.getString("Waypoint.reset"));
                this.buttonSave = new Button(ButtonEnum.Save, Constants.getString("Waypoint.save"));
                this.buttonSave.setNoDisableText(true);
                String closeLabel = this.isNew ? "Waypoint.cancel" : "MapOverlay.close";
                this.buttonClose = new Button(ButtonEnum.Close, Constants.getString(closeLabel));
                this.field_146292_n.add(this.buttonEnable);
                this.field_146292_n.add(this.buttonRandomize);
                this.field_146292_n.add(this.buttonRemove);
                this.field_146292_n.add(this.buttonReset);
                this.field_146292_n.add(this.buttonSave);
                this.field_146292_n.add(this.buttonClose);
                this.bottomButtons = new ButtonList(this.buttonRemove, this.buttonSave, this.buttonClose);
                this.bottomButtons.setUniformWidths(this.getFontRenderer());
                this.setFormColor(this.originalWaypoint.getColor());
                this.validate();
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe(LogFormatter.toString(t));
            UIManager.getInstance().closeAll();
        }
    }

    @Override
    protected void layoutButtons() {
        this.func_73866_w_();
        FontRenderer fr = this.getFontRenderer();
        int vpad = 5;
        int hgap = fr.func_78256_a("X") * 3;
        int vgap = this.fieldX.getHeight() + 5;
        int startY = Math.max(30, (this.field_146295_m - 200) / 2);
        int dcw = fr.func_78256_a(this.dimensionsTitle);
        dcw = 8 + Math.max(dcw, this.dimScrollPane.getFitWidth(fr));
        int leftWidth = hgap * 2 + this.fieldX.func_146200_o() + this.fieldY.func_146200_o() + this.fieldZ.func_146200_o();
        int rightWidth = dcw;
        int totalWidth = leftWidth + 10 + rightWidth;
        int leftX = (this.field_146294_l - totalWidth) / 2;
        int leftXEnd = leftX + leftWidth;
        int rightX = leftXEnd + 10;
        int rightXEnd = rightX + rightWidth;
        int leftRow = startY;
        this.drawLabel(this.labelName, leftX, leftRow);
        this.fieldName.setWidth(leftWidth);
        this.fieldName.setX(leftX);
        this.fieldName.setY(leftRow += 12);
        if (!this.fieldName.func_146206_l()) {
            this.fieldName.func_146199_i(this.fieldName.func_146179_b().length());
        }
        this.fieldName.func_146194_f();
        this.drawLabel(this.locationTitle, leftX, leftRow += vgap + 5);
        this.drawLabelAndField(this.labelX, this.fieldX, leftX, leftRow += 12);
        this.drawLabelAndField(this.labelZ, this.fieldZ, this.fieldX.getX() + this.fieldX.func_146200_o() + hgap, leftRow);
        this.drawLabelAndField(this.labelY, this.fieldY, this.fieldZ.getX() + this.fieldZ.func_146200_o() + hgap, leftRow);
        this.drawLabel(this.colorTitle, leftX, leftRow += vgap + 5);
        this.drawLabelAndField(this.labelR, this.fieldR, leftX, leftRow += 12);
        this.drawLabelAndField(this.labelG, this.fieldG, this.fieldR.getX() + this.fieldR.func_146200_o() + hgap, leftRow);
        this.drawLabelAndField(this.labelB, this.fieldB, this.fieldG.getX() + this.fieldG.func_146200_o() + hgap, leftRow);
        this.buttonRandomize.setWidth(4 + Math.max(this.fieldB.getX() + this.fieldB.func_146200_o() - this.fieldR.getX(), 10 + fr.func_78256_a(this.buttonRandomize.field_146126_j)));
        this.buttonRandomize.setPosition(this.fieldR.getX() - 2, leftRow += vgap);
        int cpY = this.fieldB.getY();
        int cpSize = this.buttonRandomize.getY() + this.buttonRandomize.getHeight() - cpY - 2;
        int cpHAreaX = this.fieldB.getX() + this.fieldB.func_146200_o();
        int cpHArea = this.fieldName.getX() + this.fieldName.func_146200_o() - cpHAreaX;
        int cpX = cpHAreaX + (cpHArea - cpSize);
        this.drawColorPicker(cpX, cpY, cpSize);
        int iconX = cpHAreaX + (cpX - cpHAreaX) / 2 - this.wpTexture.width / 2 + 1;
        int iconY = this.buttonRandomize.getY() - 2;
        this.drawWaypoint(iconX, iconY);
        this.buttonEnable.fitWidth(fr);
        this.buttonEnable.setWidth(Math.max(leftWidth / 2, this.buttonEnable.getWidth()));
        this.buttonEnable.setPosition(leftX - 2, leftRow += vgap);
        this.buttonReset.setWidth(leftWidth - this.buttonEnable.getWidth() - 2);
        this.buttonReset.setPosition(leftXEnd - this.buttonReset.getWidth() + 2, leftRow);
        int rightRow = startY;
        this.drawLabel(this.dimensionsTitle, rightX, rightRow);
        int scrollHeight = this.buttonReset.getY() + this.buttonReset.getHeight() - 2 - (rightRow += 12);
        this.dimScrollPane.position(dcw, scrollHeight, 0, 0, rightX, rightRow);
        int totalRow = Math.max(leftRow + vgap, rightRow + vgap);
        this.bottomButtons.layoutFilledHorizontal(fr, leftX - 2, totalRow, rightXEnd + 2, 4, true);
    }

    @Override
    public void func_73863_a(int x, int y, float par3) {
        this.func_146278_c(0);
        this.validate();
        this.layoutButtons();
        this.dimScrollPane.func_148128_a(x, y, par3);
        DrawUtil.drawLabel(this.currentLocation, this.field_146294_l / 2, this.field_146295_m, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, Color.BLACK, 255, Color.lightGray, 255, 1.0, true);
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(k);
            guibutton.func_146112_a(this.field_146297_k, x, y);
        }
        this.drawTitle();
        this.drawLogo();
    }

    protected void drawWaypoint(int x, int y) {
        DrawUtil.drawColoredImage(this.wpTexture, 255, this.currentColor, x, y - this.wpTexture.height / 2);
    }

    protected void drawColorPicker(int x, int y, float size) {
        int sizeI = (int)size;
        WaypointEditor.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + sizeI + 1), (int)(y + sizeI + 1), (int)-6250336);
        if (this.colorPickRect.width != (double)size) {
            Image image = this.colorPickTexture.getImage().getScaledInstance(sizeI, sizeI, 2);
            this.colorPickImg = new BufferedImage(sizeI, sizeI, 1);
            Graphics2D g = this.colorPickImg.createGraphics();
            g.drawImage(image, 0, 0, sizeI, sizeI, null);
            g.dispose();
        }
        this.colorPickRect.setRect(x, y, size, size);
        float scale = size / (float)this.colorPickTexture.width;
        DrawUtil.drawImage(this.colorPickTexture, x, y, false, scale);
    }

    protected void drawLabelAndField(String label, TextField field, int x, int y) {
        field.setX(x);
        field.setY(y);
        FontRenderer fr = this.getFontRenderer();
        int width = fr.func_78256_a(label) + 4;
        this.func_73731_b(this.getFontRenderer(), label, x - width, y + (field.getHeight() - 8) / 2, Color.cyan.getRGB());
        field.func_146194_f();
    }

    protected void drawLabel(String label, int x, int y) {
        this.func_73731_b(this.getFontRenderer(), label, x, y, Color.cyan.getRGB());
    }

    @Override
    protected void func_73869_a(char par1, int par2) {
        GuiTextField field;
        boolean done;
        switch (par2) {
            case 1: {
                this.closeAndReturn();
                return;
            }
            case 28: {
                this.save();
                return;
            }
            case 15: {
                this.validate();
                this.onTab();
                return;
            }
        }
        Iterator<TextField> i$ = this.fieldList.iterator();
        while (i$.hasNext() && !(done = (field = (GuiTextField)i$.next()).func_146201_a(par1, par2))) {
        }
        this.updateWaypointFromForm();
        this.validate();
    }

    protected void func_146273_a(int par1, int par2, int par3, long par4) {
        this.checkColorPicker(par1, par2);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (GuiTextField guiTextField : this.fieldList) {
            guiTextField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        this.checkColorPicker(mouseX, mouseY);
        Button button = this.dimScrollPane.mouseClicked(mouseX, mouseY, mouseButton);
        if (button != null) {
            this.func_146284_a(button);
        }
    }

    protected void checkColorPicker(int mouseX, int mouseY) {
        if (this.colorPickRect.contains(mouseX, mouseY)) {
            int x = mouseX - (int)this.colorPickRect.x;
            int y = mouseY - (int)this.colorPickRect.y;
            this.setFormColor(new Color(this.colorPickImg.getRGB(x, y)));
        }
    }

    protected void setFormColor(Color color) {
        this.currentColor = color;
        this.fieldR.func_146180_a(Integer.toString(color.getRed()));
        this.fieldG.func_146180_a(Integer.toString(color.getGreen()));
        this.fieldB.func_146180_a(Integer.toString(color.getBlue()));
        this.updateWaypointFromForm();
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (this.dimButtonList.contains(guibutton)) {
            DimensionButton dimButton = (DimensionButton)guibutton;
            dimButton.toggle();
            this.updateWaypointFromForm();
        } else {
            ButtonEnum id = ButtonEnum.values()[guibutton.field_146127_k];
            switch (id) {
                case Randomize: {
                    this.setRandomColor();
                    break;
                }
                case Enable: {
                    this.buttonEnable.toggle();
                    break;
                }
                case Remove: {
                    this.remove();
                    break;
                }
                case Reset: {
                    this.resetForm();
                    break;
                }
                case Save: {
                    this.save();
                    break;
                }
                case Close: {
                    this.refreshAndClose(this.originalWaypoint);
                }
            }
        }
    }

    protected void setRandomColor() {
        this.editedWaypoint.setRandomColor();
        this.setFormColor(this.editedWaypoint.getColor());
    }

    protected void onTab() {
        boolean focusNext = false;
        boolean foundFocus = false;
        for (TextField field : this.fieldList) {
            if (focusNext) {
                field.func_146195_b(true);
                foundFocus = true;
                break;
            }
            if (!field.func_146206_l()) continue;
            field.func_146195_b(false);
            field.clamp();
            focusNext = true;
        }
        if (!foundFocus) {
            this.fieldList.get(0).func_146195_b(true);
        }
    }

    protected boolean validate() {
        boolean valid = true;
        if (this.fieldName != null) {
            valid = this.fieldName.hasMinLength();
        }
        if (valid && this.fieldY != null) {
            valid = this.fieldY.hasMinLength();
        }
        if (this.buttonSave != null) {
            this.buttonSave.setEnabled(valid && (this.isNew || !this.originalWaypoint.equals(this.editedWaypoint)));
        }
        return valid;
    }

    protected void remove() {
        WaypointStore.instance().remove(this.originalWaypoint);
        this.refreshAndClose(null);
    }

    protected void save() {
        if (!this.validate()) {
            return;
        }
        this.updateWaypointFromForm();
        WaypointStore.instance().remove(this.originalWaypoint);
        WaypointStore.instance().save(this.editedWaypoint);
        this.refreshAndClose(this.editedWaypoint);
    }

    protected void resetForm() {
        this.editedWaypoint = new Waypoint(this.originalWaypoint);
        this.dimButtonList.clear();
        this.fieldList.clear();
        this.field_146292_n.clear();
        this.func_73866_w_();
        this.validate();
    }

    protected void updateWaypointFromForm() {
        this.currentColor = new Color(this.getSafeColorInt(this.fieldR), this.getSafeColorInt(this.fieldG), this.getSafeColorInt(this.fieldB));
        this.editedWaypoint.setColor(this.currentColor);
        this.fieldName.func_146193_g(this.editedWaypoint.getSafeColor().getRGB());
        ArrayList<Integer> dims = new ArrayList<Integer>();
        for (DimensionButton db : this.dimButtonList) {
            if (!db.getToggled().booleanValue()) continue;
            dims.add(db.dimension);
        }
        this.editedWaypoint.setDimensions(dims);
        this.editedWaypoint.setEnable(this.buttonEnable.getToggled());
        this.editedWaypoint.setName(this.fieldName.func_146179_b());
        this.editedWaypoint.setLocation(this.getSafeCoordInt(this.fieldX), this.getSafeCoordInt(this.fieldY), this.getSafeCoordInt(this.fieldZ), this.field_146297_k.field_71439_g.field_71093_bK);
    }

    protected int getSafeColorInt(TextField field) {
        field.clamp();
        String text = field.func_146179_b();
        if (text == null || text.isEmpty()) {
            return 0;
        }
        int val = 0;
        try {
            val = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return Math.max(0, Math.min(255, val));
    }

    protected int getSafeCoordInt(TextField field) {
        String text = field.func_146179_b();
        if (text == null || text.isEmpty() || text.equals("-")) {
            return 0;
        }
        int val = 0;
        try {
            val = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return val;
    }

    protected void refreshAndClose(Waypoint focusWaypoint) {
        if (this.returnClass != null && this.returnClass.equals(WaypointManager.class)) {
            UIManager.getInstance().openWaypointManager(focusWaypoint, MapOverlay.class);
            return;
        }
        MapOverlay.state().requireRefresh();
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        if (this.returnClass == null) {
            UIManager.getInstance().closeAll();
        } else {
            UIManager.getInstance().open(this.returnClass);
        }
    }

    class DimensionButton
    extends Button {
        public final int dimension;

        DimensionButton(int id, int dimension, String dimensionName, boolean toggled) {
            super(id, 0, 0, String.format("%s: %s", dimensionName, Constants.getString("MapOverlay.on")), String.format("%s: %s", dimensionName, Constants.getString("MapOverlay.off")), toggled);
            this.dimension = dimension;
            this.setToggled(toggled);
        }
    }

    private static enum ButtonEnum {
        Randomize,
        Enable,
        Remove,
        Reset,
        Save,
        Close;

    }
}

