/*
 * Decompiled with CFR 0.152.
 */
package com.rneffects.client;

import com.rneffects.effects.RNEffectType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

@SideOnly(value=Side.CLIENT)
public class ClientEffectManager {
    public static final ClientEffectManager INSTANCE = new ClientEffectManager();
    private final List<EffectInstance> active = new ArrayList<EffectInstance>();
    private final Queue<EffectInstance> pending = new LinkedList<EffectInstance>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enqueuePending(RNEffectType type, int durationTicks, int amplifier) {
        Queue<EffectInstance> queue = ClientEffectManager.INSTANCE.pending;
        synchronized (queue) {
            ClientEffectManager.INSTANCE.pending.add(new EffectInstance(type, durationTicks, amplifier));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainPendingToActive() {
        Queue<EffectInstance> queue = this.pending;
        synchronized (queue) {
            while (!this.pending.isEmpty()) {
                this.active.add(this.pending.poll());
            }
        }
    }

    public void addEffect(RNEffectType type, int durationTicks, int amplifier) {
        this.active.add(new EffectInstance(type, durationTicks, amplifier));
    }

    public List<EffectInstance> getActiveEffects() {
        return this.active;
    }

    public void tick() {
        Iterator<EffectInstance> it = this.active.iterator();
        while (it.hasNext()) {
            EffectInstance e = it.next();
            --e.remainingTicks;
            if (e.remainingTicks > 0) continue;
            it.remove();
        }
    }

    public boolean hasEffect(RNEffectType type) {
        for (EffectInstance e : this.active) {
            if (e.type != type) continue;
            return true;
        }
        return false;
    }

    public static class EffectInstance {
        public final RNEffectType type;
        public int remainingTicks;
        public final int amplifier;

        public EffectInstance(RNEffectType type, int durationTicks, int amplifier) {
            this.type = type;
            this.remainingTicks = durationTicks;
            this.amplifier = amplifier;
        }
    }
}

