/*
 * Decompiled with CFR 0.152.
 */
package com.rneffects.client;

import com.rneffects.client.ClientEffectManager;
import com.rneffects.effects.RNEffectType;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;

@SideOnly(value=Side.CLIENT)
public class ClientRenderHandler {
    private final Minecraft mc = Minecraft.func_71410_x();
    private boolean applied = false;
    private final Random rand = new Random();
    private float lastYawOffset = 0.0f;
    private float lastPitchOffset = 0.0f;

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent evt) {
        if (this.mc.field_71439_g == null) {
            return;
        }
        if (evt.phase == TickEvent.Phase.START) {
            this.lastYawOffset = 0.0f;
            this.lastPitchOffset = 0.0f;
            this.applied = false;
            for (ClientEffectManager.EffectInstance ei : ClientEffectManager.INSTANCE.getActiveEffects()) {
                if (ei.type != RNEffectType.SCREEN_SHAKE) continue;
                float intensity = 0.6f * (1.0f + (float)ei.amplifier * 0.6f);
                float yawOffset = (this.rand.nextFloat() - 0.5f) * 2.0f * intensity;
                float pitchOffset = (this.rand.nextFloat() - 0.5f) * 2.0f * intensity * 0.6f;
                this.mc.field_71439_g.field_70177_z += yawOffset;
                this.mc.field_71439_g.field_70125_A += pitchOffset;
                this.lastYawOffset = yawOffset;
                this.lastPitchOffset = pitchOffset;
                this.applied = true;
                break;
            }
        } else if (evt.phase == TickEvent.Phase.END && this.applied) {
            this.mc.field_71439_g.field_70177_z -= this.lastYawOffset;
            this.mc.field_71439_g.field_70125_A -= this.lastPitchOffset;
            this.lastYawOffset = 0.0f;
            this.lastPitchOffset = 0.0f;
            this.applied = false;
        }
    }
}

