/*
 * Decompiled with CFR 0.152.
 */
package com.rneffects.client;

import java.util.LinkedList;
import java.util.Queue;

public class ClientShieldManager {
    public static final ClientShieldManager INSTANCE = new ClientShieldManager();
    private int currentUnits = 0;
    private int maxUnits = 0;
    private final Queue<int[]> pending = new LinkedList<int[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enqueuePending(int currentUnits, int maxUnits) {
        Queue<int[]> queue = ClientShieldManager.INSTANCE.pending;
        synchronized (queue) {
            ClientShieldManager.INSTANCE.pending.add(new int[]{currentUnits, maxUnits});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainPendingToActive() {
        Queue<int[]> queue = this.pending;
        synchronized (queue) {
            while (!this.pending.isEmpty()) {
                int[] v = this.pending.poll();
                if (v == null) continue;
                this.currentUnits = v[0];
                this.maxUnits = v[1];
            }
        }
    }

    public int getCurrentUnits() {
        return this.currentUnits;
    }

    public int getMaxUnits() {
        return this.maxUnits;
    }

    public float getPercent() {
        if (this.maxUnits <= 0) {
            return 0.0f;
        }
        return Math.max(0.0f, Math.min(1.0f, (float)this.currentUnits / (float)this.maxUnits));
    }

    public boolean hasShield() {
        return this.currentUnits > 0 && this.maxUnits > 0;
    }
}

