/*
 * Decompiled with CFR 0.152.
 */
package com.rneffects.cmd;

import com.rneffects.effects.RNEffectType;
import com.rneffects.network.NetworkHandler;
import com.rneffects.network.PacketAddEffect;
import com.rneffects.server.ServerEffectManager;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.PlayerSelector;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CommandRNEffect
extends CommandBase {
    public String func_71517_b() {
        return "rneffect";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/rneffect <player|selector> <idDoEfeito> <duracaoSegundos> <amplificador>";
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        MinecraftServer server;
        if (args.length < 4) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String targetToken = args[0];
        int effectId = this.parseIntSafe(args[1]);
        int durationSec = this.parseIntSafe(args[2]);
        int amp = this.parseIntSafe(args[3]);
        RNEffectType type = RNEffectType.byId(effectId);
        if (type == null) {
            throw new CommandException("ID de efeito inv\u00e1lido: " + effectId, new Object[0]);
        }
        boolean normalized = false;
        int originalAmp = amp;
        if (type == RNEffectType.CHAKRA_DRAIN || type == RNEffectType.LIFE_SHIELD || type == RNEffectType.LIFE_STEAL) {
            if (amp <= 0) {
                amp = 0;
            } else {
                if (amp < 1) {
                    amp = 1;
                    normalized = true;
                }
                if (amp > 100) {
                    amp = 100;
                    normalized = true;
                }
            }
        }
        if ((server = MinecraftServer.func_71276_C()) == null) {
            throw new CommandException("Servidor n\u00e3o dispon\u00edvel no momento.", new Object[0]);
        }
        int ticks = durationSec * 20;
        if (targetToken.startsWith("@")) {
            EntityPlayerMP[] matched = PlayerSelector.func_82380_c((ICommandSender)sender, (String)targetToken);
            if (matched == null || matched.length == 0) {
                throw new PlayerNotFoundException("Nenhum jogador correspondeu ao selector: " + targetToken, new Object[0]);
            }
            int appliedCount = 0;
            StringBuilder names = new StringBuilder();
            for (EntityPlayerMP target : matched) {
                if (target == null) continue;
                if (type == RNEffectType.SLOW_PROGRESSIVE || type == RNEffectType.CHAKRA_DRAIN || type == RNEffectType.LIFE_SHIELD || type == RNEffectType.LIFE_STEAL) {
                    ServerEffectManager.INSTANCE.addEffect(target, type, ticks, amp);
                }
                if (NetworkHandler.INSTANCE != null) {
                    NetworkHandler.INSTANCE.sendTo((IMessage)new PacketAddEffect(effectId, ticks, amp), target);
                }
                if (appliedCount > 0) {
                    names.append(", ");
                }
                names.append(target.func_70005_c_());
                ++appliedCount;
            }
            if (appliedCount == 0) {
                throw new PlayerNotFoundException("Selector n\u00e3o retornou jogadores v\u00e1lidos.", new Object[0]);
            }
            String msg = EnumChatFormatting.GOLD + "[RNEffects] " + EnumChatFormatting.RESET + "Aplicado efeito " + EnumChatFormatting.AQUA + type.name() + EnumChatFormatting.RESET + " (id " + effectId + ") em " + EnumChatFormatting.YELLOW + appliedCount + EnumChatFormatting.RESET + " jogador(es): " + EnumChatFormatting.GREEN + names.toString() + EnumChatFormatting.RESET + " - duracao: " + EnumChatFormatting.GREEN + durationSec + EnumChatFormatting.RESET + "s (Amplificador: " + EnumChatFormatting.RED + amp + EnumChatFormatting.RESET + ")";
            if (normalized || originalAmp != amp) {
                msg = msg + " " + EnumChatFormatting.GRAY + "(normalizado de " + originalAmp + " para " + amp + ")";
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(msg));
            return;
        }
        EntityPlayerMP target = server.func_71203_ab().func_152612_a(targetToken);
        if (target == null) {
            throw new PlayerNotFoundException("Jogador n\u00e3o encontrado: " + targetToken, new Object[0]);
        }
        if (type == RNEffectType.SLOW_PROGRESSIVE || type == RNEffectType.CHAKRA_DRAIN || type == RNEffectType.LIFE_SHIELD || type == RNEffectType.LIFE_STEAL) {
            ServerEffectManager.INSTANCE.addEffect(target, type, ticks, amp);
        }
        if (NetworkHandler.INSTANCE != null) {
            NetworkHandler.INSTANCE.sendTo((IMessage)new PacketAddEffect(effectId, ticks, amp), target);
        }
        String singleMsg = EnumChatFormatting.GOLD + "[RNEffects] " + EnumChatFormatting.RESET + "Aplicado efeito " + EnumChatFormatting.AQUA + type.name() + EnumChatFormatting.RESET + " (id " + effectId + ") em " + EnumChatFormatting.YELLOW + target.func_70005_c_() + EnumChatFormatting.RESET + " - duracao: " + EnumChatFormatting.GREEN + durationSec + EnumChatFormatting.RESET + "s (Amplificador: " + EnumChatFormatting.RED + amp + EnumChatFormatting.RESET + ")";
        if (normalized || originalAmp != amp) {
            singleMsg = singleMsg + " " + EnumChatFormatting.GRAY + "(normalizado de " + originalAmp + " para " + amp + ")";
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText(singleMsg));
    }

    public int func_82362_a() {
        return 2;
    }

    private int parseIntSafe(String s) throws NumberInvalidException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new NumberInvalidException("commands.generic.num.invalid", new Object[]{s});
        }
    }
}

