/*
 * Decompiled with CFR 0.152.
 */
package com.rneffects.server;

import com.rneffects.server.ServerEffectManager;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class LifeStealHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt(LivingHurtEvent event) {
        block39: {
            if (event == null || event.entity == null) {
                return;
            }
            if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
                return;
            }
            try {
                Entity sourceEntity = null;
                try {
                    sourceEntity = event.source.func_76346_g();
                }
                catch (Throwable ignored) {
                    sourceEntity = null;
                }
                if (sourceEntity == null) {
                    try {
                        sourceEntity = event.source.func_76364_f();
                    }
                    catch (Throwable ignored) {
                        sourceEntity = null;
                    }
                }
                if (sourceEntity instanceof EntityPlayerMP) {
                    EntityPlayerMP p = (EntityPlayerMP)sourceEntity;
                    float dbcDamage = ServerEffectManager.INSTANCE.readLastDamageDealtFromDBC(p);
                    float anyAttacker = ServerEffectManager.INSTANCE.readAnyLastDamageCandidates((Entity)p);
                    float eventDamage = this.safeReadEventDamage(event);
                    if (dbcDamage > 0.0f) {
                        ServerEffectManager.INSTANCE.applyLifeStealFromDamage(p, dbcDamage);
                    } else if (anyAttacker > 0.0f) {
                        ServerEffectManager.INSTANCE.applyLifeStealFromDamage(p, anyAttacker);
                    } else {
                        ServerEffectManager.INSTANCE.enqueuePendingLifeSteal(p.func_110124_au(), eventDamage);
                    }
                    return;
                }
                if (sourceEntity != null) {
                    Entity possibleOwner;
                    block38: {
                        possibleOwner = null;
                        try {
                            String[] methodNames;
                            try {
                                Field f = sourceEntity.getClass().getField("shootingEntity");
                                f.setAccessible(true);
                                String[] o = f.get(sourceEntity);
                                if (o instanceof Entity) {
                                    possibleOwner = (Entity)o;
                                }
                            }
                            catch (Throwable f) {
                                // empty catch block
                            }
                            if (possibleOwner != null) break block38;
                            for (String mname : methodNames = new String[]{"getShooter", "getThrower", "getOwner", "getShooterEntity", "getOwnerEntity"}) {
                                try {
                                    Method mm = sourceEntity.getClass().getMethod(mname, new Class[0]);
                                    Object o = mm.invoke((Object)sourceEntity, new Object[0]);
                                    if (!(o instanceof Entity)) continue;
                                    possibleOwner = (Entity)o;
                                    break;
                                }
                                catch (Throwable mm) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (Throwable methodNames) {
                            // empty catch block
                        }
                    }
                    if (possibleOwner instanceof EntityPlayerMP) {
                        EntityPlayerMP owner = (EntityPlayerMP)possibleOwner;
                        float dbcDamage = ServerEffectManager.INSTANCE.readLastDamageDealtFromDBC(owner);
                        float anyOwner = ServerEffectManager.INSTANCE.readAnyLastDamageCandidates((Entity)owner);
                        float projDamage = ServerEffectManager.INSTANCE.readDamageFromProjectile(sourceEntity);
                        float eventDamage = this.safeReadEventDamage(event);
                        float anyProj = ServerEffectManager.INSTANCE.readAnyLastDamageCandidates(sourceEntity);
                        if (dbcDamage > 0.0f) {
                            ServerEffectManager.INSTANCE.applyLifeStealFromDamage(owner, dbcDamage);
                        } else if (anyOwner > 0.0f) {
                            ServerEffectManager.INSTANCE.applyLifeStealFromDamage(owner, anyOwner);
                        } else if (anyProj > 0.0f) {
                            ServerEffectManager.INSTANCE.applyLifeStealFromDamage(owner, anyProj);
                        } else if (projDamage > 0.0f) {
                            ServerEffectManager.INSTANCE.applyLifeStealFromDamage(owner, projDamage);
                        } else {
                            ServerEffectManager.INSTANCE.enqueuePendingLifeSteal(owner.func_110124_au(), eventDamage);
                        }
                        return;
                    }
                }
                try {
                    Entity srcOf = event.source.func_76364_f();
                    if (!(srcOf instanceof EntityPlayerMP)) break block39;
                    EntityPlayerMP p2 = (EntityPlayerMP)srcOf;
                    float dbcDamage2 = ServerEffectManager.INSTANCE.readLastDamageDealtFromDBC(p2);
                    float any2 = ServerEffectManager.INSTANCE.readAnyLastDamageCandidates((Entity)p2);
                    float eventDamage2 = this.safeReadEventDamage(event);
                    float chosen = 0.0f;
                    if (dbcDamage2 > 0.0f) {
                        chosen = dbcDamage2;
                    } else if (any2 > 0.0f) {
                        chosen = any2;
                    }
                    if (chosen > 0.0f) {
                        ServerEffectManager.INSTANCE.applyLifeStealFromDamage(p2, chosen);
                        break block39;
                    }
                    ServerEffectManager.INSTANCE.enqueuePendingLifeSteal(p2.func_110124_au(), eventDamage2);
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private float safeReadEventDamage(LivingHurtEvent event) {
        if (event == null) {
            return 0.0f;
        }
        float damage = 0.0f;
        boolean got = false;
        try {
            Object val;
            Method gm = event.getClass().getMethod("getAmount", new Class[0]);
            if (gm != null && (val = gm.invoke((Object)event, new Object[0])) instanceof Number) {
                damage = ((Number)val).floatValue();
                got = true;
            }
        }
        catch (Throwable gm) {
            // empty catch block
        }
        if (!got) {
            try {
                Field f = event.getClass().getField("amount");
                f.setAccessible(true);
                damage = f.getFloat(event);
                got = true;
            }
            catch (Throwable f) {
                // empty catch block
            }
        }
        if (!got) {
            try {
                Field f2 = event.getClass().getField("ammount");
                f2.setAccessible(true);
                damage = f2.getFloat(event);
                got = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return damage;
    }
}

