/*
 * Decompiled with CFR 0.152.
 */
package com.rneffects.server;

import com.rneffects.effects.RNEffectType;
import com.rneffects.network.NetworkHandler;
import com.rneffects.network.PacketShieldUpdate;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S39PacketPlayerAbilities;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ServerEffectManager {
    public static final ServerEffectManager INSTANCE = new ServerEffectManager();
    private static final boolean DEBUG_LOG = false;
    private final Map<UUID, List<ServerEffectInstance>> byPlayer = new HashMap<UUID, List<ServerEffectInstance>>();
    private final Map<UUID, Boolean> savedAllowFlying = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> savedIsFlying = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> savedSprinting = new HashMap<UUID, Boolean>();
    private final Map<UUID, Integer> lastBodyMap = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> lifeShieldMap = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> pendingLifeStealTs = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Float> pendingLifeStealEventDamage = new ConcurrentHashMap<UUID, Float>();
    private static final long PENDING_LIFESTEAL_TIMEOUT_MS = 2000L;
    private final Map<UUID, Long> lastLifeStealAppliedAt = new ConcurrentHashMap<UUID, Long>();
    private static final long LIFESTEAL_DEBOUNCE_MS = 50L;
    private final Map<UUID, Float> lastProcessedDbcDamage = new ConcurrentHashMap<UUID, Float>();
    private final Map<UUID, Long> lastProcessedDbcTime = new ConcurrentHashMap<UUID, Long>();
    private static final long LIFESTEAL_DB_DAMAGE_DEDUP_MS = 600L;
    private static final double DBC_DAMAGE_EPS = 0.5;
    private final Map<UUID, LifeStealState> lifeStealStates = new ConcurrentHashMap<UUID, LifeStealState>();
    private int damageIdCounter = 1;

    private synchronized int nextDamageId() {
        return this.damageIdCounter++;
    }

    private UUID getPlayerSlowUUID(UUID playerUuid) {
        return UUID.nameUUIDFromBytes((playerUuid.toString() + ":rneffects:slow").getBytes());
    }

    public void addEffect(EntityPlayerMP player, RNEffectType type, int durationTicks, int amplifier) {
        if (player == null) {
            return;
        }
        UUID puid = player.func_110124_au();
        this.byPlayer.computeIfAbsent(puid, k -> new ArrayList()).add(new ServerEffectInstance(type, durationTicks, amplifier));
        if (type == RNEffectType.LIFE_SHIELD) {
            try {
                int ampVal;
                int maxBody = this.readPlayerMaxBody(player);
                if (maxBody <= 0) {
                    try {
                        maxBody = Math.max(1, Math.round(player.func_110138_aP()));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if ((ampVal = amplifier) <= 0) {
                    this.lifeShieldMap.remove(puid);
                    this.sendShieldUpdate(puid, player);
                } else {
                    float frac = (float)(ampVal = Math.max(1, Math.min(100, ampVal))) / 100.0f;
                    int shieldUnits = Math.max(0, Math.round((float)maxBody * frac));
                    if (shieldUnits <= 0 && frac > 0.0f) {
                        shieldUnits = 1;
                    }
                    this.lifeShieldMap.put(puid, shieldUnits);
                    this.sendShieldUpdate(puid, player);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (type == RNEffectType.LIFE_STEAL) {
            this.startLifeStealState(player);
        }
    }

    public void updateLastBodySnapshot(EntityPlayerMP player) {
        if (player == null) {
            return;
        }
        try {
            int body = this.readPlayerBody(player);
            this.lastBodyMap.put(player.func_110124_au(), body);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setJinRyuuTurboSuppressed(EntityPlayerMP player, boolean suppress) {
        try {
            String[] possibleClasses = new String[]{"JinRyuu.DragonBC.common.DBCKiTech", "JinRyuu.DragonBC.DBCKiTech", "JinRyuu.JRMCore.DBCKiTech", "JinRyuu.JRMCore.DBCKiTech", "JinRyuu.DragonBC.common.DBCClientTickHandler", "JinRyuu.DragonBC.common.DBCClient"};
            String[] boolKeys = new String[]{"turbo", "turb", "dash", "float", "flying", "sprint", "sprinting", "issprinting", "isprint"};
            String[] numKeys = new String[]{"forw", "forward", "forwards", "speed", "time", "sec", "floattime", "float_time"};
            for (String className : possibleClasses) {
                try {
                    String name;
                    Field[] fields;
                    Class<?> cls = Class.forName(className);
                    if (cls == null) continue;
                    if (suppress) {
                        try {
                            Method m = cls.getMethod("DashKi", Boolean.TYPE);
                            m.invoke(null, false);
                        }
                        catch (Throwable m) {
                            // empty catch block
                        }
                        try {
                            Method m2 = cls.getMethod("TurboMode", Boolean.TYPE);
                            m2.invoke(null, false);
                        }
                        catch (Throwable m2) {
                            // empty catch block
                        }
                        try {
                            Method m3 = cls.getMethod("DashKi", Boolean.TYPE);
                            m3.invoke(null, false);
                        }
                        catch (Throwable m3) {
                            // empty catch block
                        }
                        block22: for (Field f : fields = cls.getDeclaredFields()) {
                            try {
                                f.setAccessible(true);
                                name = f.getName().toLowerCase();
                                for (String k : boolKeys) {
                                    if (!name.contains(k) || f.getType() != Boolean.TYPE && f.getType() != Boolean.class) continue;
                                    try {
                                        f.setBoolean(null, false);
                                    }
                                    catch (Throwable throwable) {}
                                    break;
                                }
                                for (String k2 : numKeys) {
                                    if (!name.contains(k2)) continue;
                                    Class<?> t = f.getType();
                                    try {
                                        if (t == Integer.TYPE) {
                                            f.setInt(null, 0);
                                            continue block22;
                                        }
                                        if (t == Long.TYPE) {
                                            f.setLong(null, 0L);
                                            continue block22;
                                        }
                                        if (t == Float.TYPE) {
                                            f.setFloat(null, 0.0f);
                                            continue block22;
                                        }
                                        if (t != Double.TYPE) continue block22;
                                        f.setDouble(null, 0.0);
                                    }
                                    catch (Throwable throwable) {}
                                    continue block22;
                                }
                            }
                            catch (Throwable name2) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    for (Field f : fields = cls.getDeclaredFields()) {
                        try {
                            f.setAccessible(true);
                            name = f.getName().toLowerCase();
                            if (f.getType() != Boolean.TYPE || !name.contains("request") && !name.contains("req") && !name.contains("try") && !name.contains("onrequest")) continue;
                            try {
                                f.setBoolean(null, false);
                            }
                            catch (Throwable throwable) {}
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void writePlayerEnergy(EntityPlayerMP player, int value) {
        block52: {
            if (player == null) {
                return;
            }
            String[] classNames = new String[]{"JinRyuu.JRMCore.JRMCoreH", "JRMCoreH"};
            String[] candidateKeys = new String[]{"jrmcEnrgy", "curEnergy", "jrmcEnergy", "jrmcKi", "curKi", "energy", "enrgy", "curEn", "curEnrgy", "jrmcE"};
            Supplier<Integer> readBack = () -> {
                try {
                    return this.readPlayerEnergy(player);
                }
                catch (Throwable t) {
                    return -1;
                }
            };
            for (String clsName : classNames) {
                try {
                    Class<?>[] ps;
                    String mn;
                    Class<?> cls = Class.forName(clsName);
                    for (Method m : cls.getMethods()) {
                        int after;
                        mn = m.getName().toLowerCase();
                        if (!mn.contains("set") && !mn.contains("put")) continue;
                        ps = m.getParameterTypes();
                        boolean invoked = false;
                        if (ps.length == 3 && ps[0] == Integer.TYPE && EntityPlayer.class.isAssignableFrom(ps[1]) && ps[2] == String.class) {
                            for (String key : candidateKeys) {
                                try {
                                    m.invoke(null, value, player, key);
                                    invoked = true;
                                    break;
                                }
                                catch (Throwable throwable) {
                                }
                            }
                        } else if (ps.length == 3 && ps[0] == Integer.TYPE && ps[1] == String.class && EntityPlayer.class.isAssignableFrom(ps[2])) {
                            for (String key : candidateKeys) {
                                try {
                                    m.invoke(null, value, key, player);
                                    invoked = true;
                                    break;
                                }
                                catch (Throwable throwable) {
                                }
                            }
                        } else if (ps.length == 3 && EntityPlayer.class.isAssignableFrom(ps[0]) && ps[2] == Integer.TYPE && ps[1] == String.class) {
                            for (String key : candidateKeys) {
                                try {
                                    m.invoke(null, player, key, value);
                                    invoked = true;
                                    break;
                                }
                                catch (Throwable throwable) {
                                }
                            }
                        } else if (ps.length == 2 && ps[0] == Integer.TYPE && ps[1] == String.class) {
                            for (String key : candidateKeys) {
                                try {
                                    m.invoke(null, value, key);
                                    invoked = true;
                                    break;
                                }
                                catch (Throwable throwable) {
                                }
                            }
                        } else if (ps.length == 1 && ps[0] == Integer.TYPE) {
                            try {
                                m.invoke(null, value);
                                invoked = true;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (!invoked || (after = readBack.get().intValue()) != value) continue;
                        return;
                    }
                    for (Method m : cls.getMethods()) {
                        int after;
                        mn = m.getName().toLowerCase();
                        if (!mn.contains("setbyte") && !mn.equals("setb") && !mn.contains("setbyt")) continue;
                        ps = m.getParameterTypes();
                        if (value < -128 || value > 127) continue;
                        byte vb = (byte)value;
                        boolean invoked = false;
                        try {
                            if (ps.length == 3 && ps[0] == Byte.TYPE && EntityPlayer.class.isAssignableFrom(ps[1]) && ps[2] == String.class) {
                                m.invoke(null, vb, player, candidateKeys[0]);
                                invoked = true;
                            } else if (ps.length == 3 && ps[0] == Byte.TYPE && ps[1] == String.class && EntityPlayer.class.isAssignableFrom(ps[2])) {
                                m.invoke(null, vb, candidateKeys[0], player);
                                invoked = true;
                            } else if (ps.length == 2 && ps[0] == Byte.TYPE && ps[1] == String.class) {
                                m.invoke(null, vb, candidateKeys[0]);
                                invoked = true;
                            } else if (ps.length == 1 && ps[0] == Byte.TYPE) {
                                m.invoke(null, vb);
                                invoked = true;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!invoked || (after = readBack.get().intValue()) != value) continue;
                        return;
                    }
                    try {
                        Method nbtMethod = cls.getMethod("nbt", Entity.class);
                        Object nbtObj = nbtMethod.invoke(null, player);
                        if (nbtObj == null) continue;
                        Class<?> nbtCls = nbtObj.getClass();
                        for (String key : candidateKeys) {
                            try {
                                Method setInt = null;
                                try {
                                    setInt = nbtCls.getMethod("setInteger", String.class, Integer.TYPE);
                                }
                                catch (Throwable after) {
                                    // empty catch block
                                }
                                if (setInt == null) continue;
                                setInt.invoke(nbtObj, key, value);
                                int after = readBack.get();
                                if (after != value) continue;
                                return;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Throwable nbtMethod) {
                    }
                }
                catch (ClassNotFoundException cls) {
                }
                catch (Throwable cls) {
                    // empty catch block
                }
            }
            try {
                NBTTagCompound nbt = player.getEntityData();
                if (nbt == null) break block52;
                for (String key : candidateKeys) {
                    try {
                        nbt.func_74768_a(key, value);
                        int after = this.readPlayerEnergy(player);
                        if (after != value) continue;
                        return;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void tickForPlayer(EntityPlayerMP player) {
        AttributeModifier mod;
        IAttributeInstance attr;
        if (player == null) {
            return;
        }
        UUID puid = player.func_110124_au();
        List<ServerEffectInstance> list = this.byPlayer.get(puid);
        if (list == null || list.isEmpty()) {
            this.cleanupModifierIfNoEffects(player, puid);
            try {
                this.setJinRyuuTurboSuppressed(player, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.processPendingLifeStealForPlayer(player);
            return;
        }
        Iterator<ServerEffectInstance> it = list.iterator();
        float highestSlowPercent = 0.0f;
        boolean removedLifeStealInstance = false;
        while (it.hasNext()) {
            double curPercent;
            ServerEffectInstance inst = it.next();
            --inst.remainingTicks;
            if (inst.remainingTicks <= 0) {
                if (inst.type == RNEffectType.LIFE_SHIELD) {
                    try {
                        this.lifeShieldMap.remove(puid);
                        this.sendShieldUpdate(puid, player);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (inst.type == RNEffectType.LIFE_STEAL) {
                    removedLifeStealInstance = true;
                }
                it.remove();
                continue;
            }
            if (inst.type != RNEffectType.SLOW_PROGRESSIVE || !((float)(curPercent = this.computeSlowPercent(inst)) > highestSlowPercent)) continue;
            highestSlowPercent = (float)curPercent;
        }
        if (removedLifeStealInstance) {
            boolean stillHasLifeSteal = false;
            List<ServerEffectInstance> after = this.byPlayer.get(puid);
            if (after != null) {
                for (ServerEffectInstance si : after) {
                    if (si == null || si.type != RNEffectType.LIFE_STEAL || si.remainingTicks <= 0) continue;
                    stillHasLifeSteal = true;
                    break;
                }
            }
            if (!stillHasLifeSteal) {
                this.endLifeStealState(player);
            }
        }
        if ((attr = player.func_110148_a(SharedMonsterAttributes.field_111263_d)) == null) {
            if (list.isEmpty()) {
                this.byPlayer.remove(puid);
            }
            this.processPendingLifeStealForPlayer(player);
            return;
        }
        UUID modUUID = this.getPlayerSlowUUID(puid);
        if (highestSlowPercent <= 1.0E-5f) {
            AttributeModifier existing = attr.func_111127_a(modUUID);
            if (existing != null) {
                try {
                    attr.func_111124_b(existing);
                }
                catch (Throwable si) {
                    // empty catch block
                }
            }
            try {
                if (this.savedAllowFlying.containsKey(puid)) {
                    boolean prevAllow = this.savedAllowFlying.remove(puid);
                    boolean prevIsFlying = this.savedIsFlying.remove(puid);
                    player.field_71075_bZ.field_75101_c = prevAllow;
                    player.field_71075_bZ.field_75100_b = prevIsFlying;
                    try {
                        player.field_71135_a.func_147359_a((Packet)new S39PacketPlayerAbilities(player.field_71075_bZ));
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable prevAllow) {
                // empty catch block
            }
            try {
                if (this.savedSprinting.containsKey(puid)) {
                    boolean prevSprint = this.savedSprinting.remove(puid);
                    player.func_70031_b(prevSprint);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (list.isEmpty()) {
                this.byPlayer.remove(puid);
            }
            try {
                this.setJinRyuuTurboSuppressed(player, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.processPendingLifeStealForPlayer(player);
            return;
        }
        double amount = -highestSlowPercent;
        try {
            this.setJinRyuuTurboSuppressed(player, true);
        }
        catch (Throwable prevIsFlying) {
            // empty catch block
        }
        try {
            if (!this.savedAllowFlying.containsKey(puid)) {
                this.savedAllowFlying.put(puid, player.field_71075_bZ.field_75101_c);
                this.savedIsFlying.put(puid, player.field_71075_bZ.field_75100_b);
                player.field_71075_bZ.field_75100_b = false;
                player.field_71075_bZ.field_75101_c = false;
                try {
                    player.field_71135_a.func_147359_a((Packet)new S39PacketPlayerAbilities(player.field_71075_bZ));
                }
                catch (Throwable prevIsFlying) {}
            }
        }
        catch (Throwable prevIsFlying) {
            // empty catch block
        }
        try {
            if (!this.savedSprinting.containsKey(puid)) {
                this.savedSprinting.put(puid, player.func_70051_ag());
            }
            boolean pktSent = false;
            try {
                pktSent = this.trySendStopSprintingPacket(player);
            }
            catch (Throwable tt) {
                pktSent = false;
            }
            if (player.func_70051_ag()) {
                player.func_70031_b(false);
            }
        }
        catch (Throwable pktSent) {
            // empty catch block
        }
        AttributeModifier existing = attr.func_111127_a(modUUID);
        if (existing != null && !(Math.abs(existing.func_111164_d() - amount) < 1.0E-6)) {
            try {
                attr.func_111124_b(existing);
            }
            catch (Throwable tt) {
                // empty catch block
            }
        }
        try {
            mod = new AttributeModifier(modUUID, "RNEffects:Slow", amount, 2);
        }
        catch (NoSuchMethodError e) {
            try {
                mod = new AttributeModifier(modUUID.toString(), amount, 1);
            }
            catch (Throwable t2) {
                try {
                    mod = new AttributeModifier("RNEffects:Slow", amount, 1);
                }
                catch (Throwable t3) {
                    return;
                }
            }
        }
        catch (Throwable t) {
            return;
        }
        try {
            attr.func_111121_a(mod);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.processPendingLifeStealForPlayer(player);
    }

    public float getMovementMultiplier(EntityPlayerMP player) {
        if (player == null) {
            return 1.0f;
        }
        UUID puid = player.func_110124_au();
        List<ServerEffectInstance> list = this.byPlayer.get(puid);
        if (list == null || list.isEmpty()) {
            return 1.0f;
        }
        float worst = 1.0f;
        for (ServerEffectInstance inst : list) {
            float pct;
            float mul;
            if (inst.type != RNEffectType.SLOW_PROGRESSIVE || !((mul = 1.0f - (pct = (float)this.computeSlowPercent(inst))) < worst)) continue;
            worst = mul;
        }
        return worst;
    }

    public float getChakraDrainFraction(EntityPlayerMP player) {
        if (player == null) {
            return 0.0f;
        }
        UUID puid = player.func_110124_au();
        List<ServerEffectInstance> list = this.byPlayer.get(puid);
        if (list == null || list.isEmpty()) {
            return 0.0f;
        }
        int bestAmp = 0;
        for (ServerEffectInstance inst : list) {
            if (inst.type != RNEffectType.CHAKRA_DRAIN || inst.remainingTicks <= 0 || inst.amplifier <= bestAmp) continue;
            bestAmp = inst.amplifier;
        }
        if (bestAmp <= 0) {
            return 0.0f;
        }
        int amp = Math.max(1, Math.min(100, bestAmp));
        float frac = (float)amp / 100.0f;
        if (frac > 1.0f) {
            frac = 1.0f;
        }
        return frac;
    }

    public float getLifeStealFraction(EntityPlayerMP player) {
        if (player == null) {
            return 0.0f;
        }
        UUID puid = player.func_110124_au();
        List<ServerEffectInstance> list = this.byPlayer.get(puid);
        if (list == null || list.isEmpty()) {
            return 0.0f;
        }
        int bestLifeAmp = 0;
        for (ServerEffectInstance inst : list) {
            if (inst == null || inst.type != RNEffectType.LIFE_STEAL || inst.remainingTicks <= 0 || inst.amplifier <= bestLifeAmp) continue;
            bestLifeAmp = inst.amplifier;
        }
        if (bestLifeAmp <= 0) {
            return 0.0f;
        }
        int amp = Math.max(1, Math.min(100, bestLifeAmp));
        float frac = (float)amp / 100.0f;
        if (frac > 1.0f) {
            frac = 1.0f;
        }
        return frac;
    }

    public void applyChakraDrainFromDamage(EntityPlayerMP player, float eventDamage) {
        if (player == null) {
            return;
        }
        float frac = this.getChakraDrainFraction(player);
        if (frac <= 0.0f) {
            return;
        }
        int actualDamageUnits = 0;
        try {
            int toDrain;
            int delta;
            UUID puid = player.func_110124_au();
            int currentBody = this.readPlayerBody(player);
            Integer lastBody = this.lastBodyMap.get(puid);
            if (lastBody != null && (delta = lastBody - currentBody) > 0) {
                actualDamageUnits = delta;
            }
            if (actualDamageUnits <= 0) {
                actualDamageUnits = Math.max(0, Math.round(eventDamage));
            }
            if ((toDrain = Math.max(0, Math.round((float)actualDamageUnits * frac))) <= 0) {
                return;
            }
            int curEn = this.readPlayerEnergy(player);
            int newEn = curEn - toDrain;
            if (newEn < 0) {
                newEn = 0;
            }
            this.writePlayerEnergy(player, newEn);
            if (newEn == 0) {
                try {
                    try {
                        Class<?> cls = Class.forName("JinRyuu.JRMCore.JRMCoreH");
                        Method setByte = null;
                        try {
                            setByte = cls.getMethod("setByte", Byte.TYPE, EntityPlayerMP.class, String.class);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        if (setByte != null) {
                            setByte.invoke(null, (byte)0, player, "jrmcRelease");
                        }
                    }
                    catch (ClassNotFoundException cnf) {
                        try {
                            Class<?> cls2 = Class.forName("JRMCoreH");
                            Method m = cls2.getMethod("setByte", Byte.TYPE, EntityPlayerMP.class, String.class);
                            m.invoke(null, (byte)0, player, "jrmcRelease");
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.lastBodyMap.put(puid, currentBody);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void applyLifeShieldFromEvent(LivingHurtEvent event, EntityPlayerMP player) {
        if (player == null || event == null) {
            return;
        }
        UUID puid = player.func_110124_au();
        try {
            float damage = 0.0f;
            boolean gotDamage = false;
            try {
                Object val;
                Method gm = event.getClass().getMethod("getAmount", new Class[0]);
                if (gm != null && (val = gm.invoke((Object)event, new Object[0])) instanceof Number) {
                    damage = ((Number)val).floatValue();
                    gotDamage = true;
                }
            }
            catch (Throwable gm) {
                // empty catch block
            }
            if (!gotDamage) {
                try {
                    Field f = event.getClass().getField("amount");
                    f.setAccessible(true);
                    damage = f.getFloat(event);
                    gotDamage = true;
                }
                catch (Throwable f) {
                    // empty catch block
                }
            }
            if (!gotDamage) {
                try {
                    Field f2 = event.getClass().getField("ammount");
                    f2.setAccessible(true);
                    damage = f2.getFloat(event);
                    gotDamage = true;
                }
                catch (Throwable f2) {
                    // empty catch block
                }
            }
            if (!gotDamage) {
                return;
            }
            if (damage <= 0.0f) {
                return;
            }
            int dmgUnits = Math.max(0, Math.round(damage));
            int shieldUnits = 0;
            try {
                Integer s = this.lifeShieldMap.get(puid);
                if (s != null) {
                    shieldUnits = s;
                }
            }
            catch (Throwable s) {
                // empty catch block
            }
            if (shieldUnits <= 0) {
                return;
            }
            if (shieldUnits >= dmgUnits) {
                int newShield = shieldUnits - dmgUnits;
                if (newShield <= 0) {
                    this.lifeShieldMap.remove(puid);
                    List<ServerEffectInstance> list = this.byPlayer.get(puid);
                    if (list != null) {
                        Iterator<ServerEffectInstance> it = list.iterator();
                        while (it.hasNext()) {
                            ServerEffectInstance inst = it.next();
                            if (inst.type != RNEffectType.LIFE_SHIELD) continue;
                            it.remove();
                        }
                        if (list.isEmpty()) {
                            this.byPlayer.remove(puid);
                        }
                    }
                } else {
                    this.lifeShieldMap.put(puid, newShield);
                }
                try {
                    try {
                        Method sm = event.getClass().getMethod("setAmount", Float.TYPE);
                        sm.invoke((Object)event, Float.valueOf(0.0f));
                    }
                    catch (NoSuchMethodException nsf) {
                        try {
                            Field f = event.getClass().getField("amount");
                            f.setAccessible(true);
                            f.setFloat(event, 0.0f);
                        }
                        catch (Throwable ignored) {
                            try {
                                Field f2 = event.getClass().getField("ammount");
                                f2.setAccessible(true);
                                f2.setFloat(event, 0.0f);
                            }
                            catch (Throwable f2) {}
                        }
                    }
                }
                catch (Throwable nsf) {
                    // empty catch block
                }
                this.sendShieldUpdate(puid, player);
                return;
            }
            int remainingDamageUnits = dmgUnits - shieldUnits;
            this.lifeShieldMap.remove(puid);
            List<ServerEffectInstance> list = this.byPlayer.get(puid);
            if (list != null) {
                Iterator<ServerEffectInstance> it = list.iterator();
                while (it.hasNext()) {
                    ServerEffectInstance inst = it.next();
                    if (inst.type != RNEffectType.LIFE_SHIELD) continue;
                    it.remove();
                }
                if (list.isEmpty()) {
                    this.byPlayer.remove(puid);
                }
            }
            float newDamage = remainingDamageUnits;
            try {
                try {
                    Method sm = event.getClass().getMethod("setAmount", Float.TYPE);
                    sm.invoke((Object)event, Float.valueOf(newDamage));
                }
                catch (NoSuchMethodException nsf) {
                    try {
                        Field f = event.getClass().getField("amount");
                        f.setAccessible(true);
                        f.setFloat(event, newDamage);
                    }
                    catch (Throwable ignored) {
                        try {
                            Field f2 = event.getClass().getField("ammount");
                            f2.setAccessible(true);
                            f2.setFloat(event, newDamage);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.sendShieldUpdate(puid, player);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private int readPlayerEnergy(EntityPlayerMP player) {
        block68: {
            block67: {
                if (player == null) {
                    return 0;
                }
                String[] classNames = new String[]{"JinRyuu.JRMCore.JRMCoreH", "JRMCoreH"};
                String[] candidateKeys = new String[]{"jrmcEnrgy", "curEnergy", "jrmcEnergy", "jrmcKi", "curKi", "energy", "enrgy", "curEn", "curEnrgy", "jrmcE"};
                for (String clsName : classNames) {
                    try {
                        Class<?> cls = Class.forName(clsName);
                        for (Method throwable : cls.getMethods()) {
                            String mn = throwable.getName().toLowerCase();
                            if (!mn.contains("getint") && !mn.contains("getfloat") && !mn.contains("getdouble") && !mn.equals("get")) continue;
                            Class<?>[] ps = throwable.getParameterTypes();
                            for (String key : candidateKeys) {
                                try {
                                    Object v = null;
                                    if (ps.length == 2 && ps[0].isAssignableFrom(player.getClass()) && ps[1] == String.class) {
                                        v = throwable.invoke(null, player, key);
                                    } else if (ps.length == 2 && ps[0] == String.class && ps[1].isAssignableFrom(player.getClass())) {
                                        v = throwable.invoke(null, key, player);
                                    } else if (ps.length == 1 && ps[0].isAssignableFrom(player.getClass())) {
                                        v = throwable.invoke(null, player);
                                    } else if (ps.length == 1 && ps[0] == String.class) {
                                        v = throwable.invoke(null, key);
                                    } else if (ps.length == 0) {
                                        v = throwable.invoke(null, new Object[0]);
                                    }
                                    if (!(v instanceof Number)) continue;
                                    int val = ((Number)v).intValue();
                                    return val;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                            }
                        }
                        try {
                            Field f = null;
                            try {
                                f = cls.getField("curEnergy");
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (f == null) {
                                try {
                                    f = cls.getField("curEn");
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            if (f == null) {
                                try {
                                    f = cls.getField("curE");
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            if (f != null) {
                                f.setAccessible(true);
                                Object object = f.get(null);
                                if (object instanceof Number) {
                                    int val = ((Number)object).intValue();
                                    return val;
                                }
                            }
                        }
                        catch (Throwable f) {
                            // empty catch block
                        }
                        try {
                            Method nbtMethod = cls.getMethod("nbt", Entity.class);
                            Object object = nbtMethod.invoke(null, player);
                            if (object == null) continue;
                            Class<?> nbtCls = object.getClass();
                            for (String key : candidateKeys) {
                                try {
                                    try {
                                        Method gi = nbtCls.getMethod("getInteger", String.class);
                                        Object val = gi.invoke(object, key);
                                        if (val instanceof Number) {
                                            int v = ((Number)val).intValue();
                                            return v;
                                        }
                                    }
                                    catch (Throwable gi) {
                                        // empty catch block
                                    }
                                    try {
                                        Method gd = nbtCls.getMethod("getDouble", String.class);
                                        Object val2 = gd.invoke(object, key);
                                        if (!(val2 instanceof Number)) continue;
                                        int v2 = (int)Math.round(((Number)val2).doubleValue());
                                        return v2;
                                    }
                                    catch (Throwable throwable) {}
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (Throwable nbtMethod) {
                        }
                    }
                    catch (ClassNotFoundException cls) {
                    }
                    catch (Throwable cls) {
                        // empty catch block
                    }
                }
                try {
                    NBTTagCompound nbt = player.getEntityData();
                    if (nbt == null) break block67;
                    for (String key : candidateKeys) {
                        try {
                            if (!nbt.func_74764_b(key)) continue;
                            try {
                                int v = nbt.func_74762_e(key);
                                return v;
                            }
                            catch (Throwable v) {
                                try {
                                    double d = nbt.func_74769_h(key);
                                    int vv = (int)Math.round(d);
                                    return vv;
                                }
                                catch (Throwable d) {
                                    try {
                                        String s = nbt.func_74779_i(key);
                                        if (s == null || s.length() <= 0) continue;
                                        int n = Integer.parseInt(s);
                                        return n;
                                    }
                                    catch (Throwable throwable) {}
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable nbt) {
                    // empty catch block
                }
            }
            try {
                Class<?> extCls = null;
                try {
                    extCls = Class.forName("JinRyuu.JRMCore.ExtendedPlayer");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (extCls == null) {
                    try {
                        extCls = Class.forName("ExtendedPlayer");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (extCls == null) break block68;
                try {
                    Method gm = extCls.getMethod("get", EntityPlayer.class);
                    Object inst = gm.invoke(null, player);
                    if (inst == null) break block68;
                    for (Field field : inst.getClass().getDeclaredFields()) {
                        try {
                            String fname = field.getName().toLowerCase();
                            if (!fname.contains("en") && !fname.contains("energy") && !fname.contains("ki") && !fname.contains("cur")) continue;
                            field.setAccessible(true);
                            Object object = field.get(inst);
                            if (!(object instanceof Number)) continue;
                            int val = ((Number)object).intValue();
                            return val;
                        }
                        catch (Throwable fname) {
                            // empty catch block
                        }
                    }
                    for (AccessibleObject accessibleObject : inst.getClass().getMethods()) {
                        String mn = ((Method)accessibleObject).getName().toLowerCase();
                        if (!mn.contains("get") || !mn.contains("en") && !mn.contains("energy") && !mn.contains("ki") && !mn.contains("cur")) continue;
                        try {
                            Object object = ((Method)accessibleObject).invoke(inst, new Object[0]);
                            if (!(object instanceof Number)) continue;
                            int val = ((Number)object).intValue();
                            return val;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }

    private int readPlayerBody(EntityPlayerMP player) {
        block62: {
            block61: {
                if (player == null) {
                    return 0;
                }
                String[] classNames = new String[]{"JinRyuu.JRMCore.JRMCoreH", "JRMCoreH"};
                String[] candidateKeys = new String[]{"jrmcBdy"};
                for (String clsName : classNames) {
                    try {
                        Class<?> cls = Class.forName(clsName);
                        for (Method throwable : cls.getMethods()) {
                            String mn = throwable.getName().toLowerCase();
                            if (!mn.contains("getint") && !mn.contains("getfloat") && !mn.contains("getdouble") && !mn.equals("get")) continue;
                            Class<?>[] ps = throwable.getParameterTypes();
                            for (String key : candidateKeys) {
                                try {
                                    Object v = null;
                                    if (ps.length == 2 && ps[0].isAssignableFrom(player.getClass()) && ps[1] == String.class) {
                                        v = throwable.invoke(null, player, key);
                                    } else if (ps.length == 2 && ps[0] == String.class && ps[1].isAssignableFrom(player.getClass())) {
                                        v = throwable.invoke(null, key, player);
                                    } else if (ps.length == 1 && ps[0].isAssignableFrom(player.getClass())) {
                                        v = throwable.invoke(null, player);
                                    } else if (ps.length == 1 && ps[0] == String.class) {
                                        v = throwable.invoke(null, key);
                                    } else if (ps.length == 0) {
                                        v = throwable.invoke(null, new Object[0]);
                                    }
                                    if (!(v instanceof Number)) continue;
                                    int val = ((Number)v).intValue();
                                    return val;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                            }
                        }
                        try {
                            Field f = cls.getField("curBody");
                            if (f != null) {
                                f.setAccessible(true);
                                Object object = f.get(null);
                                if (object instanceof Number) {
                                    int val = ((Number)object).intValue();
                                    return val;
                                }
                            }
                        }
                        catch (Throwable f) {
                            // empty catch block
                        }
                        try {
                            Method nbtMethod = cls.getMethod("nbt", Entity.class);
                            Object object = nbtMethod.invoke(null, player);
                            if (object == null) continue;
                            Class<?> nbtCls = object.getClass();
                            for (String key : candidateKeys) {
                                try {
                                    try {
                                        Method gi = nbtCls.getMethod("getInteger", String.class);
                                        Object val = gi.invoke(object, key);
                                        if (val instanceof Number) {
                                            int v = ((Number)val).intValue();
                                            return v;
                                        }
                                    }
                                    catch (Throwable gi) {
                                        // empty catch block
                                    }
                                    try {
                                        Method gd = nbtCls.getMethod("getDouble", String.class);
                                        Object val2 = gd.invoke(object, key);
                                        if (!(val2 instanceof Number)) continue;
                                        int v2 = (int)Math.round(((Number)val2).doubleValue());
                                        return v2;
                                    }
                                    catch (Throwable throwable) {}
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (Throwable nbtMethod) {
                        }
                    }
                    catch (ClassNotFoundException cls) {
                    }
                    catch (Throwable cls) {
                        // empty catch block
                    }
                }
                try {
                    NBTTagCompound nbt = player.getEntityData();
                    if (nbt == null) break block61;
                    for (String key : candidateKeys) {
                        try {
                            if (!nbt.func_74764_b(key)) continue;
                            try {
                                int v = nbt.func_74762_e(key);
                                return v;
                            }
                            catch (Throwable v) {
                                try {
                                    double d = nbt.func_74769_h(key);
                                    int vv = (int)Math.round(d);
                                    return vv;
                                }
                                catch (Throwable d) {
                                    try {
                                        String s = nbt.func_74779_i(key);
                                        if (s == null || s.length() <= 0) continue;
                                        int n = Integer.parseInt(s);
                                        return n;
                                    }
                                    catch (Throwable throwable) {}
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable nbt) {
                    // empty catch block
                }
            }
            try {
                Class<?> extCls = null;
                try {
                    extCls = Class.forName("JinRyuu.JRMCore.ExtendedPlayer");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (extCls == null) {
                    try {
                        extCls = Class.forName("ExtendedPlayer");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (extCls == null) break block62;
                try {
                    Method gm = extCls.getMethod("get", EntityPlayer.class);
                    Object inst = gm.invoke(null, player);
                    if (inst == null) break block62;
                    for (Field field : inst.getClass().getDeclaredFields()) {
                        try {
                            String fname = field.getName().toLowerCase();
                            if (!fname.contains("bdy") && !fname.contains("body") && !fname.contains("cur")) continue;
                            field.setAccessible(true);
                            Object object = field.get(inst);
                            if (!(object instanceof Number)) continue;
                            int val = ((Number)object).intValue();
                            return val;
                        }
                        catch (Throwable fname) {
                            // empty catch block
                        }
                    }
                    for (AccessibleObject accessibleObject : inst.getClass().getMethods()) {
                        String mn = ((Method)accessibleObject).getName().toLowerCase();
                        if (!mn.contains("get") || !mn.contains("bdy") && !mn.contains("body") && !mn.contains("cur")) continue;
                        try {
                            Object object = ((Method)accessibleObject).invoke(inst, new Object[0]);
                            if (!(object instanceof Number)) continue;
                            int val = ((Number)object).intValue();
                            return val;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable extCls) {
                // empty catch block
            }
        }
        try {
            int fallback = Math.round(player.func_110143_aJ());
            return Math.max(0, fallback);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private void writePlayerBody(EntityPlayerMP player, int value) {
        this.writePlayerBodyToJinRyuu(player, value);
        try {
            if (player != null) {
                this.lastBodyMap.put(player.func_110124_au(), value);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void writePlayerBodyToJinRyuu(EntityPlayerMP player, int newBody) {
        UUID puid;
        block49: {
            boolean wrote;
            block48: {
                if (player == null) {
                    return;
                }
                puid = player.func_110124_au();
                wrote = false;
                try {
                    Method[] methods;
                    Class<?> cls = null;
                    try {
                        cls = Class.forName("JinRyuu.JRMCore.JRMCoreH");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (cls == null) {
                        try {
                            cls = Class.forName("JRMCoreH");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (cls == null) break block48;
                    for (Method m : methods = cls.getMethods()) {
                        if (!m.getName().equals("setInt")) continue;
                        Class<?>[] params = m.getParameterTypes();
                        try {
                            if (params.length == 3 && params[0] == Integer.TYPE && EntityPlayer.class.isAssignableFrom(params[1]) && params[2] == String.class) {
                                m.invoke(null, newBody, player, "jrmcBdy");
                                wrote = true;
                            } else {
                                if (params.length != 3 || params[0] != Integer.TYPE || params[1] != String.class || !EntityPlayer.class.isAssignableFrom(params[2])) continue;
                                m.invoke(null, newBody, "jrmcBdy", player);
                                wrote = true;
                            }
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable cls) {
                    // empty catch block
                }
            }
            if (!wrote) {
                try {
                    Class<?> extCls = null;
                    try {
                        extCls = Class.forName("JinRyuu.JRMCore.ExtendedPlayer");
                    }
                    catch (Throwable methods) {
                        // empty catch block
                    }
                    if (extCls == null) {
                        try {
                            extCls = Class.forName("ExtendedPlayer");
                        }
                        catch (Throwable methods) {
                            // empty catch block
                        }
                    }
                    if (extCls == null) break block49;
                    Method getM = null;
                    try {
                        getM = extCls.getMethod("get", EntityPlayer.class);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Object extInst = null;
                    if (getM != null) {
                        extInst = getM.invoke(null, player);
                    } else {
                        try {
                            Method m2 = extCls.getMethod("get", EntityPlayerMP.class);
                            extInst = m2.invoke(null, player);
                        }
                        catch (Throwable m2) {
                            // empty catch block
                        }
                    }
                    if (extInst == null) break block49;
                    try {
                        Method mset = null;
                        try {
                            mset = extInst.getClass().getMethod("setBdy", Integer.TYPE);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (mset == null) {
                            try {
                                mset = extInst.getClass().getMethod("setBody", Integer.TYPE);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (mset == null) {
                            try {
                                mset = extInst.getClass().getMethod("setJrmcBdy", Integer.TYPE);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (mset != null) {
                            mset.invoke(extInst, newBody);
                            wrote = true;
                        } else {
                            try {
                                Method setIntMethod = extInst.getClass().getMethod("setInt", Integer.TYPE, String.class);
                                setIntMethod.invoke(extInst, newBody, "jrmcBdy");
                                wrote = true;
                            }
                            catch (Throwable setIntMethod) {
                                // empty catch block
                            }
                        }
                        if (wrote) break block49;
                        try {
                            Field f = extInst.getClass().getDeclaredField("bdy");
                            f.setAccessible(true);
                            f.setInt(extInst, newBody);
                            wrote = true;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable extCls) {
                    // empty catch block
                }
            }
        }
        try {
            NBTTagCompound nbt = player.getEntityData();
            if (nbt != null) {
                nbt.func_74768_a("jrmcBdy", newBody);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.lastBodyMap.put(puid, newBody);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void tryTriggerJRMCoreSync(Class<?> jrmClass, EntityPlayerMP player) {
        if (jrmClass == null || player == null) {
            return;
        }
        try {
            for (Method mm : jrmClass.getMethods()) {
                String n = mm.getName().toLowerCase();
                if (!n.contains("sync") && !n.contains("send") && !n.contains("update") && !n.contains("nbt")) continue;
                Class<?>[] ps = mm.getParameterTypes();
                try {
                    if (ps.length == 1 && ps[0].isAssignableFrom(player.getClass())) {
                        mm.invoke(null, player);
                        return;
                    }
                    if (ps.length == 0) {
                        mm.invoke(null, new Object[0]);
                        return;
                    }
                    if (ps.length != 2 || !ps[0].isAssignableFrom(player.getClass())) continue;
                    try {
                        mm.invoke(null, player, "jrmcBdy");
                        return;
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private int readPlayerMaxBody(EntityPlayerMP player) {
        Class<?> cls2;
        if (player == null) {
            return 0;
        }
        String[] classNames = new String[]{"JinRyuu.JRMCore.JRMCoreH", "JRMCoreH"};
        String[] maxFieldNames = new String[]{"maxBody", "maxbody", "maxBdy", "max_bdy", "maxBodyVal"};
        for (String clsName : classNames) {
            try {
                cls2 = Class.forName(clsName);
                for (String fld : maxFieldNames) {
                    try {
                        Field f = cls2.getField(fld);
                        f.setAccessible(true);
                        Object v = f.get(null);
                        if (!(v instanceof Number)) continue;
                        return ((Number)v).intValue();
                    }
                    catch (NoSuchFieldException f) {
                    }
                    catch (Throwable f) {
                        // empty catch block
                    }
                }
            }
            catch (ClassNotFoundException cls2) {
            }
            catch (Throwable cls2) {
                // empty catch block
            }
        }
        for (String clsName : classNames) {
            try {
                Field f2;
                cls2 = Class.forName(clsName);
                Method statMethod = null;
                for (Method m : cls2.getDeclaredMethods()) {
                    if (!m.getName().equals("stat") || m.getParameterTypes().length < 7) continue;
                    statMethod = m;
                    break;
                }
                Object pwrObj = null;
                Object raceObj = null;
                Object clsObj = null;
                Object plyrArrObj = null;
                try {
                    f2 = cls2.getField("Pwrtyp");
                    f2.setAccessible(true);
                    pwrObj = f2.get(null);
                }
                catch (Throwable f2) {
                    // empty catch block
                }
                try {
                    f2 = cls2.getField("Race");
                    f2.setAccessible(true);
                    raceObj = f2.get(null);
                }
                catch (Throwable f3) {
                    // empty catch block
                }
                try {
                    f2 = cls2.getField("Class");
                    f2.setAccessible(true);
                    clsObj = f2.get(null);
                }
                catch (Throwable f4) {
                    // empty catch block
                }
                try {
                    f2 = cls2.getField("PlyrAttrbts");
                    f2.setAccessible(true);
                    plyrArrObj = f2.get(null);
                }
                catch (Throwable f5) {
                    // empty catch block
                }
                int pwr = 0;
                int rce = 0;
                int clsv = 0;
                int plyrAttr2 = 0;
                try {
                    if (pwrObj instanceof Number) {
                        pwr = ((Number)pwrObj).intValue();
                    } else if (pwrObj instanceof Character) {
                        pwr = ((Character)pwrObj).charValue();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (raceObj instanceof Number) {
                        rce = ((Number)raceObj).intValue();
                    } else if (raceObj instanceof Character) {
                        rce = ((Character)raceObj).charValue();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (clsObj instanceof Number) {
                        clsv = ((Number)clsObj).intValue();
                    } else if (clsObj instanceof Character) {
                        clsv = ((Character)clsObj).charValue();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    Object o;
                    if (plyrArrObj instanceof int[]) {
                        plyrAttr2 = ((int[])plyrArrObj)[2];
                    } else if (plyrArrObj instanceof byte[]) {
                        plyrAttr2 = ((byte[])plyrArrObj)[2];
                    } else if (plyrArrObj instanceof short[]) {
                        plyrAttr2 = ((short[])plyrArrObj)[2];
                    } else if (plyrArrObj instanceof Object[] && (o = ((Object[])plyrArrObj)[2]) instanceof Number) {
                        plyrAttr2 = ((Number)o).intValue();
                    }
                }
                catch (Throwable o) {
                    // empty catch block
                }
                if (statMethod == null) continue;
                try {
                    Object[][] attempts;
                    statMethod.setAccessible(true);
                    Object result = null;
                    for (Object[] args : attempts = new Object[][]{{player, 2, (byte)pwr, 2, plyrAttr2, (byte)rce, (byte)clsv, 0.0}, {player, 2, pwr, 2, plyrAttr2, rce, clsv, 0.0}, {player, 2, (byte)pwr, 2, plyrAttr2, (byte)rce, (byte)clsv, Float.valueOf(0.0f)}}) {
                        try {
                            result = statMethod.invoke(null, args);
                            if (!(result instanceof Number)) continue;
                            return ((Number)result).intValue();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String[] possibleKeys = new String[]{"jrmcMaxBdy", "jrmcBdyMax", "jrmcMax", "jrmcHPMAX", "jrmcMaxHP", "maxbdy", "maxbody", "maxhp", "maxhpval", "max_health", "maxhealth", "maxBody", "jrmcMaxBody"};
        try {
            NBTTagCompound nbt = player.getEntityData();
            if (nbt != null) {
                for (String key : possibleKeys) {
                    try {
                        String upper;
                        String lower;
                        if (nbt.func_74764_b(key)) {
                            try {
                                return nbt.func_74762_e(key);
                            }
                            catch (Throwable t1) {
                                try {
                                    return (int)nbt.func_74769_h(key);
                                }
                                catch (Throwable raceObj) {
                                    // empty catch block
                                }
                            }
                        }
                        if (!(lower = key.toLowerCase()).equals(key) && nbt.func_74764_b(lower)) {
                            try {
                                return nbt.func_74762_e(lower);
                            }
                            catch (Throwable t1) {
                                try {
                                    return (int)nbt.func_74769_h(lower);
                                }
                                catch (Throwable clsObj) {
                                    // empty catch block
                                }
                            }
                        }
                        if ((upper = key.toUpperCase()).equals(key) || !nbt.func_74764_b(upper)) continue;
                        try {
                            return nbt.func_74762_e(upper);
                        }
                        catch (Throwable t1) {
                            try {
                                return (int)nbt.func_74769_h(upper);
                            }
                            catch (Throwable throwable) {
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            return Math.max(1, Math.round(player.func_110138_aP()));
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private double computeSlowPercent(ServerEffectInstance inst) {
        int step;
        int total = Math.max(1, inst.totalTicks);
        int elapsed = total - inst.remainingTicks;
        double frac = Math.min(1.0, Math.max(0.0, (double)elapsed / (double)total));
        int steps = 5;
        int amp = Math.max(0, inst.amplifier);
        double maxPercent = (double)amp * 0.1;
        double MAX_SLOW_FRACTION = 1.0;
        if (maxPercent > 1.0) {
            maxPercent = 1.0;
        }
        if (frac >= 1.0) {
            step = 4;
        } else {
            step = (int)Math.floor(frac / 0.15);
            if (step < 0) {
                step = 0;
            }
            if (step > 3) {
                step = 3;
            }
        }
        double curPercent = (double)step / 4.0 * maxPercent;
        if (curPercent < 0.0) {
            curPercent = 0.0;
        }
        if (curPercent > 1.0) {
            curPercent = 1.0;
        }
        return curPercent;
    }

    private boolean trySendStopSprintingPacket(EntityPlayerMP player) {
        try {
            Constructor<?>[] ctors;
            Object stopAction;
            Class<?> actionEnum;
            Class<?> pktClass;
            block27: {
                String pktClassName = "net.minecraft.network.play.server.S0BPacketEntityAction";
                try {
                    pktClass = Class.forName(pktClassName);
                }
                catch (Throwable e) {
                    pktClass = null;
                }
                if (pktClass == null) {
                    return false;
                }
                actionEnum = null;
                try {
                    actionEnum = Class.forName(pktClassName + "$Action");
                }
                catch (Throwable ee) {
                    for (Class<?> inner : pktClass.getDeclaredClasses()) {
                        if (!inner.isEnum()) continue;
                        actionEnum = inner;
                        break;
                    }
                }
                stopAction = null;
                if (actionEnum != null) {
                    try {
                        Field stopField = actionEnum.getDeclaredField("STOP_SPRINTING");
                        stopField.setAccessible(true);
                        stopAction = stopField.get(null);
                    }
                    catch (Throwable ignored) {
                        try {
                            ?[] constants = actionEnum.getEnumConstants();
                            if (constants == null) break block27;
                            for (Object c : constants) {
                                String nm = c.toString().toLowerCase();
                                if (!nm.contains("stop") || !nm.contains("sprint")) continue;
                                stopAction = c;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            for (Constructor<?> ctor : ctors = pktClass.getDeclaredConstructors()) {
                try {
                    ctor.setAccessible(true);
                    Class<?>[] params = ctor.getParameterTypes();
                    Object pkt = null;
                    if (params.length == 2 && actionEnum != null && params[0].isAssignableFrom(player.getClass()) && params[1].isAssignableFrom(actionEnum) && stopAction != null) {
                        pkt = ctor.newInstance(player, stopAction);
                    } else if (params.length == 2 && params[0] == Integer.TYPE && params[1].isAssignableFrom(actionEnum) && stopAction != null) {
                        pkt = ctor.newInstance(player.func_145782_y(), stopAction);
                    } else {
                        if (params.length != 1 || !params[0].isAssignableFrom(actionEnum) || stopAction == null) continue;
                        pkt = ctor.newInstance(stopAction);
                    }
                    if (pkt == null) continue;
                    try {
                        Method sendPacket = player.field_71135_a.getClass().getMethod("sendPacket", Class.forName("net.minecraft.network.Packet"));
                        sendPacket.invoke((Object)player.field_71135_a, pkt);
                    }
                    catch (NoSuchMethodException nsf) {
                        try {
                            Method[] methods;
                            for (Method mm : methods = player.field_71135_a.getClass().getMethods()) {
                                if (!mm.getName().equals("sendPacket") || mm.getParameterTypes().length != 1) continue;
                                mm.invoke((Object)player.field_71135_a, pkt);
                            }
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private void sendShieldUpdate(UUID puid, EntityPlayerMP player) {
        if (player == null) {
            return;
        }
        try {
            int now = 0;
            try {
                Integer n = this.lifeShieldMap.get(puid);
                if (n != null) {
                    now = n;
                }
            }
            catch (Throwable n) {
                // empty catch block
            }
            int max = 0;
            try {
                max = this.readPlayerMaxBody(player);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (NetworkHandler.INSTANCE != null) {
                try {
                    NetworkHandler.INSTANCE.sendTo((IMessage)new PacketShieldUpdate(now, max), player);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueuePendingLifeSteal(UUID puid, float eventDamage) {
        if (puid == null) {
            return;
        }
        Map<UUID, Long> map = this.pendingLifeStealTs;
        synchronized (map) {
            this.pendingLifeStealTs.put(puid, System.currentTimeMillis());
            this.pendingLifeStealEventDamage.put(puid, Float.valueOf(eventDamage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPendingLifeStealForPlayer(EntityPlayerMP player) {
        Float fallback;
        Long ts;
        if (player == null) {
            return;
        }
        UUID puid = player.func_110124_au();
        Map<UUID, Long> map = this.pendingLifeStealTs;
        synchronized (map) {
            ts = this.pendingLifeStealTs.get(puid);
            fallback = this.pendingLifeStealEventDamage.get(puid);
        }
        if (ts == null) {
            return;
        }
        float dbcDamage = 0.0f;
        try {
            dbcDamage = this.readLastDamageDealtFromDBC(player);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        long age = System.currentTimeMillis() - ts;
        if (dbcDamage <= 0.0f && age >= 2000L && fallback != null && fallback.floatValue() > 0.0f) {
            dbcDamage = fallback.floatValue();
        }
        if (dbcDamage > 0.0f) {
            try {
                this.applyLifeStealFromDamage(player, dbcDamage);
            }
            catch (Throwable throwable) {
                Map<UUID, Long> map2 = this.pendingLifeStealTs;
                synchronized (map2) {
                    this.pendingLifeStealTs.remove(puid);
                    this.pendingLifeStealEventDamage.remove(puid);
                }
            }
            finally {
                Map<UUID, Long> map3 = this.pendingLifeStealTs;
                synchronized (map3) {
                    this.pendingLifeStealTs.remove(puid);
                    this.pendingLifeStealEventDamage.remove(puid);
                }
            }
        } else if (age > 10000L) {
            Map<UUID, Long> map4 = this.pendingLifeStealTs;
            synchronized (map4) {
                this.pendingLifeStealTs.remove(puid);
                this.pendingLifeStealEventDamage.remove(puid);
            }
        }
    }

    public float readLastDamageDealtFromDBC(EntityPlayerMP player) {
        block65: {
            if (player == null) {
                return 0.0f;
            }
            String[] classNames = new String[]{"JinRyuu.JRMCore.JRMCoreH", "JRMCoreH"};
            String[] candidateKeys = new String[]{"jrmcLastDamageDealt", "jrmcLastDamage", "jrmcLastHitDamage", "jrmcLastDamageDealtInt", "lastDamageDealt", "jrmcLastDmg", "jrmcLast", "lastDamage"};
            for (String clsName : classNames) {
                try {
                    Method[] methods;
                    Class<?> cls = Class.forName(clsName);
                    for (Method m : methods = cls.getMethods()) {
                        String mname = m.getName().toLowerCase();
                        if (!mname.contains("getint") && !mname.contains("getfloat") && !mname.contains("getdouble") && !mname.equals("get")) continue;
                        Class<?>[] params = m.getParameterTypes();
                        for (String key : candidateKeys) {
                            try {
                                Object v = null;
                                if (params.length == 2 && params[0].isAssignableFrom(player.getClass()) && params[1] == String.class) {
                                    v = m.invoke(null, player, key);
                                } else if (params.length == 2 && params[0] == String.class && params[1].isAssignableFrom(player.getClass())) {
                                    v = m.invoke(null, key, player);
                                } else if (params.length == 1 && params[0].isAssignableFrom(player.getClass())) {
                                    v = m.invoke(null, player);
                                } else if (params.length == 1 && params[0] == String.class) {
                                    v = m.invoke(null, key);
                                } else if (params.length == 0) {
                                    v = m.invoke(null, new Object[0]);
                                }
                                if (!(v instanceof Number)) continue;
                                return ((Number)v).floatValue();
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    try {
                        Method nbtMethod = cls.getMethod("nbt", Entity.class);
                        Object nbt2 = nbtMethod.invoke(null, player);
                        if (nbt2 == null) continue;
                        Class<?> nbtCls = nbt2.getClass();
                        for (String key : candidateKeys) {
                            try {
                                Method getInt = nbtCls.getMethod("getInteger", String.class);
                                Object val = getInt.invoke(nbt2, key);
                                if (val instanceof Number) {
                                    return ((Number)val).floatValue();
                                }
                            }
                            catch (Throwable getInt) {
                                // empty catch block
                            }
                            try {
                                Method getD = nbtCls.getMethod("getDouble", String.class);
                                Object val2 = getD.invoke(nbt2, key);
                                if (val2 instanceof Number) {
                                    return ((Number)val2).floatValue();
                                }
                            }
                            catch (Throwable getD) {
                                // empty catch block
                            }
                            try {
                                Method getF = nbtCls.getMethod("getFloat", String.class);
                                Object val3 = getF.invoke(nbt2, key);
                                if (!(val3 instanceof Number)) continue;
                                return ((Number)val3).floatValue();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Throwable nbtMethod) {
                    }
                }
                catch (ClassNotFoundException cls) {
                }
                catch (Throwable cls) {
                    // empty catch block
                }
            }
            try {
                NBTTagCompound nbt = player.getEntityData();
                if (nbt != null) {
                    for (String k : candidateKeys) {
                        try {
                            String upper;
                            String lower;
                            if (nbt.func_74764_b(k)) {
                                try {
                                    return nbt.func_74762_e(k);
                                }
                                catch (Throwable ex) {
                                    try {
                                        return (float)nbt.func_74769_h(k);
                                    }
                                    catch (Throwable nbtMethod) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (!(lower = k.toLowerCase()).equals(k) && nbt.func_74764_b(lower)) {
                                try {
                                    return nbt.func_74762_e(lower);
                                }
                                catch (Throwable ex) {
                                    try {
                                        return (float)nbt.func_74769_h(lower);
                                    }
                                    catch (Throwable nbt2) {
                                        // empty catch block
                                    }
                                }
                            }
                            if ((upper = k.toUpperCase()).equals(k) || !nbt.func_74764_b(upper)) continue;
                            try {
                                return nbt.func_74762_e(upper);
                            }
                            catch (Throwable ex) {
                                try {
                                    return (float)nbt.func_74769_h(upper);
                                }
                                catch (Throwable throwable) {
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Throwable nbt) {
                // empty catch block
            }
            try {
                Class<?> extCls = null;
                try {
                    extCls = Class.forName("ExtendedPlayer");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (extCls == null) {
                    try {
                        extCls = Class.forName("JinRyuu.JRMCore.ExtendedPlayer");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (extCls == null) break block65;
                try {
                    Method getM = extCls.getMethod("get", EntityPlayer.class);
                    Object extInst = getM.invoke(null, player);
                    if (extInst == null) break block65;
                    try {
                        Method mLast = extInst.getClass().getMethod("getLastDamageDealt", new Class[0]);
                        Object v = mLast.invoke(extInst, new Object[0]);
                        if (v instanceof Number) {
                            return ((Number)v).floatValue();
                        }
                    }
                    catch (Throwable mLast) {
                        // empty catch block
                    }
                    try {
                        Field f = extInst.getClass().getDeclaredField("lastDamageDealt");
                        f.setAccessible(true);
                        Object v2 = f.get(extInst);
                        if (v2 instanceof Number) {
                            return ((Number)v2).floatValue();
                        }
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public float readAnyLastDamageCandidates(Entity ent) {
        block43: {
            if (ent == null) {
                return 0.0f;
            }
            try {
                if (ent instanceof EntityPlayerMP) {
                    try {
                        return this.readLastDamageDealtFromDBC((EntityPlayerMP)ent);
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String[] fieldNames = new String[]{"lastDamageDealt", "lastDamage", "jrmcLastDamageDealt", "lastDamageDealtInt", "lastDmg", "damage", "dmg"};
            String[] methodNames = new String[]{"getLastDamageDealt", "getLastDamage", "getDamage", "getDamageAmount", "getDmg"};
            try {
                String[] cls = ent.getClass();
                String[] stringArray = fieldNames;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String fn = stringArray[i];
                    try {
                        Field f = null;
                        Object walker = cls;
                        while (walker != null && f == null) {
                            try {
                                f = walker.getDeclaredField(fn);
                            }
                            catch (Throwable ignoreF) {
                                walker = walker.getSuperclass();
                            }
                        }
                        if (f == null) continue;
                        f.setAccessible(true);
                        Object v = f.get(ent);
                        if (!(v instanceof Number)) continue;
                        return ((Number)v).floatValue();
                    }
                    catch (Throwable f) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable cls) {
                // empty catch block
            }
            try {
                for (String mn : methodNames) {
                    try {
                        Object ret;
                        Method m = ent.getClass().getMethod(mn, new Class[0]);
                        if (m == null || !((ret = m.invoke((Object)ent, new Object[0])) instanceof Number)) continue;
                        return ((Number)ret).floatValue();
                    }
                    catch (Throwable m) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable cls) {
                // empty catch block
            }
            try {
                NBTTagCompound nbt = ent.getEntityData();
                if (nbt == null) break block43;
                for (String k : fieldNames) {
                    try {
                        String lower;
                        if (nbt.func_74764_b(k)) {
                            try {
                                return nbt.func_74762_e(k);
                            }
                            catch (Throwable ex) {
                                try {
                                    return (float)nbt.func_74769_h(k);
                                }
                                catch (Throwable walker) {
                                    // empty catch block
                                }
                            }
                        }
                        if ((lower = k.toLowerCase()).equals(k) || !nbt.func_74764_b(lower)) continue;
                        try {
                            return nbt.func_74762_e(lower);
                        }
                        catch (Throwable ex) {
                            try {
                                return (float)nbt.func_74769_h(lower);
                            }
                            catch (Throwable throwable) {
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    if (nbt.func_74764_b("damage")) {
                        try {
                            return nbt.func_74762_e("damage");
                        }
                        catch (Throwable ex) {
                            try {
                                return (float)nbt.func_74769_h("damage");
                            }
                            catch (Throwable throwable) {
                            }
                        }
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable nbt) {
                // empty catch block
            }
        }
        try {
            float pd = this.readDamageFromProjectile(ent);
            if (pd > 0.0f) {
                return pd;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0.0f;
    }

    private EntityPlayerMP getPlayerByUUID(UUID puid) {
        try {
            MinecraftServer srv = MinecraftServer.func_71276_C();
            if (srv == null) {
                return null;
            }
            List players = srv.func_71203_ab().field_72404_b;
            if (players == null) {
                return null;
            }
            for (Object o : players) {
                EntityPlayerMP p;
                if (!(o instanceof EntityPlayerMP) || (p = (EntityPlayerMP)o).func_110124_au() == null || !p.func_110124_au().equals(puid)) continue;
                return p;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public float readDamageFromProjectile(Entity proj) {
        if (proj == null) {
            return 0.0f;
        }
        try {
            try {
                Field f = proj.getClass().getDeclaredField("damage");
                f.setAccessible(true);
                Object v = f.get(proj);
                if (v instanceof Number) {
                    return ((Number)v).floatValue();
                }
            }
            catch (NoSuchFieldException nsf) {
                Field f2 = null;
                try {
                    f2 = proj.getClass().getDeclaredField("dmg");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (f2 != null) {
                    f2.setAccessible(true);
                    Object v2 = f2.get(proj);
                    if (v2 instanceof Number) {
                        return ((Number)v2).floatValue();
                    }
                }
            }
        }
        catch (Throwable nsf) {
            // empty catch block
        }
        try {
            String[] meths;
            for (String mn : meths = new String[]{"getDamage", "getDamageAmount", "getDmg"}) {
                try {
                    Method mm = proj.getClass().getMethod(mn, new Class[0]);
                    Object o = mm.invoke((Object)proj, new Object[0]);
                    if (!(o instanceof Number)) continue;
                    return ((Number)o).floatValue();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0.0f;
    }

    private void startLifeStealState(EntityPlayerMP player) {
        long newGen;
        if (player == null) {
            return;
        }
        UUID puid = player.func_110124_au();
        LifeStealState s = this.lifeStealStates.get(puid);
        if (s == null) {
            s = new LifeStealState();
            this.lifeStealStates.put(puid, s);
        }
        s.generation = newGen = s.generation + 1L;
        s.active = true;
        s.startTs = System.currentTimeMillis();
        s.endTs = 0L;
        s.healedIds.clear();
        s.damageQueue.clear();
    }

    private void endLifeStealState(EntityPlayerMP player) {
        if (player == null) {
            return;
        }
        UUID puid = player.func_110124_au();
        LifeStealState s = this.lifeStealStates.get(puid);
        if (s == null) {
            return;
        }
        if (!s.active) {
            return;
        }
        s.active = false;
        s.endTs = System.currentTimeMillis();
    }

    private void removeLifeStealStateFully(UUID puid) {
        if (puid == null) {
            return;
        }
        this.lifeStealStates.remove(puid);
    }

    private void markDamageHealed(UUID puid, int damageId, float dmg, EntityPlayerMP player) {
        if (puid == null) {
            return;
        }
        LifeStealState s = this.lifeStealStates.get(puid);
        if (s == null) {
            s = new LifeStealState();
            this.lifeStealStates.put(puid, s);
        }
        s.healedIds.add(damageId);
    }

    private boolean wasDamageHealed(UUID puid, int damageId) {
        if (puid == null) {
            return false;
        }
        LifeStealState s = this.lifeStealStates.get(puid);
        if (s == null) {
            return false;
        }
        return s.healedIds.contains(damageId);
    }

    public void applyLifeStealFromDamage(EntityPlayerMP player, float dbcDamage) {
        if (player == null) {
            return;
        }
        if (dbcDamage <= 0.0f) {
            return;
        }
        UUID puid = player.func_110124_au();
        long now = System.currentTimeMillis();
        try {
            Float lastD = this.lastProcessedDbcDamage.get(puid);
            Long lastT = this.lastProcessedDbcTime.get(puid);
            if (lastD != null && lastT != null && (double)Math.abs(lastD.floatValue() - dbcDamage) <= 0.5 && now - lastT < 600L) {
                return;
            }
        }
        catch (Throwable lastD) {
            // empty catch block
        }
        Long lastApplied = this.lastLifeStealAppliedAt.get(puid);
        if (lastApplied != null && now - lastApplied < 50L) {
            this.lastProcessedDbcDamage.put(puid, Float.valueOf(dbcDamage));
            this.lastProcessedDbcTime.put(puid, now);
            return;
        }
        try {
            int healAmount;
            LifeStealState s = this.lifeStealStates.get(puid);
            if (s == null || !s.active) {
                this.lastProcessedDbcDamage.put(puid, Float.valueOf(dbcDamage));
                this.lastProcessedDbcTime.put(puid, now);
                return;
            }
            float frac = this.getLifeStealFraction(player);
            if (frac <= 0.0f) {
                this.lastProcessedDbcDamage.put(puid, Float.valueOf(dbcDamage));
                this.lastProcessedDbcTime.put(puid, now);
                return;
            }
            int dmgUnits = Math.max(0, Math.round(dbcDamage));
            if (dmgUnits <= 0) {
                this.lastProcessedDbcDamage.put(puid, Float.valueOf(dbcDamage));
                this.lastProcessedDbcTime.put(puid, now);
                return;
            }
            int toHeal = Math.max(0, Math.round((float)dmgUnits * frac));
            if (toHeal <= 0) {
                this.lastProcessedDbcDamage.put(puid, Float.valueOf(dbcDamage));
                this.lastProcessedDbcTime.put(puid, now);
                return;
            }
            int damageId = this.nextDamageId();
            if (this.wasDamageHealed(puid, damageId)) {
                this.lastProcessedDbcDamage.put(puid, Float.valueOf(dbcDamage));
                this.lastProcessedDbcTime.put(puid, now);
                return;
            }
            int curBody = this.readPlayerBody(player);
            int maxBody = this.readPlayerMaxBody(player);
            if (maxBody > 0) {
                int space = Math.max(0, maxBody - curBody);
                healAmount = Math.min(toHeal, space);
            } else {
                healAmount = toHeal;
            }
            if (healAmount <= 0) {
                this.lastProcessedDbcDamage.put(puid, Float.valueOf(dbcDamage));
                this.lastProcessedDbcTime.put(puid, now);
                this.lastLifeStealAppliedAt.put(puid, now);
                this.markDamageHealed(puid, damageId, dbcDamage, player);
                return;
            }
            int newBody = curBody + healAmount;
            this.writePlayerBodyToJinRyuu(player, newBody);
            try {
                this.lastBodyMap.put(puid, newBody);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.lastProcessedDbcDamage.put(puid, Float.valueOf(dbcDamage));
            this.lastProcessedDbcTime.put(puid, now);
            this.lastLifeStealAppliedAt.put(puid, now);
            this.markDamageHealed(puid, damageId, dbcDamage, player);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void cleanupModifierIfNoEffects(EntityPlayerMP player, UUID puid) {
        try {
            UUID modUUID;
            AttributeModifier existing;
            IAttributeInstance attr = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (attr != null && (existing = attr.func_111127_a(modUUID = this.getPlayerSlowUUID(puid))) != null) {
                try {
                    attr.func_111124_b(existing);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable attr) {
            // empty catch block
        }
        try {
            if (this.savedAllowFlying.containsKey(puid)) {
                boolean prevAllow = this.savedAllowFlying.remove(puid);
                boolean prevIsFlying = this.savedIsFlying.remove(puid);
                player.field_71075_bZ.field_75101_c = prevAllow;
                player.field_71075_bZ.field_75100_b = prevIsFlying;
                try {
                    player.field_71135_a.func_147359_a((Packet)new S39PacketPlayerAbilities(player.field_71075_bZ));
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable prevAllow) {
            // empty catch block
        }
        try {
            if (this.savedSprinting.containsKey(puid)) {
                boolean prevSprint = this.savedSprinting.remove(puid);
                player.func_70031_b(prevSprint);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.lifeShieldMap.remove(puid);
            this.sendShieldUpdate(puid, player);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.pendingLifeStealTs.remove(puid);
            this.pendingLifeStealEventDamage.remove(puid);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.lastLifeStealAppliedAt.remove(puid);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.endLifeStealState(player);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.byPlayer.remove(puid);
    }

    public void clearPlayer(EntityPlayerMP player) {
        if (player == null) {
            return;
        }
        UUID puid = player.func_110124_au();
        List<ServerEffectInstance> list = this.byPlayer.remove(puid);
        try {
            UUID modUUID;
            AttributeModifier existing;
            IAttributeInstance attr = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (attr != null && (existing = attr.func_111127_a(modUUID = this.getPlayerSlowUUID(puid))) != null) {
                try {
                    attr.func_111124_b(existing);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable attr) {
            // empty catch block
        }
        try {
            if (this.savedAllowFlying.containsKey(puid)) {
                boolean prevAllow = this.savedAllowFlying.remove(puid);
                boolean prevIsFlying = this.savedIsFlying.remove(puid);
                player.field_71075_bZ.field_75101_c = prevAllow;
                player.field_71075_bZ.field_75100_b = prevIsFlying;
                try {
                    player.field_71135_a.func_147359_a((Packet)new S39PacketPlayerAbilities(player.field_71075_bZ));
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable prevAllow) {
            // empty catch block
        }
        try {
            if (this.savedSprinting.containsKey(puid)) {
                boolean prevSprint = this.savedSprinting.remove(puid);
                player.func_70031_b(prevSprint);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.lastBodyMap.remove(puid);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.lifeShieldMap.remove(puid);
            this.sendShieldUpdate(puid, player);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.pendingLifeStealTs.remove(puid);
            this.pendingLifeStealEventDamage.remove(puid);
            this.lastLifeStealAppliedAt.remove(puid);
            this.lastProcessedDbcDamage.remove(puid);
            this.lastProcessedDbcTime.remove(puid);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.removeLifeStealStateFully(puid);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class DamageRecord {
        public final int id;
        public final float damage;
        public final long ts;
        public final long generation;
        public volatile boolean healed = false;

        public DamageRecord(int id, float damage, long ts, long generation) {
            this.id = id;
            this.damage = damage;
            this.ts = ts;
            this.generation = generation;
        }
    }

    private static class LifeStealState {
        public volatile boolean active = false;
        public volatile long startTs = 0L;
        public volatile long endTs = 0L;
        public volatile long generation = 0L;
        public final Set<Integer> healedIds = Collections.newSetFromMap(new ConcurrentHashMap());
        public final ConcurrentLinkedQueue<DamageRecord> damageQueue = new ConcurrentLinkedQueue();

        private LifeStealState() {
        }
    }

    private static class ServerEffectInstance {
        public final RNEffectType type;
        public final int totalTicks;
        public int remainingTicks;
        public final int amplifier;

        public ServerEffectInstance(RNEffectType type, int totalTicks, int amplifier) {
            this.type = type;
            this.totalTicks = totalTicks;
            this.remainingTicks = totalTicks;
            this.amplifier = amplifier;
        }
    }
}

