/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client.shader;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import kamkeel.npcdbc.CommonProxy;
import kamkeel.npcdbc.client.ClientConstants;
import kamkeel.npcdbc.client.gui.hud.formWheel.HUDFormWheel;
import kamkeel.npcdbc.client.shader.ShaderHelper;
import kamkeel.npcdbc.config.ConfigDBCClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

@SideOnly(value=Side.CLIENT)
public class PostProcessing {
    public static Framebuffer MAIN;
    public static int MAIN_BLOOM_BUFFER;
    public static int MAIN_BLOOM_TEXTURE;
    public static int DEPTH_TEXTURE;
    public static int MISC_POST_PROCESSING_BUFFER;
    public static int BLUR_TEXTURE;
    public static int blankTexture;
    public static int BLOOM_BUFFERS_LENGTH;
    public static int[] bloomBuffers;
    public static int[] bloomTextures;
    public static int[] bloomTextures2;
    public static int auraBuffer;
    public static int[] auraTextures;
    public static boolean processBloom;
    public static FloatBuffer DEFAULT_MODELVIEW;
    public static FloatBuffer DEFAULT_PROJECTION;
    public static Minecraft mc;
    public static int PREVIOUS_BUFFER;
    public static int VIEWPORT_WIDTH;
    public static int VIEWPORT_HEIGHT;
    public static boolean hasInitialized;
    private static boolean isScissorEnabled;

    public static void startBlooming(boolean clearBloomBuffer) {
        if (!ConfigDBCClient.EnableBloom || !ShaderHelper.shadersEnabled()) {
            return;
        }
        PREVIOUS_BUFFER = GL11.glGetInteger((int)36006);
        GL30.glBindFramebuffer((int)36160, (int)MAIN_BLOOM_BUFFER);
        if (clearBloomBuffer) {
            PostProcessing.drawToBuffers(2);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glClear((int)16384);
        }
        PostProcessing.drawToBuffers(0, 2);
        processBloom = true;
    }

    public static void endBlooming() {
        if (processBloom) {
            GL30.glBindFramebuffer((int)36160, (int)PREVIOUS_BUFFER);
        }
    }

    public static void postProcess() {
        PostProcessing.bloom(1.5f, false);
        if (ShaderHelper.shadersEnabled() && PostProcessing.mc.field_71462_r instanceof HUDFormWheel && HUDFormWheel.BLUR_ENABLED) {
            Framebuffer buff = PostProcessing.getMainBuffer();
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)PostProcessing.mc.field_71443_c, (double)PostProcessing.mc.field_71440_d, (double)0.0, (double)0.0, (double)1.0);
            GL30.glBindFramebuffer((int)36160, (int)MISC_POST_PROCESSING_BUFFER);
            PostProcessing.drawToBuffers(0);
            PostProcessing.disableGLState();
            PostProcessing.blurVertical(buff.field_147617_g, HUDFormWheel.BLUR_INTENSITY, 0.0f, 0.0f, PostProcessing.mc.field_71443_c, PostProcessing.mc.field_71440_d);
            buff.func_147610_a(false);
            PostProcessing.disableGLState();
            PostProcessing.blurHorizontal(BLUR_TEXTURE, HUDFormWheel.BLUR_INTENSITY, 0.0f, 0.0f, PostProcessing.mc.field_71443_c, PostProcessing.mc.field_71440_d);
            ShaderHelper.releaseShader();
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2903);
        }
        if (isScissorEnabled) {
            GL11.glEnable((int)3089);
        }
    }

    public static void bloom(float lightExposure, boolean resetGLState) {
        int i;
        isScissorEnabled = GL11.glIsEnabled((int)3089);
        GL11.glDisable((int)3089);
        if (!processBloom) {
            return;
        }
        PostProcessing.updateViewportDimensions();
        int width = VIEWPORT_WIDTH;
        int height = VIEWPORT_HEIGHT;
        FloatBuffer prevModelView = ShaderHelper.getModelView();
        FloatBuffer prevProjection = ShaderHelper.getProjection();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)width, (double)height, (double)0.0, (double)0.0, (double)1.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2903);
        PostProcessing.mc.field_71460_t.func_78483_a(0.0);
        IntBuffer drawBuffers = BufferUtils.createIntBuffer((int)15);
        if (resetGLState && !ClientConstants.renderingGUI && !ClientConstants.renderingArm) {
            GL11.glDisable((int)2912);
        }
        GL30.glBindFramebuffer((int)36160, (int)bloomBuffers[0]);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16384);
        GL11.glViewport((int)0, (int)0, (int)(width >> 1), (int)(height >> 1));
        ShaderHelper.useShader(ShaderHelper.downsample13);
        PostProcessing.renderQuad(MAIN_BLOOM_TEXTURE, 0.0f, 0.0f, width, height);
        PostProcessing.blurFilter(bloomTextures[0], 2.5f, 0.0f, 0.0f, width, height);
        int downSamples = 0;
        for (i = 0; i < bloomBuffers.length; ++i) {
            if (bloomBuffers[i] <= 0 || i + 1 >= bloomBuffers.length) continue;
            int mipWidth = width >> i + 2;
            int mipHeight = height >> i + 2;
            GL30.glBindFramebuffer((int)36160, (int)bloomBuffers[i + 1]);
            GL11.glViewport((int)0, (int)0, (int)mipWidth, (int)mipHeight);
            ShaderHelper.useShader(ShaderHelper.downsample13);
            PostProcessing.renderQuad(bloomTextures[i], 0.0f, 0.0f, width, height);
            downSamples = i + 1;
        }
        for (i = downSamples; i > 0; --i) {
            int lower = bloomTextures[i];
            int mipWidth = width >> i;
            int mipHeight = height >> i;
            GL30.glBindFramebuffer((int)36160, (int)bloomBuffers[i - 1]);
            PostProcessing.drawToBuffers(2);
            GL11.glViewport((int)0, (int)0, (int)mipWidth, (int)mipHeight);
            PostProcessing.blurFilter(lower, 1.0f, 0.0f, 0.0f, width, height);
            PostProcessing.resetDrawBuffer();
            int lowerUpscaled = bloomTextures2[i - 1];
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)1);
            PostProcessing.renderQuad(lowerUpscaled, 0.0f, 0.0f, width, height);
            GL11.glDisable((int)3042);
        }
        MAIN.func_147610_a(false);
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        ShaderHelper.useShader(ShaderHelper.additiveCombine, () -> {
            ShaderHelper.uniformTexture("bloomTexture", 2, bloomTextures[0]);
            ShaderHelper.uniform1f("exposure", lightExposure);
        });
        PostProcessing.renderQuad(PostProcessing.MAIN.field_147617_g, 0.0f, 0.0f, width, height);
        ShaderHelper.releaseShader();
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2903);
        if (resetGLState) {
            PostProcessing.mc.field_71460_t.func_78463_b(0.0);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadMatrix((FloatBuffer)prevProjection);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadMatrix((FloatBuffer)prevModelView);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3008);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            if (!ClientConstants.renderingGUI && !ClientConstants.renderingArm) {
                GL11.glEnable((int)2912);
            }
        }
        GL30.glBindFramebuffer((int)36160, (int)MAIN_BLOOM_BUFFER);
        PostProcessing.drawToBuffers(2);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glClear((int)16384);
        MAIN.func_147610_a(false);
        processBloom = false;
    }

    public static void captureSceneDepth() {
        Framebuffer buff = PostProcessing.getMainBuffer();
        int width = PostProcessing.mc.field_71443_c;
        int height = PostProcessing.mc.field_71440_d;
        ByteBuffer depthBuff = BufferUtils.createByteBuffer((int)(width * height * 4));
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6402, (int)5126, (ByteBuffer)depthBuff);
        ByteBuffer rgbaBuffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        for (int i = 0; i < width * height; ++i) {
            float depth = depthBuff.getFloat(i * 4);
            float depth2 = depth == 1.0f ? 0.0f : 1.0f;
            rgbaBuffer.put((byte)(depth * 255.0f));
            rgbaBuffer.put((byte)(depth * 255.0f));
            rgbaBuffer.put((byte)(depth * 255.0f));
            rgbaBuffer.put((byte)(depth == 1.0f ? 0 : 255));
        }
        rgbaBuffer.flip();
        GL11.glBindTexture((int)3553, (int)DEPTH_TEXTURE);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)rgbaBuffer);
    }

    public static void disableGLState() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2903);
        PostProcessing.mc.field_71460_t.func_78483_a(0.0);
    }

    public static void enableGLState() {
        PostProcessing.mc.field_71460_t.func_78463_b(0.0);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2903);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static void blurVertical(int textureID, float blurIntensity, float startX, float startY, float width, float height) {
        ShaderHelper.useShader(ShaderHelper.blur, () -> {
            ShaderHelper.uniformVec2("u_resolution", width - startX, height - startY);
            ShaderHelper.uniform1i("horizontal", 0);
            ShaderHelper.uniform1f("blurIntensity", blurIntensity);
        });
        PostProcessing.renderQuad(textureID, startX, startY, width, height);
    }

    public static void blurHorizontal(int textureID, float blurIntensity, float startX, float startY, float width, float height) {
        ShaderHelper.useShader(ShaderHelper.blur, () -> {
            ShaderHelper.uniformVec2("u_resolution", width - startX, height - startY);
            ShaderHelper.uniform1i("horizontal", 1);
            ShaderHelper.uniform1f("blurIntensity", blurIntensity);
        });
        PostProcessing.renderQuad(textureID, startX, startY, width, height);
    }

    public static void blurFilter(int textureID, float blurIntensity, float startX, float startY, float width, float height) {
        PostProcessing.blurVertical(textureID, blurIntensity, startX, startY, width, height);
        PostProcessing.blurHorizontal(textureID, blurIntensity, startX, startY, width, height);
        ShaderHelper.releaseShader();
    }

    public static void setupDepthAndStencil() {
        OpenGlHelper.func_153176_h((int)OpenGlHelper.field_153199_f, (int)PostProcessing.MAIN.field_147624_h);
        if (MinecraftForgeClient.getStencilBits() == 0) {
            OpenGlHelper.func_153186_a((int)OpenGlHelper.field_153199_f, (int)33190, (int)PostProcessing.MAIN.field_147622_a, (int)PostProcessing.MAIN.field_147620_b);
            OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153201_h, (int)OpenGlHelper.field_153199_f, (int)PostProcessing.MAIN.field_147624_h);
        } else {
            OpenGlHelper.func_153186_a((int)OpenGlHelper.field_153199_f, (int)35056, (int)PostProcessing.MAIN.field_147622_a, (int)PostProcessing.MAIN.field_147620_b);
            OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)36096, (int)OpenGlHelper.field_153199_f, (int)PostProcessing.MAIN.field_147624_h);
            OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)36128, (int)OpenGlHelper.field_153199_f, (int)PostProcessing.MAIN.field_147624_h);
        }
    }

    public static void init(int width, int height) {
        hasInitialized = true;
        int previousBuffer = GL11.glGetInteger((int)36006);
        MAIN = PostProcessing.getMainBuffer();
        MISC_POST_PROCESSING_BUFFER = OpenGlHelper.func_153165_e();
        GL30.glBindFramebuffer((int)36160, (int)MISC_POST_PROCESSING_BUFFER);
        BLUR_TEXTURE = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)BLUR_TEXTURE);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)34842, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        OpenGlHelper.func_153188_a((int)36160, (int)36064, (int)3553, (int)BLUR_TEXTURE, (int)0);
        MAIN_BLOOM_BUFFER = OpenGlHelper.func_153165_e();
        GL30.glBindFramebuffer((int)36160, (int)MAIN_BLOOM_BUFFER);
        OpenGlHelper.func_153188_a((int)36160, (int)36064, (int)3553, (int)PostProcessing.MAIN.field_147617_g, (int)0);
        MAIN_BLOOM_TEXTURE = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)MAIN_BLOOM_TEXTURE);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)34842, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        OpenGlHelper.func_153188_a((int)36160, (int)36066, (int)3553, (int)MAIN_BLOOM_TEXTURE, (int)0);
        PostProcessing.setupDepthAndStencil();
        PostProcessing.drawToBuffers(0, 2);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glClear((int)16384);
        for (int i = 0; i < bloomBuffers.length; ++i) {
            int mipWidth = width >> i + 1;
            int mipHeight = height >> i + 1;
            if (mipWidth < 15 || mipHeight < 7) break;
            PostProcessing.bloomBuffers[i] = OpenGlHelper.func_153165_e();
            GL30.glBindFramebuffer((int)36160, (int)bloomBuffers[i]);
            PostProcessing.bloomTextures[i] = TextureUtil.func_110996_a();
            GL11.glBindTexture((int)3553, (int)bloomTextures[i]);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexImage2D((int)3553, (int)0, (int)34842, (int)mipWidth, (int)mipHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            OpenGlHelper.func_153188_a((int)36160, (int)36064, (int)3553, (int)bloomTextures[i], (int)0);
            PostProcessing.bloomTextures2[i] = TextureUtil.func_110996_a();
            GL11.glBindTexture((int)3553, (int)bloomTextures2[i]);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexImage2D((int)3553, (int)0, (int)34842, (int)mipWidth, (int)mipHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            OpenGlHelper.func_153188_a((int)36160, (int)36066, (int)3553, (int)bloomTextures2[i], (int)0);
            int status = GL30.glCheckFramebufferStatus((int)36160);
            if (status != 36053) {
                CommonProxy.LOGGER.error("Framebuffer " + i + " is not complete: " + status);
            }
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glClear((int)16384);
        }
        PostProcessing.resetDrawBuffer();
        MAIN.func_147610_a(false);
        int status = GL30.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            CommonProxy.LOGGER.error("Framebuffer is not complete: " + status);
        }
        DEPTH_TEXTURE = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)DEPTH_TEXTURE);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexImage2D((int)3553, (int)0, (int)36012, (int)width, (int)height, (int)0, (int)6402, (int)5126, (ByteBuffer)null);
        auraBuffer = OpenGlHelper.func_153165_e();
        GL30.glBindFramebuffer((int)36160, (int)auraBuffer);
        for (int i = 0; i < auraTextures.length; ++i) {
            PostProcessing.auraTextures[i] = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)auraTextures[i]);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexImage2D((int)3553, (int)0, (int)34842, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            OpenGlHelper.func_153188_a((int)36160, (int)(36064 + i), (int)3553, (int)auraTextures[i], (int)0);
        }
        PostProcessing.setupDepthAndStencil();
        status = GL30.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            CommonProxy.LOGGER.error("Aura framebuffer is not complete: " + status);
        }
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glClear((int)16384);
        GL30.glBindFramebuffer((int)36160, (int)previousBuffer);
        blankTexture = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)blankTexture);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)34842, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
    }

    public static void delete() {
        int i;
        if (!hasInitialized) {
            return;
        }
        for (i = 0; i < bloomBuffers.length; ++i) {
            if (bloomTextures[i] > 0) {
                TextureUtil.func_147942_a((int)bloomTextures[i]);
            }
            if (bloomBuffers[i] <= 0) continue;
            OpenGlHelper.func_153174_h((int)bloomBuffers[i]);
        }
        OpenGlHelper.func_153174_h((int)auraBuffer);
        for (i = 0; i < auraTextures.length; ++i) {
            if (auraTextures[i] <= 0) continue;
            TextureUtil.func_147942_a((int)auraTextures[i]);
        }
        OpenGlHelper.func_153174_h((int)MISC_POST_PROCESSING_BUFFER);
        bloomBuffers = new int[BLOOM_BUFFERS_LENGTH];
        bloomTextures = new int[bloomBuffers.length];
        TextureUtil.func_147942_a((int)MAIN_BLOOM_TEXTURE);
        TextureUtil.func_147942_a((int)DEPTH_TEXTURE);
        TextureUtil.func_147942_a((int)BLUR_TEXTURE);
        TextureUtil.func_147942_a((int)blankTexture);
    }

    public static void copyBuffer(int copyFBO, int pasteFBO, int width, int height, int bufferBits) {
        int previousBuffer = GL11.glGetInteger((int)36006);
        GL30.glBindFramebuffer((int)3074, (int)copyFBO);
        GL30.glBindFramebuffer((int)3073, (int)pasteFBO);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)width, (int)height, (int)0, (int)0, (int)width, (int)height, (int)bufferBits, (int)9728);
        int status = GL30.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            CommonProxy.LOGGER.error("Copying FBO " + pasteFBO + " is not complete: " + status);
        }
        GL30.glBindFramebuffer((int)36160, (int)previousBuffer);
    }

    public static void saveTextureToPNG(int textureID) {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)textureID);
        int width = (int)GL11.glGetTexLevelParameterf((int)3553, (int)0, (int)4096);
        int height = (int)GL11.glGetTexLevelParameterf((int)3553, (int)0, (int)4097);
        ByteBuffer buffer = ByteBuffer.allocateDirect(width * height * 4);
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int index = (x + (height - y - 1) * width) * 4;
                int r = buffer.get(index) & 0xFF;
                int g = buffer.get(index + 1) & 0xFF;
                int b = buffer.get(index + 2) & 0xFF;
                int a = buffer.get(index + 3) & 0xFF;
                int argb = a << 24 | r << 16 | g << 8 | b;
                image.setRGB(x, y, argb);
            }
        }
        String desktopPath = System.getProperty("user.home") + "/Desktop/image/";
        String filename = desktopPath + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "_" + textureID + ".png";
        File file = new File(filename);
        try {
            ImageIO.write((RenderedImage)image, "PNG", file);
            System.out.println("Texture saved to: " + filename);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Failed to write PNG file: " + e.getMessage());
        }
    }

    public static Framebuffer getMainBuffer() {
        return Minecraft.func_71410_x().func_147110_a();
    }

    public static void updateViewportDimensions() {
        IntBuffer viewport = BufferUtils.createIntBuffer((int)16);
        GL11.glGetInteger((int)2978, (IntBuffer)viewport);
        VIEWPORT_WIDTH = viewport.get(2);
        VIEWPORT_HEIGHT = viewport.get(3);
    }

    public static void drawToBuffers(int ... colorBuffers) {
        IntBuffer buffer = BufferUtils.createIntBuffer((int)colorBuffers.length);
        for (int colorBuffer : colorBuffers) {
            if (colorBuffer > 15) continue;
            buffer.put(36064 + colorBuffer);
        }
        buffer.flip();
        GL20.glDrawBuffers((IntBuffer)buffer);
    }

    public static void resetDrawBuffer() {
        GL20.glDrawBuffers((int)36064);
    }

    public static void renderQuad(int textureID, float startX, float startY, float width, float height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (textureID != -1) {
            GL11.glBindTexture((int)3553, (int)textureID);
        }
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)startX, (double)startY, 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)startX, (double)height, 0.0, 0.0, 0.0);
        tessellator.func_78374_a((double)width, (double)height, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)width, (double)startY, 0.0, 1.0, 1.0);
        tessellator.func_78381_a();
        GL11.glBindTexture((int)3553, (int)0);
    }

    static {
        BLOOM_BUFFERS_LENGTH = 10;
        bloomBuffers = new int[BLOOM_BUFFERS_LENGTH];
        bloomTextures = new int[bloomBuffers.length];
        bloomTextures2 = new int[bloomBuffers.length];
        auraTextures = new int[3];
        DEFAULT_MODELVIEW = BufferUtils.createFloatBuffer((int)16);
        DEFAULT_PROJECTION = BufferUtils.createFloatBuffer((int)16);
        mc = Minecraft.func_71410_x();
    }
}

