/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data;

import JinRyuu.JRMCore.JRMCoreH;
import java.util.ArrayList;
import java.util.List;
import kamkeel.npcdbc.config.ConfigDBCGameplay;
import kamkeel.npcdbc.data.PlayerDBCInfo;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.util.PlayerDataUtil;
import kamkeel.npcs.controllers.data.profile.IProfileData;
import kamkeel.npcs.controllers.data.profile.ProfileInfoEntry;
import kamkeel.npcs.controllers.data.profile.ProfileOperation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class DBCProfileData
implements IProfileData {
    public String getTagName() {
        return "DBC";
    }

    public NBTTagCompound getCurrentNBT(EntityPlayer player) {
        DBCData dbcData = DBCData.get(player);
        return (NBTTagCompound)dbcData.getRawCompound().func_74737_b();
    }

    public void save(EntityPlayer player) {
        DBCData dbcData = DBCData.get(player);
        dbcData.loadNBTData(true);
        PlayerDBCInfo info = PlayerDataUtil.getDBCInfo(player);
        info.updateClient();
    }

    public void setNBT(EntityPlayer player, NBTTagCompound replace) {
        DBCData.get(player);
        player.getEntityData().func_74782_a(DBCData.DBCPersisted, replace.func_74737_b());
    }

    public int getSwitchPriority() {
        return 1;
    }

    public ProfileOperation verifySwitch(EntityPlayer entityPlayer) {
        DBCData dbcData = DBCData.get(entityPlayer);
        if (dbcData.stats.isFused()) {
            return ProfileOperation.error((String)"Player is fused");
        }
        if (ConfigDBCGameplay.ProfileSwitchingRemovesLegendary && JRMCoreH.StusEfcts((int)14, (String)dbcData.StatusEffects)) {
            dbcData.setSE(14, false);
            dbcData.saveNBTData(false);
        }
        return ProfileOperation.success((String)"");
    }

    public List<ProfileInfoEntry> getInfo(EntityPlayer entityPlayer, NBTTagCompound nbtTagCompound) {
        DBCData dbcData = new DBCData(entityPlayer);
        dbcData.loadFromNBT(nbtTagCompound);
        ArrayList<ProfileInfoEntry> info = new ArrayList<ProfileInfoEntry>();
        info.add(new ProfileInfoEntry("DBC", 0xFFFFFF, "", 0xFFFFFF));
        info.add(new ProfileInfoEntry("------------------", 0xFFFFFF, "", 0xFFFFFF));
        info.add(new ProfileInfoEntry("jinryuujrmcore.Level", 4697333, JRMCoreH.getPlayerLevel((int)(dbcData.STR + dbcData.DEX + dbcData.CON + dbcData.WIL + dbcData.MND + dbcData.SPI)), 0xFFFFFF));
        info.add(new ProfileInfoEntry("jinryuujrmcore.TP", 4697333, dbcData.TP, 0xFFFFFF));
        info.add(new ProfileInfoEntry("jinryuujrmcore.Class", 6355543, JRMCoreH.ClassesDBC[dbcData.Class], 0xFFFFFF));
        info.add(new ProfileInfoEntry("jinryuujrmcore.Race", 16208694, JRMCoreH.Races[dbcData.Race], 0xFFFFFF));
        info.add(new ProfileInfoEntry("------------------", 0xFFFFFF, "", 0xFFFFFF));
        info.add(new ProfileInfoEntry("jinryuujrmcore.Strength", 4697333, dbcData.STR, 0xFFFFFF));
        info.add(new ProfileInfoEntry("jinryuujrmcore.Dexterity", 4697333, dbcData.DEX, 0xFFFFFF));
        info.add(new ProfileInfoEntry("jinryuujrmcore.Constitution", 4697333, dbcData.CON, 0xFFFFFF));
        info.add(new ProfileInfoEntry("jinryuujrmcore.WillPower", 4697333, dbcData.WIL, 0xFFFFFF));
        info.add(new ProfileInfoEntry("jinryuujrmcore.Mind", 4697333, dbcData.MND, 0xFFFFFF));
        info.add(new ProfileInfoEntry("jinryuujrmcore.Spirit", 4697333, dbcData.SPI, 0xFFFFFF));
        return info;
    }
}

