/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.scripted;

import cpw.mods.fml.common.eventhandler.Cancelable;
import kamkeel.npcdbc.api.event.IDBCEvent;
import kamkeel.npcdbc.constants.DBCDamageSource;
import kamkeel.npcdbc.constants.DBCScriptType;
import kamkeel.npcdbc.constants.enums.EnumHealthCapsules;
import kamkeel.npcdbc.constants.enums.EnumKiCapsules;
import kamkeel.npcdbc.constants.enums.EnumMiscCapsules;
import kamkeel.npcdbc.constants.enums.EnumRegenCapsules;
import kamkeel.npcdbc.constants.enums.EnumStaminaCapsules;
import kamkeel.npcdbc.data.DBCDamageCalc;
import kamkeel.npcdbc.util.PlayerDataUtil;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.client.event.RenderPlayerEvent;
import noppes.npcs.api.IDamageSource;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.event.player.PlayerEvent;

public abstract class DBCPlayerEvent
extends PlayerEvent
implements IDBCEvent {
    public DBCPlayerEvent(IPlayer player) {
        super(player);
    }

    public static class RenderArmEvent
    extends RenderPlayerEvent {
        public RenderArmEvent(EntityPlayer player, RenderPlayer renderer, float partialRenderTick) {
            super(player, renderer, partialRenderTick);
        }

        public static class Post
        extends RenderPlayerEvent {
            public Post(EntityPlayer player, RenderPlayer renderer, float partialRenderTick) {
                super(player, renderer, partialRenderTick);
            }
        }

        @Cancelable
        public static class Pre
        extends RenderPlayerEvent {
            public Pre(EntityPlayer player, RenderPlayer renderer, float partialRenderTick) {
                super(player, renderer, partialRenderTick);
            }
        }

        @Cancelable
        public static class Item
        extends RenderPlayerEvent {
            public Item(EntityPlayer player, RenderPlayer renderer, float partialRenderTick) {
                super(player, renderer, partialRenderTick);
            }
        }
    }

    public static class RenderEvent
    extends RenderPlayerEvent {
        public RenderEvent(EntityPlayer player, RenderPlayer renderer, float partialRenderTick) {
            super(player, renderer, partialRenderTick);
        }

        public static class Post
        extends RenderPlayerEvent {
            public Post(EntityPlayer player, RenderPlayer renderer, float tick) {
                super(player, renderer, tick);
            }
        }

        @Cancelable
        public static class Pre
        extends RenderPlayerEvent {
            public Pre(EntityPlayer player, RenderPlayer renderer, float tick) {
                super(player, renderer, tick);
            }
        }
    }

    @Cancelable
    public static class KnockoutEvent
    extends DBCPlayerEvent
    implements IDBCEvent.DBCKnockout {
        public final IDamageSource damageSource;

        public KnockoutEvent(IPlayer player, DamageSource damageSource) {
            super(player);
            this.damageSource = NpcAPI.Instance().getIDamageSource(damageSource);
        }

        @Override
        public IDamageSource getDamageSource() {
            return this.damageSource;
        }

        public String getHookName() {
            return DBCScriptType.KNOCKOUT.function;
        }
    }

    public static class ReviveEvent
    extends DBCPlayerEvent
    implements IDBCEvent.DBCReviveEvent {
        public ReviveEvent(IPlayer player) {
            super(player);
        }

        public String getHookName() {
            return DBCScriptType.REVIVED.function;
        }
    }

    @Cancelable
    public static class DamagedEvent
    extends DBCPlayerEvent
    implements IDBCEvent.DamagedEvent {
        public final IDamageSource damageSource;
        public final int sourceType;
        public float damage;
        public int stamina;
        public int ki;
        public boolean willKo;

        public DamagedEvent(EntityPlayer player, float damage, DamageSource damageSource, int type) {
            super(PlayerDataUtil.getIPlayer(player));
            this.damage = damage;
            this.damageSource = NpcAPI.Instance().getIDamageSource(damageSource);
            this.sourceType = type;
        }

        public DamagedEvent(EntityPlayer player, DBCDamageCalc damageCalc, DamageSource damageSource, int type) {
            super(PlayerDataUtil.getIPlayer(player));
            this.damage = damageCalc.damage;
            this.stamina = damageCalc.stamina;
            this.ki = damageCalc.ki;
            this.willKo = damageCalc.willKo;
            this.damageSource = NpcAPI.Instance().getIDamageSource(damageSource);
            this.sourceType = type;
        }

        @Override
        public float getDamage() {
            return this.damage;
        }

        @Override
        public void setDamage(float damage) {
            this.damage = damage;
        }

        @Override
        public int getStaminaReduced() {
            return this.stamina;
        }

        @Override
        public void setStaminaReduced(int stamina) {
            this.stamina = stamina;
        }

        @Override
        public boolean willKo() {
            return this.willKo;
        }

        @Override
        public int getKiReduced() {
            return this.ki;
        }

        @Override
        public void setKiReduced(int ki) {
            this.ki = ki;
        }

        @Override
        public IDamageSource getDamageSource() {
            return this.damageSource;
        }

        @Override
        public boolean isDamageSourceKiAttack() {
            return this.sourceType == DBCDamageSource.KIATTACK;
        }

        @Override
        public float getType() {
            return this.sourceType;
        }

        public String getHookName() {
            return DBCScriptType.DAMAGED.function;
        }
    }

    @Cancelable
    public static class FormChangeEvent
    extends DBCPlayerEvent
    implements IDBCEvent.FormChangeEvent {
        private final int formBeforeID;
        private final boolean isBeforeCustom;
        private final int formAfterID;
        private final boolean isAfterCustom;

        public FormChangeEvent(IPlayer player, boolean isBeforeCustom, int formBeforeID, boolean isAfterCustom, int formAfterID) {
            super(player);
            this.formBeforeID = formBeforeID;
            this.isBeforeCustom = isBeforeCustom;
            this.formAfterID = formAfterID;
            this.isAfterCustom = isAfterCustom;
        }

        @Override
        public int getFormBeforeID() {
            return this.formBeforeID;
        }

        @Override
        public int getFormAfterID() {
            return this.formAfterID;
        }

        @Override
        public boolean isFormBeforeCustom() {
            return this.isBeforeCustom;
        }

        @Override
        public boolean isFormAfterCustom() {
            return this.isAfterCustom;
        }

        public String getHookName() {
            return DBCScriptType.FORMCHANGE.function;
        }
    }

    @Cancelable
    public static class SenzuUsedEvent
    extends DBCPlayerEvent
    implements IDBCEvent.SenzuUsedEvent {
        public SenzuUsedEvent(IPlayer player) {
            super(player);
        }

        public String getHookName() {
            return DBCScriptType.SENZUUSED.function;
        }
    }

    @Cancelable
    public static class CapsuleUsedEvent
    extends DBCPlayerEvent
    implements IDBCEvent.CapsuleUsedEvent {
        private final int type;
        private final int subtype;

        public CapsuleUsedEvent(IPlayer player, int type, int subtype) {
            super(player);
            this.type = type;
            this.subtype = subtype;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public int getSubType() {
            return this.subtype;
        }

        @Override
        public String getCapsuleName() {
            String name = "UNKNOWN";
            if (this.subtype >= 0) {
                if (this.type == 0 && this.subtype < EnumMiscCapsules.count()) {
                    name = EnumMiscCapsules.values()[this.subtype].getName();
                } else if (this.type == 1 && this.subtype < EnumHealthCapsules.count()) {
                    name = EnumHealthCapsules.values()[this.subtype].getName();
                } else if (this.type == 2 && this.subtype < EnumKiCapsules.count()) {
                    name = EnumKiCapsules.values()[this.subtype].getName();
                } else if (this.type == 3 && this.subtype < EnumStaminaCapsules.count()) {
                    name = EnumStaminaCapsules.values()[this.subtype].getName();
                } else if (this.type == 4 && this.subtype < EnumRegenCapsules.count()) {
                    name = EnumRegenCapsules.values()[this.subtype].getName();
                }
            }
            return name;
        }

        public String getHookName() {
            return DBCScriptType.CAPSULEUSED.function;
        }
    }
}

