/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.client.gui.wardrobe.tab;

import cpw.mods.fml.client.config.GuiButtonExt;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import riskyken.armourersWorkshop.client.gui.GuiHelper;
import riskyken.armourersWorkshop.client.gui.controls.GuiTabPanel;
import riskyken.armourersWorkshop.client.gui.wardrobe.GuiWardrobe;
import riskyken.armourersWorkshop.client.lib.LibGuiResources;
import riskyken.armourersWorkshop.client.render.ModRenderHelper;
import riskyken.armourersWorkshop.common.data.PlayerPointer;
import riskyken.armourersWorkshop.common.network.PacketHandler;
import riskyken.armourersWorkshop.common.network.messages.client.MessageClientSkinWardrobeUpdate;
import riskyken.armourersWorkshop.common.skin.EquipmentWardrobeData;
import riskyken.armourersWorkshop.common.skin.ExPropsPlayerSkinData;
import riskyken.armourersWorkshop.proxies.ClientProxy;

@SideOnly(value=Side.CLIENT)
public class GuiTabWardrobeColourSettings
extends GuiTabPanel {
    private static final ResourceLocation TEXTURE = new ResourceLocation(LibGuiResources.WARDROBE);
    private boolean selectingSkinColour = false;
    private boolean selectingHairColour = false;
    private Color skinColour;
    private Color hairColour;
    private GuiButtonExt selectSkinButton;
    private GuiButtonExt autoSkinButton;
    private GuiButtonExt selectHairButton;
    private GuiButtonExt autoHairButton;
    EntityPlayer entityPlayer;
    ExPropsPlayerSkinData propsPlayerSkinData;
    EquipmentWardrobeData equipmentWardrobeData;
    String guiName = "equipmentWardrobe";

    public GuiTabWardrobeColourSettings(int tabId, GuiScreen parent, EntityPlayer entityPlayer, ExPropsPlayerSkinData propsPlayerSkinData, EquipmentWardrobeData equipmentWardrobeData) {
        super(tabId, parent, false);
        this.skinColour = new Color(equipmentWardrobeData.skinColour);
        this.hairColour = new Color(equipmentWardrobeData.hairColour);
        this.entityPlayer = entityPlayer;
        this.propsPlayerSkinData = propsPlayerSkinData;
        this.equipmentWardrobeData = equipmentWardrobeData;
    }

    @Override
    public void initGui(int xPos, int yPos, int width, int height) {
        super.initGui(xPos, yPos, width, height);
        this.selectSkinButton = new GuiButtonExt(0, 68, 46, 100, 18, GuiHelper.getLocalizedControlName(this.guiName, "selectSkin"));
        this.autoSkinButton = new GuiButtonExt(0, 173, 46, 50, 18, GuiHelper.getLocalizedControlName(this.guiName, "autoSkin"));
        this.selectHairButton = new GuiButtonExt(0, 68, 98, 100, 18, GuiHelper.getLocalizedControlName(this.guiName, "selectHair"));
        this.autoHairButton = new GuiButtonExt(0, 173, 98, 50, 18, GuiHelper.getLocalizedControlName(this.guiName, "autoHair"));
        this.buttonList.add(this.selectSkinButton);
        this.buttonList.add(this.autoSkinButton);
        this.buttonList.add(this.selectHairButton);
        this.buttonList.add(this.autoHairButton);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button) {
        EquipmentWardrobeData ewd;
        if (button == 0 & this.selectingSkinColour) {
            ewd = new EquipmentWardrobeData(this.equipmentWardrobeData);
            ewd.skinColour = this.skinColour.getRGB();
            PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientSkinWardrobeUpdate(ewd));
            this.selectingSkinColour = false;
        }
        if (button == 0 & this.selectingHairColour) {
            ewd = new EquipmentWardrobeData(this.equipmentWardrobeData);
            ewd.hairColour = this.hairColour.getRGB();
            PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientSkinWardrobeUpdate(ewd));
            this.selectingHairColour = false;
        }
        super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        EquipmentWardrobeData ewd;
        if (button == this.selectSkinButton) {
            this.selectingSkinColour = true;
        }
        if (button == this.selectHairButton) {
            this.selectingHairColour = true;
        }
        if (button == this.autoSkinButton) {
            int newSkinColour = this.equipmentWardrobeData.autoColourSkin((AbstractClientPlayer)this.entityPlayer);
            ewd = new EquipmentWardrobeData(this.equipmentWardrobeData);
            ewd.skinColour = newSkinColour;
            PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientSkinWardrobeUpdate(ewd));
        }
        if (button == this.autoHairButton) {
            int newHairColour = this.equipmentWardrobeData.autoColourHair((AbstractClientPlayer)this.entityPlayer);
            ewd = new EquipmentWardrobeData(this.equipmentWardrobeData);
            ewd.hairColour = newHairColour;
            PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientSkinWardrobeUpdate(ewd));
        }
    }

    @Override
    public void drawBackgroundLayer(float partialTickTime, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.x, this.y, 0, 0, 236, 151);
        this.func_73729_b(this.x + 29, this.y + 151, 29, 151, 178, 89);
        PlayerPointer playerPointer = new PlayerPointer(this.entityPlayer);
        EquipmentWardrobeData newEwd = this.equipmentWardrobeData = ClientProxy.equipmentWardrobeHandler.getEquipmentWardrobeData(playerPointer);
        if (newEwd != null) {
            this.equipmentWardrobeData = newEwd;
        }
        float skinR = (float)this.skinColour.getRed() / 255.0f;
        float skinG = (float)this.skinColour.getGreen() / 255.0f;
        float skinB = (float)this.skinColour.getBlue() / 255.0f;
        this.func_73729_b(this.x + 68, this.y + 30, 242, 180, 14, 14);
        GL11.glColor4f((float)skinR, (float)skinG, (float)skinB, (float)1.0f);
        this.func_73729_b(this.x + 69, this.y + 31, 243, 181, 12, 12);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float hairR = (float)this.hairColour.getRed() / 255.0f;
        float hairG = (float)this.hairColour.getGreen() / 255.0f;
        float hairB = (float)this.hairColour.getBlue() / 255.0f;
        this.func_73729_b(this.x + 68, this.y + 82, 242, 180, 14, 14);
        GL11.glColor4f((float)hairR, (float)hairG, (float)hairB, (float)1.0f);
        this.func_73729_b(this.x + 69, this.y + 83, 243, 181, 12, 12);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        String labelSkinColour = GuiHelper.getLocalizedControlName("equipmentWardrobe", "label.skinColour");
        this.fontRenderer.func_78276_b(labelSkinColour + ":", 70, 18, 0x404040);
        String labelHairColour = GuiHelper.getLocalizedControlName("equipmentWardrobe", "label.hairColour");
        this.fontRenderer.func_78276_b(labelHairColour + ":", 70, 70, 0x404040);
        this.skinColour = new Color(this.equipmentWardrobeData.skinColour);
        this.hairColour = new Color(this.equipmentWardrobeData.hairColour);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-this.x), (double)(-this.y), (double)0.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ModRenderHelper.enableAlphaBlend();
        if (this.selectingSkinColour) {
            this.skinColour = ((GuiWardrobe)this.parent).drawPlayerPreview(this.x, this.y, mouseX, mouseY, true);
        } else if (this.selectingHairColour) {
            this.hairColour = ((GuiWardrobe)this.parent).drawPlayerPreview(this.x, this.y, mouseX, mouseY, true);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ModRenderHelper.enableAlphaBlend();
            ((GuiWardrobe)this.parent).drawPlayerPreview(this.x, this.y, mouseX, mouseY, false);
        }
        GL11.glPopMatrix();
    }
}

