/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import riskyken.armourersWorkshop.api.common.IPoint3D;
import riskyken.armourersWorkshop.api.common.skin.Rectangle3D;
import riskyken.armourersWorkshop.api.common.skin.data.ISkinPointer;
import riskyken.armourersWorkshop.api.common.skin.type.ISkinType;
import riskyken.armourersWorkshop.client.model.skin.AbstractModelSkin;
import riskyken.armourersWorkshop.client.render.SkinModelRenderer;
import riskyken.armourersWorkshop.client.render.SkinPartRenderer;
import riskyken.armourersWorkshop.client.skin.cache.ClientSkinCache;
import riskyken.armourersWorkshop.common.skin.data.Skin;
import riskyken.armourersWorkshop.common.skin.data.SkinPart;
import riskyken.armourersWorkshop.common.skin.data.SkinPointer;
import riskyken.armourersWorkshop.common.skin.type.SkinTypeRegistry;
import riskyken.armourersWorkshop.utils.SkinNBTHelper;

@SideOnly(value=Side.CLIENT)
public final class ItemStackRenderHelper {
    @Deprecated
    public static void renderItemAsArmourModel(ItemStack stack, boolean showSkinPaint) {
        if (SkinNBTHelper.stackHasSkinData(stack)) {
            SkinPointer skinPointer = SkinNBTHelper.getSkinPointerFromStack(stack);
            ItemStackRenderHelper.renderItemModelFromSkinPointer(skinPointer, showSkinPaint, false);
        }
    }

    @Deprecated
    public static void renderItemModelFromSkinPointer(ISkinPointer skinPointer, boolean showSkinPaint, boolean doLodLoading) {
        ItemStackRenderHelper.renderItemModelFromSkin(ClientSkinCache.INSTANCE.getSkin(skinPointer), skinPointer, showSkinPaint, doLodLoading);
    }

    @Deprecated
    public static void renderItemModelFromSkin(Skin skin, ISkinPointer skinPointer, boolean showSkinPaint, boolean doLodLoading) {
        if (skin == null) {
            return;
        }
        float blockScale = 16.0f;
        float mcScale = 1.0f / blockScale;
        float scale = 1.0f;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float offsetZ = 0.0f;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        float scaleZ = 1.0f;
        int width = 1;
        int height = 1;
        int depth = 1;
        Rectangle3D sb = skin.getSkinBounds();
        width = Math.max(width, sb.getWidth());
        height = Math.max(height, sb.getHeight());
        depth = Math.max(depth, sb.getDepth());
        scaleX = Math.min(scaleX, 1.0f / (float)width);
        scaleY = Math.min(scaleY, 1.0f / (float)height);
        scaleZ = Math.min(scaleZ, 1.0f / (float)depth);
        scale = Math.min(scale, scaleX);
        scale = Math.min(scale, scaleY);
        scale = Math.min(scale, scaleZ);
        offsetX = (float)(-sb.getX()) - (float)width / 2.0f;
        offsetY = (float)(-sb.getY()) - (float)height / 2.0f;
        offsetZ = (float)(-sb.getZ()) - (float)depth / 2.0f;
        GL11.glPushMatrix();
        GL11.glScalef((float)(scale * blockScale), (float)(scale * blockScale), (float)(scale * blockScale));
        GL11.glTranslatef((float)(offsetX * mcScale), (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(offsetY * mcScale), (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(offsetZ * mcScale));
        if (skin.getSkinType() == SkinTypeRegistry.skinWings) {
            GL11.glTranslated((double)(-offsetX * mcScale), (double)0.0, (double)0.0);
        }
        ItemStackRenderHelper.renderSkinWithHelper(skin, skinPointer, showSkinPaint, doLodLoading);
        GL11.glPopMatrix();
    }

    public static void renderSkinWithHelper(Skin skin, ISkinPointer skinPointer, boolean showSkinPaint, boolean doLodLoading) {
        AbstractModelSkin targetModel;
        ISkinType skinType = skinPointer.getIdentifier().getSkinType();
        if (skinType == null) {
            skinType = skin.getSkinType();
        }
        if ((targetModel = SkinModelRenderer.INSTANCE.getModelForEquipmentType(skinType)) == null) {
            ItemStackRenderHelper.renderSkinWithoutHelper(skinPointer, doLodLoading);
            return;
        }
        targetModel.render(null, null, skin, showSkinPaint, skinPointer.getSkinDye(), null, true, 0.0, doLodLoading);
    }

    public static void renderSkinWithoutHelper(ISkinPointer skinPointer, boolean doLodLoading) {
        Skin skin = ClientSkinCache.INSTANCE.getSkin(skinPointer);
        if (skin == null) {
            return;
        }
        float scale = 0.0625f;
        for (int i = 0; i < skin.getParts().size(); ++i) {
            GL11.glPushMatrix();
            SkinPart skinPart = skin.getParts().get(i);
            IPoint3D offset = skinPart.getPartType().getOffset();
            GL11.glTranslated((double)((float)offset.getX() * scale), (double)((float)(offset.getY() + 1) * scale), (double)((float)offset.getZ() * scale));
            SkinPartRenderer.INSTANCE.renderPart(skinPart, 0.0625f, skinPointer.getSkinDye(), null, doLodLoading);
            GL11.glPopMatrix();
        }
    }
}

