/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.common.library.global.auth;

import com.google.gson.JsonObject;
import riskyken.armourersWorkshop.ArmourersWorkshop;
import riskyken.armourersWorkshop.common.library.global.permission.PermissionSystem;
import riskyken.armourersWorkshop.utils.ModLogger;

public class PlushieSession {
    private PermissionSystem.PermissionGroup permissionGroup;
    private boolean isAuth;
    private int server_id;
    private String mc_id;
    private String mc_name;
    private String accessToken;
    private long accessTokenReceivedTime;
    private int accessTokenExpiryTime;
    private int permission_group_id;

    public PlushieSession() {
        this.permissionGroup = ArmourersWorkshop.getProxy().getPermissionSystem().groupNoLogin;
        this.server_id = 0;
    }

    public boolean authenticate(JsonObject jsonObject) {
        if (jsonObject != null && jsonObject.has("valid") && jsonObject.get("valid").getAsBoolean()) {
            this.server_id = jsonObject.get("server_id").getAsInt();
            this.mc_id = jsonObject.get("mc_id").getAsString();
            this.mc_name = jsonObject.get("mc_name").getAsString();
            this.accessToken = jsonObject.get("accessToken").getAsString();
            this.accessTokenReceivedTime = System.currentTimeMillis();
            this.accessTokenExpiryTime = jsonObject.get("expiryTime").getAsInt();
            this.permission_group_id = jsonObject.get("permission_group_id").getAsInt();
            this.isAuth = true;
            return true;
        }
        this.isAuth = false;
        return false;
    }

    public int getServerId() {
        return this.server_id;
    }

    public void setPermission_group_id(int permission_group_id) {
        ModLogger.log("permission_group_id: " + permission_group_id);
        this.permission_group_id = permission_group_id;
    }

    public int getPermission_group_id() {
        return this.permission_group_id;
    }

    public void setServerId(int serverId) {
        this.server_id = serverId;
    }

    public boolean hasServerId() {
        return this.server_id > 0;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public boolean isAuthenticated() {
        return this.isAuth && this.accessTokenReceivedTime + (long)(this.accessTokenExpiryTime * 1000) > System.currentTimeMillis();
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        this.accessTokenReceivedTime = System.currentTimeMillis();
    }

    public void setPermissionGroup(PermissionSystem.PermissionGroup permissionGroup) {
        this.permissionGroup = permissionGroup;
    }

    public boolean hasPermission(PermissionSystem.Action action) {
        return this.permissionGroup.havePermission(action);
    }
}

