/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.common.skin;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.BitSet;
import java.util.HashMap;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import riskyken.armourersWorkshop.api.common.skin.type.ISkinType;
import riskyken.armourersWorkshop.common.SkinHelper;
import riskyken.armourersWorkshop.common.config.ConfigHandler;
import riskyken.armourersWorkshop.common.skin.ExPropsPlayerSkinData;
import riskyken.armourersWorkshop.common.skin.type.SkinTypeRegistry;

public class EquipmentWardrobeData {
    private static final String TAG_SKIN_COLOUR = "skinColour";
    private static final String TAG_HAIR_COLOUR = "hairColour";
    private static final String TAG_ARMOUR_OVERRIDE = "armourOverride";
    private static final String TAG_HEAD_OVERLAY = "headOverlay";
    private static final String TAG_LIMIT_LIMBS = "limitLimbs";
    private static final String TAG_SLOTS_UNLOCKED = "slotsUnlocked";
    private static final String TAG_SLOT_KEY = "slotKey";
    private static final String TAG_SLOT_VALUE = "slotValue";
    public int skinColour;
    public int hairColour;
    public BitSet armourOverride;
    public boolean headOverlay;
    public boolean limitLimbs;
    public HashMap<String, Integer> slotsUnlocked;

    public EquipmentWardrobeData() {
        this.skinColour = Color.decode("#F9DFD2").getRGB();
        this.hairColour = Color.decode("#804020").getRGB();
        this.armourOverride = new BitSet(4);
        this.headOverlay = false;
        this.limitLimbs = true;
        this.slotsUnlocked = new HashMap();
        ISkinType[] validSkins = ExPropsPlayerSkinData.validSkins;
        for (int i = 0; i < validSkins.length; ++i) {
            ISkinType skinType = validSkins[i];
            this.slotsUnlocked.put(skinType.getRegistryName(), this.getUnlockedSlotsForSkinType(skinType));
        }
    }

    public int getUnlockedSlotsForSkinType(ISkinType skinType) {
        if (skinType == SkinTypeRegistry.skinBow) {
            return 1;
        }
        if (skinType == SkinTypeRegistry.skinSword) {
            return 5;
        }
        if (this.slotsUnlocked.containsKey(skinType.getRegistryName())) {
            return this.slotsUnlocked.get(skinType.getRegistryName());
        }
        return ConfigHandler.startingWardrobeSlots;
    }

    public void setUnlockedSlotsForSkinType(ISkinType skinType, int value) {
        this.slotsUnlocked.put(skinType.getRegistryName(), value);
    }

    public EquipmentWardrobeData(EquipmentWardrobeData ewd) {
        this.skinColour = ewd.skinColour;
        this.hairColour = ewd.hairColour;
        this.armourOverride = (BitSet)ewd.armourOverride.clone();
        this.headOverlay = ewd.headOverlay;
        this.limitLimbs = ewd.limitLimbs;
        this.slotsUnlocked = ewd.slotsUnlocked;
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74768_a(TAG_SKIN_COLOUR, this.skinColour);
        compound.func_74768_a(TAG_HAIR_COLOUR, this.hairColour);
        for (int i = 0; i < 4; ++i) {
            compound.func_74757_a(TAG_ARMOUR_OVERRIDE + i, this.armourOverride.get(i));
        }
        compound.func_74757_a(TAG_HEAD_OVERLAY, this.headOverlay);
        compound.func_74757_a(TAG_LIMIT_LIMBS, this.limitLimbs);
        NBTTagList slotsList = new NBTTagList();
        ISkinType[] validSkins = ExPropsPlayerSkinData.validSkins;
        for (int i = 0; i < validSkins.length; ++i) {
            ISkinType skinType = validSkins[i];
            NBTTagCompound slotCount = new NBTTagCompound();
            slotCount.func_74778_a(TAG_SLOT_KEY, skinType.getRegistryName());
            slotCount.func_74768_a(TAG_SLOT_VALUE, this.getUnlockedSlotsForSkinType(skinType));
            slotsList.func_74742_a((NBTBase)slotCount);
        }
        compound.func_74782_a(TAG_SLOTS_UNLOCKED, (NBTBase)slotsList);
    }

    public void loadNBTData(NBTTagCompound compound) {
        if (compound.func_74764_b(TAG_SKIN_COLOUR)) {
            this.skinColour = compound.func_74762_e(TAG_SKIN_COLOUR);
        }
        if (compound.func_74764_b(TAG_HAIR_COLOUR)) {
            this.hairColour = compound.func_74762_e(TAG_HAIR_COLOUR);
        }
        for (int i = 0; i < 4; ++i) {
            this.armourOverride.set(i, compound.func_74767_n(TAG_ARMOUR_OVERRIDE + i));
        }
        if (compound.func_74764_b(TAG_HEAD_OVERLAY)) {
            this.headOverlay = compound.func_74767_n(TAG_HEAD_OVERLAY);
        }
        if (compound.func_74764_b(TAG_LIMIT_LIMBS)) {
            this.limitLimbs = compound.func_74767_n(TAG_LIMIT_LIMBS);
        }
        if (compound.func_150297_b(TAG_SLOTS_UNLOCKED, 9)) {
            NBTTagList slotsList = compound.func_150295_c(TAG_SLOTS_UNLOCKED, 10);
            this.slotsUnlocked.clear();
            for (int i = 0; i < slotsList.func_74745_c(); ++i) {
                NBTTagCompound slotCount = slotsList.func_150305_b(i);
                if (!(slotCount.func_150297_b(TAG_SLOT_KEY, 8) & slotCount.func_150297_b(TAG_SLOT_VALUE, 3))) continue;
                String key = slotCount.func_74779_i(TAG_SLOT_KEY);
                int value = slotCount.func_74762_e(TAG_SLOT_VALUE);
                this.slotsUnlocked.put(key, value);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.skinColour = buf.readInt();
        this.hairColour = buf.readInt();
        this.armourOverride = new BitSet(4);
        for (i = 0; i < 4; ++i) {
            this.armourOverride.set(i, buf.readBoolean());
        }
        this.headOverlay = buf.readBoolean();
        this.limitLimbs = buf.readBoolean();
        for (i = 0; i < ExPropsPlayerSkinData.validSkins.length; ++i) {
            String key = ByteBufUtils.readUTF8String((ByteBuf)buf);
            int value = buf.readInt();
            this.slotsUnlocked.put(key, value);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.skinColour);
        buf.writeInt(this.hairColour);
        for (int i = 0; i < 4; ++i) {
            buf.writeBoolean(this.armourOverride.get(i));
        }
        buf.writeBoolean(this.headOverlay);
        buf.writeBoolean(this.limitLimbs);
        ISkinType[] validSkins = ExPropsPlayerSkinData.validSkins;
        for (int i = 0; i < validSkins.length; ++i) {
            ISkinType skinType = validSkins[i];
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)skinType.getRegistryName());
            buf.writeInt(this.getUnlockedSlotsForSkinType(skinType));
        }
    }

    public int autoColourHair(AbstractClientPlayer player) {
        BufferedImage playerSkin = SkinHelper.getBufferedImageSkin(player);
        int r = 0;
        int g = 0;
        int b = 0;
        for (int ix = 0; ix < 2; ++ix) {
            for (int iy = 0; iy < 1; ++iy) {
                Color c = new Color(playerSkin.getRGB(ix + 11, iy + 3));
                r += c.getRed();
                g += c.getGreen();
                b += c.getBlue();
            }
        }
        return new Color(r /= 2, g /= 2, b /= 2).getRGB();
    }

    public int autoColourSkin(AbstractClientPlayer player) {
        BufferedImage playerSkin = SkinHelper.getBufferedImageSkin(player);
        int r = 0;
        int g = 0;
        int b = 0;
        for (int ix = 0; ix < 2; ++ix) {
            for (int iy = 0; iy < 1; ++iy) {
                Color c = new Color(playerSkin.getRGB(ix + 11, iy + 13));
                r += c.getRed();
                g += c.getGreen();
                b += c.getBlue();
            }
        }
        return new Color(r /= 2, g /= 2, b /= 2).getRGB();
    }
}

