/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.realms;

import org.lwjgl.opengl.GL11;

public class RealmsEditBox {
    public static final int BACKWARDS = -1;
    public static final int FORWARDS = 1;
    private static final int CURSOR_INSERT_WIDTH = 1;
    private static final int CURSOR_INSERT_COLOR = -3092272;
    private static final String CURSOR_APPEND_CHARACTER = "_";
    private final bbu font;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private String value = "";
    private int maxLength = 32;
    private int frame;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean inFocus;
    private boolean isEditable = true;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    private boolean visible = true;

    public RealmsEditBox(int n2, int n3, int n4, int n5) {
        this(bao.B().l, n2, n3, n4, n5);
    }

    public RealmsEditBox(bbu bbu2, int n2, int n3, int n4, int n5) {
        this.font = bbu2;
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    public void tick() {
        ++this.frame;
    }

    public void setValue(String string) {
        this.value = string.length() > this.maxLength ? string.substring(0, this.maxLength) : string;
        this.moveCursorToEnd();
    }

    public String getValue() {
        return this.value;
    }

    public String getHighlighted() {
        int n2 = this.cursorPos < this.highlightPos ? this.cursorPos : this.highlightPos;
        int n3 = this.cursorPos < this.highlightPos ? this.highlightPos : this.cursorPos;
        return this.value.substring(n2, n3);
    }

    public void insertText(String string) {
        String string2 = "";
        String string3 = t.a(string);
        int n2 = this.cursorPos < this.highlightPos ? this.cursorPos : this.highlightPos;
        int n3 = this.cursorPos < this.highlightPos ? this.highlightPos : this.cursorPos;
        int n4 = this.maxLength - this.value.length() - (n2 - this.highlightPos);
        int n5 = 0;
        if (this.value.length() > 0) {
            string2 = string2 + this.value.substring(0, n2);
        }
        if (n4 < string3.length()) {
            string2 = string2 + string3.substring(0, n4);
            n5 = n4;
        } else {
            string2 = string2 + string3;
            n5 = string3.length();
        }
        if (this.value.length() > 0 && n3 < this.value.length()) {
            string2 = string2 + this.value.substring(n3);
        }
        this.value = string2;
        this.moveCursor(n2 - this.highlightPos + n5);
    }

    public void deleteWords(int n2) {
        if (this.value.length() == 0) {
            return;
        }
        if (this.highlightPos != this.cursorPos) {
            this.insertText("");
            return;
        }
        this.deleteChars(this.getWordPosition(n2) - this.cursorPos);
    }

    public void deleteChars(int n2) {
        if (this.value.length() == 0) {
            return;
        }
        if (this.highlightPos != this.cursorPos) {
            this.insertText("");
            return;
        }
        boolean bl2 = n2 < 0;
        int n3 = bl2 ? this.cursorPos + n2 : this.cursorPos;
        int n4 = bl2 ? this.cursorPos : this.cursorPos + n2;
        String string = "";
        if (n3 >= 0) {
            string = this.value.substring(0, n3);
        }
        if (n4 < this.value.length()) {
            string = string + this.value.substring(n4);
        }
        this.value = string;
        if (bl2) {
            this.moveCursor(n2);
        }
    }

    public int getWordPosition(int n2) {
        return this.getWordPosition(n2, this.getCursorPosition());
    }

    public int getWordPosition(int n2, int n3) {
        return this.getWordPosition(n2, this.getCursorPosition(), true);
    }

    public int getWordPosition(int n2, int n3, boolean bl2) {
        int n4 = n3;
        boolean bl3 = n2 < 0;
        int n5 = Math.abs(n2);
        for (int i2 = 0; i2 < n5; ++i2) {
            if (bl3) {
                while (bl2 && n4 > 0 && this.value.charAt(n4 - 1) == ' ') {
                    --n4;
                }
                while (n4 > 0 && this.value.charAt(n4 - 1) != ' ') {
                    --n4;
                }
                continue;
            }
            int n6 = this.value.length();
            if ((n4 = this.value.indexOf(32, n4)) == -1) {
                n4 = n6;
                continue;
            }
            while (bl2 && n4 < n6 && this.value.charAt(n4) == ' ') {
                ++n4;
            }
        }
        return n4;
    }

    public void moveCursor(int n2) {
        this.moveCursorTo(this.highlightPos + n2);
    }

    public void moveCursorTo(int n2) {
        this.cursorPos = n2;
        int n3 = this.value.length();
        if (this.cursorPos < 0) {
            this.cursorPos = 0;
        }
        if (this.cursorPos > n3) {
            this.cursorPos = n3;
        }
        this.setHighlightPos(this.cursorPos);
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd() {
        this.moveCursorTo(this.value.length());
    }

    public boolean keyPressed(char c2, int n2) {
        if (!this.inFocus) {
            return false;
        }
        switch (c2) {
            case '\u0001': {
                this.moveCursorToEnd();
                this.setHighlightPos(0);
                return true;
            }
            case '\u0003': {
                bdw.e(this.getHighlighted());
                return true;
            }
            case '\u0016': {
                if (this.isEditable) {
                    this.insertText(bdw.o());
                }
                return true;
            }
            case '\u0018': {
                bdw.e(this.getHighlighted());
                if (this.isEditable) {
                    this.insertText("");
                }
                return true;
            }
        }
        switch (n2) {
            case 203: {
                if (bdw.r()) {
                    if (bdw.q()) {
                        this.setHighlightPos(this.getWordPosition(-1, this.getHighlightPos()));
                    } else {
                        this.setHighlightPos(this.getHighlightPos() - 1);
                    }
                } else if (bdw.q()) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 205: {
                if (bdw.r()) {
                    if (bdw.q()) {
                        this.setHighlightPos(this.getWordPosition(1, this.getHighlightPos()));
                    } else {
                        this.setHighlightPos(this.getHighlightPos() + 1);
                    }
                } else if (bdw.q()) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 14: {
                if (bdw.q()) {
                    if (this.isEditable) {
                        this.deleteWords(-1);
                    }
                } else if (this.isEditable) {
                    this.deleteChars(-1);
                }
                return true;
            }
            case 211: {
                if (bdw.q()) {
                    if (this.isEditable) {
                        this.deleteWords(1);
                    }
                } else if (this.isEditable) {
                    this.deleteChars(1);
                }
                return true;
            }
            case 199: {
                if (bdw.r()) {
                    this.setHighlightPos(0);
                } else {
                    this.moveCursorToStart();
                }
                return true;
            }
            case 207: {
                if (bdw.r()) {
                    this.setHighlightPos(this.value.length());
                } else {
                    this.moveCursorToEnd();
                }
                return true;
            }
        }
        if (t.a(c2)) {
            if (this.isEditable) {
                this.insertText(Character.toString(c2));
            }
            return true;
        }
        return false;
    }

    public void mouseClicked(int n2, int n3, int n4) {
        boolean bl2;
        boolean bl3 = bl2 = n2 >= this.x && n2 < this.x + this.width && n3 >= this.y && n3 < this.y + this.height;
        if (this.canLoseFocus) {
            this.setFocus(bl2);
        }
        if (this.inFocus && n4 == 0) {
            int n5 = n2 - this.x;
            if (this.bordered) {
                n5 -= 4;
            }
            String string = this.font.a(this.value.substring(this.displayPos), this.getInnerWidth());
            this.moveCursorTo(this.font.a(string, n5).length() + this.displayPos);
        }
    }

    public void render() {
        if (!this.isVisible()) {
            return;
        }
        if (this.isBordered()) {
            bbw.a(this.x - 1, this.y - 1, this.x + this.width + 1, this.y + this.height + 1, -6250336);
            bbw.a(this.x, this.y, this.x + this.width, this.y + this.height, -16777216);
        }
        int n2 = this.isEditable ? this.textColor : this.textColorUneditable;
        int n3 = this.cursorPos - this.displayPos;
        int n4 = this.highlightPos - this.displayPos;
        String string = this.font.a(this.value.substring(this.displayPos), this.getInnerWidth());
        boolean bl2 = n3 >= 0 && n3 <= string.length();
        boolean bl3 = this.inFocus && this.frame / 6 % 2 == 0 && bl2;
        int n5 = this.bordered ? this.x + 4 : this.x;
        int n6 = this.bordered ? this.y + (this.height - 8) / 2 : this.y;
        int n7 = n5;
        if (n4 > string.length()) {
            n4 = string.length();
        }
        if (string.length() > 0) {
            String string2 = bl2 ? string.substring(0, n3) : string;
            n7 = this.font.a(string2, n7, n6, n2);
        }
        boolean bl4 = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
        int n8 = n7;
        if (!bl2) {
            n8 = n3 > 0 ? n5 + this.width : n5;
        } else if (bl4) {
            --n8;
            --n7;
        }
        if (string.length() > 0 && bl2 && n3 < string.length()) {
            n7 = this.font.a(string.substring(n3), n7, n6, n2);
        }
        if (bl3) {
            if (bl4) {
                bbw.a(n8, n6 - 1, n8 + 1, n6 + 1 + this.font.a, -3092272);
            } else {
                this.font.a(CURSOR_APPEND_CHARACTER, n8, n6, n2);
            }
        }
        if (n4 != n3) {
            int n9 = n5 + this.font.a(string.substring(0, n4));
            this.renderHighlight(n8, n6 - 1, n9 - 1, n6 + 1 + this.font.a);
        }
    }

    private void renderHighlight(int n2, int n3, int n4, int n5) {
        int n6;
        if (n2 < n4) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        if (n3 < n5) {
            n6 = n3;
            n3 = n5;
            n5 = n6;
        }
        if (n4 > this.x + this.width) {
            n4 = this.x + this.width;
        }
        if (n2 > this.x + this.width) {
            n2 = this.x + this.width;
        }
        bmh bmh2 = bmh.a;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        bmh2.b();
        bmh2.a((double)n2, (double)n5, 0.0);
        bmh2.a((double)n4, (double)n5, 0.0);
        bmh2.a((double)n4, (double)n3, 0.0);
        bmh2.a((double)n2, (double)n3, 0.0);
        bmh2.a();
        GL11.glDisable((int)3058);
        GL11.glEnable((int)3553);
    }

    public void setMaxLength(int n2) {
        this.maxLength = n2;
        if (this.value.length() > n2) {
            this.value = this.value.substring(0, n2);
        }
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean bl2) {
        this.bordered = bl2;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int n2) {
        this.textColor = n2;
    }

    public int getTextColorUneditable() {
        return this.textColorUneditable;
    }

    public void setTextColorUneditable(int n2) {
        this.textColorUneditable = n2;
    }

    public void setFocus(boolean bl2) {
        if (bl2 && !this.inFocus) {
            this.frame = 0;
        }
        this.inFocus = bl2;
    }

    public boolean isFocused() {
        return this.inFocus;
    }

    public boolean isIsEditable() {
        return this.isEditable;
    }

    public void setIsEditable(boolean bl2) {
        this.isEditable = bl2;
    }

    public int getHighlightPos() {
        return this.highlightPos;
    }

    public int getInnerWidth() {
        return this.isBordered() ? this.width - 8 : this.width;
    }

    public void setHighlightPos(int n2) {
        int n3 = this.value.length();
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.highlightPos = n2;
        if (this.font != null) {
            if (this.displayPos > n3) {
                this.displayPos = n3;
            }
            int n4 = this.getInnerWidth();
            String string = this.font.a(this.value.substring(this.displayPos), n4);
            int n5 = string.length() + this.displayPos;
            if (n2 == this.displayPos) {
                this.displayPos -= this.font.a(this.value, n4, true).length();
            }
            if (n2 > n5) {
                this.displayPos += n2 - n5;
            } else if (n2 <= this.displayPos) {
                this.displayPos -= this.displayPos - n2;
            }
            if (this.displayPos < 0) {
                this.displayPos = 0;
            }
            if (this.displayPos > n3) {
                this.displayPos = n3;
            }
        }
    }

    public boolean isCanLoseFocus() {
        return this.canLoseFocus;
    }

    public void setCanLoseFocus(boolean bl2) {
        this.canLoseFocus = bl2;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl2) {
        this.visible = bl2;
    }
}

