/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary.panels;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.armourer.tab.GuiTabArmourerMain;
import moe.plushie.armourers_workshop.client.gui.controls.GuiDropDownList;
import moe.plushie.armourers_workshop.client.gui.controls.GuiLabeledTextField;
import moe.plushie.armourers_workshop.client.gui.controls.GuiPanel;
import moe.plushie.armourers_workshop.client.gui.globallibrary.GuiGlobalLibrary;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskSkinSearch;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGlobalLibraryPanelSearchBox
extends GuiPanel
implements GuiDropDownList.IDropDownListCallback {
    private static final String ARROW_UP = "\u2191";
    private static final String ARROW_DOWN = "\u2193";
    private GuiLabeledTextField searchTextbox;
    private GuiDropDownList dropDownSkinType;
    private GuiDropDownList dropDownSort;
    public static ISkinType selectedSkinType;
    public static GlobalTaskSkinSearch.SearchColumnType searchColumnType;
    public static GlobalTaskSkinSearch.SearchOrderType searchOrderType;

    public GuiGlobalLibraryPanelSearchBox(GuiGlobalLibrary parent, int x, int y, int width, int height) {
        super((GuiScreen)parent, x, y, width, height);
    }

    @Override
    public void initGui() {
        super.initGui();
        String guiName = ((GuiGlobalLibrary)this.parent).getGuiName();
        this.buttonList.clear();
        this.searchTextbox = new GuiLabeledTextField(this.fontRenderer, this.x + 5, this.y + 5, this.width - 10 - 180 - 70 - 5, 12);
        this.searchTextbox.setEmptyLabel(GuiHelper.getLocalizedControlName(guiName, "searchBox.typeToSearch", new Object[0]));
        this.buttonList.add(new GuiButtonExt(0, this.x + this.width - 85, this.y + 3, 80, 16, GuiHelper.getLocalizedControlName(guiName, "searchBox.search", new Object[0])));
        SkinTypeRegistry str = SkinTypeRegistry.INSTANCE;
        this.dropDownSkinType = new GuiDropDownList(1, this.x + this.width - 160, this.y + 4, 70, "", this);
        ArrayList<ISkinType> skinList = str.getRegisteredSkinTypes();
        this.dropDownSkinType.addListItem("*", "*", true);
        for (int i = 0; i < skinList.size(); ++i) {
            ISkinType skinType = skinList.get(i);
            if (skinType.isHidden()) continue;
            String skinLocalizedName = str.getLocalizedSkinTypeName(skinType);
            String skinRegistryName = skinType.getRegistryName();
            GuiTabArmourerMain.DropDownItemSkin item = new GuiTabArmourerMain.DropDownItemSkin(skinLocalizedName, skinRegistryName, skinType.enabled(), skinType);
            this.dropDownSkinType.addListItem(item);
            if (skinType != selectedSkinType) continue;
            this.dropDownSkinType.setListSelectedIndex(i + 1);
        }
        this.buttonList.add(this.dropDownSkinType);
        this.dropDownSort = new GuiDropDownList(-1, this.x + this.width - 180 - 70 - 5, this.y + 4, 90, "", this);
        GlobalTaskSkinSearch.SearchColumnType[] columnTypes = new GlobalTaskSkinSearch.SearchColumnType[]{GlobalTaskSkinSearch.SearchColumnType.DATE_CREATED, GlobalTaskSkinSearch.SearchColumnType.NAME, GlobalTaskSkinSearch.SearchColumnType.DOWNLOADS, GlobalTaskSkinSearch.SearchColumnType.RATING};
        for (int i = 0; i < columnTypes.length; ++i) {
            GlobalTaskSkinSearch.SearchColumnType columnType = columnTypes[i];
            this.dropDownSort.addListItem("\u2191 " + I18n.func_135052_a((String)columnType.getLangKey(), (Object[])new Object[0]), columnType.toString(), true);
            this.dropDownSort.addListItem("\u2193 " + I18n.func_135052_a((String)columnType.getLangKey(), (Object[])new Object[0]), columnType.toString(), true);
            if (columnType != searchColumnType) continue;
            this.dropDownSort.setListSelectedIndex(i * 2);
            if (searchOrderType != GlobalTaskSkinSearch.SearchOrderType.ASC) continue;
            this.dropDownSort.setListSelectedIndex(i * 2 + 1);
        }
        this.buttonList.add(this.dropDownSort);
    }

    public void updateDropDowns(GlobalTaskSkinSearch.SearchColumnType searchOrderColumn, GlobalTaskSkinSearch.SearchOrderType searchOrder) {
        searchColumnType = searchOrderColumn;
        searchOrderType = searchOrder;
        this.dropDownSort.clearList();
        GlobalTaskSkinSearch.SearchColumnType[] columnTypes = new GlobalTaskSkinSearch.SearchColumnType[]{GlobalTaskSkinSearch.SearchColumnType.DATE_CREATED, GlobalTaskSkinSearch.SearchColumnType.NAME, GlobalTaskSkinSearch.SearchColumnType.DOWNLOADS, GlobalTaskSkinSearch.SearchColumnType.RATING};
        for (int i = 0; i < columnTypes.length; ++i) {
            GlobalTaskSkinSearch.SearchColumnType columnType = columnTypes[i];
            this.dropDownSort.addListItem("\u2191 " + I18n.func_135052_a((String)columnType.getLangKey(), (Object[])new Object[0]), columnType.toString(), true);
            this.dropDownSort.addListItem("\u2193 " + I18n.func_135052_a((String)columnType.getLangKey(), (Object[])new Object[0]), columnType.toString(), true);
            if (columnType != searchColumnType) continue;
            this.dropDownSort.setListSelectedIndex(i * 2);
            if (searchOrderType != GlobalTaskSkinSearch.SearchOrderType.ASC) continue;
            this.dropDownSort.setListSelectedIndex(i * 2 + 1);
        }
    }

    @Override
    public void onDropDownListChanged(GuiDropDownList dropDownList) {
        GuiDropDownList.DropDownListItem listItem;
        if (dropDownList == this.dropDownSkinType) {
            listItem = dropDownList.getListSelectedItem();
            selectedSkinType = listItem.tag.equals("*") ? null : SkinTypeRegistry.INSTANCE.getSkinTypeFromRegistryName(listItem.tag);
        }
        if (dropDownList == this.dropDownSort) {
            listItem = dropDownList.getListSelectedItem();
            searchColumnType = GlobalTaskSkinSearch.SearchColumnType.valueOf(listItem.tag);
            if (listItem.displayText.startsWith(ARROW_UP)) {
                searchOrderType = GlobalTaskSkinSearch.SearchOrderType.DESC;
            }
            if (listItem.displayText.startsWith(ARROW_DOWN)) {
                searchOrderType = GlobalTaskSkinSearch.SearchOrderType.ASC;
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (!this.visible | !this.enabled) {
            return false;
        }
        boolean clicked = super.mouseClicked(mouseX, mouseY, button);
        if (!clicked) {
            clicked = this.searchTextbox.func_146192_a(mouseX, mouseY, button);
            if (button == 1) {
                if (this.searchTextbox.func_146206_l()) {
                    this.searchTextbox.func_146180_a("");
                }
                return true;
            }
        }
        return clicked;
    }

    @Override
    public boolean keyTyped(char c, int keycode) {
        if (!this.visible | !this.enabled) {
            return false;
        }
        boolean pressed = this.searchTextbox.func_146201_a(c, keycode);
        if (keycode == 28) {
            this.doSearch();
        }
        return pressed;
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.doSearch();
        }
    }

    private void doSearch() {
        ((GuiGlobalLibrary)this.parent).panelSearchResults.clearResults();
        String search = this.searchTextbox.func_146179_b();
        ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.SEARCH);
        ((GuiGlobalLibrary)this.parent).panelSearchResults.doSearch(search, selectedSkinType, searchColumnType, searchOrderType);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTickTime) {
        if (!this.visible) {
            return;
        }
        this.func_73733_a(this.x, this.y, this.x + this.width, this.y + this.height, -1072689136, -804253680);
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTickTime) {
        if (!this.visible) {
            return;
        }
        super.draw(mouseX, mouseY, partialTickTime);
        this.searchTextbox.func_146194_f();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY, float partialTickTime) {
        this.dropDownSkinType.drawForeground(this.mc, mouseX, mouseY, partialTickTime);
        this.dropDownSort.drawForeground(this.mc, mouseX, mouseY, partialTickTime);
    }

    static {
        searchColumnType = GlobalTaskSkinSearch.SearchColumnType.DATE_CREATED;
        searchOrderType = GlobalTaskSkinSearch.SearchOrderType.DESC;
    }
}

