/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.crafting.recipe;

import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.common.addons.ModAddonManager;
import moe.plushie.armourers_workshop.common.crafting.recipe.RecipeItemSkinning;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RecipeSkinItem
extends RecipeItemSkinning {
    private final ModAddonManager.ItemOverrideType overrideType;

    public RecipeSkinItem(ISkinType skinType, ModAddonManager.ItemOverrideType overrideType) {
        super(skinType);
        this.overrideType = overrideType;
    }

    @Override
    public boolean matches(IInventory inventory) {
        return !this.getCraftingResult(inventory).func_190926_b();
    }

    @Override
    public ItemStack getCraftingResult(IInventory inventory) {
        ItemStack skinStack = ItemStack.field_190927_a;
        ItemStack itemStack = ItemStack.field_190927_a;
        for (int slotId = 0; slotId < inventory.func_70302_i_(); ++slotId) {
            ItemStack stack = inventory.func_70301_a(slotId);
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (this.isValidSkinForType(stack)) {
                if (!skinStack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                skinStack = stack;
                continue;
            }
            if (ModAddonManager.isOverrideItem(this.overrideType, item)) {
                if (!itemStack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                itemStack = stack;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (!skinStack.func_190926_b() && !itemStack.func_190926_b()) {
            ItemStack returnStack = itemStack.func_77946_l();
            SkinDescriptor skinData = SkinNBTHelper.getSkinDescriptorFromStack(skinStack);
            SkinNBTHelper.addSkinDataToStack(returnStack, skinData.getIdentifier(), skinData.getSkinDye());
            return returnStack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void onCraft(IInventory inventory) {
        for (int slotId = 0; slotId < inventory.func_70302_i_(); ++slotId) {
            inventory.func_70298_a(slotId, 1);
        }
    }
}

