/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.items.paintingtool;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.painting.IPaintingTool;
import moe.plushie.armourers_workshop.api.common.painting.IPantable;
import moe.plushie.armourers_workshop.api.common.painting.IPantableBlock;
import moe.plushie.armourers_workshop.common.init.blocks.ModBlocks;
import moe.plushie.armourers_workshop.common.init.items.AbstractModItem;
import moe.plushie.armourers_workshop.common.init.sounds.ModSounds;
import moe.plushie.armourers_workshop.common.lib.EnumGuiId;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiToolOptionUpdate;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.painting.PaintingHelper;
import moe.plushie.armourers_workshop.common.painting.tool.IConfigurableTool;
import moe.plushie.armourers_workshop.common.painting.tool.ToolOption;
import moe.plushie.armourers_workshop.common.painting.tool.ToolOptions;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColourPicker
extends AbstractModItem
implements IPaintingTool,
IConfigurableTool {
    public ItemColourPicker() {
        super("colour-picker");
        this.func_77637_a(ArmourersWorkshop.TAB_PAINTING_TOOLS);
        this.setSortPriority(12);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        IPaintType paintType = PaintingHelper.getToolPaintType(stack);
        return paintType != PaintTypeRegistry.PAINT_TYPE_NORMAL;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        ItemStack stack = player.func_184586_b(hand);
        boolean changePaintType = (Boolean)ToolOptions.CHANGE_PAINT_TYPE.getValue(stack);
        IPaintType paintType = this.getToolPaintType(stack);
        if (player.func_70093_af() & state.func_177230_c() == ModBlocks.COLOUR_MIXER & this.getToolHasColour(stack)) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te != null && te instanceof IPantable && !worldIn.field_72995_K) {
                int colour = this.getToolColour(stack);
                ((IPantable)te).setColour(colour);
                ((IPantable)te).setPaintType(paintType, 0);
            }
            return EnumActionResult.SUCCESS;
        }
        if (state.func_177230_c() instanceof IPantableBlock) {
            IPantableBlock paintable = (IPantableBlock)state.func_177230_c();
            IPaintType targetPaintType = paintable.getPaintType((IBlockAccess)worldIn, pos, facing);
            if (paintable.isRemoteOnly((IBlockAccess)worldIn, pos, facing) & worldIn.field_72995_K) {
                int colour = paintable.getColour((IBlockAccess)worldIn, pos, facing);
                NBTTagCompound compound = new NBTTagCompound();
                byte[] paintData = new byte[4];
                Color c = new Color(colour);
                paintData[0] = (byte)c.getRed();
                paintData[1] = (byte)c.getGreen();
                paintData[2] = (byte)c.getBlue();
                paintData[3] = changePaintType ? (byte)targetPaintType.getId() : (byte)paintType.getId();
                PaintingHelper.setPaintData(compound, paintData);
                PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientGuiToolOptionUpdate(compound));
            } else if (!paintable.isRemoteOnly((IBlockAccess)worldIn, pos, facing) & !worldIn.field_72995_K) {
                this.setToolColour(stack, ((IPantableBlock)state.func_177230_c()).getColour((IBlockAccess)worldIn, pos, facing));
                if (changePaintType) {
                    this.setToolPaintType(stack, targetPaintType);
                } else {
                    this.setToolPaintType(stack, paintType);
                }
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_184133_a(null, pos, (SoundEvent)ModSounds.PICKER, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.getToolHasColour(stack)) {
            Color c = new Color(this.getToolColour(stack));
            IPaintType paintType = this.getToolPaintType(stack);
            String hex = String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
            tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.colour", c.getRGB()));
            tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.hex", hex));
            tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.paintType", paintType.getLocalizedName()));
        } else {
            tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.nopaint"));
        }
        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.openSettings"));
    }

    @Override
    public boolean getToolHasColour(ItemStack stack) {
        return PaintingHelper.getToolHasPaint(stack);
    }

    @Override
    public int getToolColour(ItemStack stack) {
        return PaintingHelper.getToolPaintColourRGB(stack);
    }

    @Override
    public void setToolColour(ItemStack stack, int colour) {
        PaintingHelper.setToolPaintColour(stack, colour);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn.func_70093_af()) {
            if (worldIn.field_72995_K) {
                playerIn.openGui((Object)ArmourersWorkshop.getInstance(), EnumGuiId.TOOL_OPTIONS.ordinal(), worldIn, 0, 0, 0);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public void getToolOptions(ArrayList<ToolOption<?>> toolOptionList) {
        toolOptionList.add(ToolOptions.CHANGE_PAINT_TYPE);
    }

    @Override
    public void setToolPaintType(ItemStack stack, IPaintType paintType) {
        PaintingHelper.setToolPaint(stack, paintType);
    }

    @Override
    public IPaintType getToolPaintType(ItemStack stack) {
        return PaintingHelper.getToolPaintType(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (ItemColourPicker.this.getToolHasColour(stack)) {
                    return new ModelResourceLocation(new ResourceLocation("armourers_workshop", ItemColourPicker.this.func_77658_a()), "inventory");
                }
                return new ModelResourceLocation(new ResourceLocation("armourers_workshop", ItemColourPicker.this.func_77658_a() + "-empty"), "inventory");
            }
        });
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_77658_a()), "inventory"), new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_77658_a() + "-empty"), "inventory")});
    }
}

