/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.items.paintingtool;

import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.painting.IPantableBlock;
import moe.plushie.armourers_workshop.common.init.blocks.ModBlocks;
import moe.plushie.armourers_workshop.common.init.items.paintingtool.AbstractPaintingTool;
import moe.plushie.armourers_workshop.common.init.sounds.ModSounds;
import moe.plushie.armourers_workshop.common.painting.tool.IConfigurableTool;
import moe.plushie.armourers_workshop.common.painting.tool.ToolOption;
import moe.plushie.armourers_workshop.common.painting.tool.ToolOptions;
import moe.plushie.armourers_workshop.common.world.undo.UndoManager;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPaintRoller
extends AbstractPaintingTool
implements IConfigurableTool {
    public ItemPaintRoller() {
        super("paint-roller");
        this.setSortPriority(19);
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        ItemStack stack = player.func_184586_b(hand);
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public void onPaint(ItemStack stack, EntityPlayer player, World world, BlockPos pos, Block block, EnumFacing usedFace) {
        this.paintArea(world, player, block, stack, pos, usedFace);
    }

    private void paintArea(World world, EntityPlayer player, Block targetBlock, ItemStack stack, BlockPos pos, EnumFacing face) {
        int radius = (Integer)ToolOptions.RADIUS.getValue(stack);
        for (int i = -radius + 1; i < radius; ++i) {
            for (int j = -radius + 1; j < radius; ++j) {
                BlockPos target = pos;
                switch (face) {
                    case DOWN: {
                        target = pos.func_177982_a(j, 0, i);
                        break;
                    }
                    case UP: {
                        target = pos.func_177982_a(j, 0, i);
                        break;
                    }
                    case NORTH: {
                        target = pos.func_177982_a(i, j, 0);
                        break;
                    }
                    case SOUTH: {
                        target = pos.func_177982_a(i, j, 0);
                        break;
                    }
                    case WEST: {
                        target = pos.func_177982_a(0, i, j);
                        break;
                    }
                    case EAST: {
                        target = pos.func_177982_a(0, i, j);
                    }
                }
                Block block = world.func_180495_p(target).func_177230_c();
                if (!(targetBlock != ModBlocks.BOUNDING_BOX & block != ModBlocks.BOUNDING_BOX | targetBlock == ModBlocks.BOUNDING_BOX & block == ModBlocks.BOUNDING_BOX)) continue;
                this.usedOnBlockSide(stack, player, world, target, block, face, true);
            }
        }
    }

    @Override
    public void playToolSound(EntityPlayer player, World world, BlockPos pos, ItemStack stack) {
        world.func_184133_a(null, pos, (SoundEvent)ModSounds.PAINT, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public void usedOnBlockSide(ItemStack stack, EntityPlayer player, World world, BlockPos pos, Block block, EnumFacing facing, boolean spawnParticles) {
        boolean fullBlock = false;
        if (this instanceof IConfigurableTool) {
            ArrayList toolOptionList = new ArrayList();
            this.getToolOptions(toolOptionList);
            if (toolOptionList.contains(ToolOptions.FULL_BLOCK_MODE)) {
                fullBlock = (Boolean)ToolOptions.FULL_BLOCK_MODE.getValue(stack);
            }
        }
        if (block instanceof IPantableBlock) {
            int newColour = this.getToolColour(stack);
            IPaintType paintType = this.getToolPaintType(stack);
            if (!world.field_72995_K) {
                IPantableBlock worldColourable = (IPantableBlock)block;
                if (fullBlock) {
                    for (int i = 0; i < 6; ++i) {
                        int oldColour = worldColourable.getColour((IBlockAccess)world, pos, EnumFacing.field_82609_l[i]);
                        byte oldPaintType = (byte)worldColourable.getPaintType((IBlockAccess)world, pos, EnumFacing.field_82609_l[i]).getId();
                        UndoManager.blockPainted(player, world, pos, oldColour, oldPaintType, EnumFacing.field_82609_l[i]);
                        ((IPantableBlock)block).setColour((IBlockAccess)world, pos, newColour, EnumFacing.field_82609_l[i]);
                        ((IPantableBlock)block).setPaintType((IBlockAccess)world, pos, paintType, EnumFacing.field_82609_l[i]);
                    }
                } else {
                    int oldColour = worldColourable.getColour((IBlockAccess)world, pos, facing);
                    byte oldPaintType = (byte)worldColourable.getPaintType((IBlockAccess)world, pos, facing).getId();
                    UndoManager.blockPainted(player, world, pos, oldColour, oldPaintType, facing);
                    ((IPantableBlock)block).setColour((IBlockAccess)world, pos, newColour, facing);
                    ((IPantableBlock)block).setPaintType((IBlockAccess)world, pos, paintType, facing);
                }
            } else if (spawnParticles) {
                this.spawnPaintParticles(world, pos, facing, newColour);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int radius = (Integer)ToolOptions.RADIUS.getValue(stack);
        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.area", radius * 2 - 1, radius * 2 - 1, 1));
        this.addOpenSettingsInformation(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public void getToolOptions(ArrayList<ToolOption<?>> toolOptionList) {
        toolOptionList.add(ToolOptions.FULL_BLOCK_MODE);
        toolOptionList.add(ToolOptions.RADIUS);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (((Boolean)ToolOptions.FULL_BLOCK_MODE.getValue(stack)).booleanValue()) {
                    return new ModelResourceLocation(new ResourceLocation("armourers_workshop", ItemPaintRoller.this.func_77658_a()), "normal");
                }
                return new ModelResourceLocation(new ResourceLocation("armourers_workshop", ItemPaintRoller.this.func_77658_a() + "-small"), "normal");
            }
        });
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_77658_a()), "normal"), new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_77658_a() + "-small"), "normal")});
    }
}

