/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.painting;

import java.awt.Color;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.capability.IWardrobeCap;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.common.capability.wardrobe.WardrobeCap;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PaintingHelper {
    private static final String TAG_TOOL_PAINT = "toolPaint";

    public static boolean getToolHasPaint(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        return compound != null && compound.func_74764_b(TAG_TOOL_PAINT);
    }

    public static void setToolPaintColour(ItemStack stack, byte[] rgb) {
        byte[] rgbt = PaintingHelper.getToolPaintData(stack);
        rgbt[0] = rgb[0];
        rgbt[1] = rgb[1];
        rgbt[2] = rgb[2];
        PaintingHelper.setToolPaintData(stack, rgbt);
    }

    public static void setToolPaintColour(ItemStack stack, int colour) {
        byte[] rgbt = PaintingHelper.getToolPaintData(stack);
        Color c = new Color(colour);
        rgbt[0] = (byte)c.getRed();
        rgbt[1] = (byte)c.getGreen();
        rgbt[2] = (byte)c.getBlue();
        PaintingHelper.setToolPaintData(stack, rgbt);
    }

    public static byte[] getToolPaintColourArray(ItemStack stack) {
        byte[] rgbt = PaintingHelper.getToolPaintData(stack);
        return new byte[]{rgbt[0], rgbt[1], rgbt[2]};
    }

    public static int getToolPaintColourRGB(ItemStack stack) {
        return PaintingHelper.getToolPaintColour(stack).getRGB();
    }

    public static Color getToolPaintColour(ItemStack stack) {
        byte[] rgbt = PaintingHelper.getToolPaintData(stack);
        return new Color(rgbt[0] & 0xFF, rgbt[1] & 0xFF, rgbt[2] & 0xFF, 255);
    }

    public static int getToolDisplayColourRGB(ItemStack stack) {
        return PaintingHelper.getToolDisplayColour(stack).getRGB();
    }

    public static Color getToolDisplayColour(ItemStack stack) {
        byte[] rgbt = PaintingHelper.getToolPaintData(stack);
        IPaintType paintType = PaintTypeRegistry.getInstance().getPaintTypeFormByte(rgbt[3]);
        if (paintType == PaintTypeRegistry.PAINT_TYPE_RAINBOW) {
            return PaintingHelper.getRainbowColour();
        }
        if (paintType == PaintTypeRegistry.PAINT_TYPE_PULSE_1) {
            return PaintingHelper.getPulse1Colour(rgbt);
        }
        if (paintType == PaintTypeRegistry.PAINT_TYPE_PULSE_2) {
            return PaintingHelper.getPulse2Colour(rgbt);
        }
        return new Color(rgbt[0] & 0xFF, rgbt[1] & 0xFF, rgbt[2] & 0xFF, 255);
    }

    public static void setToolPaint(ItemStack stack, IPaintType paintType) {
        byte[] rgbt = PaintingHelper.getToolPaintData(stack);
        rgbt[3] = (byte)paintType.getId();
        PaintingHelper.setToolPaintData(stack, rgbt);
    }

    public static IPaintType getToolPaintType(ItemStack stack) {
        byte[] rgbt = PaintingHelper.getToolPaintData(stack);
        return PaintTypeRegistry.getInstance().getPaintTypeFormByte(rgbt[3]);
    }

    public static byte[] getToolPaintData(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_150297_b(TAG_TOOL_PAINT, 7)) {
            return compound.func_74770_j(TAG_TOOL_PAINT);
        }
        return PaintingHelper.getBlankPaintData();
    }

    public static void setToolPaintData(ItemStack stack, byte[] paintData) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        compound.func_74773_a(TAG_TOOL_PAINT, paintData);
        stack.func_77982_d(compound);
    }

    public static void setPaintData(NBTTagCompound compound, byte[] paintData) {
        compound.func_74773_a(TAG_TOOL_PAINT, paintData);
    }

    public static byte[] getBlankRGBColour() {
        return new byte[]{-1, -1, -1};
    }

    public static byte[] getBlankPaintData() {
        return new byte[]{-1, -1, -1, -1};
    }

    public static byte[] intToBytes(int trgb) {
        int t = 0xFF & trgb >> 24;
        int r = 0xFF & trgb >> 16;
        int g = 0xFF & trgb >> 8;
        int b = 0xFF & trgb >> 0;
        return new byte[]{(byte)r, (byte)g, (byte)b, (byte)t};
    }

    public static int bytesToInt(byte[] rgbt) {
        return (rgbt[3] & 0xFF) << 24 | (rgbt[0] & 0xFF) << 16 | (rgbt[1] & 0xFF) << 8 | rgbt[2] & 0xFF;
    }

    public static double getPaintTextureOffset() {
        double f = (double)(System.currentTimeMillis() % 6375L) / 25.0;
        return Math.round(f);
    }

    private static Color getRainbowColour() {
        float f = (float)(System.currentTimeMillis() % 6375L) / 25.0f;
        return new Color(Color.HSBtoRGB(f / 255.0f, 1.0f, 1.0f));
    }

    private static Color getPulse1Colour(byte[] rgbt) {
        float f = (float)((double)System.currentTimeMillis() % 6375.0) / 25.0f;
        if ((f *= 2.0f) > 255.0f) {
            f = 255.0f - (f - 255.0f);
        }
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)255.0f);
        float[] hsb = Color.RGBtoHSB(rgbt[0] & 0xFF, rgbt[1] & 0xFF, rgbt[2] & 0xFF, null);
        return new Color(Color.HSBtoRGB(hsb[0], hsb[1], f / 255.0f));
    }

    private static Color getPulse2Colour(byte[] rgbt) {
        float f = (float)((double)System.currentTimeMillis() % 3187.5) / 12.5f;
        if ((f *= 2.0f) > 255.0f) {
            f = 255.0f - (f - 255.0f);
        }
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)255.0f);
        float[] hsb = Color.RGBtoHSB(rgbt[0] & 0xFF, rgbt[1] & 0xFF, rgbt[2] & 0xFF, null);
        return new Color(Color.HSBtoRGB(hsb[0], hsb[1], f / 255.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public static IExtraColours getLocalPlayerExtraColours() {
        IWardrobeCap wardrobeCapability = WardrobeCap.get((Entity)Minecraft.func_71410_x().field_71439_g);
        if (wardrobeCapability != null) {
            return wardrobeCapability.getExtraColours();
        }
        return null;
    }
}

