/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.tileentities;

import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.client.gui.skinlibrary.GuiSkinLibrary;
import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.init.blocks.BlockSkinLibrary;
import moe.plushie.armourers_workshop.common.init.blocks.ModBlocks;
import moe.plushie.armourers_workshop.common.init.items.ItemSkin;
import moe.plushie.armourers_workshop.common.init.items.ItemSkinTemplate;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.inventory.ContainerSkinLibrary;
import moe.plushie.armourers_workshop.common.inventory.IGuiFactory;
import moe.plushie.armourers_workshop.common.library.ILibraryManager;
import moe.plushie.armourers_workshop.common.library.LibraryFile;
import moe.plushie.armourers_workshop.common.library.LibraryFileType;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.server.MessageServerLibrarySendSkin;
import moe.plushie.armourers_workshop.common.skin.ISkinHolder;
import moe.plushie.armourers_workshop.common.skin.cache.CommonSkinCache;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.common.skin.data.SkinIdentifier;
import moe.plushie.armourers_workshop.common.tileentities.AbstractTileEntityInventory;
import moe.plushie.armourers_workshop.utils.ModLogger;
import moe.plushie.armourers_workshop.utils.SkinIOUtils;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySkinLibrary
extends AbstractTileEntityInventory
implements ISidedInventory,
IGuiFactory {
    private static final int INVENTORY_SIZE = 2;

    public TileEntitySkinLibrary() {
        super(2);
    }

    @Override
    public String func_70005_c_() {
        return "skin-library";
    }

    public boolean isCreativeLibrary() {
        IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (blockState.func_177230_c() == ModBlocks.SKIN_LIBRARY) {
            return blockState.func_177229_b(BlockSkinLibrary.STATE_TYPE) == BlockSkinLibrary.EnumLibraryType.CREATIVE;
        }
        return false;
    }

    public void saveSkin(String fileName, String filePath, EntityPlayerMP player, boolean publicFiles) {
        Skin skin;
        ItemStack stackInput = this.func_70301_a(0);
        ItemStack stackOutput = this.func_70301_a(1);
        if (stackInput.func_190926_b()) {
            return;
        }
        if (!stackOutput.func_190926_b()) {
            return;
        }
        if (!(stackInput.func_77973_b() instanceof ItemSkin)) {
            return;
        }
        if (!SkinNBTHelper.stackHasSkinData(stackInput)) {
            return;
        }
        SkinDescriptor skinPointer = SkinNBTHelper.getSkinDescriptorFromStack(stackInput);
        if (skinPointer == null) {
            return;
        }
        if (!publicFiles) {
            // empty if block
        }
        if ((skin = CommonSkinCache.INSTANCE.getSkin(skinPointer)) == null) {
            ModLogger.log("no input");
            return;
        }
        filePath = SkinIOUtils.makeFilePathValid(filePath);
        fileName = SkinIOUtils.makeFileNameValid(fileName);
        LibraryFile file = new LibraryFile(fileName, filePath, skin.getSkinType());
        ModLogger.log("User " + player.func_70005_c_() + " is saving a skin to \"" + file.getFullName() + "\".");
        ILibraryManager libraryManager = ArmourersWorkshop.getProxy().libraryManager;
        CommonSkinCache.INSTANCE.clearFileNameIdLink(file);
        if (!SkinIOUtils.saveSkinFromFileName(filePath, fileName + ".armour", skin)) {
            return;
        }
        if (ArmourersWorkshop.isDedicated()) {
            if (publicFiles) {
                libraryManager.addFileToListType(new LibraryFile(fileName, filePath, skin.getSkinType()), LibraryFileType.SERVER_PUBLIC, (EntityPlayer)player);
            } else {
                libraryManager.addFileToListType(new LibraryFile(fileName, filePath, skin.getSkinType()), LibraryFileType.SERVER_PRIVATE, (EntityPlayer)player);
            }
        } else {
            libraryManager.addFileToListType(new LibraryFile(fileName, filePath, skin.getSkinType()), LibraryFileType.LOCAL, (EntityPlayer)player);
        }
        this.func_70298_a(0, 1);
        this.func_70299_a(1, stackInput);
    }

    public void loadSkin(String fileName, String filePath, EntityPlayerMP player, boolean trackFile) {
        ItemStack stackInput = this.func_70301_a(0);
        ItemStack stackOutput = this.func_70301_a(1);
        if (this.isCreativeLibrary() && stackInput.func_190926_b()) {
            stackInput = new ItemStack(ModItems.SKIN_TEMPLATE);
        }
        if (stackInput.func_190926_b()) {
            return;
        }
        if (!stackOutput.func_190926_b()) {
            return;
        }
        if (!(stackInput.func_77973_b() instanceof ISkinHolder)) {
            return;
        }
        String fullFileName = fileName;
        Skin skin = SkinIOUtils.loadSkinFromFileName(filePath + fileName + ".armour");
        if (skin == null) {
            return;
        }
        LibraryFile libraryFile = new LibraryFile(fileName, filePath, skin.getSkinType());
        SkinIdentifier identifier = null;
        identifier = trackFile ? new SkinIdentifier(0, libraryFile, 0, skin.getSkinType()) : new SkinIdentifier(skin.lightHash(), null, 0, skin.getSkinType());
        CommonSkinCache.INSTANCE.addEquipmentDataToCache(skin, libraryFile);
        ModLogger.log("Loaded file form lib: " + libraryFile.toString().replace("%", ""));
        ItemStack stackArmour = ((ISkinHolder)stackInput.func_77973_b()).makeSkinStack(identifier);
        if (stackArmour.func_190926_b()) {
            return;
        }
        if (!this.isCreativeLibrary()) {
            this.func_70298_a(0, 1);
        }
        this.func_70299_a(1, stackArmour);
    }

    public void sendSkinToClient(String filename, String filePath, EntityPlayerMP player) {
        if (!ConfigHandler.allowDownloadingSkins) {
            return;
        }
        ItemStack stackInput = this.func_70301_a(0);
        ItemStack stackOutput = this.func_70301_a(1);
        if (stackInput.func_190926_b()) {
            return;
        }
        if (!stackOutput.func_190926_b()) {
            return;
        }
        if (!(stackInput.func_77973_b() instanceof ItemSkin)) {
            return;
        }
        if (!SkinNBTHelper.stackHasSkinData(stackInput)) {
            return;
        }
        SkinDescriptor skinPointer = SkinNBTHelper.getSkinDescriptorFromStack(stackInput);
        Skin skin = CommonSkinCache.INSTANCE.getSkin(skinPointer);
        if (skin == null) {
            return;
        }
        LibraryFile file = new LibraryFile(filename, filePath, skin.getSkinType());
        MessageServerLibrarySendSkin message = new MessageServerLibrarySendSkin(filename, filePath, skin, MessageServerLibrarySendSkin.SendType.LIBRARY_SAVE);
        PacketHandler.networkWrapper.sendTo((IMessage)message, player);
        this.func_70298_a(0, 1);
        this.func_70299_a(1, stackInput);
    }

    public void loadClientSkin(Skin skin, EntityPlayerMP player) {
        ItemStack stackInput = this.func_70301_a(0);
        ItemStack stackOutput = this.func_70301_a(1);
        if (this.isCreativeLibrary() && stackInput.func_190926_b()) {
            stackInput = new ItemStack(ModItems.SKIN_TEMPLATE);
        }
        if (stackInput.func_190926_b()) {
            return;
        }
        if (!stackOutput.func_190926_b()) {
            return;
        }
        if (!(stackInput.func_77973_b() instanceof ISkinHolder)) {
            return;
        }
        CommonSkinCache.INSTANCE.addEquipmentDataToCache(skin, null);
        ItemStack stackArmour = ((ISkinHolder)stackInput.func_77973_b()).makeSkinStack(skin);
        if (stackArmour.func_190926_b()) {
            return;
        }
        if (!this.isCreativeLibrary()) {
            this.func_70298_a(0, 1);
        }
        this.func_70299_a(1, stackArmour);
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] slots = new int[]{0, 1};
        return slots;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        if (index != 0) {
            return false;
        }
        if (itemStackIn.func_77973_b() instanceof ItemSkinTemplate && itemStackIn.func_77952_i() == 0) {
            return true;
        }
        return itemStackIn.func_77973_b() instanceof ItemSkin;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, World world, BlockPos pos) {
        return new ContainerSkinLibrary(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(EntityPlayer player, World world, BlockPos pos) {
        return new GuiSkinLibrary(player.field_71071_by, this);
    }
}

