/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.script;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kamkeel.npcs.network.packets.request.script.EffectScriptPacket;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.client.gui.global.GuiNPCManageEffects;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextArea;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.GuiScriptTextArea;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IJTextAreaListener;
import noppes.npcs.client.gui.util.ITextChangeListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.data.CustomEffect;
import noppes.npcs.controllers.data.EffectScript;

public class GuiScriptEffect
extends GuiNPCInterface
implements GuiYesNoCallback,
IGuiData,
ITextChangeListener,
ICustomScrollListener,
IJTextAreaListener,
ITextfieldListener {
    private int activeTab = 0;
    public Map<String, List<String>> languages = new HashMap<String, List<String>>();
    private final int scriptLimit = 1;
    public List<String> hookList = new ArrayList<String>();
    public String previousHookClicked = "";
    public final GuiNPCManageEffects parent;
    public final CustomEffect effect;
    private final EffectScript scriptHandler;
    boolean loaded = false;

    public GuiScriptEffect(GuiNPCManageEffects parent, CustomEffect effect) {
        this.drawDefaultBackground = true;
        this.closeOnEsc = true;
        this.xSize = 420;
        this.setBackground("menubg.png");
        this.parent = parent;
        this.effect = effect;
        this.scriptHandler = new EffectScript();
        for (EffectScript.ScriptType type : EffectScript.ScriptType.values()) {
            this.hookList.add(type.function);
        }
        EffectScriptPacket.Get(effect.id);
    }

    @Override
    public void func_73866_w_() {
        this.ySize = (int)((double)this.xSize * 0.56);
        if ((double)this.ySize > (double)this.field_146295_m * 0.95) {
            this.ySize = (int)((double)this.field_146295_m * 0.95);
            this.xSize = (int)((double)this.ySize / 0.56);
        }
        this.bgScale = (float)this.xSize / 400.0f;
        super.func_73866_w_();
        this.guiTop += 10;
        int yoffset = (int)((double)this.ySize * 0.02);
        GuiMenuTopButton top = new GuiMenuTopButton(0, this.guiLeft + 4, this.guiTop - 17, "gui.settings");
        this.addTopButton(top);
        int topXoffset = 0;
        int topYoffset = 0;
        if (this.scriptHandler.container != null) {
            top = new GuiMenuTopButton(1, top.field_146128_h + top.field_146120_f + topXoffset, top.field_146129_i + topYoffset, "Script");
            this.addTopButton(top);
        } else {
            this.addTopButton(new GuiMenuTopButton(this.scriptLimit, top.field_146128_h + top.field_146120_f, top.field_146129_i, "+"));
        }
        top = this.getTopButton(this.activeTab);
        if (top == null) {
            this.activeTab = 0;
            top = this.getTopButton(0);
        }
        top.active = true;
        if (this.activeTab == 1) {
            GuiCustomScroll hooks = new GuiCustomScroll(this, 1);
            hooks.field_146291_p = false;
            hooks.setSize(108, 198);
            hooks.guiLeft = this.guiLeft - 110;
            hooks.guiTop = this.guiTop + 14;
            hooks.setUnsortedList(this.hookList);
            this.addScroll(hooks);
            GuiNpcLabel hookLabel = new GuiNpcLabel(0, "script.hooks", hooks.guiLeft, this.guiTop + 5);
            hookLabel.color = 0xAAAAAA;
            this.addLabel(hookLabel);
            ScriptContainer container = this.scriptHandler.container;
            GuiScriptTextArea ta = new GuiScriptTextArea(this, 2, this.guiLeft + 1 + yoffset, this.guiTop + yoffset, this.xSize - 108 - yoffset, (int)((double)this.ySize * 0.96) - yoffset * 2, container == null ? "" : container.script);
            ta.enableCodeHighlighting();
            ta.setListener(this);
            this.addTextField(ta);
            int left1 = this.guiLeft + this.xSize - 104;
            this.addButton(new GuiNpcButton(102, left1, this.guiTop + yoffset, 60, 20, "gui.clear"));
            this.addButton(new GuiNpcButton(101, left1 + 61, this.guiTop + yoffset, 60, 20, "gui.paste"));
            this.addButton(new GuiNpcButton(100, left1, this.guiTop + 21 + yoffset, 60, 20, "gui.copy"));
            this.addButton(new GuiNpcButton(105, left1 + 61, this.guiTop + 21 + yoffset, 60, 20, "gui.remove"));
            this.addButton(new GuiNpcButton(107, left1, this.guiTop + 66 + yoffset, 80, 20, "script.loadscript"));
            this.getButton((int)107).field_146124_l = false;
            GuiCustomScroll scroll = new GuiCustomScroll(this, 0).setUnselectable();
            scroll.setSize(100, (int)((double)this.ySize * 0.54) - yoffset * 2);
            scroll.guiLeft = left1;
            scroll.guiTop = this.guiTop + 88 + yoffset;
            if (container != null) {
                scroll.setList(container.scripts);
            }
            this.addScroll(scroll);
        } else {
            GuiNpcTextArea var8 = new GuiNpcTextArea(2, this, this.guiLeft + 4 + yoffset, this.guiTop + 6 + yoffset, this.xSize - 160 - yoffset, (int)((float)this.ySize * 0.92f) - yoffset * 2, this.getConsoleText());
            var8.enabled = false;
            this.addTextField(var8);
            int var9 = this.guiLeft + this.xSize - 150;
            this.addButton(new GuiNpcButton(100, var9, this.guiTop + 125, 60, 20, "gui.copy"));
            this.addButton(new GuiNpcButton(102, var9, this.guiTop + 146, 60, 20, "gui.clear"));
            this.addLabel(new GuiNpcLabel(1, "script.language", var9, this.guiTop + 15));
            this.addButton(new GuiNpcButton(103, var9 + 60, this.guiTop + 10, 80, 20, this.languages.keySet().toArray(new String[this.languages.keySet().size()]), this.getScriptIndex()));
            this.getButton((int)103).field_146124_l = !this.languages.isEmpty();
            this.addLabel(new GuiNpcLabel(2, "gui.enabled", var9, this.guiTop + 36));
            this.addButton(new GuiNpcButton(104, var9 + 60, this.guiTop + 31, 50, 20, new String[]{"gui.no", "gui.yes"}, this.scriptHandler.getEnabled() ? 1 : 0));
            this.addButton(new GuiNpcButton(109, var9, this.guiTop + 78, 80, 20, "gui.website"));
            this.addButton(new GuiNpcButton(112, var9 + 81, this.guiTop + 78, 80, 20, "gui.forum"));
            this.addButton(new GuiNpcButton(110, var9, this.guiTop + 99, 80, 20, "script.apidoc"));
            this.addButton(new GuiNpcButton(111, var9 + 81, this.guiTop + 99, 80, 20, "script.apisrc"));
        }
        this.xSize = 420;
        this.ySize = 256;
    }

    @Override
    public void customScrollClicked(int i, int j, int k, GuiCustomScroll scroll) {
        String hook = scroll.getSelected();
        if (this.previousHookClicked.equals(hook)) {
            String addString = "";
            if (!this.getTextField(2).func_146179_b().isEmpty()) {
                addString = addString + "\n";
            }
            addString = addString + "function " + hook + "(event) {\n    \n}\n";
            this.getTextField(2).func_146180_a(this.getTextField(2).func_146179_b() + addString);
            this.previousHookClicked = "";
        } else {
            this.previousHookClicked = hook;
        }
    }

    @Override
    public void unFocused(GuiNpcTextField textfield) {
    }

    private String getConsoleText() {
        Map<Long, String> map = this.scriptHandler.getConsoleText();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Long, String> entry : map.entrySet()) {
            builder.insert(0, new Date(entry.getKey()) + entry.getValue() + "\n");
        }
        return builder.toString();
    }

    private int getScriptIndex() {
        int i = 0;
        for (String language : this.languages.keySet()) {
            if (language.equalsIgnoreCase(this.scriptHandler.getLanguage())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void func_73878_a(boolean flag, int i) {
        if (flag) {
            if (i == 0) {
                this.openLink("https://www.curseforge.com/minecraft/mc-mods/customnpc-plus");
            }
            if (i == 1) {
                this.openLink("https://kamkeel.github.io/CustomNPC-Plus/");
            }
            if (i == 2) {
                this.openLink("https://kamkeel.github.io/CustomNPC-Plus/");
            }
            if (i == 3) {
                this.openLink("http://www.minecraftforge.net/forum/index.php/board,122.0.html");
            }
            if (i == 10) {
                this.scriptHandler.container = null;
                this.activeTab = 0;
            }
            if (i == 101) {
                this.getTextField(2).func_146180_a(NoppesStringUtils.getClipboardContents());
                this.setScript();
            }
            if (i == 102) {
                if (this.activeTab == 1) {
                    ScriptContainer container = this.scriptHandler.container;
                    container.script = "";
                } else {
                    this.scriptHandler.clearConsole();
                }
                this.func_73866_w_();
            }
        }
        this.displayGuiScreen(this);
    }

    @Override
    protected void func_146284_a(GuiButton guibutton) {
        ScriptContainer container;
        GuiYesNo container1;
        if (guibutton.field_146127_k == 0) {
            this.setScript();
            this.activeTab = 0;
            this.func_73866_w_();
        }
        if (guibutton.field_146127_k == this.scriptLimit) {
            if (this.scriptHandler.container == null) {
                this.scriptHandler.container = new ScriptContainer(this.scriptHandler);
            } else {
                this.setScript();
            }
            this.activeTab = 1;
            this.func_73866_w_();
        }
        if (guibutton.field_146127_k == 109) {
            this.displayGuiScreen((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, "https://kamkeel.github.io/CustomNPC-Plus/", 0, true));
        }
        if (guibutton.field_146127_k == 110) {
            this.displayGuiScreen((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, "https://github.com/KAMKEEL/CustomNPC-Plus-API", 1, true));
        }
        if (guibutton.field_146127_k == 111) {
            this.displayGuiScreen((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, "https://github.com/Noppes/CustomNPCsAPI", 2, true));
        }
        if (guibutton.field_146127_k == 112) {
            this.displayGuiScreen((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, "http://www.minecraftforge.net/forum/index.php/board,122.0.html", 3, true));
        }
        if (guibutton.field_146127_k == 100) {
            NoppesStringUtils.setClipboardContents(this.getTextField(2).func_146179_b());
        }
        if (guibutton.field_146127_k == 101) {
            GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, StatCollector.func_74838_a((String)"gui.paste"), StatCollector.func_74838_a((String)"gui.sure"), 101);
            this.displayGuiScreen((GuiScreen)guiyesno);
        }
        if (guibutton.field_146127_k == 102) {
            container1 = new GuiYesNo((GuiYesNoCallback)this, StatCollector.func_74838_a((String)"gui.clear"), StatCollector.func_74838_a((String)"gui.sure"), 102);
            this.displayGuiScreen((GuiScreen)container1);
        }
        if (guibutton.field_146127_k == 103) {
            this.scriptHandler.setLanguage(guibutton.field_146126_j);
        }
        if (guibutton.field_146127_k == 104) {
            this.scriptHandler.setEnabled(((GuiNpcButton)guibutton).getValue() == 1);
        }
        if (guibutton.field_146127_k == 105) {
            container1 = new GuiYesNo((GuiYesNoCallback)this, "", ((GuiNpcButton)guibutton).field_146126_j, 10);
            this.displayGuiScreen((GuiScreen)container1);
        }
        if (guibutton.field_146127_k == 107 && (container = this.scriptHandler.container) == null) {
            this.scriptHandler.container = container = new ScriptContainer(this.scriptHandler);
        }
    }

    private void setScript() {
        if (this.activeTab == 1) {
            ScriptContainer container = this.scriptHandler.container;
            if (container == null) {
                this.scriptHandler.container = container = new ScriptContainer(this.scriptHandler);
            }
            String text = this.getTextField(2).func_146179_b();
            text = text.replace("\r\n", "\n");
            container.script = text = text.replace("\r", "\n");
        }
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (compound.func_74764_b("LoadComplete")) {
            this.loaded = true;
            return;
        }
        if (!compound.func_74764_b("Tab")) {
            this.scriptHandler.setLanguage(compound.func_74779_i("ScriptLanguage"));
            this.scriptHandler.setEnabled(compound.func_74767_n("ScriptEnabled"));
            this.copiedSetGuiData(compound);
        } else {
            int tab = compound.func_74762_e("Tab");
            ScriptContainer container = new ScriptContainer(this.scriptHandler);
            container.readFromNBT(compound.func_74775_l("Script"));
            this.scriptHandler.container = container;
            this.func_73866_w_();
        }
    }

    private void copiedSetGuiData(NBTTagCompound compound) {
        NBTTagList data = compound.func_150295_c("Languages", 10);
        HashMap<String, List<String>> languages = new HashMap<String, List<String>>();
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound comp = data.func_150305_b(i);
            ArrayList<String> scripts = new ArrayList<String>();
            NBTTagList list = comp.func_150295_c("Scripts", 8);
            for (int j = 0; j < list.func_74745_c(); ++j) {
                scripts.add(list.func_150307_f(j));
            }
            languages.put(comp.func_74779_i("Language"), scripts);
        }
        this.languages = languages;
        this.func_73866_w_();
    }

    @Override
    public void save() {
        if (this.loaded) {
            this.setScript();
            List<ScriptContainer> containers = this.scriptHandler.getScripts();
            for (int i = 0; i < containers.size(); ++i) {
                ScriptContainer container = containers.get(i);
                EffectScriptPacket.Save(this.effect.id, i, containers.size(), container.writeToNBT(new NBTTagCompound()));
            }
            NBTTagCompound scriptData = new NBTTagCompound();
            scriptData.func_74778_a("ScriptLanguage", this.scriptHandler.getLanguage());
            scriptData.func_74757_a("ScriptEnabled", this.scriptHandler.getEnabled());
            scriptData.func_74782_a("ScriptConsole", (NBTBase)NBTTags.NBTLongStringMap(this.scriptHandler.getConsoleText()));
            EffectScriptPacket.Save(this.effect.id, -1, containers.size(), scriptData);
        }
    }

    @Override
    public void textUpdate(String text) {
        ScriptContainer container = this.scriptHandler.container;
        if (container != null) {
            container.script = text;
        }
    }

    @Override
    public void saveText(String text) {
        ScriptContainer container = this.scriptHandler.container;
        if (container != null) {
            container.script = text;
        }
        this.func_73866_w_();
    }

    @Override
    public void close() {
        this.save();
        this.parent.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        this.parent.func_73866_w_();
        this.field_146297_k.field_71462_r = this.parent;
    }
}

