/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data.action;

import java.util.function.Consumer;
import java.util.function.Supplier;
import noppes.npcs.api.handler.data.IAction;
import noppes.npcs.api.handler.data.actions.IConditionalAction;
import noppes.npcs.controllers.data.action.Action;
import noppes.npcs.scripted.ScriptedActionManager;

public class ConditionalAction
extends Action
implements IConditionalAction {
    private Supplier<Boolean> condition;
    private Supplier<Boolean> terminateWhen;
    private Consumer<IAction> onTermination;
    private int maxChecks = -1;
    private int checkCount;
    private boolean taskExecuted;

    public ConditionalAction(ScriptedActionManager manager, Supplier<Boolean> condition, Consumer<IAction> task) {
        super(manager, "conditional", task);
        this.condition = condition;
    }

    public ConditionalAction(ScriptedActionManager manager, String name, Supplier<Boolean> condition, Consumer<IAction> task) {
        super(manager, name, task);
        this.condition = condition;
    }

    public ConditionalAction(ScriptedActionManager manager, Supplier<Boolean> condition, Consumer<IAction> task, Supplier<Boolean> terminateWhen) {
        this(manager, condition, task);
        this.terminateWhen = terminateWhen;
    }

    public ConditionalAction(ScriptedActionManager manager, String name, Supplier<Boolean> condition, Consumer<IAction> task, Supplier<Boolean> terminateWhen) {
        this(manager, name, condition, task);
        this.terminateWhen = terminateWhen;
    }

    public ConditionalAction(ScriptedActionManager manager, Supplier<Boolean> condition, Consumer<IAction> task, Supplier<Boolean> terminateWhen, Consumer<IAction> onTermination) {
        this(manager, condition, task, terminateWhen);
        this.onTermination = onTermination;
    }

    public ConditionalAction(ScriptedActionManager manager, String name, Supplier<Boolean> condition, Consumer<IAction> task, Supplier<Boolean> terminateWhen, Consumer<IAction> onTermination) {
        this(manager, name, condition, task, terminateWhen);
        this.onTermination = onTermination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick(int ticksExisted) {
        block12: {
            if (this.isDone()) {
                return;
            }
            try {
                boolean terminated;
                if (ticksExisted % this.updateEveryXTick != 0) break block12;
                ++this.checkCount;
                boolean bl = terminated = this.terminateWhen != null && this.terminateWhen.get() != false;
                if (terminated && this.onTermination != null) {
                    try {
                        this.onTermination.accept(this);
                    }
                    catch (Throwable t) {
                        System.err.println("Error in onTermination for conditional '" + this.getName() + "':");
                        t.printStackTrace();
                    }
                }
                if (this.maxChecks >= 0 && this.checkCount > this.maxChecks || terminated) {
                    this.markDone();
                    return;
                }
                if (this.condition != null && this.condition.get().booleanValue()) {
                    this.task.accept(this);
                    this.taskExecuted = true;
                }
            }
            catch (Throwable t) {
                System.err.println("Scripted conditional '" + this.getName() + "' threw an exception:");
                t.printStackTrace();
                this.markDone();
            }
            finally {
                ++this.duration;
            }
        }
    }

    @Override
    public IConditionalAction setMaxChecks(int maxChecks) {
        this.maxChecks = maxChecks;
        return this;
    }

    @Override
    public IConditionalAction setCondition(Supplier<Boolean> condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public IConditionalAction terminateWhen(Supplier<Boolean> terminateWhen) {
        this.terminateWhen = terminateWhen;
        return this;
    }

    @Override
    public IConditionalAction onTermination(Consumer<IAction> onTermination) {
        this.onTermination = onTermination;
        return this;
    }

    @Override
    public boolean wasTaskExecuted() {
        return this.taskExecuted;
    }

    @Override
    public int getCheckCount() {
        return this.checkCount;
    }

    @Override
    public int getMaxChecks() {
        return this.maxChecks;
    }

    @Override
    public IConditionalAction after(IConditionalAction after) {
        return this.manager.scheduleAction(after);
    }

    @Override
    public IConditionalAction after(Supplier<Boolean> condition, Consumer<IAction> task) {
        return this.after(this.manager.create(condition, task));
    }

    @Override
    public IConditionalAction after(String name, Supplier<Boolean> condition, Consumer<IAction> task) {
        return this.after(this.manager.create(name, condition, task));
    }

    @Override
    public IConditionalAction after(Supplier<Boolean> condition, Consumer<IAction> task, Supplier<Boolean> terminateWhen) {
        return this.after(this.manager.create(condition, task, terminateWhen));
    }

    @Override
    public IConditionalAction after(String name, Supplier<Boolean> condition, Consumer<IAction> task, Supplier<Boolean> terminateWhen) {
        return this.after(this.manager.create(name, condition, task, terminateWhen));
    }

    @Override
    public IConditionalAction after(Supplier<Boolean> condition, Consumer<IAction> task, Supplier<Boolean> terminateWhen, Consumer<IAction> onTermination) {
        return this.after(this.manager.create(condition, task, terminateWhen, onTermination));
    }

    @Override
    public IConditionalAction after(String name, Supplier<Boolean> condition, Consumer<IAction> task, Supplier<Boolean> terminateWhen, Consumer<IAction> onTermination) {
        return this.after(this.manager.create(name, condition, task, terminateWhen, onTermination));
    }
}

