/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.impl;

import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ScrollableListControl;
import com.gitlab.cdagaming.unilib.utils.gui.impl.MessageGui;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiScreen;

public class SelectorGui
extends ExtendedScreen {
    private final String attributeName;
    private final String originalValue;
    private final List<String> originalList;
    private final boolean allowContinuing;
    private final boolean allowDynamicEditing;
    private final BiConsumer<String, String> onUpdatedCallback;
    private final BiConsumer<String, GuiScreen> onAdjustDynamicEntry;
    private ExtendedButtonControl proceedButton;
    private ScrollableListControl scrollList;
    private ExtendedTextControl searchBox;
    private String searchTerm;
    private List<String> itemList;

    public SelectorGui(String mainTitle, List<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, BiConsumer<String, String> onUpdatedCallback, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        super(mainTitle);
        this.originalList = list == null ? StringUtils.newArrayList() : StringUtils.newArrayList(list);
        this.itemList = this.originalList;
        this.originalValue = currentValue;
        this.attributeName = attributeName;
        this.allowContinuing = allowContinuing;
        this.allowDynamicEditing = allowDynamicEditing;
        this.onUpdatedCallback = onUpdatedCallback;
        this.onAdjustDynamicEntry = onAdjustDynamicEntry;
    }

    public SelectorGui(String mainTitle, Set<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, BiConsumer<String, String> onUpdatedCallback, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        this(mainTitle, list == null ? null : StringUtils.newArrayList(list), currentValue, attributeName, allowContinuing, allowDynamicEditing, onUpdatedCallback, onAdjustDynamicEntry);
    }

    public SelectorGui(String mainTitle, List<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        this(mainTitle, list, currentValue, attributeName, allowContinuing, allowDynamicEditing, null, onAdjustDynamicEntry);
    }

    public SelectorGui(String mainTitle, Set<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        this(mainTitle, list, currentValue, attributeName, allowContinuing, allowDynamicEditing, null, onAdjustDynamicEntry);
    }

    @Override
    public void constructElements() {
        super.constructElements();
        this.appendListControl();
        this.appendControls();
    }

    protected String getOriginalValue() {
        return this.originalValue;
    }

    protected List<String> getItemList() {
        return this.itemList;
    }

    protected void setListControl(ScrollableListControl scrollList) {
        this.scrollList = scrollList;
    }

    protected void appendListControl() {
        this.setListControl(this.addControl(new ScrollableListControl(this.getGameInstance(), this, this.getScreenWidth(), this.getScreenHeight() - 64, 32, this.getScreenHeight() - 32, this.getItemList(), this.getOriginalValue())));
    }

    protected void appendControls() {
        this.proceedButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 101, this.getScreenHeight() - 26, 95, 20, "Back", () -> {
            if (this.allowContinuing && this.scrollList.currentValue != null) {
                if (this.getOriginalValue() != null) {
                    if (!this.scrollList.currentValue.equals(this.getOriginalValue())) {
                        if (this.onUpdatedCallback != null) {
                            this.onUpdatedCallback.accept(this.attributeName, this.scrollList.currentValue);
                            this.openScreen(this.getParent());
                        } else {
                            this.openScreen(new MessageGui("UniLib", "This area is not implemented just yet!\\n\\nPlease check back later..."), this.getParent());
                        }
                    } else {
                        this.openScreen(this.getParent());
                    }
                } else if (this.onAdjustDynamicEntry != null) {
                    this.onAdjustDynamicEntry.accept(this.scrollList.currentValue, this.getParent());
                } else {
                    this.openScreen(new MessageGui("UniLib", "This area is not implemented just yet!\\n\\nPlease check back later..."), this.getParent());
                }
            } else {
                this.openScreen(this.getParent());
            }
        }, new String[0]));
        int searchBoxRight = this.proceedButton.getLeft() - 6;
        if (this.allowDynamicEditing && this.onAdjustDynamicEntry != null) {
            this.addControl(new ExtendedButtonControl(this.proceedButton.getLeft() - 100, this.getScreenHeight() - 26, 95, 20, "Add New", () -> this.onAdjustDynamicEntry.accept(null, this.getParent()), new String[0]));
            searchBoxRight -= 100;
        }
        this.searchBox = this.addControl(new ExtendedTextControl(this.getFontRenderer(), 60, this.getScreenHeight() - 26, searchBoxRight - 60, 20));
    }

    protected List<String> getFilteredList(String searchTerm, List<String> originalItems) {
        List<String> modifiedList = StringUtils.newArrayList();
        for (String item : originalItems) {
            if (modifiedList.contains(item) || !item.toLowerCase().contains(searchTerm.toLowerCase())) continue;
            modifiedList.add(item);
            break;
        }
        return modifiedList;
    }

    @Override
    public void preRender() {
        List<String> originalItems = StringUtils.newArrayList(this.originalList);
        if (!this.searchBox.getControlMessage().isEmpty()) {
            if (!this.searchBox.getControlMessage().equals(this.searchTerm)) {
                this.searchTerm = this.searchBox.getControlMessage();
                this.itemList = this.getFilteredList(this.searchTerm, originalItems);
            }
        } else {
            this.itemList = originalItems;
        }
        if (!this.getItemList().equals(originalItems) && !this.getItemList().contains(this.scrollList.currentValue)) {
            this.scrollList.currentValue = this.getOriginalValue() != null && this.getItemList().contains(this.getOriginalValue()) ? this.getOriginalValue() : null;
        } else if (this.scrollList.currentValue == null && this.getOriginalValue() != null) {
            this.scrollList.currentValue = this.getOriginalValue();
        }
        this.scrollList.setList(this.getItemList());
        this.proceedButton.setControlMessage(this.allowContinuing && this.scrollList.currentValue != null && (this.getOriginalValue() != null && !this.scrollList.currentValue.equals(this.getOriginalValue()) || StringUtils.isNullOrEmpty(this.getOriginalValue())) ? "Continue" : "Back");
        super.preRender();
    }

    @Override
    public void renderStringData() {
        super.renderStringData();
        int renderY = this.searchBox.getBottom() - this.searchBox.getControlHeight() / 2 - this.getFontHeight() / 2;
        this.renderScrollingString("Search:", 2, renderY, 58, renderY + this.getFontHeight(), 0xFFFFFF);
    }
}

