/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.constants.enums;

import java.util.ArrayList;
import java.util.List;
import kamkeel.npcdbc.constants.DBCForm;
import kamkeel.npcdbc.data.IAuraData;

public enum EnumAuraTypes3D {
    None(""),
    Base("default"),
    SaiyanGod("ssgod"),
    SaiyanBlue("ssb"),
    SaiyanBlueEvo("shinka"),
    SaiyanRose("ssrose"),
    SaiyanRoseEvo("ssroseevo"),
    UltimateArco("ultimate"),
    UI("ui"),
    GoD("godofdestruction");

    private final String name;

    private EnumAuraTypes3D(String name) {
        this.name = name;
    }

    public static EnumAuraTypes3D getEnumFromName(String name) {
        for (EnumAuraTypes3D auraType : EnumAuraTypes3D.values()) {
            if (!auraType.getName().equalsIgnoreCase(name)) continue;
            return auraType;
        }
        return null;
    }

    public static List<String> getAllNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (EnumAuraTypes3D auraType : EnumAuraTypes3D.values()) {
            names.add(auraType.getName());
        }
        return names;
    }

    public static EnumAuraTypes3D getType(IAuraData data) {
        byte race = data.getRace();
        byte state = data.getState();
        boolean divine = data.isForm(26);
        boolean ui = data.isForm(41);
        boolean god = data.isForm(24);
        if (ui) {
            return UI;
        }
        if (god) {
            return GoD;
        }
        if (DBCForm.isGod(race, state)) {
            return SaiyanGod;
        }
        if (race == 1 || race == 2) {
            if (state == 10) {
                if (divine) {
                    return SaiyanRose;
                }
                return SaiyanBlue;
            }
            if (state == 15) {
                if (divine) {
                    return SaiyanRoseEvo;
                }
                return SaiyanBlueEvo;
            }
        }
        return Base;
    }

    public static int getManualAuraColor(EnumAuraTypes3D playerAuraTypes, boolean revampedAura) {
        int col = -1;
        if (playerAuraTypes == SaiyanGod) {
            col = revampedAura ? 15083303 : 16761125;
        } else if (playerAuraTypes == SaiyanBlue) {
            col = revampedAura ? 4765434 : 2805230;
        } else if (playerAuraTypes == SaiyanBlueEvo) {
            col = revampedAura ? 787148 : Short.MAX_VALUE;
        } else if (playerAuraTypes == SaiyanRose) {
            col = 7536661;
        } else if (playerAuraTypes == SaiyanRoseEvo) {
            col = 14030412;
        } else if (playerAuraTypes == UI) {
            col = 0xF0F0F0;
        } else if (playerAuraTypes == GoD) {
            col = 12464847;
        } else if (playerAuraTypes == UltimateArco) {
            col = 16430355;
        }
        return col;
    }

    public static boolean isBlue(EnumAuraTypes3D type) {
        return type == SaiyanBlue || type == SaiyanBlueEvo || type == SaiyanRose || type == SaiyanRoseEvo;
    }

    public String getName() {
        return this.name;
    }
}

