/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client.config;

import cpw.mods.fml.client.config.ConfigGuiType;
import cpw.mods.fml.client.config.GuiConfigEntries;
import cpw.mods.fml.client.config.GuiEditArrayEntries;
import cpw.mods.fml.client.config.IConfigElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class DummyConfigElement<T>
implements IConfigElement<T> {
    protected boolean isProperty = true;
    protected boolean isList = false;
    protected ConfigGuiType type;
    protected String name;
    protected String langKey;
    protected Object value;
    protected Object defaultValue;
    protected T[] values;
    protected T[] defaultValues;
    protected String[] validValues;
    protected Pattern validStringPattern;
    protected T minValue;
    protected T maxValue;
    protected boolean requiresWorldRestart = false;
    protected boolean requiresMcRestart = false;
    protected boolean isListFixedLength = false;
    protected int maxListLength = -1;
    protected List<IConfigElement> childElements;
    protected Class<? extends GuiConfigEntries.IConfigEntry> configEntryClass;
    protected Class<? extends GuiEditArrayEntries.IArrayEntry> arrayEntryClass;

    public DummyConfigElement(String name, T defaultValue, ConfigGuiType type, String langKey, String[] validValues, Pattern validStringPattern, T minValue, T maxValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.type = type;
        this.langKey = langKey;
        this.validValues = validValues;
        this.validStringPattern = validStringPattern;
        if (minValue == null) {
            if (type == ConfigGuiType.INTEGER) {
                this.minValue = Integer.MIN_VALUE;
            } else if (type == ConfigGuiType.DOUBLE) {
                this.minValue = -1.7976931348623157E308;
            }
        } else {
            this.minValue = minValue;
        }
        if (maxValue == null) {
            if (type == ConfigGuiType.INTEGER) {
                this.maxValue = Integer.MAX_VALUE;
            } else if (type == ConfigGuiType.DOUBLE) {
                this.maxValue = Double.MAX_VALUE;
            }
        } else {
            this.maxValue = maxValue;
        }
    }

    public DummyConfigElement(String name, T defaultValue, ConfigGuiType type, String langKey, Pattern validStringPattern) {
        this(name, defaultValue, type, langKey, null, validStringPattern, null, null);
    }

    public DummyConfigElement(String name, T defaultValue, ConfigGuiType type, String langKey, String[] validValues) {
        this(name, defaultValue, type, langKey, validValues, null, null, null);
    }

    public DummyConfigElement(String name, T defaultValue, ConfigGuiType type, String langKey) {
        this(name, defaultValue, type, langKey, null, null, null, null);
    }

    public DummyConfigElement(String name, T defaultValue, ConfigGuiType type, String langKey, T minValue, T maxValue) {
        this(name, defaultValue, type, langKey, null, null, minValue, maxValue);
    }

    public DummyConfigElement setCustomListEntryClass(Class<? extends GuiConfigEntries.IConfigEntry> clazz) {
        this.configEntryClass = clazz;
        return this;
    }

    @Override
    public boolean isProperty() {
        return this.isProperty;
    }

    public IConfigElement setConfigEntryClass(Class<? extends GuiConfigEntries.IConfigEntry> clazz) {
        this.configEntryClass = clazz;
        return this;
    }

    @Override
    public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
        return this.configEntryClass;
    }

    public IConfigElement setArrayEntryClass(Class<? extends GuiEditArrayEntries.IArrayEntry> clazz) {
        this.arrayEntryClass = clazz;
        return this;
    }

    @Override
    public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
        return this.arrayEntryClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.name;
    }

    @Override
    public String getLanguageKey() {
        return this.langKey;
    }

    @Override
    public String getComment() {
        return brp.a((String)(this.langKey + ".tooltip"), (Object[])new Object[0]);
    }

    @Override
    public List<IConfigElement> getChildElements() {
        return this.childElements;
    }

    @Override
    public ConfigGuiType getType() {
        return this.type;
    }

    @Override
    public boolean isList() {
        return this.isList;
    }

    @Override
    public boolean isListLengthFixed() {
        return this.isListFixedLength;
    }

    @Override
    public int getMaxListLength() {
        return this.maxListLength;
    }

    @Override
    public boolean isDefault() {
        if (this.isProperty) {
            if (!this.isList) {
                if (this.value != null) {
                    return this.value.equals(this.defaultValue);
                }
                return this.defaultValue == null;
            }
            return Arrays.deepEquals(this.values, this.defaultValues);
        }
        return true;
    }

    @Override
    public Object getDefault() {
        return this.defaultValue;
    }

    @Override
    public T[] getDefaults() {
        return this.defaultValues;
    }

    @Override
    public void setToDefault() {
        if (this.isList) {
            this.values = Arrays.copyOf(this.defaultValues, this.defaultValues.length);
        } else {
            this.value = this.defaultValue;
        }
    }

    public IConfigElement<T> setRequiresWorldRestart(boolean requiresWorldRestart) {
        this.requiresWorldRestart = requiresWorldRestart;
        return this;
    }

    @Override
    public boolean requiresWorldRestart() {
        return this.requiresWorldRestart;
    }

    @Override
    public boolean showInGui() {
        return true;
    }

    public IConfigElement<T> setRequiresMcRestart(boolean requiresMcRestart) {
        this.requiresMcRestart = this.requiresWorldRestart = requiresMcRestart;
        return this;
    }

    @Override
    public boolean requiresMcRestart() {
        return this.requiresMcRestart;
    }

    @Override
    public String[] getValidValues() {
        return this.validValues;
    }

    @Override
    public Pattern getValidationPattern() {
        return this.validStringPattern;
    }

    @Override
    public Object get() {
        return this.value;
    }

    @Override
    public T[] getList() {
        return this.values;
    }

    @Override
    public void set(T value) {
        this.defaultValue = value;
    }

    @Override
    public void set(T[] aVal) {
        this.defaultValues = aVal;
    }

    @Override
    public T getMinValue() {
        return this.minValue;
    }

    @Override
    public T getMaxValue() {
        return this.maxValue;
    }

    public static class DummyListElement<T>
    extends DummyConfigElement<T> {
        public DummyListElement(String name, T[] defaultValues, ConfigGuiType type, String langKey, boolean isListFixedLength, int maxListLength, Pattern validStringPattern, T minValue, T maxValue) {
            super(name, null, type, langKey, minValue, maxValue);
            this.defaultValues = defaultValues;
            this.values = defaultValues;
            this.isListFixedLength = isListFixedLength;
            this.maxListLength = maxListLength;
            this.validStringPattern = validStringPattern;
            this.isList = true;
        }

        public DummyListElement(String name, T[] defaultValues, ConfigGuiType type, String langKey) {
            this(name, defaultValues, type, langKey, false, -1, null, null, null);
        }

        public DummyListElement(String name, T[] defaultValues, ConfigGuiType type, String langKey, boolean isListFixedLength) {
            this(name, defaultValues, type, langKey, isListFixedLength, -1, null, null, null);
        }

        public DummyListElement(String name, T[] defaultValues, ConfigGuiType type, String langKey, int maxListLength) {
            this(name, defaultValues, type, langKey, false, maxListLength, null, null, null);
        }

        public DummyListElement(String name, T[] defaultValues, ConfigGuiType type, String langKey, T minValue, T maxValue) {
            this(name, defaultValues, type, langKey, false, -1, null, minValue, maxValue);
        }

        public DummyListElement(String name, T[] defaultValues, ConfigGuiType type, String langKey, boolean isListFixedLength, T minValue, T maxValue) {
            this(name, defaultValues, type, langKey, isListFixedLength, -1, null, minValue, maxValue);
        }

        public DummyListElement(String name, T[] defaultValues, ConfigGuiType type, String langKey, int maxListLength, T minValue, T maxValue) {
            this(name, defaultValues, type, langKey, false, maxListLength, null, minValue, maxValue);
        }

        public DummyListElement(String name, T[] defaultValues, ConfigGuiType type, String langKey, boolean isListFixedLength, int maxListLength, T minValue, T maxValue) {
            this(name, defaultValues, type, langKey, isListFixedLength, maxListLength, null, minValue, maxValue);
        }

        public DummyListElement(String name, T[] defaultValues, ConfigGuiType type, String langKey, Pattern validStringPattern) {
            this(name, defaultValues, type, langKey, false, -1, validStringPattern, null, null);
        }

        public DummyListElement(String name, T[] defaultValues, ConfigGuiType type, String langKey, boolean isListFixedLength, Pattern validStringPattern) {
            this(name, defaultValues, type, langKey, isListFixedLength, -1, validStringPattern, null, null);
        }

        public DummyListElement(String name, T[] defaultValues, ConfigGuiType type, String langKey, int maxListLength, Pattern validStringPattern) {
            this(name, defaultValues, type, langKey, false, maxListLength, validStringPattern, null, null);
        }

        public DummyListElement setCustomEditListEntryClass(Class<? extends GuiEditArrayEntries.IArrayEntry> clazz) {
            this.arrayEntryClass = clazz;
            return this;
        }

        @Override
        public Object getDefault() {
            return Arrays.toString(this.defaultValues);
        }
    }

    public static class DummyCategoryElement<T>
    extends DummyConfigElement<T> {
        public DummyCategoryElement(String name, String langKey, List<IConfigElement> childElements) {
            this(name, langKey, childElements, (Class<? extends GuiConfigEntries.IConfigEntry>)null);
        }

        public DummyCategoryElement(String name, String langKey, Class<? extends GuiConfigEntries.IConfigEntry> customListEntryClass) {
            this(name, langKey, new ArrayList<IConfigElement>(), customListEntryClass);
        }

        public DummyCategoryElement(String name, String langKey, List<IConfigElement> childElements, Class<? extends GuiConfigEntries.IConfigEntry> customListEntryClass) {
            super(name, null, ConfigGuiType.CONFIG_CATEGORY, langKey);
            this.childElements = childElements;
            this.configEntryClass = customListEntryClass;
            this.isProperty = false;
        }
    }
}

