/*
 * Decompiled with CFR 0.152.
 */
package lumien.resourceloader.asm;

import lumien.resourceloader.asm.BetterClassWriter;
import lumien.resourceloader.asm.MCPNames;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    Logger logger = LogManager.getLogger((String)"ResourceLoader");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.client.Minecraft")) {
            return this.patchMinecraft(basicClass);
        }
        return basicClass;
    }

    private byte[] patchMinecraft(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found Minecraft Class: " + classNode.name);
        MethodNode refreshResources = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_110436_a"))) continue;
            refreshResources = mn;
        }
        if (refreshResources != null) {
            this.logger.log(Level.DEBUG, " - Found refreshResources 1/2");
            for (int i = 0; i < refreshResources.instructions.size(); ++i) {
                AbstractInsnNode ain = refreshResources.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals(MCPNames.method("func_110541_a"))) continue;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/resourceloader/ResourceLoader", "insertForcedPack", "(Ljava/util/ArrayList;)V", false));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
                refreshResources.instructions.insertBefore((AbstractInsnNode)min, toInsert);
                this.logger.log(Level.DEBUG, " - Patched refreshResources 2/2");
                break;
            }
        }
        BetterClassWriter writer = new BetterClassWriter(this.getClass().getClassLoader(), 3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchDummyClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.INFO, "Found Dummy Class: " + classNode.name);
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

