/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.render;

import java.util.HashMap;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDye;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.model.skin.ModelDummy;
import moe.plushie.armourers_workshop.client.model.skin.ModelSkinBow;
import moe.plushie.armourers_workshop.client.model.skin.ModelSkinChest;
import moe.plushie.armourers_workshop.client.model.skin.ModelSkinFeet;
import moe.plushie.armourers_workshop.client.model.skin.ModelSkinHead;
import moe.plushie.armourers_workshop.client.model.skin.ModelSkinItem;
import moe.plushie.armourers_workshop.client.model.skin.ModelSkinLegs;
import moe.plushie.armourers_workshop.client.model.skin.ModelSkinOutfit;
import moe.plushie.armourers_workshop.client.model.skin.ModelSkinWings;
import moe.plushie.armourers_workshop.client.model.skin.ModelTypeHelper;
import moe.plushie.armourers_workshop.client.render.SkinRenderData;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinCapability;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperty;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class SkinModelRenderHelper {
    public static SkinModelRenderHelper INSTANCE;
    private final HashMap<String, ModelTypeHelper> helperModelsMap;
    public final ModelSkinHead modelHead = new ModelSkinHead();
    public final ModelSkinChest modelChest = new ModelSkinChest();
    public final ModelSkinLegs modelLegs = new ModelSkinLegs();
    public final ModelSkinFeet modelFeet = new ModelSkinFeet();
    public final ModelSkinWings modelWings = new ModelSkinWings();
    public final ModelSkinOutfit modelOutfit = new ModelSkinOutfit();
    public final ModelSkinItem modelItem = new ModelSkinItem();
    public final ModelSkinBow modelBow = new ModelSkinBow();
    public final ModelDummy modelHelperDummy = new ModelDummy();
    public EntityPlayer targetPlayer = null;

    public static void init() {
        INSTANCE = new SkinModelRenderHelper();
    }

    private SkinModelRenderHelper() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.helperModelsMap = new HashMap();
        this.registerSkinTypeHelperForModel(ModelType.MODEL_BIPED, SkinTypeRegistry.skinHead, this.modelHead);
        this.registerSkinTypeHelperForModel(ModelType.MODEL_BIPED, SkinTypeRegistry.skinChest, this.modelChest);
        this.registerSkinTypeHelperForModel(ModelType.MODEL_BIPED, SkinTypeRegistry.skinLegs, this.modelLegs);
        this.registerSkinTypeHelperForModel(ModelType.MODEL_BIPED, SkinTypeRegistry.skinFeet, this.modelFeet);
        this.registerSkinTypeHelperForModel(ModelType.MODEL_BIPED, SkinTypeRegistry.skinWings, this.modelWings);
        this.registerSkinTypeHelperForModel(ModelType.MODEL_BIPED, SkinTypeRegistry.skinSword, this.modelItem);
        this.registerSkinTypeHelperForModel(ModelType.MODEL_BIPED, SkinTypeRegistry.skinShield, this.modelItem);
        this.registerSkinTypeHelperForModel(ModelType.MODEL_BIPED, SkinTypeRegistry.skinBow, this.modelBow);
        this.registerSkinTypeHelperForModel(ModelType.MODEL_BIPED, SkinTypeRegistry.skinPickaxe, this.modelItem);
        this.registerSkinTypeHelperForModel(ModelType.MODEL_BIPED, SkinTypeRegistry.skinAxe, this.modelItem);
        this.registerSkinTypeHelperForModel(ModelType.MODEL_BIPED, SkinTypeRegistry.skinShovel, this.modelItem);
        this.registerSkinTypeHelperForModel(ModelType.MODEL_BIPED, SkinTypeRegistry.skinHoe, this.modelItem);
        this.registerSkinTypeHelperForModel(ModelType.MODEL_BIPED, SkinTypeRegistry.skinItem, this.modelItem);
        this.registerSkinTypeHelperForModel(ModelType.MODEL_BIPED, SkinTypeRegistry.skinOutfit, this.modelOutfit);
    }

    private boolean isPlayerWearingSkirt(EntityPlayer player) {
        Skin skin;
        ISkinDescriptor skinDescriptor;
        int i;
        IEntitySkinCapability skinCapability = EntitySkinCapability.get((Entity)player);
        if (skinCapability == null) {
            return false;
        }
        boolean limitLimbs = false;
        for (i = 0; i < skinCapability.getSlotCountForSkinType(SkinTypeRegistry.skinLegs); ++i) {
            skinDescriptor = skinCapability.getSkinDescriptor(SkinTypeRegistry.skinLegs, i);
            if (skinDescriptor == null || (skin = ClientSkinCache.INSTANCE.getSkin(skinDescriptor, false)) == null || !SkinProperties.PROP_MODEL_LEGS_LIMIT_LIMBS.getValue(skin.getProperties()).booleanValue()) continue;
            limitLimbs = true;
            break;
        }
        if (!limitLimbs) {
            for (i = 0; i < skinCapability.getSlotCountForSkinType(SkinTypeRegistry.skinOutfit); ++i) {
                skinDescriptor = skinCapability.getSkinDescriptor(SkinTypeRegistry.skinOutfit, i);
                if (skinDescriptor == null || (skin = ClientSkinCache.INSTANCE.getSkin(skinDescriptor, false)) == null || !SkinProperties.PROP_MODEL_LEGS_LIMIT_LIMBS.getValue(skin.getProperties()).booleanValue()) continue;
                limitLimbs = true;
                break;
            }
        }
        return limitLimbs;
    }

    public static boolean isPlayersArmSlim(ModelBiped modelBiped, EntityPlayer entityPlayer, EnumHandSide handSide) {
        Skin skin;
        ISkinDescriptor skinDescriptor;
        int i;
        boolean slim = false;
        SkinProperty<Boolean> targetProp = null;
        if (handSide == EnumHandSide.LEFT) {
            slim = modelBiped.field_178724_i.field_78797_d == 2.5f;
            targetProp = SkinProperties.PROP_MODEL_OVERRIDE_ARM_LEFT;
        } else {
            slim = modelBiped.field_178723_h.field_78797_d == 2.5f;
            targetProp = SkinProperties.PROP_MODEL_OVERRIDE_ARM_RIGHT;
        }
        boolean armHidden = false;
        IEntitySkinCapability skinCapability = EntitySkinCapability.get((Entity)entityPlayer);
        if (skinCapability == null) {
            return armHidden;
        }
        for (i = 0; i < skinCapability.getSlotCountForSkinType(SkinTypeRegistry.skinChest); ++i) {
            skinDescriptor = skinCapability.getSkinDescriptor(SkinTypeRegistry.skinChest, i);
            if (skinDescriptor == null || (skin = ClientSkinCache.INSTANCE.getSkin(skinDescriptor, false)) == null || !targetProp.getValue(skin.getProperties()).booleanValue()) continue;
            armHidden = true;
            break;
        }
        if (!armHidden) {
            for (i = 0; i < skinCapability.getSlotCountForSkinType(SkinTypeRegistry.skinOutfit); ++i) {
                skinDescriptor = skinCapability.getSkinDescriptor(SkinTypeRegistry.skinOutfit, i);
                if (skinDescriptor == null || (skin = ClientSkinCache.INSTANCE.getSkin(skinDescriptor, false)) == null || !targetProp.getValue(skin.getProperties()).booleanValue()) continue;
                armHidden = true;
                break;
            }
        }
        if (armHidden) {
            return false;
        }
        return slim;
    }

    @SubscribeEvent
    public void onRender(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        if (this.isPlayerWearingSkirt(player) && player.field_70721_aZ > 0.25f) {
            player.field_70721_aZ = 0.25f;
            player.field_184618_aE = 0.25f;
        }
    }

    public ModelTypeHelper getTypeHelperForModel(ModelType modelType, ISkinType skinType) {
        ModelTypeHelper typeHelper = this.helperModelsMap.get(skinType.getRegistryName() + ":" + modelType.name());
        if (typeHelper == null) {
            return this.modelHelperDummy;
        }
        return typeHelper;
    }

    public void registerSkinTypeHelperForModel(ModelType modelType, ISkinType skinType, ModelTypeHelper typeHelper) {
        this.helperModelsMap.put(skinType.getRegistryName() + ":" + modelType.name(), typeHelper);
    }

    public ModelTypeHelper agetTypeHelperForModel(ModelType modelType, ISkinType skinType) {
        return this.helperModelsMap.get(skinType.getRegistryName() + ":" + modelType.name());
    }

    public boolean renderEquipmentPart(Skin skin, SkinRenderData renderData, Entity entity, ModelBiped modelBiped) {
        if (skin == null) {
            return false;
        }
        ModelTypeHelper model = this.getTypeHelperForModel(ModelType.MODEL_BIPED, skin.getSkinType());
        GlStateManager.func_179123_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179147_l();
        GlStateManager.func_179091_B();
        model.render(entity, skin, modelBiped, renderData);
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        GlStateManager.func_179129_p();
        GlStateManager.func_179099_b();
        return true;
    }

    public boolean renderEquipmentPart(Entity entity, ModelBiped modelBiped, Skin skin, ISkinDye skinDye, IExtraColours extraColours, double distance, boolean doLodLoading) {
        if (skin == null) {
            return false;
        }
        ModelTypeHelper model = this.getTypeHelperForModel(ModelType.MODEL_BIPED, skin.getSkinType());
        GlStateManager.func_179123_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179147_l();
        GlStateManager.func_179091_B();
        model.render(entity, skin, modelBiped, false, skinDye, extraColours, false, distance, doLodLoading);
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        GlStateManager.func_179129_p();
        GlStateManager.func_179099_b();
        return true;
    }

    public static enum ModelType {
        MODEL_BIPED;

    }
}

