/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.skin.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDye;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.skin.SkinModelTexture;
import moe.plushie.armourers_workshop.client.skin.SkinTextureKey;
import moe.plushie.armourers_workshop.common.capability.wardrobe.ExtraColours;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientSkinPaintCache
implements RemovalListener<SkinTextureKey, SkinModelTexture>,
Runnable {
    public static ClientSkinPaintCache INSTANCE = new ClientSkinPaintCache();
    private final Cache<SkinTextureKey, SkinModelTexture> textureCache;
    private final HashSet<TextureGenInfo> requestSet;
    private final ArrayList<TextureGenInfo> requestList;
    private volatile Thread textureGenThread;

    public ClientSkinPaintCache() {
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.removalListener((RemovalListener)this);
        if (ConfigHandlerClient.textureCacheExpireTime > 0) {
            builder.expireAfterAccess((long)ConfigHandlerClient.textureCacheExpireTime, TimeUnit.SECONDS);
        }
        if (ConfigHandlerClient.textureCacheMaxSize > 0) {
            builder.maximumSize((long)ConfigHandlerClient.textureCacheMaxSize);
        }
        this.textureCache = builder.build();
        this.requestSet = new HashSet();
        this.requestList = new ArrayList();
        this.textureGenThread = new Thread((Runnable)this, "Texture Gen Thread");
        this.textureGenThread.setPriority(1);
        this.textureGenThread.start();
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public SkinModelTexture getTextureForSkin(Skin skin, ISkinDye skinDye, IExtraColours extraColours) {
        if (extraColours == null) {
            extraColours = ExtraColours.EMPTY_COLOUR;
        }
        SkinTextureKey cmk = new SkinTextureKey(skin.lightHash(), skinDye, extraColours);
        return this.getTextureForSkin(skin, cmk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SkinModelTexture getTextureForSkin(Skin skin, SkinTextureKey cmk) {
        SkinModelTexture st = (SkinModelTexture)((Object)this.textureCache.getIfPresent((Object)cmk));
        if (st != null) {
            return st;
        }
        TextureGenInfo tgi = new TextureGenInfo(skin, cmk);
        HashSet<TextureGenInfo> hashSet = this.requestSet;
        synchronized (hashSet) {
            if (!this.requestSet.contains(tgi)) {
                this.requestSet.add(tgi);
                ArrayList<TextureGenInfo> arrayList = this.requestList;
                synchronized (arrayList) {
                    this.requestList.add(tgi);
                }
            }
        }
        return skin.skinModelTexture;
    }

    public int size() {
        this.textureCache.cleanUp();
        return (int)this.textureCache.size();
    }

    public void clear() {
        this.textureCache.invalidateAll();
    }

    public void onRemoval(final RemovalNotification<SkinTextureKey, SkinModelTexture> notification) {
        Minecraft.func_71410_x().func_152344_a(new Runnable(){

            @Override
            public void run() {
                ClientSkinPaintCache.this.cleanupTexture((SkinModelTexture)((Object)notification.getValue()));
            }
        });
    }

    private void cleanupTexture(SkinModelTexture modelTexture) {
        if (modelTexture != null) {
            modelTexture.func_147631_c();
        }
    }

    protected void finalize() throws Throwable {
        this.textureGenThread = null;
        super.finalize();
    }

    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.textureGenThread == thisThread) {
            try {
                Thread.sleep(100L);
                this.genTextures();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genTextures() {
        SkinModelTexture smt = null;
        TextureGenInfo tgi = null;
        AbstractCollection abstractCollection = this.requestList;
        synchronized (abstractCollection) {
            if (this.requestList.size() > 0) {
                tgi = this.requestList.get(this.requestList.size() - 1);
                this.requestList.remove(this.requestList.size() - 1);
                smt = new SkinModelTexture();
                smt.createTextureForColours(tgi.skin, tgi.cmk);
            }
        }
        if (smt != null && tgi != null) {
            this.textureCache.put((Object)tgi.cmk, smt);
            abstractCollection = this.requestSet;
            synchronized (abstractCollection) {
                this.requestSet.remove(tgi);
            }
        }
    }

    protected class TextureGenInfo {
        public Skin skin;
        public SkinTextureKey cmk;

        public TextureGenInfo(Skin skin, SkinTextureKey cmk) {
            this.skin = skin;
            this.cmk = cmk;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cmk == null ? 0 : this.cmk.hashCode());
            result = 31 * result + (this.skin == null ? 0 : this.skin.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TextureGenInfo other = (TextureGenInfo)obj;
            if (this.cmk == null ? other.cmk != null : !this.cmk.equals(other.cmk)) {
                return false;
            }
            return !(this.skin == null ? other.skin != null : !this.skin.equals(other.skin));
        }
    }
}

