/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.crafting.recipe;

import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.common.crafting.recipe.RecipeItemSkinning;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RecipeSkinArmour
extends RecipeItemSkinning {
    public RecipeSkinArmour(ISkinType skinType) {
        super(skinType);
    }

    @Override
    public boolean matches(IInventory inventory) {
        return !this.getCraftingResult(inventory).func_190926_b();
    }

    @Override
    public ItemStack getCraftingResult(IInventory inventory) {
        ItemStack skinStack = ItemStack.field_190927_a;
        ItemStack armourStack = ItemStack.field_190927_a;
        for (int slotId = 0; slotId < inventory.func_70302_i_(); ++slotId) {
            ItemStack stack = inventory.func_70301_a(slotId);
            if (stack == ItemStack.field_190927_a) continue;
            if (this.isValidSkinForType(stack)) {
                if (skinStack != ItemStack.field_190927_a) {
                    return ItemStack.field_190927_a;
                }
                skinStack = stack;
                continue;
            }
            if (this.isValidArmour(stack) & !SkinNBTHelper.stackHasSkinData(stack)) {
                if (armourStack != ItemStack.field_190927_a) {
                    return ItemStack.field_190927_a;
                }
                armourStack = stack;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (skinStack != ItemStack.field_190927_a && armourStack != ItemStack.field_190927_a) {
            if (!this.isValidArmourForSkin(armourStack, skinStack)) {
                return ItemStack.field_190927_a;
            }
            ItemStack returnStack = armourStack.func_77946_l();
            SkinDescriptor skinDescriptor = SkinNBTHelper.getSkinDescriptorFromStack(skinStack);
            SkinNBTHelper.addSkinDataToStack(returnStack, skinDescriptor.getIdentifier(), skinDescriptor.getSkinDye());
            return returnStack;
        }
        return ItemStack.field_190927_a;
    }

    private boolean isValidArmour(ItemStack stack) {
        Item item = stack.func_77973_b();
        for (int i = 0; i < 4; ++i) {
            EntityEquipmentSlot slot = EntityEquipmentSlot.values()[5 - i];
            if (!item.isValidArmor(stack, slot, null)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidArmourForSkin(ItemStack armourStack, ItemStack skinStack) {
        SkinDescriptor sd = SkinNBTHelper.getSkinDescriptorFromStack(skinStack);
        ISkinType skinType = sd.getIdentifier().getSkinType();
        Item armourItem = armourStack.func_77973_b();
        return armourItem.isValidArmor(armourStack, EntityEquipmentSlot.values()[5 - skinType.getVanillaArmourSlotId()], null);
    }

    @Override
    public void onCraft(IInventory inventory) {
        for (int slotId = 0; slotId < inventory.func_70302_i_(); ++slotId) {
            inventory.func_70298_a(slotId, 1);
        }
    }
}

