/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.tileentities;

import moe.plushie.armourers_workshop.common.init.blocks.BlockSkinnable;
import moe.plushie.armourers_workshop.common.init.blocks.BlockSkinnableChild;
import moe.plushie.armourers_workshop.common.tileentities.TileEntitySkinnable;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.Level;

public class TileEntitySkinnableChild
extends TileEntitySkinnable {
    private static final String TAG_PARENT_X = "parentX";
    private static final String TAG_PARENT_Y = "parentY";
    private static final String TAG_PARENT_Z = "parentZ";
    private BlockPos parentPos;

    public boolean isParentValid() {
        return this.getParent() != null;
    }

    public void setParentLocation(BlockPos parentPos) {
        this.parentPos = parentPos;
        this.dirtySync();
    }

    @Override
    public AxisAlignedBB getBoundsForBlock(Block block, int xOffset, int yOffset, int zOffset) {
        if (this.parentPos == null) {
            this.parentPos = this.func_174877_v();
        }
        int x = this.func_174877_v().func_177958_n() - this.parentPos.func_177958_n();
        int y = this.func_174877_v().func_177956_o() - this.parentPos.func_177956_o();
        int z = this.func_174877_v().func_177952_p() - this.parentPos.func_177952_p();
        if (!this.isParentValid()) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        int widthOffset = x;
        int heightOffset = y;
        int depthOffset = z;
        if (block != null && !(block instanceof BlockSkinnableChild)) {
            ModLogger.log(Level.ERROR, String.format("Tile entity at X:%d Y:%d Z:%d has an invalid block.", xOffset, yOffset, zOffset));
            if (this.func_145831_w() != null) {
                // empty if block
            }
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        BlockSkinnableChild child = (BlockSkinnableChild)this.func_145838_q();
        EnumFacing dir = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockSkinnable.STATE_FACING);
        switch (dir) {
            case NORTH: {
                widthOffset = 1 - x;
                depthOffset = z;
                break;
            }
            case EAST: {
                widthOffset = -x;
                depthOffset = z + 1;
                break;
            }
            case SOUTH: {
                widthOffset = 1 - x;
                depthOffset = 2 + z;
                break;
            }
            case WEST: {
                widthOffset = 2 - x;
                depthOffset = z + 1;
                break;
            }
        }
        return super.getBoundsForBlock(block, widthOffset, heightOffset, depthOffset);
    }

    @Override
    public TileEntitySkinnable getParent() {
        TileEntity te = this.func_145831_w().func_175625_s(this.parentPos);
        if (te != null && te instanceof TileEntitySkinnable) {
            return (TileEntitySkinnable)te;
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.parentPos = new BlockPos(compound.func_74762_e(TAG_PARENT_X), compound.func_74762_e(TAG_PARENT_Y), compound.func_74762_e(TAG_PARENT_Z));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.parentPos != null) {
            compound.func_74768_a(TAG_PARENT_X, this.parentPos.func_177958_n());
            compound.func_74768_a(TAG_PARENT_Y, this.parentPos.func_177956_o());
            compound.func_74768_a(TAG_PARENT_Z, this.parentPos.func_177952_p());
        }
        return compound;
    }
}

